/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader.service.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ModuleContext;
import org.apache.tomee.loader.service.ServiceContext;
import org.apache.tomee.loader.service.ServiceException;
import org.apache.tomee.loader.service.helper.JndiHelper;
import org.apache.tomee.loader.service.helper.JndiTreeHelperImpl;
import org.apache.tomee.loader.service.helper.TypeAndValueEntry;

public class JndiHelperImpl
implements JndiHelper {
    public static final String CONTEXT_NODE_TYPE = "context";
    public static final String LEAF_NODE_TYPE = "leaf";
    public static final String APPLICATION_NODE_TYPE = "application";
    public static final String MODULE_NODE_TYPE = "module";
    public static final String ROOT_NODE_TYPE = "root";
    private final ServiceContext srvCtx;

    public JndiHelperImpl(ServiceContext srvCtx) {
        this.srvCtx = srvCtx;
    }

    @Override
    public List<Method> getJndiMethods(String path) {
        Object srv = null;
        try {
            srv = this.srvCtx.getOpenEJBHelper().lookup(path);
        }
        catch (NamingException e) {
            return Collections.emptyList();
        }
        Class<?> srvCls = srv.getClass();
        return new ArrayList<Method>(Arrays.asList(srvCls.getMethods()));
    }

    @Override
    public Context getContext(String user, String password) {
        InitialContext ctx;
        Properties ctxParams = new Properties();
        ctxParams.put("java.naming.factory.initial", "org.apache.openejb.client.LocalInitialContextFactory");
        if (user != null && !"".equals(user.trim())) {
            ctxParams.put("java.naming.security.principal", user);
        }
        if (password != null) {
            ctxParams.put("java.naming.security.credentials", password);
        }
        try {
            ctx = new InitialContext(ctxParams);
        }
        catch (NamingException e) {
            throw new ServiceException(e);
        }
        return ctx;
    }

    @Override
    public Object invokeJndiMethod(Context context, String path, String methodName, TypeAndValueEntry ... params) {
        Object result;
        Method method;
        Object[] parameterValues;
        Object obj;
        try {
            obj = context.lookup(path);
        }
        catch (NamingException e) {
            throw new ServiceException(e);
        }
        Class<?> cls = obj.getClass();
        try {
            if (params == null) {
                parameterValues = null;
                method = cls.getMethod(methodName, new Class[0]);
            } else {
                Class[] parameterTypes = new Class[params.length];
                parameterValues = new Object[params.length];
                for (int i = 0; i < params.length; ++i) {
                    parameterTypes[i] = params[i].type;
                    parameterValues[i] = params[i].value;
                }
                method = cls.getMethod(methodName, parameterTypes);
            }
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException(e);
        }
        try {
            result = parameterValues == null ? method.invoke(obj, new Object[0]) : method.invoke(obj, parameterValues);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException(e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException(e);
        }
        return result;
    }

    @Override
    public Map<String, Object> getJndi() {
        Map<String, Object> root = JndiHelperImpl.createTreeNode(ROOT_NODE_TYPE, "/", null);
        for (AppContext appContext : this.srvCtx.getOpenEJBHelper().getAppContexts()) {
            Map<String, Object> appNode = JndiHelperImpl.createTreeNode(APPLICATION_NODE_TYPE, appContext.getId(), root);
            HashMap<String, ModuleContext> modules = new HashMap<String, ModuleContext>();
            for (BeanContext beanContext : appContext.getBeanContexts()) {
                if (beanContext.getBeanClass().equals(BeanContext.Comp.class)) continue;
                ModuleContext moduleContext = beanContext.getModuleContext();
                modules.put(moduleContext.getUniqueId(), moduleContext);
            }
            for (ModuleContext module : modules.values()) {
                Map<String, Object> moduleNode = JndiHelperImpl.createTreeNode(MODULE_NODE_TYPE, appContext.getId(), appNode);
                this.addSubContext(module.getModuleJndiContext(), MODULE_NODE_TYPE, moduleNode);
            }
            this.addSubContext(appContext.getAppJndiContext(), "app", appNode);
            this.addSubContext(appContext.getGlobalJndiContext(), "global", appNode);
        }
        this.normalizePaths(new ArrayList<String>(), root);
        return root;
    }

    private void addSubContext(Context context, String subContext, Map<String, Object> parent) {
        Map<String, Object> subNode = JndiHelperImpl.createTreeNode(CONTEXT_NODE_TYPE, subContext, parent);
        try {
            JndiTreeHelperImpl.runOnJndiTree((Context)context.lookup(subContext), subNode);
        }
        catch (NamingException e) {
            // empty catch block
        }
    }

    public static Map<String, Object> createTreeNode(String type, String path, Map<String, Object> parent) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", type);
        result.put("path", path);
        if (parent != null) {
            ArrayList<HashMap<String, Object>> children = (ArrayList<HashMap<String, Object>>)parent.get("children");
            if (children == null) {
                children = new ArrayList<HashMap<String, Object>>();
                parent.put("children", children);
            }
            children.add(result);
        }
        return result;
    }

    private void normalizePaths(List<String> path, Map<String, Object> jndiEntry) {
        ArrayList<String> innerPath = new ArrayList<String>(path);
        if (CONTEXT_NODE_TYPE.equals(jndiEntry.get("type"))) {
            innerPath.add((String)jndiEntry.get("path"));
        } else if (LEAF_NODE_TYPE.equals(jndiEntry.get("type"))) {
            String[] entryPaths = ((String)jndiEntry.get("path")).split("/");
            String leafName = entryPaths[entryPaths.length - 1];
            StringBuffer resultingPath = new StringBuffer();
            for (String pathEntry : path) {
                resultingPath.append(pathEntry);
                resultingPath.append("/");
            }
            resultingPath.append(leafName);
            jndiEntry.put("path", "java:" + resultingPath.toString());
            return;
        }
        List jndiEntries = (List)jndiEntry.get("children");
        if (jndiEntries != null && !jndiEntries.isEmpty()) {
            for (Map child : jndiEntries) {
                this.normalizePaths(innerPath, child);
            }
        }
    }
}

