/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader.service.helper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.tomee.loader.service.helper.OpenEJBHelper;

public class OpenEJBHelperImpl
implements OpenEJBHelper {
    private final ContainerSystem container = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);

    @Override
    public List<AppContext> getAppContexts() {
        return this.container.getAppContexts();
    }

    @Override
    public Object lookup(String path) throws NamingException {
        return this.container.getJNDIContext().lookup(path);
    }

    public AppContext app(String name) {
        for (AppContext appContext : this.getAppContexts()) {
            String appName = appContext.getId();
            if (!appName.equals(name)) continue;
            return appContext;
        }
        return null;
    }

    public BeanContext bean(String app, String name) {
        AppContext appCtx = this.app(app);
        if (appCtx == null) {
            return null;
        }
        for (BeanContext ctx : appCtx.getBeanContexts()) {
            if (!ctx.getDeploymentID().equals(name)) continue;
            return ctx;
        }
        return null;
    }

    public Method method(String app, String name, long id) {
        BeanContext bean = this.bean(app, name);
        if (bean != null) {
            List<MethodInfo> methods = this.methods(this.baseClass(bean));
            for (MethodInfo method : methods) {
                if (method.getId() != id) continue;
                return method.getMethod();
            }
        }
        return null;
    }

    public Class<?> baseClass(BeanContext beanContext) {
        if (beanContext.isLocalbean()) {
            return beanContext.getBeanClass();
        }
        if (beanContext.getBusinessLocalInterfaces().size() > 0) {
            return beanContext.getBusinessLocalInterface();
        }
        if (beanContext.getBusinessRemoteInterface() != null) {
            return beanContext.getBusinessRemoteInterface();
        }
        return beanContext.getBeanClass();
    }

    public List<MethodInfo> methods(Class<?> beanClass) {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        Class<?> current = beanClass;
        do {
            for (Method method : current.getDeclaredMethods()) {
                methods.add(new MethodInfo(method.toGenericString().replace(beanClass.getName().concat("."), "").replace("java.lang.", ""), method.hashCode(), method));
            }
        } while ((current = current.getSuperclass()) != null && !current.equals(Object.class));
        return methods;
    }

    public static class MethodInfo {
        private String signature;
        private long id;
        private Method method;

        public MethodInfo(String signature, long id, Method mtd) {
            this.signature = signature;
            this.id = id;
            this.method = mtd;
        }

        public String getSignature() {
            return this.signature;
        }

        public long getId() {
            return this.id;
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

