/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.util.Collection;
import org.apache.openjpa.datacache.AbstractDataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.event.RemoteCommitListener;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.CacheMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentDataCache
extends AbstractDataCache
implements RemoteCommitListener {
    private static final Localizer _loc = Localizer.forPackage(ConcurrentDataCache.class);
    private CacheMap _cache = this.newCacheMap();

    public CacheMap getCacheMap() {
        return this._cache;
    }

    public void setCacheSize(int size) {
        this._cache.setCacheSize(size);
    }

    public int getCacheSize() {
        return this._cache.getCacheSize();
    }

    public void setSoftReferenceSize(int size) {
        this._cache.setSoftReferenceSize(size);
    }

    public int getSoftReferenceSize() {
        return this._cache.getSoftReferenceSize();
    }

    @Override
    public void initialize(DataCacheManager mgr) {
        super.initialize(mgr);
        this.conf.getRemoteCommitEventManager().addInternalListener(this);
    }

    @Override
    public void unpinAll(Class<?> cls, boolean subs) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(_loc.get("cache-class-unpin-all", this.getName()));
        }
        this.unpinAll((Collection)this._cache.getPinnedKeys());
    }

    @Override
    public void writeLock() {
        this._cache.writeLock();
    }

    @Override
    public void writeUnlock() {
        this._cache.writeUnlock();
    }

    protected CacheMap newCacheMap() {
        return new CacheMap(){

            protected void entryRemoved(Object key, Object value, boolean expired) {
                ConcurrentDataCache.this.keyRemoved(key, expired);
            }
        };
    }

    @Override
    protected DataCachePCData getInternal(Object key) {
        return (DataCachePCData)this._cache.get(key);
    }

    @Override
    protected DataCachePCData putInternal(Object key, DataCachePCData pc) {
        return (DataCachePCData)this._cache.put(key, pc);
    }

    @Override
    protected DataCachePCData removeInternal(Object key) {
        return (DataCachePCData)this._cache.remove(key);
    }

    @Override
    protected void removeAllInternal(Class<?> cls, boolean subs) {
        CacheMap orig = this._cache;
        this._cache = this.newCacheMap();
        for (Object o : orig.values()) {
            Class curClass = ((DataCachePCData)o).getType();
            if (!subs || cls != curClass && (cls == null || !cls.isAssignableFrom(curClass))) continue;
            orig.remove(((DataCachePCData)o).getId());
        }
        this._cache.putAll(orig, false);
    }

    @Override
    protected void clearInternal() {
        this._cache.clear();
    }

    @Override
    protected boolean pinInternal(Object key) {
        return this._cache.pin(key);
    }

    @Override
    protected boolean unpinInternal(Object key) {
        return this._cache.unpin(key);
    }
}

