/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.openjpa.datacache.AbstractQueryCache;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.datacache.QueryResult;
import org.apache.openjpa.datacache.TypesChangedEvent;
import org.apache.openjpa.datacache.TypesChangedListener;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.QueryContext;
import org.apache.openjpa.kernel.ResultShape;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.lib.rop.ListResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.ObjectNotFoundException;
import serp.util.Numbers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCacheStoreQuery
implements StoreQuery {
    private final StoreQuery _query;
    private final QueryCache _cache;
    private StoreContext _sctx;
    private MetaDataRepository _repos;

    public QueryCacheStoreQuery(StoreQuery query, QueryCache cache) {
        this._query = query;
        this._cache = cache;
    }

    public QueryCache getCache() {
        return this._cache;
    }

    public StoreQuery getDelegate() {
        return this._query;
    }

    private List<Object> checkCache(QueryKey qk) {
        int projs;
        AbstractQueryCache qcache;
        if (qk == null) {
            return null;
        }
        FetchConfiguration fetch = this.getContext().getFetchConfiguration();
        if (!fetch.getQueryCacheEnabled()) {
            return null;
        }
        if (fetch.getReadLockLevel() > 0) {
            return null;
        }
        QueryResult res = this._cache.get(qk);
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return Collections.emptyList();
        }
        if (this._cache instanceof AbstractQueryCache && (qcache = (AbstractQueryCache)this._cache).getEvictPolicy() == AbstractQueryCache.EvictPolicy.TIMESTAMP) {
            Set<String> classNames = qk.getAcessPathClassNames();
            ArrayList<String> keyList = new ArrayList<String>();
            keyList.addAll(classNames);
            List<Long> timestamps = qcache.getAllEntityTimestamp(keyList);
            long queryTS = res.getTimestamp();
            if (timestamps != null) {
                for (Long ts : timestamps) {
                    if (queryTS >= ts) continue;
                    qcache.remove(qk);
                    return null;
                }
            }
        }
        if ((projs = this.getContext().getProjectionAliases().length) == 0) {
            ClassMetaData meta = this._repos.getMetaData(this.getContext().getCandidateType(), this._sctx.getClassLoader(), true);
            if (meta.getDataCache() == null) {
                return null;
            }
            BitSet idxs = meta.getDataCache().containsAll(res);
            int len = idxs.length();
            if (len < res.size()) {
                return null;
            }
            for (int i = 0; i < len; ++i) {
                if (idxs.get(i)) continue;
                return null;
            }
        }
        return new CachedList(res, projs != 0, this._sctx);
    }

    private ResultObjectProvider wrapResult(ResultObjectProvider rop, QueryKey key) {
        if (key == null) {
            return rop;
        }
        return new CachingResultObjectProvider(rop, this.getContext().getProjectionAliases().length > 0, key);
    }

    private static Object copyProjection(Object obj, StoreContext ctx) {
        if (obj == null) {
            return null;
        }
        switch (JavaTypes.getTypeCode(obj.getClass())) {
            case 9: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                return obj;
            }
            case 14: {
                return ((Date)obj).clone();
            }
            case 26: {
                return ((Locale)obj).clone();
            }
        }
        if (obj instanceof CachedObjectId) {
            return QueryCacheStoreQuery.fromObjectId(((CachedObjectId)obj).oid, ctx);
        }
        Object oid = ctx.getObjectId(obj);
        if (oid != null) {
            return new CachedObjectId(oid);
        }
        return obj;
    }

    private static Object fromObjectId(Object oid, StoreContext sctx) {
        if (oid == null) {
            return null;
        }
        Object obj = sctx.find(oid, null, null, null, 0);
        if (obj == null) {
            throw new ObjectNotFoundException(oid);
        }
        return obj;
    }

    public Object writeReplace() throws ObjectStreamException {
        return this._query;
    }

    @Override
    public QueryContext getContext() {
        return this._query.getContext();
    }

    @Override
    public void setContext(QueryContext qctx) {
        this._query.setContext(qctx);
        this._sctx = qctx.getStoreContext();
        this._repos = this._sctx.getConfiguration().getMetaDataRepositoryInstance();
    }

    @Override
    public boolean setQuery(Object query) {
        return this._query.setQuery(query);
    }

    @Override
    public FilterListener getFilterListener(String tag) {
        return this._query.getFilterListener(tag);
    }

    @Override
    public AggregateListener getAggregateListener(String tag) {
        return this._query.getAggregateListener(tag);
    }

    @Override
    public Object newCompilationKey() {
        return this._query.newCompilationKey();
    }

    @Override
    public Object newCompilation() {
        return this._query.newCompilation();
    }

    @Override
    public void populateFromCompilation(Object comp) {
        this._query.populateFromCompilation(comp);
    }

    @Override
    public void invalidateCompilation() {
        this._query.invalidateCompilation();
    }

    @Override
    public boolean supportsDataStoreExecution() {
        return this._query.supportsDataStoreExecution();
    }

    @Override
    public boolean supportsInMemoryExecution() {
        return this._query.supportsInMemoryExecution();
    }

    @Override
    public StoreQuery.Executor newInMemoryExecutor(ClassMetaData meta, boolean subs) {
        return this._query.newInMemoryExecutor(meta, subs);
    }

    @Override
    public StoreQuery.Executor newDataStoreExecutor(ClassMetaData meta, boolean subs) {
        StoreQuery.Executor ex = this._query.newDataStoreExecutor(meta, subs);
        return new QueryCacheExecutor(ex, meta, subs, this.getContext().getFetchConfiguration());
    }

    @Override
    public boolean supportsAbstractExecutors() {
        return this._query.supportsAbstractExecutors();
    }

    @Override
    public boolean requiresCandidateType() {
        return this._query.requiresCandidateType();
    }

    @Override
    public boolean requiresParameterDeclarations() {
        return this._query.requiresParameterDeclarations();
    }

    @Override
    public boolean supportsParameterDeclarations() {
        return this._query.supportsParameterDeclarations();
    }

    @Override
    public Object evaluate(Object value, Object ob, Object[] params, OpenJPAStateManager sm) {
        return this._query.evaluate(value, ob, params, sm);
    }

    private static class CachedObjectId {
        public final Object oid;

        public CachedObjectId(Object oid) {
            this.oid = oid;
        }
    }

    private class CachingResultObjectProvider
    implements ResultObjectProvider,
    TypesChangedListener {
        private final ResultObjectProvider _rop;
        private final boolean _proj;
        private final QueryKey _qk;
        private final TreeMap<Integer, Object> _data = new TreeMap();
        private boolean _maintainCache = true;
        private int _pos = -1;
        private int _max = -1;
        private int _size = Integer.MAX_VALUE;

        public CachingResultObjectProvider(ResultObjectProvider rop, boolean proj, QueryKey key) {
            this._rop = rop;
            this._proj = proj;
            this._qk = key;
            QueryCacheStoreQuery.this._cache.addTypesChangedListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void abortCaching() {
            if (!this._maintainCache) {
                return;
            }
            CachingResultObjectProvider cachingResultObjectProvider = this;
            synchronized (cachingResultObjectProvider) {
                this._maintainCache = false;
                QueryCacheStoreQuery.this._cache.removeTypesChangedListener(this);
                this._data.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkFinished(Object obj, boolean result) {
            boolean finished = false;
            CachingResultObjectProvider cachingResultObjectProvider = this;
            synchronized (cachingResultObjectProvider) {
                if (this._maintainCache) {
                    Integer index;
                    if (result && !this._data.containsKey(index = Numbers.valueOf((int)this._pos))) {
                        Object[] cached;
                        if (obj == null) {
                            cached = null;
                        } else if (!this._proj) {
                            cached = QueryCacheStoreQuery.this._sctx.getObjectId(obj);
                        } else {
                            Object[] arr = (Object[])obj;
                            Object[] cp = new Object[arr.length];
                            for (int i = 0; i < arr.length; ++i) {
                                cp[i] = QueryCacheStoreQuery.copyProjection(arr[i], QueryCacheStoreQuery.this._sctx);
                            }
                            cached = cp;
                        }
                        if (cached != null) {
                            this._data.put(index, cached);
                        }
                    }
                    finished = this._size == this._data.size();
                }
            }
            if (finished) {
                QueryCacheStoreQuery.this._cache.writeLock();
                try {
                    if (this._maintainCache) {
                        QueryResult res = null;
                        CachingResultObjectProvider cachingResultObjectProvider2 = this;
                        synchronized (cachingResultObjectProvider2) {
                            res = new QueryResult(this._qk, this._data.values());
                            res.setTimestamp(System.currentTimeMillis());
                        }
                        QueryCacheStoreQuery.this._cache.put(this._qk, res);
                        this.abortCaching();
                    }
                    Object var13_12 = null;
                    QueryCacheStoreQuery.this._cache.writeUnlock();
                }
                catch (Throwable throwable) {
                    Object var13_13 = null;
                    QueryCacheStoreQuery.this._cache.writeUnlock();
                    throw throwable;
                }
            }
        }

        public boolean supportsRandomAccess() {
            return this._rop.supportsRandomAccess();
        }

        public void open() throws Exception {
            this._rop.open();
        }

        public Object getResultObject() throws Exception {
            Object obj = this._rop.getResultObject();
            this.checkFinished(obj, true);
            return obj;
        }

        public boolean next() throws Exception {
            ++this._pos;
            boolean next = this._rop.next();
            if (!next && this._pos == this._max + 1) {
                this._size = this._pos;
                this.checkFinished(null, false);
            } else if (next && this._pos > this._max) {
                this._max = this._pos;
            }
            return next;
        }

        public boolean absolute(int pos) throws Exception {
            this._pos = pos;
            boolean valid = this._rop.absolute(pos);
            if (!valid && this._pos == this._max + 1) {
                this._size = this._pos;
                this.checkFinished(null, false);
            } else if (valid && this._pos > this._max) {
                this._max = this._pos;
            }
            return valid;
        }

        public int size() throws Exception {
            int size;
            if (this._size != Integer.MAX_VALUE) {
                return this._size;
            }
            this._size = size = this._rop.size();
            this.checkFinished(null, false);
            return size;
        }

        public void reset() throws Exception {
            this._rop.reset();
            this._pos = -1;
        }

        public void close() throws Exception {
            this.abortCaching();
            this._rop.close();
        }

        public void handleCheckedException(Exception e) {
            this._rop.handleCheckedException(e);
        }

        public void onTypesChanged(TypesChangedEvent ev) {
            if (this._qk.changeInvalidatesQuery(ev.getTypes())) {
                this.abortCaching();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CachedList
    extends AbstractList<Object>
    implements Serializable {
        private final QueryResult _res;
        private final boolean _proj;
        private final StoreContext _sctx;

        public CachedList(QueryResult res, boolean proj, StoreContext ctx) {
            this._res = res;
            this._proj = proj;
            this._sctx = ctx;
        }

        @Override
        public Object get(int idx) {
            if (!this._proj) {
                return QueryCacheStoreQuery.fromObjectId(this._res.get(idx), this._sctx);
            }
            Object[] cached = (Object[])this._res.get(idx);
            if (cached == null) {
                return null;
            }
            Object[] uncached = new Object[cached.length];
            for (int i = 0; i < cached.length; ++i) {
                uncached[i] = QueryCacheStoreQuery.copyProjection(cached[i], this._sctx);
            }
            return uncached;
        }

        @Override
        public int size() {
            return this._res.size();
        }

        public Object writeReplace() throws ObjectStreamException {
            return new ArrayList<Object>(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QueryCacheExecutor
    implements StoreQuery.Executor {
        private final StoreQuery.Executor _ex;
        private final Class<?> _candidate;
        private final boolean _subs;
        private final FetchConfiguration _fc;

        public QueryCacheExecutor(StoreQuery.Executor ex, ClassMetaData meta, boolean subs, FetchConfiguration fc) {
            this._ex = ex;
            this._candidate = meta == null ? null : meta.getDescribedType();
            this._subs = subs;
            this._fc = fc;
        }

        @Override
        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            QueryCacheStoreQuery cq = (QueryCacheStoreQuery)q;
            QueryKey key = QueryKey.newInstance(cq.getContext(), this._ex.isPacking(q), params, this._candidate, this._subs, range.start, range.end);
            List cached = cq.checkCache(key);
            if (cached != null) {
                return new ListResultObjectProvider(cached);
            }
            ResultObjectProvider rop = this._ex.executeQuery(cq.getDelegate(), params, range);
            if (this._fc.getQueryCacheEnabled()) {
                return cq.wrapResult(rop, key);
            }
            return rop;
        }

        @Override
        public QueryExpressions[] getQueryExpressions() {
            return this._ex.getQueryExpressions();
        }

        private void clearAccessPath(StoreQuery q) {
            if (q == null) {
                return;
            }
            ClassMetaData[] cmd = this.getAccessPathMetaDatas(q);
            if (cmd == null || cmd.length == 0) {
                return;
            }
            ArrayList classes = new ArrayList(cmd.length);
            for (int i = 0; i < cmd.length; ++i) {
                classes.add(cmd[i].getDescribedType());
            }
            QueryCacheStoreQuery cq = (QueryCacheStoreQuery)q;
            cq.getCache().onTypesChanged(new TypesChangedEvent(q.getContext(), classes));
            for (int i = 0; i < cmd.length; ++i) {
                if (cmd[i].getDataCache() == null) continue;
                cmd[i].getDataCache().removeAll(cmd[i].getDescribedType(), true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Number executeDelete(StoreQuery q, Object[] params) {
            try {
                Number number = this._ex.executeDelete(QueryCacheExecutor.unwrap(q), params);
                Object var5_4 = null;
                this.clearAccessPath(q);
                return number;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.clearAccessPath(q);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Number executeUpdate(StoreQuery q, Object[] params) {
            try {
                Number number = this._ex.executeUpdate(QueryCacheExecutor.unwrap(q), params);
                Object var5_4 = null;
                this.clearAccessPath(q);
                return number;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.clearAccessPath(q);
                throw throwable;
            }
        }

        @Override
        public String[] getDataStoreActions(StoreQuery q, Object[] params, StoreQuery.Range range) {
            return StoreQuery.EMPTY_STRINGS;
        }

        @Override
        public void validate(StoreQuery q) {
            this._ex.validate(QueryCacheExecutor.unwrap(q));
        }

        @Override
        public void getRange(StoreQuery q, Object[] params, StoreQuery.Range range) {
            this._ex.getRange(q, params, range);
        }

        @Override
        public Object getOrderingValue(StoreQuery q, Object[] params, Object resultObject, int orderIndex) {
            return this._ex.getOrderingValue(QueryCacheExecutor.unwrap(q), params, resultObject, orderIndex);
        }

        @Override
        public boolean[] getAscending(StoreQuery q) {
            return this._ex.getAscending(QueryCacheExecutor.unwrap(q));
        }

        @Override
        public boolean isPacking(StoreQuery q) {
            return this._ex.isPacking(QueryCacheExecutor.unwrap(q));
        }

        @Override
        public String getAlias(StoreQuery q) {
            return this._ex.getAlias(QueryCacheExecutor.unwrap(q));
        }

        @Override
        public Class<?> getResultClass(StoreQuery q) {
            return this._ex.getResultClass(QueryCacheExecutor.unwrap(q));
        }

        @Override
        public ResultShape<?> getResultShape(StoreQuery q) {
            return this._ex.getResultShape(q);
        }

        @Override
        public String[] getProjectionAliases(StoreQuery q) {
            return this._ex.getProjectionAliases(QueryCacheExecutor.unwrap(q));
        }

        public Class<?>[] getProjectionTypes(StoreQuery q) {
            return this._ex.getProjectionTypes(QueryCacheExecutor.unwrap(q));
        }

        @Override
        public ClassMetaData[] getAccessPathMetaDatas(StoreQuery q) {
            return this._ex.getAccessPathMetaDatas(QueryCacheExecutor.unwrap(q));
        }

        @Override
        public int getOperation(StoreQuery q) {
            return this._ex.getOperation(QueryCacheExecutor.unwrap(q));
        }

        @Override
        public boolean isAggregate(StoreQuery q) {
            return this._ex.isAggregate(QueryCacheExecutor.unwrap(q));
        }

        @Override
        public boolean hasGrouping(StoreQuery q) {
            return this._ex.hasGrouping(QueryCacheExecutor.unwrap(q));
        }

        @Override
        public LinkedMap getParameterTypes(StoreQuery q) {
            return this._ex.getParameterTypes(QueryCacheExecutor.unwrap(q));
        }

        @Override
        public Object[] toParameterArray(StoreQuery q, Map userParams) {
            return this._ex.toParameterArray(q, userParams);
        }

        @Override
        public Map getUpdates(StoreQuery q) {
            return this._ex.getUpdates(QueryCacheExecutor.unwrap(q));
        }

        private static StoreQuery unwrap(StoreQuery q) {
            return ((QueryCacheStoreQuery)q).getDelegate();
        }
    }
}

