/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.kernel.GenericResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.MappedQueryResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.SQLProjectionResultObjectProvider;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.ResultSetResult;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.AbstractStoreQuery;
import org.apache.openjpa.kernel.QueryContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.UserException;
import serp.util.Numbers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLStoreQuery
extends AbstractStoreQuery {
    private static final Localizer _loc = Localizer.forPackage(SQLStoreQuery.class);
    private final transient JDBCStore _store;

    public SQLStoreQuery(JDBCStore store) {
        this._store = store;
    }

    public JDBCStore getStore() {
        return this._store;
    }

    @Override
    public boolean supportsParameterDeclarations() {
        return false;
    }

    @Override
    public boolean supportsDataStoreExecution() {
        return true;
    }

    @Override
    public StoreQuery.Executor newDataStoreExecutor(ClassMetaData meta, boolean subclasses) {
        return new SQLExecutor(this, meta);
    }

    @Override
    public boolean requiresCandidateType() {
        return false;
    }

    @Override
    public boolean requiresParameterDeclarations() {
        return false;
    }

    public static String substituteParams(String sql2, List<Integer> paramOrder) throws IOException {
        int ttype;
        if (sql2.indexOf("?") == -1) {
            return sql2;
        }
        paramOrder.clear();
        StreamTokenizer tok = new StreamTokenizer(new StringReader(sql2));
        tok.resetSyntax();
        tok.quoteChar(39);
        tok.wordChars(48, 57);
        tok.wordChars(63, 63);
        StringBuffer buf = new StringBuffer(sql2.length());
        block4: while ((ttype = tok.nextToken()) != -1) {
            switch (ttype) {
                case -3: {
                    if (tok.sval.startsWith("?")) {
                        buf.append("?");
                        String pIndex = tok.sval.substring(1);
                        if (pIndex.length() > 0) {
                            paramOrder.add(Integer.valueOf(pIndex));
                            continue block4;
                        }
                        paramOrder.add(paramOrder.size() + 1);
                        continue block4;
                    }
                    buf.append(tok.sval);
                    continue block4;
                }
                case 39: {
                    buf.append('\'');
                    if (tok.sval == null) continue block4;
                    buf.append(tok.sval);
                    buf.append('\'');
                    continue block4;
                }
            }
            buf.append((char)ttype);
        }
        return buf.toString();
    }

    protected static class SQLExecutor
    extends AbstractStoreQuery.AbstractExecutor {
        private final ClassMetaData _meta;
        private final boolean _select;
        private final boolean _call;
        private final QueryResultMapping _resultMapping;

        public SQLExecutor(SQLStoreQuery q, ClassMetaData candidate) {
            QueryContext ctx = q.getContext();
            String resultMapping = ctx.getResultMappingName();
            if (resultMapping == null) {
                this._resultMapping = null;
            } else {
                ClassLoader envLoader = ctx.getStoreContext().getClassLoader();
                MappingRepository repos = q.getStore().getConfiguration().getMappingRepositoryInstance();
                this._resultMapping = repos.getQueryResultMapping(ctx.getResultMappingScope(), resultMapping, envLoader, true);
            }
            this._meta = candidate;
            String sql2 = StringUtils.trimToNull((String)ctx.getQueryString());
            if (sql2 == null) {
                throw new UserException(_loc.get("no-sql"));
            }
            this._select = q.getStore().getDBDictionary().isSelect(sql2);
            this._call = sql2.length() > 4 && sql2.substring(0, 4).equalsIgnoreCase("call");
        }

        public int getOperation(StoreQuery q) {
            return this._select ? 1 : (q.getContext().getCandidateType() != null || q.getContext().getResultType() != null || q.getContext().getResultMappingName() != null || q.getContext().getResultMappingScope() != null ? 1 : 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Number executeUpdate(StoreQuery q, Object[] params) {
            JDBCStore store = ((SQLStoreQuery)q).getStore();
            DBDictionary dict = store.getDBDictionary();
            String sql2 = q.getContext().getQueryString();
            ArrayList<Object> paramList = new ArrayList<Object>(Arrays.asList(params));
            SQLBuffer buf = new SQLBuffer(dict).append(sql2);
            store.getContext().beginStore();
            Connection conn = store.getConnection();
            JDBCFetchConfiguration fetch = (JDBCFetchConfiguration)q.getContext().getFetchConfiguration();
            Statement stmnt = null;
            try {
                stmnt = this._call ? this.prepareCall(conn, buf) : this.prepareStatement(conn, buf);
                buf.setParameters(paramList);
                if (stmnt != null) {
                    buf.setParameters((PreparedStatement)stmnt);
                }
                dict.setTimeouts((PreparedStatement)stmnt, fetch, true);
                int count = this.executeUpdate(store, conn, (PreparedStatement)stmnt, buf);
                Integer n = Numbers.valueOf((int)count);
                return n;
            }
            catch (SQLException se) {
                throw SQLExceptions.getStore(se, dict);
            }
            finally {
                if (stmnt != null) {
                    try {
                        stmnt.close();
                    }
                    catch (SQLException se) {
                    }
                    finally {
                        stmnt = null;
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException se) {}
            }
        }

        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            ResultObjectProvider rop;
            JDBCStore store = ((SQLStoreQuery)q).getStore();
            DBDictionary dict = store.getDBDictionary();
            String sql2 = q.getContext().getQueryString();
            ArrayList<Object> paramList = new ArrayList<Object>(Arrays.asList(params));
            SQLBuffer buf = new SQLBuffer(dict).append(sql2);
            Connection conn = store.getConnection();
            JDBCFetchConfiguration fetch = (JDBCFetchConfiguration)q.getContext().getFetchConfiguration();
            Statement stmnt = null;
            try {
                ResultSetResult res;
                stmnt = this._select && !range.lrs ? this.prepareStatement(conn, buf) : (this._select ? this.prepareStatement(conn, buf, fetch, -1, -1) : (!range.lrs ? this.prepareCall(conn, buf) : this.prepareCall(conn, buf, fetch, -1, -1)));
                int index = 0;
                Iterator i = paramList.iterator();
                while (i.hasNext() && stmnt != null) {
                    dict.setUnknown((PreparedStatement)stmnt, ++index, i.next(), null);
                }
                dict.setTimeouts((PreparedStatement)stmnt, fetch, false);
                ResultSet rs = this.executeQuery(store, conn, (PreparedStatement)stmnt, buf, paramList);
                ResultSetResult resultSetResult = res = stmnt != null ? new ResultSetResult(conn, stmnt, rs, store) : new ResultSetResult(conn, rs, dict);
                rop = this._resultMapping != null ? new MappedQueryResultObjectProvider(this._resultMapping, store, fetch, res) : (q.getContext().getCandidateType() != null ? new GenericResultObjectProvider((ClassMapping)this._meta, store, fetch, (Result)res) : new SQLProjectionResultObjectProvider(store, fetch, res, q.getContext().getResultType()));
            }
            catch (SQLException se) {
                if (stmnt != null) {
                    try {
                        stmnt.close();
                    }
                    catch (SQLException se2) {
                        // empty catch block
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException se2) {
                    // empty catch block
                }
                throw SQLExceptions.getStore(se, dict);
            }
            if (range.start != 0L || range.end != Long.MAX_VALUE) {
                rop = new RangeResultObjectProvider(rop, range.start, range.end);
            }
            return rop;
        }

        public String[] getDataStoreActions(StoreQuery q, Object[] params, StoreQuery.Range range) {
            return new String[]{q.getContext().getQueryString()};
        }

        public boolean isPacking(StoreQuery q) {
            return q.getContext().getCandidateType() == null;
        }

        protected PreparedStatement prepareCall(Connection conn, SQLBuffer buf) throws SQLException {
            return buf.prepareCall(conn);
        }

        protected int executeUpdate(JDBCStore store, Connection conn, PreparedStatement stmnt, SQLBuffer buf) throws SQLException {
            int count = 0;
            count = this._call && !stmnt.execute() ? stmnt.getUpdateCount() : stmnt.executeUpdate();
            return count;
        }

        protected PreparedStatement prepareCall(Connection conn, SQLBuffer buf, JDBCFetchConfiguration fetch, int rsType, int rsConcur) throws SQLException {
            return buf.prepareCall(conn, fetch, rsType, rsConcur);
        }

        protected PreparedStatement prepareStatement(Connection conn, SQLBuffer buf) throws SQLException {
            return buf.prepareStatement(conn);
        }

        protected PreparedStatement prepareStatement(Connection conn, SQLBuffer buf, JDBCFetchConfiguration fetch, int rsType, int rsConcur) throws SQLException {
            return buf.prepareStatement(conn, fetch, rsType, rsConcur);
        }

        protected ResultSet executeQuery(JDBCStore store, Connection conn, PreparedStatement stmnt, SQLBuffer buf, List paramList) throws SQLException {
            return stmnt.executeQuery();
        }

        public Object[] toParameterArray(StoreQuery q, Map userParams) {
            if (userParams == null || userParams.isEmpty()) {
                return StoreQuery.EMPTY_OBJECTS;
            }
            String sql2 = q.getContext().getQueryString();
            ArrayList<Integer> paramOrder = new ArrayList<Integer>();
            try {
                sql2 = SQLStoreQuery.substituteParams(sql2, paramOrder);
            }
            catch (IOException ex) {
                throw new UserException(ex.getLocalizedMessage());
            }
            Object[] result = new Object[paramOrder.size()];
            int idx = 0;
            for (Integer key : paramOrder) {
                if (!userParams.containsKey(key)) {
                    throw new UserException(_loc.get("uparam-missing", key, sql2, userParams));
                }
                result[idx++] = userParams.get(key);
            }
            q.getContext().getQuery().setQuery(sql2);
            return result;
        }
    }
}

