/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.openjpa.jdbc.kernel.JDBCStoreQuery;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.JDBCPath;
import org.apache.openjpa.jdbc.kernel.exps.SubQ;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.kernel.exps.Variable;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.Strategy;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.strats.HandlerCollectionTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.HandlerHandlerMapTableFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.LRSMapFieldStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.CandidatePath;
import org.apache.openjpa.kernel.exps.Context;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.XMLMetaData;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.UserException;

public class PCPath
extends CandidatePath
implements JDBCPath {
    protected static final String TRUE = "1 = 1";
    protected static final String FALSE = "1 <> 1";
    private static final int PATH = 0;
    private static final int BOUND_VAR = 1;
    private static final int UNBOUND_VAR = 2;
    private static final int UNACCESSED_VAR = 3;
    private static final int XPATH = 4;
    private static final Localizer _loc = Localizer.forPackage(PCPath.class);
    private final ClassMapping _candidate;
    private ClassMapping _class = null;
    private boolean _key = false;
    private int _type = 0;
    private String _varName = null;
    private Class _cast = null;
    private boolean _cid = false;
    private FieldMetaData _xmlfield = null;
    private boolean _keyPath = false;
    private String _schemaAlias = null;

    public PCPath(ClassMapping type) {
        this._candidate = type;
    }

    public PCPath(ClassMapping candidate, Variable var) {
        this._candidate = candidate;
        this._actions = new LinkedList();
        PCPath other = var.getPCPath();
        Action action = new Action();
        action.var = var.getName();
        if (other == null) {
            this._type = 2;
            action.op = 5;
            action.data = var;
            this._schemaAlias = var.getName();
        } else {
            this._type = 3;
            this._actions.addAll(other._actions);
            this._key = other._key;
            action.op = 3;
            action.data = var.getName();
            this._schemaAlias = other._schemaAlias;
            this._correlationVar = other._correlationVar;
        }
        this._actions.add(action);
        this._cast = var.getType();
    }

    public PCPath(SubQ sub) {
        this._candidate = sub.getCandidate();
        this._actions = new LinkedList();
        Action action = new Action();
        action.op = 4;
        action.data = sub.getCandidateAlias();
        this._actions.add(action);
        this._cast = sub.getType();
        this._varName = sub.getCandidateAlias();
    }

    public void setSchemaAlias(String schemaAlias) {
        if (this._schemaAlias == null) {
            this._schemaAlias = schemaAlias;
        }
    }

    public String getSchemaAlias() {
        return this._schemaAlias;
    }

    public void setSubqueryContext(Context context, String correlationVar) {
        Action action = this.lastFieldAction();
        if (action == null) {
            return;
        }
        action.context = context;
        this._correlationVar = correlationVar;
    }

    public void addVariableAction(Variable var) {
        this._varName = var.getName();
    }

    public boolean isUnaccessedVariable() {
        return this._type == 3;
    }

    public boolean isVariablePath() {
        return this._type != 0;
    }

    public synchronized void setContainsId(String id) {
        if (this._cid) {
            return;
        }
        Action action = new Action();
        action.op = 3;
        action.data = id;
        if (this._actions == null) {
            this._actions = new LinkedList();
        }
        this._actions.add(action);
        this._cid = true;
    }

    public ClassMetaData getMetaData() {
        return this._class;
    }

    public void setMetaData(ClassMetaData meta) {
        this._class = (ClassMapping)meta;
    }

    public boolean isKey() {
        return this._key;
    }

    public boolean isXPath() {
        return this._type == 4;
    }

    public String getXPath() {
        Action action;
        StringBuffer xpath = new StringBuffer();
        Iterator itr = this._actions.iterator();
        do {
            action = (Action)itr.next();
        } while (action.op != 7);
        while (itr.hasNext()) {
            action = (Action)itr.next();
            if (((XMLMetaData)action.data).getXmlname() != null) {
                xpath.append(((XMLMetaData)action.data).getXmlname());
            } else {
                xpath.append("*");
            }
            if (!itr.hasNext()) continue;
            xpath.append("/");
        }
        return xpath.toString();
    }

    public String getPCPathString() {
        if (this._actions == null) {
            return this._varName == null ? "" : this._varName + ".";
        }
        StringBuffer path = new StringBuffer();
        for (Action action : this._actions) {
            if (action.op == 3 || action.op == 4) {
                path.append(action.data);
            } else if (action.op == 5) {
                path.append(((Variable)action.data).getName());
            } else {
                path.append(((FieldMapping)action.data).getName());
            }
            path.append('.');
        }
        if (this._varName != null) {
            path.append(this._varName).append('.');
        }
        return path.toString();
    }

    public ClassMapping getClassMapping(ExpState state) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            return this._class;
        }
        if (this._key) {
            if (pstate.field.getKey().getTypeCode() == 15) {
                return pstate.field.getKeyMapping().getTypeMapping();
            }
            return null;
        }
        if (pstate.field.getElement().getTypeCode() == 15) {
            if (pstate.field.isElementCollection() && pstate.field.getElement().isEmbedded()) {
                pstate.isEmbedElementColl = true;
            }
            return pstate.field.getElementMapping().getTypeMapping();
        }
        if (pstate.field.getTypeCode() == 15) {
            return pstate.field.getTypeMapping();
        }
        return null;
    }

    public FieldMapping getFieldMapping(ExpState state) {
        return ((PathExpState)state).field;
    }

    public Column[] getColumns(ExpState state) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.cols == null) {
            pstate.cols = this.calculateColumns(pstate);
        }
        return pstate.cols;
    }

    private Column[] calculateColumns(PathExpState pstate) {
        if (this._key || this._keyPath && pstate.field.getKey() != null && !pstate.field.getKey().isEmbedded()) {
            if (!pstate.joinedRel && pstate.field.getKey().getValueMappedBy() != null) {
                this.joinRelation(pstate, this._key, false, false);
            } else if (pstate.joinedRel && pstate.field.getKey().getTypeCode() == 15) {
                return pstate.field.getKeyMapping().getTypeMapping().getPrimaryKeyColumns();
            }
            return pstate.field.getKeyMapping().getColumns();
        }
        if (pstate.field != null) {
            switch (pstate.field.getTypeCode()) {
                case 11: 
                case 12: 
                case 13: {
                    ValueMapping elem = pstate.field.getElementMapping();
                    if (pstate.field.isElementCollection() && pstate.field.getElement().isEmbedded()) {
                        FieldStrategy strategy = pstate.field.getStrategy();
                        if (strategy instanceof HandlerCollectionTableFieldStrategy) {
                            return ((HandlerCollectionTableFieldStrategy)strategy).getElementColumns(elem.getTypeMapping());
                        }
                        if (strategy instanceof HandlerHandlerMapTableFieldStrategy) {
                            return ((HandlerHandlerMapTableFieldStrategy)strategy).getValueColumns(elem.getTypeMapping());
                        }
                    }
                    if (pstate.joinedRel && elem.getTypeCode() == 15) {
                        return elem.getTypeMapping().getPrimaryKeyColumns();
                    }
                    if (elem.getColumns().length > 0) {
                        return elem.getColumns();
                    }
                    return pstate.field.getColumns();
                }
                case 15: {
                    if (pstate.joinedRel) {
                        return pstate.field.getTypeMapping().getPrimaryKeyColumns();
                    }
                    return pstate.field.getColumns();
                }
            }
            return pstate.field.getColumns();
        }
        return this._class == null ? Schemas.EMPTY_COLUMNS : this._class.getPrimaryKeyColumns();
    }

    public boolean isVariable() {
        if (this._actions == null) {
            return false;
        }
        Action action = (Action)this._actions.getLast();
        return action.op == 5 || action.op == 3;
    }

    public void get(FieldMetaData field, boolean nullTraversal) {
        if (this._actions == null) {
            this._actions = new LinkedList();
        }
        Action action = new Action();
        action.op = nullTraversal ? 1 : 0;
        action.data = field;
        this._actions.add(action);
        if (this._type == 3) {
            this._type = 1;
        }
        this._cast = null;
        this._key = false;
    }

    public void get(FieldMetaData fmd, XMLMetaData meta) {
        if (this._actions == null) {
            this._actions = new LinkedList();
        }
        Action action = new Action();
        action.op = 7;
        action.data = meta;
        this._actions.add(action);
        this._cast = null;
        this._key = false;
        this._type = 4;
        this._xmlfield = fmd;
    }

    public void get(XMLMetaData meta, String name) {
        Action action = new Action();
        action.op = 7;
        action.data = meta.getFieldMapping(name);
        this._actions.add(action);
        this._cast = null;
        this._key = false;
        this._type = 4;
    }

    public XMLMetaData getXmlMapping() {
        Action act = (Action)this._actions.getLast();
        if (act != null) {
            return (XMLMetaData)act.data;
        }
        return null;
    }

    public synchronized void getKey() {
        if (this._cid) {
            return;
        }
        Action action = this.lastFieldAction();
        Action key = new Action();
        key.op = 2;
        key.data = action.data;
        int pos = this._actions.indexOf(action);
        this._actions.remove(action);
        this._actions.add(pos, key);
        this._cast = null;
        this._key = true;
        this._type = 0;
    }

    public FieldMetaData last() {
        Action act = this.lastFieldAction();
        return act == null ? null : (this.isXPath() ? this._xmlfield : (FieldMetaData)act.data);
    }

    private Action lastFieldAction() {
        if (this._actions == null) {
            return null;
        }
        if (this.isXPath()) {
            return (Action)this._actions.getLast();
        }
        ListIterator itr = this._actions.listIterator(this._actions.size());
        while (itr.hasPrevious()) {
            Action prev = (Action)itr.previous();
            if (prev.op != 0 && prev.op != 1 && prev.op != 2) continue;
            return prev;
        }
        return null;
    }

    public Class getType() {
        boolean key;
        if (this._cast != null) {
            return this._cast;
        }
        Action act = this.lastFieldAction();
        if (act != null && act.op == 7) {
            return ((XMLMetaData)act.data).getType();
        }
        FieldMetaData fld = act == null ? null : (FieldMetaData)act.data;
        boolean bl = key = act != null && act.op == 2;
        if (fld != null) {
            switch (fld.getDeclaredTypeCode()) {
                case 11: {
                    if (fld.getDeclaredType() == byte[].class || fld.getDeclaredType() == Byte[].class || fld.getDeclaredType() == char[].class || fld.getDeclaredType() == Character[].class) {
                        return fld.getDeclaredType();
                    }
                    return fld.getElement().getDeclaredType();
                }
                case 13: {
                    if (key) {
                        return fld.getKey().getDeclaredType();
                    }
                    return fld.getElement().getDeclaredType();
                }
                case 12: {
                    return fld.getElement().getDeclaredType();
                }
            }
            return fld.getDeclaredType();
        }
        if (this._class != null) {
            return this._class.getDescribedType();
        }
        return Object.class;
    }

    public void setImplicitType(Class type) {
        this._cast = type;
    }

    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        PathExpState pstate = new PathExpState(sel.newJoins());
        boolean key = false;
        boolean forceOuter = false;
        ClassMapping rel = this._candidate;
        sel.setSchemaAlias(this._schemaAlias);
        Iterator itr = this._actions == null ? null : this._actions.iterator();
        FieldMapping field = null;
        Action prevaction = null;
        boolean isCorrelatedPath = false;
        boolean fromParentRootInSubselect = this.navigateFromParentRootInSubselect(sel);
        while (itr != null && itr.hasNext()) {
            Action action = (Action)itr.next();
            if (action.op == 3) {
                if (sel.getParent() != null && action.var != null && prevaction != null && prevaction.data != null && sel.ctx().getVariable(action.var) == null) {
                    isCorrelatedPath = true;
                    pstate.joins = pstate.joins.setCorrelatedVariable(action.var);
                } else {
                    pstate.joins = pstate.joins.setVariable((String)action.data);
                }
            } else if (action.op == 4) {
                pstate.joins = pstate.joins.setSubselect((String)action.data);
            } else if (action.op == 5) {
                Variable var = (Variable)action.data;
                rel = (ClassMapping)var.getMetaData();
                if (rel == null) {
                    throw new IllegalArgumentException(_loc.get("invalid-unbound-var", var.getName()).toString());
                }
                if (sel.getParent() != null && action.var != null && sel.ctx().getVariable(action.var) == null) {
                    isCorrelatedPath = true;
                    pstate.joins = pstate.joins.setCorrelatedVariable(var.getName());
                } else {
                    pstate.joins = pstate.joins.setVariable(var.getName());
                }
                pstate.joins = pstate.joins.crossJoin(this._candidate.getTable(), rel.getTable());
            } else {
                field = (FieldMapping)(action.op == 7 ? this._xmlfield : action.data);
                if (pstate.field != null) {
                    if (!itr.hasNext() && (flags & 4) == 0 && PCPath.isJoinedField(pstate.field, key, field)) {
                        pstate.cmpfield = field;
                        break;
                    }
                    if (fromParentRootInSubselect) {
                        isCorrelatedPath = true;
                        pstate.joins = pstate.joins.setCorrelatedVariable(this._schemaAlias);
                        pstate.joins.setJoinContext(null);
                    }
                    rel = this.traverseField(pstate, key, forceOuter, false);
                }
                key = action.op == 2;
                forceOuter |= action.op == 1;
                if (key && itr.hasNext()) {
                    this._keyPath = true;
                }
                pstate.field = field;
                ClassMapping owner = pstate.field.getDefiningMapping();
                if (pstate.field.getManagement() != 3) {
                    throw new UserException(_loc.get("non-pers-field", pstate.field));
                }
                if (rel != owner && rel != null) {
                    ClassMapping to;
                    ClassMapping from;
                    if (rel.getDescribedType().isAssignableFrom(owner.getDescribedType())) {
                        from = owner;
                        to = rel;
                    } else {
                        from = rel;
                        to = owner;
                    }
                    while (from != null && from != to) {
                        FieldMapping cast = from.getFieldMapping(pstate.field.getName());
                        if (cast != null) {
                            pstate.field = cast;
                        }
                        pstate.joins = from.joinSuperclass(pstate.joins, false);
                        from = from.getJoinablePCSuperclassMapping();
                    }
                }
                if (action.op == 7) break;
            }
            if ((prevaction = action) == null || prevaction.context == null) continue;
            Context jCtx = JDBCStoreQuery.getThreadLocalContext(prevaction.context);
            pstate.joins = pstate.joins.setJoinContext(jCtx);
        }
        if (this._varName != null) {
            pstate.joins = pstate.joins.setVariable(this._varName);
        }
        if ((flags & 2) == 0) {
            this.traverseField(pstate, key, forceOuter, true);
        }
        pstate.joinedRel = false;
        if ((flags & 4) != 0) {
            this.joinRelation(pstate, key, forceOuter || (flags & 8) != 0, false);
        }
        if (isCorrelatedPath) {
            pstate.joins.moveJoinsToParent();
        }
        pstate.joins.setJoinContext(null);
        if (this._actions == null) {
            String subqAlias = this.findSubqAlias(sel);
            pstate.joins = pstate.joins.setSubselect(subqAlias);
            pstate.joins.setCorrelatedVariable(this._schemaAlias);
        }
        return pstate;
    }

    private String findSubqAlias(Select sel) {
        Select pSel = sel.getParent();
        if (pSel == null) {
            return null;
        }
        Context pCtx = pSel.ctx();
        if (pCtx.subquery == null) {
            return null;
        }
        if (pCtx.getSchema(this._schemaAlias) != null) {
            return ((SubQ)pCtx.subquery).getCandidateAlias();
        }
        return this.findSubqAlias(pSel);
    }

    private boolean navigateFromParentRootInSubselect(Select sel) {
        if (sel.getParent() == null) {
            return false;
        }
        Iterator itr = this._actions == null ? null : this._actions.iterator();
        boolean navigateFromRoot = false;
        boolean hasVar = false;
        boolean startsWithSubquery = false;
        while (itr != null && itr.hasNext()) {
            Action action = (Action)itr.next();
            if (action.op == 3) {
                hasVar = true;
                continue;
            }
            if (action.op != 4) continue;
            startsWithSubquery = true;
        }
        return !hasVar && !startsWithSubquery && sel.ctx().getSchema(this._schemaAlias) == null;
    }

    private static boolean isJoinedField(FieldMapping src, boolean key, FieldMapping target) {
        Column[] pks;
        ValueMapping vm;
        switch (src.getTypeCode()) {
            case 11: 
            case 12: {
                vm = src.getElementMapping();
                break;
            }
            case 13: {
                vm = key ? src.getKeyMapping() : src.getElementMapping();
                break;
            }
            default: {
                vm = src;
            }
        }
        if (vm.getJoinDirection() != 0) {
            return false;
        }
        ForeignKey fk = vm.getForeignKey();
        if (fk == null) {
            return false;
        }
        Column[] rels = fk.getColumns();
        if (rels.length != (pks = target.getColumns()).length) {
            return false;
        }
        for (int i = 0; i < rels.length; ++i) {
            if (fk.getPrimaryKeyColumn(rels[i]) == pks[i]) continue;
            return false;
        }
        return true;
    }

    protected Object eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        if (this._actions == null) {
            return candidate;
        }
        for (Action action : this._actions) {
            OpenJPAStateManager sm = null;
            Broker tmpBroker = null;
            if (ImplHelper.isManageable(candidate)) {
                sm = (OpenJPAStateManager)ImplHelper.toPersistenceCapable(candidate, ctx.getConfiguration()).pcGetStateManager();
            }
            if (sm == null) {
                tmpBroker = ctx.getBroker();
                tmpBroker.transactional(candidate, false, null);
                sm = tmpBroker.getStateManager(candidate);
            }
            if (action.op != 0 && action.op != 1) continue;
            try {
                candidate = sm.fetchField(((FieldMapping)action.data).getIndex(), true);
            }
            catch (ClassCastException cce) {
                throw new RuntimeException(action.data + " not a field path");
            }
            finally {
                if (tmpBroker == null) continue;
                tmpBroker.nontransactional(sm.getManagedInstance(), null);
            }
        }
        return candidate;
    }

    private ClassMapping traverseField(PathExpState pstate, boolean key, boolean forceOuter, boolean last) {
        if (pstate.field == null) {
            return null;
        }
        pstate.joins = key ? pstate.field.joinKey(pstate.joins, forceOuter) : pstate.field.join(pstate.joins, forceOuter);
        if (!last) {
            this.joinRelation(pstate, key, forceOuter, true);
        }
        if (key) {
            return pstate.field.getKeyMapping().getTypeMapping();
        }
        if (pstate.field.getElement().getTypeCode() == 15) {
            return pstate.field.getElementMapping().getTypeMapping();
        }
        return pstate.field.getTypeMapping();
    }

    private void joinRelation(PathExpState pstate, boolean key, boolean forceOuter, boolean traverse) {
        if (pstate.field == null) {
            return;
        }
        pstate.joins = key ? pstate.field.joinKeyRelation(pstate.joins, forceOuter, traverse) : pstate.field.joinRelation(pstate.joins, forceOuter, traverse);
        pstate.joinedRel = true;
    }

    public Object toDataStoreValue(Select sel, ExpContext ctx, ExpState state, Object val) {
        FieldMapping field;
        PathExpState pstate = (PathExpState)state;
        FieldMapping fieldMapping = field = pstate.cmpfield != null ? pstate.cmpfield : pstate.field;
        if (this.isXPath()) {
            return val;
        }
        if (field != null) {
            if (this._key) {
                return field.toKeyDataStoreValue(val, ctx.store);
            }
            if (field.getElement().getDeclaredTypeCode() != 8) {
                return field.toDataStoreValue(val, ctx.store);
            }
            val = field.getExternalValue(val, ctx.store.getContext());
            return field.toDataStoreValue(val, ctx.store);
        }
        return this._class.toDataStoreValue(val, this._class.getPrimaryKeyColumns(), ctx.store);
    }

    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        this.selectColumns(sel, ctx, state, pks);
    }

    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        sel.setSchemaAlias(this._schemaAlias);
        ClassMapping mapping = this.getClassMapping(state);
        PathExpState pstate = (PathExpState)state;
        if (mapping == null || !pstate.joinedRel || pstate.isEmbedElementColl) {
            sel.select(this.getColumns(state), pstate.joins);
        } else if (this._key && pstate.field.getKey().isEmbedded()) {
            this.selectEmbeddedMapKey(sel, ctx, state);
        } else if (pks) {
            sel.select(mapping.getPrimaryKeyColumns(), pstate.joins);
        } else {
            int subs = this._type == 2 ? 1 : 3;
            sel.select(mapping, subs, ctx.store, ctx.fetch, 0, sel.outer(pstate.joins));
        }
    }

    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
        ClassMapping mapping = this.getClassMapping(state);
        PathExpState pstate = (PathExpState)state;
        if (mapping == null || !pstate.joinedRel) {
            sel.groupBy(this.getColumns(state), sel.outer(pstate.joins));
        } else {
            int subs = this._type == 2 ? 1 : 3;
            sel.groupBy(mapping, subs, ctx.store, ctx.fetch, sel.outer(pstate.joins));
        }
    }

    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
        sel.orderBy(this.getColumns(state), asc, sel.outer(state.joins), false);
    }

    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        return this.load(ctx, state, res, false);
    }

    Object load(ExpContext ctx, ExpState state, Result res, boolean pks) throws SQLException {
        ClassMapping mapping = this.getClassMapping(state);
        PathExpState pstate = (PathExpState)state;
        if (!(mapping == null || pstate.field != null && pstate.field.isEmbedded())) {
            if (pks) {
                return mapping.getObjectId(ctx.store, res, null, true, pstate.joins);
            }
            if (this._key && pstate.field.getKey().isEmbedded()) {
                return this.loadEmbeddedMapKey(ctx, state, res);
            }
            if (pstate.isEmbedElementColl) {
                return pstate.field.loadProjection(ctx.store, ctx.fetch, res, pstate.joins);
            }
            return res.load(mapping, ctx.store, ctx.fetch, pstate.joins);
        }
        Object ret = this._key ? res.getObject(pstate.cols[0], null, pstate.joins) : pstate.field.loadProjection(ctx.store, ctx.fetch, res, pstate.joins);
        if (this._cast != null) {
            ret = Filters.convert(ret, this._cast);
        }
        return ret;
    }

    private void validateMapStrategy(Strategy strategy) {
        if (strategy == null || !(strategy instanceof LRSMapFieldStrategy)) {
            throw new RuntimeException("Invalid map field strategy:" + strategy);
        }
    }

    private void selectEmbeddedMapKey(Select sel, ExpContext ctx, ExpState state) {
        PathExpState pstate = (PathExpState)state;
        this.validateMapStrategy(pstate.field.getStrategy());
        LRSMapFieldStrategy strategy = (LRSMapFieldStrategy)pstate.field.getStrategy();
        ClassMapping mapping = pstate.field.getKeyMapping().getTypeMapping();
        strategy.selectKey(sel, mapping, null, ctx.store, ctx.fetch, pstate.joins);
    }

    private Object loadEmbeddedMapKey(ExpContext ctx, ExpState state, Result res) throws SQLException {
        PathExpState pstate = (PathExpState)state;
        this.validateMapStrategy(pstate.field.getStrategy());
        LRSMapFieldStrategy strategy = (LRSMapFieldStrategy)pstate.field.getStrategy();
        return strategy.loadKey(null, ctx.store, ctx.fetch, res, pstate.joins);
    }

    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
    }

    public void verifyIndexedField() {
        Action lastAction = this.lastFieldAction();
        FieldMapping fm = (FieldMapping)lastAction.data;
        if (fm.getOrderColumn() == null) {
            throw new UserException(_loc.get("no-order-column", fm.getName()));
        }
    }

    public int length(Select sel, ExpContext ctx, ExpState state) {
        return this.getColumns(state).length;
    }

    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2, int index) {
        Column col = this.getColumns(state)[index];
        if (sel != null) {
            sel.setSchemaAlias(this._schemaAlias);
        }
        if (sel == null) {
            sql2.append(col.getName());
        } else if (this._type == 4) {
            sql2.append(this.getXPath());
        } else {
            sql2.append(sel.getColumnAlias(col, state.joins));
        }
    }

    public void appendIsEmpty(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            sql2.append(FALSE);
        } else {
            pstate.field.appendIsEmpty(sql2, sel, pstate.joins);
        }
    }

    public void appendIsNotEmpty(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            sql2.append(FALSE);
        } else {
            pstate.field.appendIsNotEmpty(sql2, sel, pstate.joins);
        }
    }

    public void appendIndex(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            sql2.append("1");
        } else {
            pstate.field.appendIndex(sql2, sel, pstate.joins);
        }
    }

    public void appendType(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2) {
        Discriminator disc = null;
        ClassMapping sup = this._class;
        while (sup.getMappedPCSuperclassMapping() != null) {
            sup = sup.getMappedPCSuperclassMapping();
        }
        disc = sup.getDiscriminator();
        Column[] cols = null;
        cols = disc != null ? disc.getColumns() : this.getColumns(state);
        if (cols == null) {
            sql2.append("1");
            return;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                sql2.append(", ");
            }
            sql2.append(sel.getColumnAlias(cols[i], state.joins));
        }
    }

    public void appendSize(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            sql2.append("1");
        } else {
            pstate.field.appendSize(sql2, sel, pstate.joins);
        }
    }

    public void appendIsNull(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            sql2.append(FALSE);
        } else {
            pstate.field.appendIsNull(sql2, sel, pstate.joins);
        }
    }

    public void appendIsNotNull(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql2) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            sql2.append(TRUE);
        } else {
            pstate.field.appendIsNotNull(sql2, sel, pstate.joins);
        }
    }

    public boolean isSubqueryPath() {
        return this._actions != null && this._actions.size() == 1 && ((Action)this._actions.get((int)0)).op == 4;
    }

    public int hashCode() {
        if (this._actions == null) {
            return this._candidate.hashCode();
        }
        return this._candidate.hashCode() ^ this._actions.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PCPath)) {
            return false;
        }
        PCPath path = (PCPath)other;
        return ObjectUtils.equals((Object)this._candidate, (Object)path._candidate) && ObjectUtils.equals((Object)this._actions, (Object)path._actions);
    }

    public int getId() {
        return 0;
    }

    private static class Action
    implements Serializable {
        public static final int GET = 0;
        public static final int GET_OUTER = 1;
        public static final int GET_KEY = 2;
        public static final int VAR = 3;
        public static final int SUBQUERY = 4;
        public static final int UNBOUND_VAR = 5;
        public static final int CAST = 6;
        public static final int GET_XPATH = 7;
        public int op = -1;
        public Object data = null;
        public String var = null;
        public Context context = null;

        private Action() {
        }

        public String toString() {
            return this.op + "|" + this.data;
        }

        public int hashCode() {
            if (this.data == null) {
                return this.op;
            }
            return this.op ^ this.data.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            Action a = (Action)other;
            return this.op == a.op && ObjectUtils.equals((Object)this.data, (Object)a.data);
        }
    }

    public static class PathExpState
    extends ExpState {
        public FieldMapping field = null;
        public FieldMapping cmpfield = null;
        public Column[] cols = null;
        public boolean joinedRel = false;
        public boolean isEmbedElementColl = false;

        public PathExpState(Joins joins) {
            super(joins);
        }
    }
}

