/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FetchConfigurationHintHandler;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.rop.EagerResultList;
import org.apache.openjpa.lib.rop.ListResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.rop.SimpleResultList;
import org.apache.openjpa.lib.rop.WindowResultList;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.NoTransactionException;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchConfigurationImpl
implements FetchConfiguration,
Cloneable {
    private static final Localizer _loc = Localizer.forPackage(FetchConfigurationImpl.class);
    private final ConfigurationState _state;
    private FetchConfigurationImpl _parent;
    private String _fromField;
    private Class _fromType;
    private String _directRelationOwner;
    private boolean _load = true;
    private int _availableRecursion;
    private int _availableDepth;
    private FetchConfigurationHintHandler _hintHandler;

    public FetchConfigurationImpl() {
        this(null);
    }

    protected FetchConfigurationImpl(ConfigurationState state) {
        this._state = state == null ? new ConfigurationState() : state;
        this._availableDepth = this._state.maxFetchDepth;
        this._hintHandler = new FetchConfigurationHintHandler(this);
    }

    @Override
    public StoreContext getContext() {
        return this._state.ctx;
    }

    @Override
    public void setContext(StoreContext ctx) {
        if (ctx != null && this._state.ctx != null && ctx != this._state.ctx) {
            throw new InternalException();
        }
        this._state.ctx = ctx;
        if (ctx == null) {
            return;
        }
        OpenJPAConfiguration conf = ctx.getConfiguration();
        this.setFetchBatchSize(conf.getFetchBatchSize());
        this.setFlushBeforeQueries(conf.getFlushBeforeQueriesConstant());
        this.setLockTimeout(conf.getLockTimeout());
        this.setQueryTimeout(conf.getQueryTimeout());
        this.clearFetchGroups();
        this.addFetchGroups(Arrays.asList(conf.getFetchGroupsList()));
        this.setMaxFetchDepth(conf.getMaxFetchDepth());
    }

    @Override
    public Object clone() {
        FetchConfigurationImpl clone = this.newInstance(null);
        clone._state.ctx = this._state.ctx;
        clone._parent = this._parent;
        clone._fromField = this._fromField;
        clone._fromType = this._fromType;
        clone._directRelationOwner = this._directRelationOwner;
        clone._load = this._load;
        clone._availableRecursion = this._availableRecursion;
        clone._availableDepth = this._availableDepth;
        clone.copy(this);
        return clone;
    }

    protected FetchConfigurationImpl newInstance(ConfigurationState state) {
        return new FetchConfigurationImpl(state);
    }

    @Override
    public void copy(FetchConfiguration fetch) {
        this.setFetchBatchSize(fetch.getFetchBatchSize());
        this.setMaxFetchDepth(fetch.getMaxFetchDepth());
        this.setQueryCacheEnabled(fetch.getQueryCacheEnabled());
        this.setFlushBeforeQueries(fetch.getFlushBeforeQueries());
        this.setExtendedPathLookup(fetch.getExtendedPathLookup());
        this.setLockTimeout(fetch.getLockTimeout());
        this.setQueryTimeout(fetch.getQueryTimeout());
        this.clearFetchGroups();
        this.addFetchGroups(fetch.getFetchGroups());
        this.clearFields();
        this.copyHints(fetch);
        this.addFields(fetch.getFields());
        this._state.readLockLevel = fetch.getReadLockLevel();
        this._state.writeLockLevel = fetch.getWriteLockLevel();
    }

    void copyHints(FetchConfiguration fetch) {
        if (!(fetch instanceof FetchConfigurationImpl)) {
            return;
        }
        FetchConfigurationImpl from = (FetchConfigurationImpl)fetch;
        if (from._state == null || from._state.hints == null) {
            return;
        }
        if (this._state == null) {
            return;
        }
        if (this._state.hints == null) {
            this._state.hints = new HashMap();
        }
        this._state.hints.putAll(from._state.hints);
    }

    @Override
    public int getFetchBatchSize() {
        return this._state.fetchBatchSize;
    }

    @Override
    public FetchConfiguration setFetchBatchSize(int fetchBatchSize) {
        if (fetchBatchSize == -99 && this._state.ctx != null) {
            fetchBatchSize = this._state.ctx.getConfiguration().getFetchBatchSize();
        }
        if (fetchBatchSize != -99) {
            this._state.fetchBatchSize = fetchBatchSize;
        }
        return this;
    }

    @Override
    public int getMaxFetchDepth() {
        return this._state.maxFetchDepth;
    }

    @Override
    public FetchConfiguration setMaxFetchDepth(int depth) {
        if (depth == -99 && this._state.ctx != null) {
            depth = this._state.ctx.getConfiguration().getMaxFetchDepth();
        }
        if (depth != -99) {
            this._state.maxFetchDepth = depth;
            if (this._parent == null) {
                this._availableDepth = depth;
            }
        }
        return this;
    }

    @Override
    public boolean getQueryCacheEnabled() {
        return this._state.queryCache;
    }

    @Override
    public FetchConfiguration setQueryCacheEnabled(boolean cache) {
        this._state.queryCache = cache;
        return this;
    }

    @Override
    public int getFlushBeforeQueries() {
        return this._state.flushQuery;
    }

    @Override
    public boolean getExtendedPathLookup() {
        return this._state.extendedPathLookup;
    }

    @Override
    public FetchConfiguration setExtendedPathLookup(boolean flag) {
        this._state.extendedPathLookup = flag;
        return this;
    }

    @Override
    public FetchConfiguration setFlushBeforeQueries(int flush) {
        if (flush != -99 && flush != 0 && flush != 1 && flush != 2) {
            throw new IllegalArgumentException(_loc.get("bad-flush-before-queries", new Integer(flush)).getMessage());
        }
        if (flush == -99 && this._state.ctx != null) {
            this._state.flushQuery = this._state.ctx.getConfiguration().getFlushBeforeQueriesConstant();
        } else if (flush != -99) {
            this._state.flushQuery = flush;
        }
        return this;
    }

    @Override
    public Set getFetchGroups() {
        return this._state.fetchGroups == null ? Collections.EMPTY_SET : this._state.fetchGroups;
    }

    @Override
    public boolean hasFetchGroup(String group) {
        return this._state.fetchGroups != null && (this._state.fetchGroups.contains(group) || this._state.fetchGroups.contains("all"));
    }

    public boolean hasFetchGroupDefault() {
        return this._state.fetchGroupContainsDefault || this._state.fetchGroupContainsAll;
    }

    public boolean hasFetchGroupAll() {
        return this._state.fetchGroupContainsAll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration addFetchGroup(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new UserException(_loc.get("null-fg"));
        }
        this.lock();
        try {
            if (this._state.fetchGroups == null) {
                this._state.fetchGroups = new HashSet();
            }
            this._state.fetchGroups.add(name);
            if ("all".equals(name)) {
                this._state.fetchGroupContainsAll = true;
            } else if ("default".equals(name)) {
                this._state.fetchGroupContainsDefault = true;
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    @Override
    public FetchConfiguration addFetchGroups(Collection groups) {
        if (groups == null || groups.isEmpty()) {
            return this;
        }
        Iterator itr = groups.iterator();
        while (itr.hasNext()) {
            this.addFetchGroup((String)itr.next());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration removeFetchGroup(String group) {
        this.lock();
        try {
            if (this._state.fetchGroups != null) {
                this._state.fetchGroups.remove(group);
                if ("all".equals(group)) {
                    this._state.fetchGroupContainsAll = false;
                } else if ("default".equals(group)) {
                    this._state.fetchGroupContainsDefault = false;
                }
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration removeFetchGroups(Collection groups) {
        this.lock();
        try {
            if (this._state.fetchGroups != null && groups != null) {
                for (Object group : groups) {
                    this.removeFetchGroup(group.toString());
                }
            }
            Object var5_4 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration clearFetchGroups() {
        this.lock();
        try {
            if (this._state.fetchGroups != null) {
                this._state.fetchGroups.clear();
                this._state.fetchGroupContainsAll = false;
                this._state.fetchGroupContainsDefault = true;
            }
            Object var2_1 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    @Override
    public FetchConfiguration resetFetchGroups() {
        this.clearFetchGroups();
        if (this._state.ctx != null) {
            this.addFetchGroups(Arrays.asList(this._state.ctx.getConfiguration().getFetchGroupsList()));
        }
        return this;
    }

    @Override
    public Set getFields() {
        return this._state.fields == null ? Collections.EMPTY_SET : this._state.fields;
    }

    @Override
    public boolean hasField(String field) {
        return this._state.fields != null && this._state.fields.contains(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration addField(String field) {
        if (StringUtils.isEmpty((String)field)) {
            throw new UserException(_loc.get("null-field"));
        }
        this.lock();
        try {
            if (this._state.fields == null) {
                this._state.fields = new HashSet();
            }
            this._state.fields.add(field);
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration addFields(Collection fields) {
        if (fields == null || fields.isEmpty()) {
            return this;
        }
        this.lock();
        try {
            if (this._state.fields == null) {
                this._state.fields = new HashSet();
            }
            this._state.fields.addAll(fields);
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration removeField(String field) {
        this.lock();
        try {
            if (this._state.fields != null) {
                this._state.fields.remove(field);
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration removeFields(Collection fields) {
        this.lock();
        try {
            if (this._state.fields != null) {
                this._state.fields.removeAll(fields);
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration clearFields() {
        this.lock();
        try {
            if (this._state.fields != null) {
                this._state.fields.clear();
            }
            Object var2_1 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    @Override
    public int getLockTimeout() {
        return this._state.lockTimeout;
    }

    @Override
    public FetchConfiguration setLockTimeout(int timeout) {
        if (timeout == -99 && this._state.ctx != null) {
            this._state.lockTimeout = this._state.ctx.getConfiguration().getLockTimeout();
        } else if (timeout != -99) {
            if (timeout < -1) {
                throw new IllegalArgumentException(_loc.get("invalid-timeout", timeout).getMessage());
            }
            this._state.lockTimeout = timeout;
        }
        return this;
    }

    @Override
    public int getQueryTimeout() {
        return this._state.queryTimeout;
    }

    @Override
    public FetchConfiguration setQueryTimeout(int timeout) {
        if (timeout == -99 && this._state.ctx != null) {
            this._state.queryTimeout = this._state.ctx.getConfiguration().getQueryTimeout();
        } else if (timeout != -99) {
            if (timeout < -1) {
                throw new IllegalArgumentException(_loc.get("invalid-timeout", timeout).getMessage());
            }
            this._state.queryTimeout = timeout;
        }
        return this;
    }

    @Override
    public int getReadLockLevel() {
        String lockModeKey = "openjpa.FetchPlan.ReadLockMode";
        String deferLockModeKey = lockModeKey + ".Defer";
        Integer value = (Integer)this.getHint(deferLockModeKey);
        if (value != null) {
            if (this.isActiveTransaction()) {
                this.removeHint(deferLockModeKey);
                this.setReadLockLevel(value);
            } else {
                return value;
            }
        }
        return this._state.readLockLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration setReadLockLevel(int level) {
        if (this._state.ctx == null) {
            return this;
        }
        if (level != -99 && level != 0 && level != 10 && level != 15 && level != 20 && level != 25 && level != 30 && level != 40 && level != 50) {
            throw new IllegalArgumentException(_loc.get("bad-lock-level", new Integer(level)).getMessage());
        }
        this.lock();
        try {
            this.assertActiveTransaction();
            this._state.readLockLevel = level == -99 ? this._state.ctx.getConfiguration().getReadLockLevelConstant() : level;
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    @Override
    public int getWriteLockLevel() {
        String lockModeKey = "openjpa.FetchPlan.WriteLockMode";
        String deferLockModeKey = lockModeKey + ".Defer";
        Integer value = (Integer)this.getHint(deferLockModeKey);
        if (value != null) {
            if (this.isActiveTransaction()) {
                this.removeHint(deferLockModeKey);
                this.setWriteLockLevel(value);
            } else {
                return value;
            }
        }
        return this._state.writeLockLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration setWriteLockLevel(int level) {
        if (this._state.ctx == null) {
            return this;
        }
        if (level != -99 && level != 0 && level != 10 && level != 15 && level != 20 && level != 25 && level != 30 && level != 40 && level != 50) {
            throw new IllegalArgumentException(_loc.get("bad-lock-level", new Integer(level)).getMessage());
        }
        this.lock();
        try {
            this.assertActiveTransaction();
            this._state.writeLockLevel = level == -99 ? this._state.ctx.getConfiguration().getWriteLockLevelConstant() : level;
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    @Override
    public ResultList newResultList(ResultObjectProvider rop) {
        if (rop instanceof ListResultObjectProvider) {
            return new SimpleResultList(rop);
        }
        if (this._state.fetchBatchSize < 0) {
            return new EagerResultList(rop);
        }
        if (rop.supportsRandomAccess()) {
            return new SimpleResultList(rop);
        }
        return new WindowResultList(rop);
    }

    private void assertActiveTransaction() {
        if (!this.isActiveTransaction()) {
            throw new NoTransactionException(_loc.get("not-active"));
        }
    }

    private boolean isActiveTransaction() {
        return this._state.ctx != null && this._state.ctx.isActive();
    }

    @Override
    public void setHint(String name, Object value) {
        this.setHint(name, value, false);
    }

    public void setHint(String name, Object value, boolean validThrowException) {
        if (this._hintHandler.setHint(name, value, validThrowException)) {
            this.addHint(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHint(String name, Object value) {
        this.lock();
        try {
            if (this._state.hints == null) {
                this._state.hints = new HashMap();
            }
            this._state.hints.put(name, value);
            Object var4_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    @Override
    public Object getHint(String name) {
        return this._state.hints == null ? null : this._state.hints.get(name);
    }

    public Object removeHint(String name) {
        return this._state.hints == null ? null : this._state.hints.remove(name);
    }

    @Override
    public Map<String, Object> getHints() {
        if (this._state.hints == null) {
            return Collections.EMPTY_MAP;
        }
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Object key : this._state.hints.keySet()) {
            result.put(key.toString(), this._state.hints.get(key));
        }
        return result;
    }

    @Override
    public Set getRootClasses() {
        return this._state.rootClasses == null ? Collections.EMPTY_SET : this._state.rootClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration setRootClasses(Collection classes) {
        this.lock();
        try {
            if (this._state.rootClasses != null) {
                this._state.rootClasses.clear();
            }
            if (classes != null && !classes.isEmpty()) {
                if (this._state.rootClasses == null) {
                    this._state.rootClasses = new HashSet(classes);
                } else {
                    this._state.rootClasses.addAll(classes);
                }
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    @Override
    public Set getRootInstances() {
        return this._state.rootInstances == null ? Collections.EMPTY_SET : this._state.rootInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FetchConfiguration setRootInstances(Collection instances) {
        this.lock();
        try {
            if (this._state.rootInstances != null) {
                this._state.rootInstances.clear();
            }
            if (instances != null && !instances.isEmpty()) {
                if (this._state.rootInstances == null) {
                    this._state.rootInstances = new HashSet(instances);
                } else {
                    this._state.rootInstances.addAll(instances);
                }
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        return this;
    }

    @Override
    public void lock() {
        if (this._state.ctx != null) {
            this._state.ctx.lock();
        }
    }

    @Override
    public void unlock() {
        if (this._state.ctx != null) {
            this._state.ctx.unlock();
        }
    }

    @Override
    public int requiresFetch(FieldMetaData fm) {
        if (!this.includes(fm)) {
            return 0;
        }
        Class type = FetchConfigurationImpl.getRelationType(fm);
        if (type == null) {
            return 1;
        }
        if (this._availableDepth == 0) {
            return 0;
        }
        if (this._parent == null) {
            return 1;
        }
        int rdepth = this.getAvailableRecursionDepth(fm, type, false);
        if (rdepth != -1 && rdepth <= 0) {
            return 0;
        }
        if (StringUtils.equals((String)this._directRelationOwner, (String)fm.getFullName())) {
            return 2;
        }
        return 1;
    }

    @Override
    public boolean requiresLoad() {
        return this._load;
    }

    @Override
    public FetchConfiguration traverse(FieldMetaData fm) {
        Class type = FetchConfigurationImpl.getRelationType(fm);
        if (type == null) {
            return this;
        }
        FetchConfigurationImpl clone = this.newInstance(this._state);
        clone._parent = this;
        clone._availableDepth = FetchConfigurationImpl.reduce(this._availableDepth);
        clone._fromField = fm.getFullName(false);
        clone._fromType = type;
        clone._availableRecursion = this.getAvailableRecursionDepth(fm, type, true);
        clone._load = StringUtils.equals((String)this._directRelationOwner, (String)fm.getFullName(false)) ? false : this._load;
        FieldMetaData owner = fm.getMappedByMetaData();
        if (owner != null && owner.getTypeCode() == 15) {
            clone._directRelationOwner = owner.getFullName(false);
        }
        return clone;
    }

    private boolean includes(FieldMetaData fmd) {
        if (this.hasFetchGroupDefault() && fmd.isInDefaultFetchGroup() || this.hasFetchGroupAll() || this.hasField(fmd.getFullName(false)) || this.hasExtendedLookupPath(fmd)) {
            return true;
        }
        String[] fgs = fmd.getCustomFetchGroups();
        for (int i = 0; i < fgs.length; ++i) {
            if (!this.hasFetchGroup(fgs[i])) continue;
            return true;
        }
        return false;
    }

    private boolean hasExtendedLookupPath(FieldMetaData fmd) {
        return this.getExtendedPathLookup() && (this.hasField(fmd.getRealName()) || this._fromField != null && this.hasField(this._fromField + "." + fmd.getName()));
    }

    private int getAvailableRecursionDepth(FieldMetaData fm, Class type, boolean traverse) {
        int avail = Integer.MIN_VALUE;
        FetchConfigurationImpl f = this;
        while (f != null) {
            if (ImplHelper.isAssignable(f._fromType, type)) {
                avail = f._availableRecursion;
                if (!traverse) break;
                avail = FetchConfigurationImpl.reduce(avail);
                break;
            }
            f = f._parent;
        }
        if (avail == 0) {
            return 0;
        }
        ClassMetaData meta = fm.getDefiningMetaData();
        int max = Integer.MIN_VALUE;
        if (fm.isInDefaultFetchGroup()) {
            max = meta.getFetchGroup("default").getRecursionDepth(fm);
        }
        String[] groups = fm.getCustomFetchGroups();
        for (int i = 0; max != -1 && i < groups.length; ++i) {
            int cur;
            if (!this.hasFetchGroup(groups[i]) || (cur = meta.getFetchGroup(groups[i]).getRecursionDepth(fm)) != -1 && cur <= max) continue;
            max = cur;
        }
        if (traverse && max != Integer.MIN_VALUE && ImplHelper.isAssignable(meta.getDescribedType(), type)) {
            max = FetchConfigurationImpl.reduce(max);
        }
        if (avail == Integer.MIN_VALUE && max == Integer.MIN_VALUE) {
            int def = 1;
            return traverse && ImplHelper.isAssignable(meta.getDescribedType(), type) ? def - 1 : def;
        }
        if (avail == Integer.MIN_VALUE || avail == -1) {
            return max;
        }
        if (max == Integer.MIN_VALUE || max == -1) {
            return avail;
        }
        return Math.min(max, avail);
    }

    private static Class getRelationType(FieldMetaData fm) {
        if (fm.isDeclaredTypePC()) {
            return fm.getDeclaredType();
        }
        if (fm.getElement().isDeclaredTypePC()) {
            return fm.getElement().getDeclaredType();
        }
        if (fm.getKey().isDeclaredTypePC()) {
            return fm.getKey().getDeclaredType();
        }
        return null;
    }

    private static int reduce(int d) {
        if (d == 0) {
            return 0;
        }
        if (d != -1) {
            --d;
        }
        return d;
    }

    FetchConfiguration getParent() {
        return this._parent;
    }

    boolean isRoot() {
        return this._parent == null;
    }

    FetchConfiguration getRoot() {
        return this.isRoot() ? this : this._parent.getRoot();
    }

    int getAvailableFetchDepth() {
        return this._availableDepth;
    }

    int getAvailableRecursionDepth() {
        return this._availableRecursion;
    }

    String getTraversedFromField() {
        return this._fromField;
    }

    Class getTraversedFromType() {
        return this._fromType;
    }

    List getPath() {
        if (this.isRoot()) {
            return Collections.EMPTY_LIST;
        }
        return this.trackPath(new ArrayList());
    }

    List trackPath(List path) {
        if (this._parent != null) {
            this._parent.trackPath(path);
        }
        path.add(this);
        return path;
    }

    public String toString() {
        return "FetchConfiguration@" + System.identityHashCode(this) + " (" + this._availableDepth + ")" + this.getPathString();
    }

    private String getPathString() {
        List path = this.getPath();
        if (path.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer().append(": ");
        Iterator itr = path.iterator();
        while (itr.hasNext()) {
            buf.append(((FetchConfigurationImpl)itr.next()).getTraversedFromField());
            if (!itr.hasNext()) continue;
            buf.append("->");
        }
        return buf.toString();
    }

    protected static class ConfigurationState
    implements Serializable {
        public transient StoreContext ctx = null;
        public int fetchBatchSize = 0;
        public int maxFetchDepth = 1;
        public boolean queryCache = true;
        public int flushQuery = 0;
        public int lockTimeout = -1;
        public int queryTimeout = -1;
        public int lockMode = 0;
        public int readLockLevel = 0;
        public int writeLockLevel = 0;
        public Set fetchGroups = null;
        public Set fields = null;
        public Set rootClasses;
        public Set rootInstances;
        public Map hints = null;
        public boolean fetchGroupContainsDefault = false;
        public boolean fetchGroupContainsAll = false;
        public boolean extendedPathLookup = false;

        protected ConfigurationState() {
        }
    }
}

