/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.xml;

import java.text.MessageFormat;
import org.apache.openjpa.lib.util.Localizer;
import org.xml.sax.Locator;
import serp.util.Numbers;

public class Location {
    private static final Localizer _loc = Localizer.forPackage(Location.class);
    private boolean _nullOnNoLocator = false;
    private Locator _locator = null;

    public Location() {
        this(false);
    }

    public Location(boolean nullOnNoLocator) {
        this._nullOnNoLocator = nullOnNoLocator;
    }

    public String getLocation(String format) {
        if (this._locator == null) {
            if (this._nullOnNoLocator) {
                return null;
            }
            return _loc.get("no-locator").getMessage();
        }
        return MessageFormat.format(format, Numbers.valueOf((int)this._locator.getLineNumber()), Numbers.valueOf((int)this._locator.getColumnNumber()), this._locator.getPublicId(), this._locator.getSystemId());
    }

    public String getLocation() {
        return this.getLocation(_loc.get("location-format").getMessage());
    }

    public void setLocator(Locator locator) {
        this._locator = locator;
    }

    public Locator getLocator() {
        return this._locator;
    }

    public void setNullOnNoLocator(boolean val) {
        this._nullOnNoLocator = val;
    }

    public boolean isNullOnNoLocator() {
        return this._nullOnNoLocator;
    }
}

