/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.DynamicPersistenceCapable;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.event.LifecycleEventManager;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.lib.util.StringDistance;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.InMemoryRelatedFieldOrder;
import org.apache.openjpa.meta.InMemoryValueOrder;
import org.apache.openjpa.meta.InheritanceComparator;
import org.apache.openjpa.meta.InheritanceOrderedMetaDataList;
import org.apache.openjpa.meta.InterfaceImplGenerator;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.MetaDataModes;
import org.apache.openjpa.meta.NonPersistentMetaData;
import org.apache.openjpa.meta.Order;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.meta.ValueMetaDataImpl;
import org.apache.openjpa.meta.XMLClassMetaData;
import org.apache.openjpa.meta.XMLFieldMetaData;
import org.apache.openjpa.meta.XMLMetaData;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.OpenJPAId;
import serp.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataRepository
implements PCRegistry.RegisterClassListener,
Configurable,
Closeable,
MetaDataModes,
Serializable {
    public static final int VALIDATE_NONE = 0;
    public static final int VALIDATE_META = 1;
    public static final int VALIDATE_MAPPING = 2;
    public static final int VALIDATE_UNENHANCED = 4;
    public static final int VALIDATE_RUNTIME = 8;
    protected static final Class<?>[] EMPTY_CLASSES = new Class[0];
    protected static final NonPersistentMetaData[] EMPTY_NON_PERSISTENT = new NonPersistentMetaData[0];
    protected final ClassMetaData[] EMPTY_METAS;
    protected final FieldMetaData[] EMPTY_FIELDS;
    protected final Order[] EMPTY_ORDERS;
    private static final Localizer _loc = Localizer.forPackage(MetaDataRepository.class);
    private SequenceMetaData _sysSeq = null;
    private Map<Class<?>, ClassMetaData> _metas = new HashMap();
    private Map<Class<?>, Class<?>> _oids = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, Collection<Class<?>>> _impls = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, Class<?>> _ifaces = Collections.synchronizedMap(new HashMap());
    private Map<Object, QueryMetaData> _queries = new HashMap<Object, QueryMetaData>();
    private Map<String, SequenceMetaData> _seqs = new HashMap<String, SequenceMetaData>();
    private Map<String, List<Class<?>>> _aliases = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, NonPersistentMetaData> _pawares = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, NonPersistentMetaData> _nonMapped = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, Class<?>> _metamodel = Collections.synchronizedMap(new HashMap());
    private Map<Class<?>, List<Class<?>>> _subs = Collections.synchronizedMap(new HashMap());
    protected final XMLMetaData[] EMPTY_XMLMETAS;
    private final Map<Class<?>, XMLMetaData> _xmlmetas = new HashMap();
    private transient OpenJPAConfiguration _conf = null;
    private transient Log _log = null;
    private transient InterfaceImplGenerator _implGen = null;
    private transient MetaDataFactory _factory = null;
    private int _resMode = 3;
    private int _sourceMode = 7;
    private int _validate = 5;
    private final Collection<Class<?>> _registered = new HashSet();
    private final InheritanceOrderedMetaDataList _resolving = new InheritanceOrderedMetaDataList();
    private final InheritanceOrderedMetaDataList _mapping = new InheritanceOrderedMetaDataList();
    private final List<RuntimeException> _errs = new LinkedList<RuntimeException>();
    private LifecycleEventManager.ListenerList _listeners = new LifecycleEventManager.ListenerList(3);
    private ReentrantLock _lock = null;
    protected boolean _preload = false;
    protected boolean _noLock = false;

    public MetaDataRepository() {
        this.EMPTY_METAS = this.newClassMetaDataArray(0);
        this.EMPTY_FIELDS = this.newFieldMetaDataArray(0);
        this.EMPTY_ORDERS = this.newOrderArray(0);
        this.EMPTY_XMLMETAS = this.newXMLClassMetaDataArray(0);
    }

    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    public Log getLog() {
        return this._log;
    }

    public MetaDataFactory getMetaDataFactory() {
        return this._factory;
    }

    public void setMetaDataFactory(MetaDataFactory factory) {
        factory.setRepository(this);
        this._factory = factory;
    }

    public int getValidate() {
        return this._validate;
    }

    public void setValidate(int validate) {
        this._validate = validate;
    }

    public void setValidate(int validate, boolean on) {
        this._validate = validate == 0 ? validate : (on ? (this._validate |= validate) : (this._validate &= ~validate));
    }

    public int getResolve() {
        return this._resMode;
    }

    public void setResolve(int mode) {
        this._resMode = mode;
    }

    public void setResolve(int mode, boolean on) {
        this._resMode = mode == 0 ? mode : (on ? (this._resMode |= mode) : (this._resMode &= ~mode));
    }

    public int getSourceMode() {
        return this._sourceMode;
    }

    public void setSourceMode(int mode) {
        this._sourceMode = mode;
    }

    public void setSourceMode(int mode, boolean on) {
        this._sourceMode = mode == 0 ? mode : (on ? (this._sourceMode |= mode) : (this._sourceMode &= ~mode));
    }

    public boolean getPreload() {
        return this._preload;
    }

    public void setPreload(boolean l) {
        this._preload = l;
    }

    public void setNoLock(boolean l) {
        this._noLock = l;
    }

    public boolean getNoLock() {
        return this._noLock;
    }

    public void preload() {
        if (!this._preload) {
            return;
        }
        if (this._log.isInfoEnabled()) {
            this._log.info(_loc.get(this._noLock ? "repos-preload" : "repos-preload-nolock"));
        }
        if (this._noLock) {
            this._oids = new HashMap();
            this._impls = new HashMap();
            this._ifaces = new HashMap();
            this._aliases = new HashMap();
            this._pawares = new HashMap();
            this._nonMapped = new HashMap();
            this._subs = new HashMap();
            this._metamodel = new HashMap();
            this._lock = null;
        }
        MultiClassLoader multi = AccessController.doPrivileged(J2DoPrivHelper.newMultiClassLoaderAction());
        multi.addClassLoader(AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
        multi.addClassLoader(AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(MetaDataRepository.class)));
        Set<String> classes = this.getPersistentTypeNames(false, multi);
        if (classes == null || classes.size() == 0) {
            throw new MetaDataException(_loc.get("repos-preload-none"));
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("repos-preloading", this.getClass().getName(), classes.toString()));
        }
        for (String c : classes) {
            try {
                Class<?> cls = AccessController.doPrivileged(J2DoPrivHelper.getForNameAction(c, true, multi));
                this._factory.load(cls, 31, multi);
            }
            catch (PrivilegedActionException pae) {
                throw new MetaDataException(_loc.get("repos-preload-error"), (Throwable)pae);
            }
        }
    }

    protected void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    protected void unlock() {
        if (this._lock != null) {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetaData getMetaData(Class cls, ClassLoader envLoader, boolean mustExist) {
        this.lock();
        try {
            ClassMetaData meta;
            if (cls != null && DynamicPersistenceCapable.class.isAssignableFrom(cls)) {
                cls = cls.getSuperclass();
            }
            if (cls != null && this._implGen.isImplType(cls)) {
                cls = this._implGen.toManagedInterface(cls);
            }
            if ((meta = this.getMetaDataInternal(cls, envLoader)) == null && mustExist) {
                if (cls != null && !ImplHelper.isManagedType(this._conf, cls)) {
                    throw new MetaDataException(_loc.get("no-meta-notpc", cls)).setFatal(false);
                }
                Set<String> pcNames = this.getPersistentTypeNames(false, envLoader);
                if (pcNames != null && pcNames.size() > 0) {
                    throw new MetaDataException(_loc.get("no-meta-types", cls, pcNames));
                }
                throw new MetaDataException(_loc.get("no-meta", cls));
            }
            this.resolve(meta);
            ClassMetaData classMetaData = meta;
            return classMetaData;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetaData getMetaData(String alias, ClassLoader envLoader, boolean mustExist) {
        if (alias == null && mustExist) {
            throw new MetaDataException(_loc.get("no-alias-meta", alias, this._aliases));
        }
        if (alias == null) {
            return null;
        }
        this.processRegisteredClasses(envLoader);
        List<Class<?>> classList = this._aliases.get(alias);
        Set<String> pcNames = this.getPersistentTypeNames(false, envLoader);
        Class<?> cls = null;
        for (int i = 0; classList != null && i < classList.size(); ++i) {
            Class<?> c = classList.get(i);
            try {
                Class<?> nc = Class.forName(c.getName(), false, envLoader);
                if (pcNames != null && pcNames.size() != 0 && !pcNames.contains(nc.getName())) continue;
                cls = nc;
                if (classList.contains(cls)) break;
                classList.add(cls);
                break;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (cls != null) {
            return this.getMetaData(cls, envLoader, mustExist);
        }
        if (this._aliases.containsKey(alias)) {
            if (mustExist) {
                this.throwNoRegisteredAlias(alias);
            }
            return null;
        }
        Map<String, List<Class<?>>> map = this._aliases;
        synchronized (map) {
            this._aliases.put(alias, null);
        }
        if (!mustExist) {
            return null;
        }
        return this.throwNoRegisteredAlias(alias);
    }

    private ClassMetaData throwNoRegisteredAlias(String alias) {
        String close = this.getClosestAliasName(alias);
        if (close != null) {
            throw new MetaDataException(_loc.get("no-alias-meta-hint", alias, this._aliases, close));
        }
        throw new MetaDataException(_loc.get("no-alias-meta", alias, this._aliases));
    }

    public String getClosestAliasName(String alias) {
        Collection<String> aliases = this.getAliasNames();
        return StringDistance.getClosestLevenshteinDistance(alias, aliases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAliasNames() {
        HashSet<String> aliases = new HashSet<String>();
        Map<String, List<Class<?>>> map = this._aliases;
        synchronized (map) {
            for (Map.Entry<String, List<Class<?>>> e : this._aliases.entrySet()) {
                if (e.getValue() == null) continue;
                aliases.add(e.getKey());
            }
        }
        return aliases;
    }

    private ClassMetaData getMetaDataInternal(Class<?> cls, ClassLoader envLoader) {
        Set<String> pcNames;
        if (cls == null) {
            return null;
        }
        ClassMetaData meta = this._metas.get(cls);
        if (meta != null && ((meta.getSourceMode() & 1) != 0 || (this._sourceMode & 1) == 0)) {
            return meta;
        }
        if ((this._validate & 8) != 0 && (pcNames = this.getPersistentTypeNames(false, envLoader)) != null && !pcNames.contains(cls.getName())) {
            return meta;
        }
        if (meta == null) {
            if (this._metas.containsKey(cls)) {
                return null;
            }
            if (cls.isPrimitive() || cls.getName().startsWith("java.") || cls == PersistenceCapable.class) {
                return null;
            }
            if ((this._validate & 8) != 0) {
                try {
                    Class.forName(cls.getName(), true, AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(cls)));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        int mode = 0;
        if ((this._sourceMode & 1) != 0) {
            mode = this._sourceMode & 0xFFFFFFFD;
        } else if ((this._sourceMode & 2) == 0) {
            mode = this._sourceMode;
        }
        if (mode != 0) {
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("load-cls", cls, MetaDataRepository.toModeString(mode)));
            }
            this._factory.load(cls, mode, envLoader);
        }
        if (meta == null) {
            meta = this._metas.get(cls);
        }
        if (meta != null && ((meta.getSourceMode() & 1) != 0 || (this._sourceMode & 1) == 0)) {
            return meta;
        }
        if (meta != null) {
            this.removeMetaData(meta);
        }
        this._metas.put(cls, null);
        return null;
    }

    private static String toModeString(int mode) {
        StringBuffer buf = new StringBuffer(31);
        if ((mode & 1) != 0) {
            buf.append("[META]");
        }
        if ((mode & 4) != 0) {
            buf.append("[QUERY]");
        }
        if ((mode & 2) != 0) {
            buf.append("[MAPPING]");
        }
        if ((mode & 8) != 0) {
            buf.append("[MAPPING_INIT]");
        }
        return buf.toString();
    }

    protected void prepareMapping(ClassMetaData meta) {
        meta.defineSuperclassFields(false);
    }

    private void resolve(ClassMetaData meta) {
        int i;
        if (meta == null || this._resMode == 0 || (meta.getResolve() & 1) != 0) {
            return;
        }
        List<ClassMetaData> resolved = this.resolveMeta(meta);
        if (resolved == null) {
            return;
        }
        for (i = 0; i < resolved.size(); ++i) {
            this.loadMapping(resolved.get(i));
        }
        for (i = 0; i < resolved.size(); ++i) {
            this.preMapping(resolved.get(i));
        }
        boolean err = true;
        if ((this._resMode & 2) != 0) {
            for (int i2 = 0; i2 < resolved.size(); ++i2) {
                err &= this.resolveMapping(resolved.get(i2));
            }
        }
        if (err && !this._errs.isEmpty()) {
            RuntimeException re = this._errs.size() == 1 ? this._errs.get(0) : new MetaDataException(_loc.get("resolve-errs")).setNestedThrowables(this._errs.toArray(new Exception[this._errs.size()]));
            this._errs.clear();
            throw re;
        }
    }

    private List<ClassMetaData> resolveMeta(ClassMetaData meta) {
        if (meta.getPCSuperclass() == null) {
            ClassMetaData supMeta;
            Class<?> sup;
            for (sup = meta.getDescribedType().getSuperclass(); sup != null && sup != Object.class; sup = sup.getSuperclass()) {
                supMeta = this.getMetaData(sup, meta.getEnvClassLoader(), false);
                if (supMeta == null) continue;
                meta.setPCSuperclass(sup);
                meta.setPCSuperclassMetaData(supMeta);
                break;
            }
            if (meta.getDescribedType().isInterface()) {
                Class<?>[] sups = meta.getDescribedType().getInterfaces();
                for (int i = 0; i < sups.length; ++i) {
                    supMeta = this.getMetaData(sups[i], meta.getEnvClassLoader(), false);
                    if (supMeta == null) continue;
                    meta.setPCSuperclass(sup);
                    meta.setPCSuperclassMetaData(supMeta);
                    break;
                }
            }
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("assigned-sup", meta, meta.getPCSuperclass()));
            }
        }
        FieldMetaData[] fmds = meta.getDeclaredFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (!fmds[i].isPrimaryKey()) continue;
            this.getMetaData(fmds[i].getDeclaredType(), meta.getEnvClassLoader(), false);
        }
        return this.processBuffer(meta, this._resolving, 1);
    }

    private void loadMapping(ClassMetaData meta) {
        if ((meta.getResolve() & 2) != 0) {
            return;
        }
        if ((meta.getSourceMode() & 2) == 0 && (this._sourceMode & 2) != 0) {
            if (meta.isEmbeddedOnly()) {
                meta.setSourceMode(2, true);
            } else {
                int mode = this._sourceMode & 0xFFFFFFFE;
                if (this._log.isTraceEnabled()) {
                    this._log.trace(_loc.get("load-mapping", meta, MetaDataRepository.toModeString(mode)));
                }
                try {
                    this._factory.load(meta.getDescribedType(), mode, meta.getEnvClassLoader());
                }
                catch (RuntimeException re) {
                    this.removeMetaData(meta);
                    this._errs.add(re);
                }
            }
        }
    }

    private void preMapping(ClassMetaData meta) {
        if ((meta.getResolve() & 2) != 0) {
            return;
        }
        try {
            if ((this._resMode & 2) != 0) {
                if (this._log.isTraceEnabled()) {
                    this._log.trace(_loc.get("prep-mapping", meta));
                }
                this.prepareMapping(meta);
            } else {
                meta.defineSuperclassFields(false);
            }
        }
        catch (RuntimeException re) {
            this.removeMetaData(meta);
            this._errs.add(re);
        }
    }

    private boolean resolveMapping(ClassMetaData meta) {
        List<ClassMetaData> mapped = this.processBuffer(meta, this._mapping, 2);
        if (mapped == null) {
            return false;
        }
        if ((this._resMode & 8) != 0) {
            for (int i = 0; i < mapped.size(); ++i) {
                meta = mapped.get(i);
                try {
                    meta.resolve(8);
                    continue;
                }
                catch (RuntimeException re) {
                    this.removeMetaData(meta);
                    this._errs.add(re);
                }
            }
        }
        return true;
    }

    private List<ClassMetaData> processBuffer(ClassMetaData meta, InheritanceOrderedMetaDataList buffer, int mode) {
        if (!buffer.add(meta) || buffer.size() != 1) {
            return null;
        }
        ArrayList<ClassMetaData> processed = new ArrayList<ClassMetaData>(5);
        while (!buffer.isEmpty()) {
            ClassMetaData buffered = buffer.peek();
            try {
                buffered.resolve(mode);
                processed.add(buffered);
                buffer.remove(buffered);
            }
            catch (RuntimeException re) {
                this._errs.add(re);
                Iterator<ClassMetaData> itr = buffer.iterator();
                while (itr.hasNext()) {
                    meta = itr.next();
                    this.removeMetaData(meta);
                    if (meta == buffered) continue;
                    this._errs.add(new MetaDataException(_loc.get("prev-errs", meta, buffered)));
                }
                buffer.clear();
            }
        }
        return processed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetaData[] getMetaDatas() {
        this.lock();
        try {
            Object[] metas = this._metas.values().toArray(new ClassMetaData[this._metas.size()]);
            for (int i = 0; i < metas.length; ++i) {
                if (metas[i] == null) continue;
                this.getMetaData(metas[i].getDescribedType(), metas[i].getEnvClassLoader(), true);
            }
            ArrayList<ClassMetaData> resolved = new ArrayList<ClassMetaData>(this._metas.size());
            for (ClassMetaData meta : this._metas.values()) {
                if (meta == null) continue;
                resolved.add(meta);
            }
            metas = resolved.toArray(this.newClassMetaDataArray(resolved.size()));
            Arrays.sort(metas);
            Object[] objectArray = metas;
            return objectArray;
        }
        finally {
            this.unlock();
        }
    }

    public ClassMetaData getCachedMetaData(Class<?> cls) {
        return this._metas.get(cls);
    }

    public ClassMetaData addMetaData(Class<?> cls) {
        return this.addMetaData(cls, AccessCode.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetaData addMetaData(Class<?> cls, int access) {
        if (cls == null || cls.isPrimitive()) {
            return null;
        }
        ClassMetaData meta = this.newClassMetaData(cls);
        this._factory.getDefaults().populate(meta, access);
        this.lock();
        try {
            if (this._pawares.containsKey(cls)) {
                throw new MetaDataException(_loc.get("pc-and-aware", cls));
            }
            this._metas.put(cls, meta);
        }
        finally {
            this.unlock();
        }
        return meta;
    }

    protected ClassMetaData newClassMetaData(Class<?> type) {
        return new ClassMetaData(type, this);
    }

    protected ClassMetaData[] newClassMetaDataArray(int length) {
        return new ClassMetaData[length];
    }

    protected FieldMetaData newFieldMetaData(String name, Class<?> type, ClassMetaData owner) {
        return new FieldMetaData(name, type, owner);
    }

    protected FieldMetaData[] newFieldMetaDataArray(int length) {
        return new FieldMetaData[length];
    }

    protected XMLMetaData[] newXMLClassMetaDataArray(int length) {
        return new XMLClassMetaData[length];
    }

    protected ClassMetaData newEmbeddedClassMetaData(ValueMetaData owner) {
        return new ClassMetaData(owner);
    }

    protected ValueMetaData newValueMetaData(FieldMetaData owner) {
        return new ValueMetaDataImpl(owner);
    }

    protected Order newOrder(FieldMetaData owner, String name, boolean asc) {
        ClassMetaData meta;
        if (name.startsWith("#element")) {
            name = name.substring("#element".length());
        }
        if (name.length() == 0) {
            return this.newValueOrder(owner, asc);
        }
        if (name.charAt(0) == '.') {
            name = name.substring(1);
        }
        if ((meta = owner.getElement().getTypeMetaData()) == null) {
            throw new MetaDataException(_loc.get("nonpc-field-orderable", owner, name));
        }
        FieldMetaData rel = this.getOrderByField(meta, name);
        if (rel == null) {
            throw new MetaDataException(_loc.get("bad-field-orderable", owner, name));
        }
        return this.newRelatedFieldOrder(owner, rel, asc);
    }

    public FieldMetaData getOrderByField(ClassMetaData meta, String orderBy) {
        FieldMetaData field = meta.getField(orderBy);
        if (field != null) {
            return field;
        }
        int dotIdx = orderBy.indexOf(".");
        if (dotIdx == -1) {
            return null;
        }
        String fieldName = orderBy.substring(0, dotIdx);
        FieldMetaData field1 = meta.getField(fieldName);
        if (field1 == null) {
            return null;
        }
        ClassMetaData meta1 = field1.getEmbeddedMetaData();
        if (meta1 == null) {
            return null;
        }
        String mappedBy1 = orderBy.substring(dotIdx + 1);
        return this.getOrderByField(meta1, mappedBy1);
    }

    protected Order newValueOrder(FieldMetaData owner, boolean asc) {
        return new InMemoryValueOrder(asc, this.getConfiguration());
    }

    protected Order newRelatedFieldOrder(FieldMetaData owner, FieldMetaData rel, boolean asc) {
        return new InMemoryRelatedFieldOrder(rel, asc, this.getConfiguration());
    }

    protected Order[] newOrderArray(int size) {
        return new Order[size];
    }

    public boolean removeMetaData(ClassMetaData meta) {
        if (meta == null) {
            return false;
        }
        return this.removeMetaData(meta.getDescribedType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMetaData(Class cls) {
        this.lock();
        try {
            if (cls == null) {
                boolean bl = false;
                return bl;
            }
            if (this._metas.remove(cls) != null) {
                Class<?> impl = this._ifaces.remove(cls);
                if (impl != null) {
                    this._metas.remove(impl);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDeclaredInterfaceImpl(ClassMetaData meta, Class<?> iface) {
        Map<Class<?>, Collection<Class<?>>> map = this._impls;
        synchronized (map) {
            Collection<Class<?>> vals = this._impls.get(iface);
            if (vals != null) {
                for (ClassMetaData sup = meta.getPCSuperclassMetaData(); sup != null; sup = sup.getPCSuperclassMetaData()) {
                    if (!vals.contains(sup.getDescribedType())) continue;
                    return;
                }
            }
            this.addToCollection(this._impls, iface, meta.getDescribedType(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterfaceImpl(ClassMetaData meta, Class<?> impl) {
        this.lock();
        try {
            if (!meta.isManagedInterface()) {
                throw new MetaDataException(_loc.get("not-managed-interface", meta, impl));
            }
            this._ifaces.put(meta.getDescribedType(), impl);
            this.addDeclaredInterfaceImpl(meta, meta.getDescribedType());
            for (ClassMetaData sup = meta.getPCSuperclassMetaData(); sup != null; sup = sup.getPCSuperclassMetaData()) {
                sup.clearSubclassCache();
                this.addToCollection(this._subs, sup.getDescribedType(), impl, true);
            }
        }
        finally {
            this.unlock();
        }
    }

    InterfaceImplGenerator getImplGenerator() {
        return this._implGen;
    }

    public ClassMetaData getMetaData(Object oid, ClassLoader envLoader, boolean mustExist) {
        if (oid == null && mustExist) {
            throw new MetaDataException(_loc.get("no-oid-meta", oid, "?", this._oids.toString()));
        }
        if (oid == null) {
            return null;
        }
        if (oid instanceof OpenJPAId) {
            Class cls = ((OpenJPAId)oid).getType();
            return this.getMetaData(cls, envLoader, mustExist);
        }
        this.processRegisteredClasses(envLoader);
        Class<?> cls = this._oids.get(oid.getClass());
        if (cls != null) {
            return this.getMetaData(cls, envLoader, mustExist);
        }
        if (this._oids.containsKey(oid.getClass())) {
            if (mustExist) {
                throw new MetaDataException(_loc.get("no-oid-meta", oid, oid.getClass(), this._oids));
            }
            return null;
        }
        this.resolveIdentityClass(oid);
        if (this.processRegisteredClasses(envLoader).length > 0 && (cls = this._oids.get(oid.getClass())) != null) {
            return this.getMetaData(cls, envLoader, mustExist);
        }
        this._oids.put(oid.getClass(), null);
        if (!mustExist) {
            return null;
        }
        throw new MetaDataException(_loc.get("no-oid-meta", oid, oid.getClass(), this._oids)).setFailedObject(oid);
    }

    private void resolveIdentityClass(Object oid) {
        if (oid == null) {
            return;
        }
        Class<?> oidClass = oid.getClass();
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("resolve-identity", oidClass));
        }
        ClassLoader cl = AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(oidClass));
        while (oidClass != null && oidClass != Object.class) {
            String className = oidClass.getName();
            for (int i = className.length(); i > 1 && className.charAt(i - 1) != '.'; --i) {
                try {
                    Class.forName(className.substring(0, i), true, cl);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            oidClass = oidClass.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetaData[] getImplementorMetaDatas(Class<?> cls, ClassLoader envLoader, boolean mustExist) {
        if (cls == null && mustExist) {
            throw new MetaDataException(_loc.get("no-meta", cls));
        }
        if (cls == null) {
            return this.EMPTY_METAS;
        }
        this.loadRegisteredClassMetaData(envLoader);
        Collection<Class<?>> vals = this._impls.get(cls);
        ArrayList<ClassMetaData> mapped = null;
        if (vals != null) {
            this.lock();
            try {
                Iterator<Class<?>> itr = vals.iterator();
                while (itr.hasNext()) {
                    ClassMetaData meta = this.getMetaData(itr.next(), envLoader, true);
                    if (!meta.isMapped() && meta.getMappedPCSubclassMetaDatas().length <= 0) continue;
                    if (mapped == null) {
                        mapped = new ArrayList<ClassMetaData>(vals.size());
                    }
                    mapped.add(meta);
                }
            }
            finally {
                this.unlock();
            }
        }
        if (mapped == null && mustExist) {
            throw new MetaDataException(_loc.get("no-meta", cls));
        }
        if (mapped == null) {
            return this.EMPTY_METAS;
        }
        return mapped.toArray(this.newClassMetaDataArray(mapped.size()));
    }

    public NonPersistentMetaData getPersistenceAware(Class<?> cls) {
        return this._pawares.get(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonPersistentMetaData[] getPersistenceAwares() {
        this.lock();
        try {
            if (this._pawares.isEmpty()) {
                NonPersistentMetaData[] nonPersistentMetaDataArray = EMPTY_NON_PERSISTENT;
                return nonPersistentMetaDataArray;
            }
            NonPersistentMetaData[] nonPersistentMetaDataArray = this._pawares.values().toArray(new NonPersistentMetaData[this._pawares.size()]);
            return nonPersistentMetaDataArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonPersistentMetaData addPersistenceAware(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        this.lock();
        try {
            if (this._pawares.containsKey(cls)) {
                NonPersistentMetaData nonPersistentMetaData = this._pawares.get(cls);
                return nonPersistentMetaData;
            }
            if (this.getCachedMetaData(cls) != null) {
                throw new MetaDataException(_loc.get("pc-and-aware", cls));
            }
            NonPersistentMetaData meta = new NonPersistentMetaData(cls, this, 1);
            this._pawares.put(cls, meta);
            NonPersistentMetaData nonPersistentMetaData = meta;
            return nonPersistentMetaData;
        }
        finally {
            this.unlock();
        }
    }

    public boolean removePersistenceAware(Class<?> cls) {
        return this._pawares.remove(cls) != null;
    }

    public NonPersistentMetaData getNonMappedInterface(Class<?> iface) {
        return this._nonMapped.get(iface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonPersistentMetaData[] getNonMappedInterfaces() {
        this.lock();
        try {
            if (this._nonMapped.isEmpty()) {
                NonPersistentMetaData[] nonPersistentMetaDataArray = EMPTY_NON_PERSISTENT;
                return nonPersistentMetaDataArray;
            }
            NonPersistentMetaData[] nonPersistentMetaDataArray = this._nonMapped.values().toArray(new NonPersistentMetaData[this._nonMapped.size()]);
            return nonPersistentMetaDataArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NonPersistentMetaData addNonMappedInterface(Class<?> iface) {
        if (iface == null) {
            return null;
        }
        if (!iface.isInterface()) {
            throw new MetaDataException(_loc.get("not-non-mapped", iface));
        }
        this.lock();
        try {
            if (this._nonMapped.containsKey(iface)) {
                NonPersistentMetaData nonPersistentMetaData = this._nonMapped.get(iface);
                return nonPersistentMetaData;
            }
            if (this.getCachedMetaData(iface) != null) {
                throw new MetaDataException(_loc.get("non-mapped-pc", iface));
            }
            NonPersistentMetaData meta = new NonPersistentMetaData(iface, this, 2);
            this._nonMapped.put(iface, meta);
            NonPersistentMetaData nonPersistentMetaData = meta;
            return nonPersistentMetaData;
        }
        finally {
            this.unlock();
        }
    }

    public boolean removeNonMappedInterface(Class<?> iface) {
        return this._nonMapped.remove(iface) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock();
        try {
            if (this._log.isTraceEnabled()) {
                this._log.trace(_loc.get("clear-repos", this));
            }
            this._metas.clear();
            this._oids.clear();
            this._subs.clear();
            this._impls.clear();
            this._queries.clear();
            this._seqs.clear();
            this._registered.clear();
            this._factory.clear();
            this._aliases.clear();
            this._pawares.clear();
            this._nonMapped.clear();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getPersistentTypeNames(boolean devpath, ClassLoader envLoader) {
        this.lock();
        try {
            Set<String> set = this._factory.getPersistentTypeNames(devpath, envLoader);
            return set;
        }
        finally {
            this.unlock();
        }
    }

    public synchronized Collection<Class<?>> loadPersistentTypes(boolean devpath, ClassLoader envLoader) {
        return this.loadPersistentTypes(devpath, envLoader, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Class<?>> loadPersistentTypes(boolean devpath, ClassLoader envLoader, boolean mustExist) {
        this.lock();
        try {
            Set<String> names = this.getPersistentTypeNames(devpath, envLoader);
            if (names == null || names.isEmpty()) {
                if (!mustExist) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                throw new MetaDataException(_loc.get("eager-no-class-found"));
            }
            ClassLoader clsLoader = this._conf.getClassResolverInstance().getClassLoader(this.getClass(), envLoader);
            ArrayList classes = new ArrayList(names.size());
            for (String className : names) {
                Class<?> cls = this.classForName(className, clsLoader);
                if (this._factory.isMetaClass(cls)) {
                    this.setMetaModel(cls);
                    continue;
                }
                if (cls != null) {
                    classes.add(cls);
                    if (!cls.isInterface()) continue;
                    this.getMetaData(cls, clsLoader, false);
                    continue;
                }
                if (cls != null || !mustExist) continue;
                throw new MetaDataException(_loc.get("eager-class-not-found", className));
            }
            ArrayList arrayList = classes;
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    private Class<?> classForName(String name, ClassLoader loader) {
        block13: {
            try {
                return Class.forName(name, true, loader);
            }
            catch (Exception e) {
                if ((this._validate & 8) != 0) {
                    if (this._log.isWarnEnabled()) {
                        this._log.warn(_loc.get("bad-discover-class", name));
                    }
                } else if (this._log.isInfoEnabled()) {
                    this._log.info(_loc.get("bad-discover-class", name));
                }
                if (this._log.isTraceEnabled()) {
                    this._log.trace(e);
                }
            }
            catch (NoSuchMethodError nsme) {
                if (nsme.getMessage().indexOf(".pc") == -1) {
                    throw nsme;
                }
                if ((this._validate & 8) != 0) {
                    if (this._log.isWarnEnabled()) {
                        this._log.warn(_loc.get("bad-discover-class", name));
                    }
                } else if (this._log.isInfoEnabled()) {
                    this._log.info(_loc.get("bad-discover-class", name));
                }
                if (!this._log.isTraceEnabled()) break block13;
                this._log.trace(nsme);
            }
        }
        return null;
    }

    Collection<Class<?>> getPCSubclasses(Class<?> cls) {
        Collection subs = this._subs.get(cls);
        if (subs == null) {
            return Collections.EMPTY_LIST;
        }
        return subs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Class cls) {
        this.lock();
        try {
            this._registered.add(cls);
        }
        finally {
            this.unlock();
        }
    }

    private void loadRegisteredClassMetaData(ClassLoader envLoader) {
        Class<?>[] reg = this.processRegisteredClasses(envLoader);
        for (int i = 0; i < reg.length; ++i) {
            try {
                this.getMetaData(reg[i], envLoader, false);
                continue;
            }
            catch (MetaDataException me) {
                if (!this._log.isWarnEnabled()) continue;
                this._log.warn(me);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?>[] processRegisteredClasses(ClassLoader envLoader) {
        Class[] reg;
        if (this._registered.isEmpty()) {
            return EMPTY_CLASSES;
        }
        this.lock();
        try {
            reg = this._registered.toArray(new Class[this._registered.size()]);
            this._registered.clear();
        }
        finally {
            this.unlock();
        }
        Set<String> pcNames = this.getPersistentTypeNames(false, envLoader);
        ArrayList<Class> failed = null;
        for (int i = 0; i < reg.length; ++i) {
            if (pcNames != null && !pcNames.isEmpty() && !pcNames.contains(reg[i].getName())) continue;
            try {
                this.processRegisteredClass(reg[i]);
                continue;
            }
            catch (Throwable t) {
                if (!this._conf.getRetryClassRegistration()) {
                    throw new MetaDataException(_loc.get("error-registered", reg[i]), t);
                }
                if (this._log.isWarnEnabled()) {
                    this._log.warn(_loc.get("failed-registered", reg[i]), t);
                }
                if (failed == null) {
                    failed = new ArrayList<Class>();
                }
                failed.add(reg[i]);
            }
        }
        if (failed != null) {
            this.lock();
            try {
                this._registered.addAll(failed);
            }
            finally {
                this.unlock();
            }
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRegisteredClass(Class<?> cls) {
        Class<?> existing;
        if (this._log.isTraceEnabled()) {
            this._log.trace(_loc.get("process-registered", cls));
        }
        Class leastDerived = cls;
        this.lock();
        try {
            Class anc = cls;
            while ((anc = PCRegistry.getPersistentSuperclass(anc)) != null) {
                this.addToCollection(this._subs, anc, cls, true);
                ClassMetaData meta = this._metas.get(anc);
                if (meta != null) {
                    meta.clearSubclassCache();
                }
                leastDerived = anc;
            }
        }
        finally {
            this.unlock();
        }
        Object oid = null;
        try {
            oid = PCRegistry.newObjectId(cls);
        }
        catch (InternalException ie) {
            // empty catch block
        }
        if (oid != null) {
            existing = this._oids.get(oid.getClass());
            if (existing != null) {
                Class sup = cls;
                while (PCRegistry.getPersistentSuperclass(sup) != null) {
                    sup = PCRegistry.getPersistentSuperclass(sup);
                }
                this._oids.put(oid.getClass(), sup);
            } else if (existing == null || cls.isAssignableFrom(existing)) {
                this._oids.put(oid.getClass(), cls);
            }
        }
        existing = this._impls;
        synchronized (existing) {
            this.updateImpls(cls, leastDerived, cls);
        }
        String alias = PCRegistry.getTypeAlias(cls);
        if (alias != null) {
            this.lock();
            try {
                List<Class<?>> classList = this._aliases.get(alias);
                if (classList == null) {
                    classList = new ArrayList(3);
                    this._aliases.put(alias, classList);
                }
                if (!classList.contains(cls)) {
                    classList.add(cls);
                }
            }
            finally {
                this.unlock();
            }
        }
    }

    private void updateImpls(Class<?> cls, Class<?> leastDerived, Class<?> check) {
        Class<?> sup = check.getSuperclass();
        if (leastDerived == cls && sup != null && sup != Object.class) {
            this.addToCollection(this._impls, sup, cls, false);
            this.updateImpls(cls, leastDerived, sup);
        }
        if (!this._factory.getDefaults().isDeclaredInterfacePersistent()) {
            return;
        }
        Class<?>[] ints = check.getInterfaces();
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i].getName().startsWith("java.") || leastDerived != cls && !this.isLeastDerivedImpl(ints[i], cls)) continue;
            this.addToCollection(this._impls, ints[i], cls, false);
            this.updateImpls(cls, leastDerived, ints[i]);
        }
    }

    private boolean isLeastDerivedImpl(Class<?> inter, Class<?> cls) {
        Class parent = PCRegistry.getPersistentSuperclass(cls);
        while (parent != null) {
            if (Arrays.asList(parent.getInterfaces()).contains(inter)) {
                return false;
            }
            parent = PCRegistry.getPersistentSuperclass(parent);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCollection(Map map, Class<?> key, Class<?> value, boolean inheritance) {
        this.lock();
        try {
            AbstractCollection coll = (LinkedList)map.get(key);
            if (coll == null) {
                if (inheritance) {
                    InheritanceComparator comp = new InheritanceComparator();
                    comp.setBase(key);
                    coll = new TreeSet(comp);
                } else {
                    coll = new LinkedList();
                }
                map.put(key, coll);
            }
            coll.add(value);
        }
        finally {
            this.unlock();
        }
    }

    public void setMetaModel(Class<?> m2) {
        Class<?> cls = this._factory.getManagedClass(m2);
        if (cls != null) {
            this._metamodel.put(cls, m2);
        }
    }

    public void setMetaModel(ClassMetaData meta, Class<?> m2) {
        this._metamodel.put(meta.getDescribedType(), m2);
    }

    public Class<?> getMetaModel(ClassMetaData meta, boolean load) {
        return this.getMetaModel(meta.getDescribedType(), load);
    }

    public Class<?> getMetaModel(Class<?> entity, boolean load) {
        if (this._metamodel.containsKey(entity)) {
            return this._metamodel.get(entity);
        }
        String m2 = this._factory.getMetaModelClassName(entity.getName());
        try {
            Class<?> m2cls = J2DoPrivHelper.getForNameAction(m2, true, entity.getClassLoader()).run();
            this._metamodel.put(entity, m2cls);
            return m2cls;
        }
        catch (Throwable t) {
            if (this._log.isWarnEnabled()) {
                this._log.warn(_loc.get("meta-no-model", m2, entity, t));
            }
            return null;
        }
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this._conf = (OpenJPAConfiguration)conf;
        this._log = this._conf.getLog("openjpa.MetaData");
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
        this._lock = new ReentrantLock();
        this.initializeMetaDataFactory();
        if (this._implGen == null) {
            this._implGen = new InterfaceImplGenerator(this);
        }
    }

    private void initializeMetaDataFactory() {
        if (this._factory == null) {
            MetaDataFactory mdf = this._conf.newMetaDataFactoryInstance();
            if (mdf == null) {
                throw new MetaDataException(_loc.get("no-metadatafactory"));
            }
            this.setMetaDataFactory(mdf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryMetaData getQueryMetaData(Class<?> cls, String name, ClassLoader envLoader, boolean mustExist) {
        this.lock();
        try {
            QueryMetaData meta = this.getQueryMetaDataInternal(cls, name, envLoader);
            if (meta == null) {
                this.resolveAll(envLoader);
                meta = this.getQueryMetaDataInternal(cls, name, envLoader);
            }
            if (meta == null && mustExist) {
                if (cls == null) {
                    throw new MetaDataException(_loc.get("no-named-query-null-class", this.getPersistentTypeNames(false, envLoader), name));
                }
                throw new MetaDataException(_loc.get("no-named-query", cls, name));
            }
            QueryMetaData queryMetaData = meta;
            return queryMetaData;
        }
        finally {
            this.unlock();
        }
    }

    private void resolveAll(ClassLoader envLoader) {
        Collection<Class<?>> types = this.loadPersistentTypes(false, envLoader);
        for (Class<?> c : types) {
            this.getMetaData(c, envLoader, false);
        }
    }

    private QueryMetaData getQueryMetaDataInternal(Class<?> cls, String name, ClassLoader envLoader) {
        if (name == null) {
            return null;
        }
        QueryMetaData qm = null;
        if (cls == null && (qm = this.searchQueryMetaDataByName(name)) != null) {
            return qm;
        }
        Object key = MetaDataRepository.getQueryKey(cls, name);
        qm = this._queries.get(key);
        if (qm != null) {
            return qm;
        }
        if (cls != null && this.getMetaData(cls, envLoader, false) != null && (qm = this._queries.get(key)) != null) {
            return qm;
        }
        if ((this._sourceMode & 4) == 0) {
            return null;
        }
        if (cls == null) {
            cls = this._factory.getQueryScope(name, envLoader);
        }
        this._factory.load(cls, 4, envLoader);
        return this._queries.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryMetaData[] getQueryMetaDatas() {
        this.lock();
        try {
            QueryMetaData[] queryMetaDataArray = this._queries.values().toArray(new QueryMetaData[this._queries.size()]);
            return queryMetaDataArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryMetaData getCachedQueryMetaData(Class<?> cls, String name) {
        this.lock();
        try {
            QueryMetaData queryMetaData = this._queries.get(MetaDataRepository.getQueryKey(cls, name));
            return queryMetaData;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryMetaData addQueryMetaData(Class<?> cls, String name) {
        this.lock();
        try {
            QueryMetaData meta = this.newQueryMetaData(cls, name);
            this._queries.put(MetaDataRepository.getQueryKey(meta), meta);
            QueryMetaData queryMetaData = meta;
            return queryMetaData;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QueryMetaData newQueryMetaData(Class<?> cls, String name) {
        this.lock();
        try {
            QueryMetaData meta = new QueryMetaData(name);
            meta.setDefiningType(cls);
            QueryMetaData queryMetaData = meta;
            return queryMetaData;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeQueryMetaData(QueryMetaData meta) {
        this.lock();
        try {
            if (meta == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this._queries.remove(MetaDataRepository.getQueryKey(meta)) != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeQueryMetaData(Class<?> cls, String name) {
        this.lock();
        try {
            if (name == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this._queries.remove(MetaDataRepository.getQueryKey(cls, name)) != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public QueryMetaData searchQueryMetaDataByName(String name) {
        for (Object key : this._queries.keySet()) {
            if (!(key instanceof QueryKey) || !StringUtils.equals((String)((QueryKey)key).name, (String)name)) continue;
            return this._queries.get(key);
        }
        return null;
    }

    private static Object getQueryKey(QueryMetaData meta) {
        if (meta == null) {
            return null;
        }
        return MetaDataRepository.getQueryKey(meta.getDefiningType(), meta.getName());
    }

    protected static Object getQueryKey(Class<?> cls, String name) {
        if (cls == null) {
            return name;
        }
        QueryKey key = new QueryKey();
        key.clsName = cls.getName();
        key.name = name;
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceMetaData getSequenceMetaData(String name, ClassLoader envLoader, boolean mustExist) {
        this.lock();
        try {
            SequenceMetaData meta = this.getSequenceMetaDataInternal(name, envLoader);
            if (meta == null && "system".equals(name)) {
                if (this._sysSeq == null) {
                    this._sysSeq = this.newSequenceMetaData(name);
                }
                SequenceMetaData sequenceMetaData = this._sysSeq;
                return sequenceMetaData;
            }
            if (meta == null && mustExist) {
                throw new MetaDataException(_loc.get("no-named-sequence", name));
            }
            SequenceMetaData sequenceMetaData = meta;
            return sequenceMetaData;
        }
        finally {
            this.unlock();
        }
    }

    SequenceMetaData getSequenceMetaData(ClassMetaData context, String name, boolean mustExist) {
        MetaDataException e = null;
        try {
            SequenceMetaData seq = this.getSequenceMetaData(name, context.getEnvClassLoader(), mustExist);
            if (seq != null) {
                return seq;
            }
        }
        catch (MetaDataException mde) {
            e = mde;
        }
        if (name.indexOf(46) != -1) {
            if (e != null) {
                throw e;
            }
            return null;
        }
        name = Strings.getPackageName(context.getDescribedType()) + "." + name;
        try {
            return this.getSequenceMetaData(name, context.getEnvClassLoader(), mustExist);
        }
        catch (MetaDataException mde) {
            if (e != null) {
                throw e;
            }
            throw mde;
        }
    }

    private SequenceMetaData getSequenceMetaDataInternal(String name, ClassLoader envLoader) {
        if (name == null) {
            return null;
        }
        SequenceMetaData meta = this._seqs.get(name);
        if (meta == null) {
            this.loadRegisteredClassMetaData(envLoader);
            meta = this._seqs.get(name);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceMetaData[] getSequenceMetaDatas() {
        this.lock();
        try {
            SequenceMetaData[] sequenceMetaDataArray = this._seqs.values().toArray(new SequenceMetaData[this._seqs.size()]);
            return sequenceMetaDataArray;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceMetaData getCachedSequenceMetaData(String name) {
        this.lock();
        try {
            SequenceMetaData sequenceMetaData = this._seqs.get(name);
            return sequenceMetaData;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceMetaData addSequenceMetaData(String name) {
        this.lock();
        try {
            SequenceMetaData meta = this.newSequenceMetaData(name);
            this._seqs.put(name, meta);
            SequenceMetaData sequenceMetaData = meta;
            return sequenceMetaData;
        }
        finally {
            this.unlock();
        }
    }

    protected SequenceMetaData newSequenceMetaData(String name) {
        return new SequenceMetaData(name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSequenceMetaData(SequenceMetaData meta) {
        this.lock();
        try {
            if (meta == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this._seqs.remove(meta.getName()) != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSequenceMetaData(String name) {
        this.lock();
        try {
            if (name == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this._seqs.remove(name) != null;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemListener(Object listener) {
        this.lock();
        try {
            LifecycleEventManager.ListenerList listeners = new LifecycleEventManager.ListenerList(this._listeners);
            listeners.add(listener);
            this._listeners = listeners;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSystemListener(Object listener) {
        this.lock();
        try {
            if (!this._listeners.contains(listener)) {
                boolean bl = false;
                return bl;
            }
            LifecycleEventManager.ListenerList listeners = new LifecycleEventManager.ListenerList(this._listeners);
            listeners.remove(listener);
            this._listeners = listeners;
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public LifecycleEventManager.ListenerList getSystemListeners() {
        return this._listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock();
        try {
            SequenceMetaData[] smds = this.getSequenceMetaDatas();
            for (int i = 0; i < smds.length; ++i) {
                smds[i].close();
            }
            this.clear();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLMetaData getXMLMetaData(FieldMetaData fmd) {
        this.lock();
        try {
            Class cls = fmd.getDeclaredType();
            XMLMetaData xmlmeta = this._xmlmetas.get(cls);
            if (xmlmeta != null) {
                XMLMetaData xMLMetaData = xmlmeta;
                return xMLMetaData;
            }
            this._factory.loadXMLMetaData(fmd);
            XMLMetaData xMLMetaData = xmlmeta = (XMLClassMetaData)this._xmlmetas.get(cls);
            return xMLMetaData;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLClassMetaData addXMLMetaData(Class<?> type, String name) {
        XMLClassMetaData meta = this.newXMLClassMetaData(type, name);
        this.lock();
        try {
            this._xmlmetas.put(type, meta);
        }
        finally {
            this.unlock();
        }
        return meta;
    }

    public XMLMetaData getCachedXMLMetaData(Class<?> cls) {
        return this._xmlmetas.get(cls);
    }

    protected XMLClassMetaData newXMLClassMetaData(Class<?> type, String name) {
        return new XMLClassMetaData(type, name);
    }

    public XMLFieldMetaData newXMLFieldMetaData(Class<?> type, String name) {
        return new XMLFieldMetaData(type, name);
    }

    private static class QueryKey
    implements Serializable {
        public String clsName;
        public String name;

        private QueryKey() {
        }

        public int hashCode() {
            int clsHash = this.clsName == null ? 0 : this.clsName.hashCode();
            int nameHash = this.name == null ? 0 : this.name.hashCode();
            return clsHash + nameHash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof QueryKey)) {
                return false;
            }
            QueryKey qk = (QueryKey)obj;
            return StringUtils.equals((String)this.clsName, (String)qk.clsName) && StringUtils.equals((String)this.name, (String)qk.name);
        }
    }
}

