/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.QueryHints;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringDistance;
import org.apache.openjpa.persistence.ArgumentException;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.FetchPlanHintHandler;
import org.apache.openjpa.persistence.FetchPlanImpl;
import org.apache.openjpa.persistence.QueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HintHandler
extends FetchPlanHintHandler {
    private static final Localizer _loc = Localizer.forPackage(HintHandler.class);
    private final QueryImpl owner;
    private Map<String, Object> _hints;
    private static Set<String> _supportedKeys;
    private static Set<String> _supportedPrefixes;
    public static final String HINT_SUBCLASSES = "openjpa.Subclasses";
    public static final String HINT_FILTER_LISTENER = "openjpa.FilterListener";
    public static final String HINT_FILTER_LISTENERS = "openjpa.FilterListeners";
    public static final String HINT_AGGREGATE_LISTENER = "openjpa.AggregateListener";
    public static final String HINT_AGGREGATE_LISTENERS = "openjpa.AggregateListeners";

    HintHandler(QueryImpl impl) {
        super((FetchPlanImpl)impl.getFetchPlan());
        this.owner = impl;
    }

    public Map<String, Object> getHints() {
        return this._hints == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this._hints);
    }

    private Boolean record(String hint, Object value) {
        if (hint == null) {
            return Boolean.FALSE;
        }
        if (this.isSupported(hint)) {
            if (this._hints == null) {
                this._hints = new TreeMap<String, Object>();
            }
            this._hints.put(hint, value);
            return Boolean.TRUE;
        }
        Log log = this.owner.getDelegate().getBroker().getConfiguration().getLog("openjpa.Runtime");
        String possible = StringDistance.getClosestLevenshteinDistance(hint, this.getSupportedHints());
        if (log.isWarnEnabled()) {
            log.warn(_loc.get("bad-query-hint", hint, possible));
        }
        return this.isKnownHintPrefix(hint) ? null : Boolean.FALSE;
    }

    public Set<String> getSupportedHints() {
        if (_supportedKeys == null) {
            _supportedKeys = new TreeSet<String>();
            _supportedPrefixes = new TreeSet<String>();
            _supportedKeys.addAll(Reflection.getFieldValues(QueryHints.class, 25, String.class));
            _supportedKeys.addAll(this.addPrefix("openjpa.FetchPlan.", Reflection.getBeanStylePropertyNames(this.owner.getFetchPlan().getClass())));
            _supportedKeys.addAll(JavaxHintsMap.keySet());
            _supportedKeys.addAll(Reflection.getFieldValues(HintHandler.class, 25, String.class));
            _supportedKeys.addAll(ProductDerivations.getSupportedQueryHints());
            for (String key : _supportedKeys) {
                _supportedPrefixes.add(HintHandler.getPrefixOf(key));
            }
        }
        return _supportedKeys;
    }

    public void addHintKey(String key) {
        this.getSupportedHints().add(key);
        _supportedPrefixes.add(HintHandler.getPrefixOf(key));
    }

    public Set<String> getKnownPrefixes() {
        this.getSupportedHints();
        return _supportedPrefixes;
    }

    private boolean isSupported(String key) {
        return this.getSupportedHints().contains(key);
    }

    private boolean isKnownHintPrefix(String key) {
        String prefix = HintHandler.getPrefixOf(key);
        return this.getKnownPrefixes().contains(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHint(String key, Object value) {
        this.owner.lock();
        try {
            Boolean record = this.record(key, value);
            if (record == Boolean.FALSE) {
                return;
            }
            FetchPlan plan = this.owner.getFetchPlan();
            if (record == null) {
                plan.setHint(key, value);
                return;
            }
            if (this.setHint(key, value, true)) {
                plan.addHint(key, value);
            }
        }
        finally {
            this.owner.unlock();
        }
    }

    @Override
    protected boolean setHintInternal(String key, Object value, boolean validateThrowException) {
        ClassLoader loader = this.owner.getDelegate().getBroker().getClassLoader();
        FetchPlan fPlan = this.owner.getFetchPlan();
        boolean objectSet = true;
        if (HINT_SUBCLASSES.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.owner.setSubclasses((Boolean)value);
        } else if (HINT_FILTER_LISTENER.equals(key)) {
            this.owner.addFilterListener(Filters.hintToFilterListener(value, loader));
        } else if (HINT_FILTER_LISTENERS.equals(key)) {
            FilterListener[] arr = Filters.hintToFilterListeners(value, loader);
            for (int i = 0; i < arr.length; ++i) {
                this.owner.addFilterListener(arr[i]);
            }
        } else if (HINT_AGGREGATE_LISTENER.equals(key)) {
            this.owner.addAggregateListener(Filters.hintToAggregateListener(value, loader));
        } else if (HINT_AGGREGATE_LISTENERS.equals(key)) {
            AggregateListener[] arr = Filters.hintToAggregateListeners(value, loader);
            for (int i = 0; i < arr.length; ++i) {
                this.owner.addAggregateListener(arr[i]);
            }
        } else if ("openjpa.hint.OptimizeResultCount".equals(key)) {
            int v = (Integer)Filters.convert(value, Integer.class);
            if (v < 0) {
                throw new ArgumentException(_loc.get("bad-query-hint-value", key, value), null, null, false);
            }
            fPlan.setHint(key, v);
            objectSet = false;
        } else if ("openjpa.hint.InvalidatePreparedQuery".equals(key)) {
            fPlan.setHint(key, Filters.convert(value, Boolean.class));
            this.owner.invalidatePreparedQuery();
            objectSet = false;
        } else if ("openjpa.hint.IgnorePreparedQuery".equals(key)) {
            fPlan.setHint(key, Filters.convert(value, Boolean.class));
            this.owner.ignorePreparedQuery();
            objectSet = false;
        } else {
            fPlan.setHint(key, value);
            objectSet = false;
        }
        return objectSet;
    }

    @Override
    protected String hintToKey(String key) {
        return key;
    }

    private Set<String> addPrefix(String prefix, Set<String> original) {
        TreeSet<String> result = new TreeSet<String>();
        String join = prefix.endsWith(".") ? "" : ".";
        for (String o : original) {
            result.add(prefix + join + o);
        }
        return result;
    }
}

