/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import org.apache.openjpa.kernel.exps.Context;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.kernel.jpql.JPQLExpressionBuilder;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.CriteriaExpressionBuilder;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.ExpressionImpl;
import org.apache.openjpa.persistence.criteria.FromImpl;
import org.apache.openjpa.persistence.criteria.Joins;
import org.apache.openjpa.persistence.criteria.PathImpl;
import org.apache.openjpa.persistence.criteria.RootImpl;
import org.apache.openjpa.persistence.meta.AbstractManagedType;
import org.apache.openjpa.persistence.meta.Members;
import org.apache.openjpa.persistence.meta.MetamodelImpl;
import org.apache.openjpa.persistence.meta.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubqueryImpl<T>
extends ExpressionImpl<T>
implements Subquery<T> {
    private final AbstractQuery<?> _parent;
    private final CriteriaQueryImpl<T> _delegate;
    private final MetamodelImpl _model;
    private Set<Join<?, ?>> _joins;
    private org.apache.openjpa.kernel.exps.Subquery _subq;
    private List<Join<?, ?>> _corrJoins = null;

    SubqueryImpl(Class<T> cls, AbstractQuery<?> parent) {
        super(cls);
        this._parent = parent;
        this._model = parent instanceof CriteriaQueryImpl ? ((CriteriaQueryImpl)parent).getMetamodel() : (parent instanceof SubqueryImpl ? ((SubqueryImpl)parent).getMetamodel() : null);
        this._delegate = new CriteriaQueryImpl(this._model, this);
    }

    public AbstractQuery<?> getParent() {
        return this._parent;
    }

    CriteriaQueryImpl<T> getDelegate() {
        return this._delegate;
    }

    public MetamodelImpl getMetamodel() {
        return this._model;
    }

    Stack<Context> getContexts() {
        return this.getInnermostParent().getContexts();
    }

    public CriteriaQueryImpl<?> getInnermostParent() {
        return (CriteriaQueryImpl)(this._parent instanceof CriteriaQueryImpl ? this._parent : ((SubqueryImpl)this._parent).getInnermostParent());
    }

    public Subquery<T> select(Expression<T> expression) {
        this._delegate.select((Selection<T>)expression);
        return this;
    }

    public Expression<T> getSelection() {
        return (Expression)this._delegate.getSelection();
    }

    public <X> Root<X> from(EntityType<X> entity) {
        return this._delegate.from(entity);
    }

    public <X> Root<X> from(Class<X> entityClass) {
        return this._delegate.from(entityClass);
    }

    public Set<Root<?>> getRoots() {
        return this._delegate.getRoots();
    }

    public Root<?> getRoot() {
        return this._delegate.getRoot(false);
    }

    public Subquery<T> where(Expression<Boolean> restriction) {
        this._delegate.where(restriction);
        return this;
    }

    public Subquery<T> where(Predicate ... restrictions) {
        this._delegate.where(restrictions);
        return this;
    }

    public Subquery<T> groupBy(Expression<?> ... grouping) {
        this._delegate.groupBy(grouping);
        return this;
    }

    public Subquery<T> groupBy(List<Expression<?>> grouping) {
        this._delegate.groupBy(grouping);
        return this;
    }

    public Subquery<T> having(Expression<Boolean> restriction) {
        this._delegate.having(restriction);
        return this;
    }

    public Subquery<T> having(Predicate ... restrictions) {
        this._delegate.having(restrictions);
        return this;
    }

    public Subquery<T> distinct(boolean distinct) {
        this._delegate.distinct(distinct);
        return this;
    }

    public List<Expression<?>> getGroupList() {
        return this._delegate.getGroupList();
    }

    public Predicate getRestriction() {
        return this._delegate.getRestriction();
    }

    public Predicate getGroupRestriction() {
        return this._delegate.getGroupRestriction();
    }

    public boolean isDistinct() {
        return this._delegate.isDistinct();
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        return new SubqueryImpl<U>(type, (AbstractQuery<?>)this);
    }

    public <Y> Root<Y> correlate(Root<Y> root) {
        Types.Entity entity = (Types.Entity)root.getModel();
        RootImpl corrRoot = new RootImpl(entity);
        corrRoot.setCorrelatedPath((RootImpl)root);
        this._delegate.addRoot(corrRoot);
        return corrRoot;
    }

    public List<Join<?, ?>> getCorrelatedJoins() {
        return this._corrJoins;
    }

    public <X, Y> Join<X, Y> correlate(Join<X, Y> parentJoin) {
        Join<X, X> corrJoin = this.clone(parentJoin);
        ((PathImpl)corrJoin).setCorrelatedPath((PathImpl)parentJoin);
        if (this._corrJoins == null) {
            this._corrJoins = new ArrayList();
        }
        this._corrJoins.add(corrJoin);
        return corrJoin;
    }

    private Join<?, ?> clone(Join<?, ?> join) {
        ArrayList members = new ArrayList();
        ArrayList<JoinType> jts = new ArrayList<JoinType>();
        FromImpl<?, ?> root = this.getMembers(join, members, jts);
        Members.SingularAttributeImpl member = (Members.SingularAttributeImpl)members.get(0);
        JoinType jt = (JoinType)jts.get(0);
        Join<?, ?> join1 = this.makeJoin(root, member, jt);
        for (int i = 1; i < members.size(); ++i) {
            join1 = this.makeJoin((FromImpl)join1, (Members.SingularAttributeImpl)members.get(i), (JoinType)jts.get(i));
        }
        return join1;
    }

    public boolean isCorrelated() {
        return this._corrJoins != null;
    }

    private Join<?, ?> makeJoin(FromImpl<?, ?> parent, Members.SingularAttributeImpl<?, ?> member, JoinType jt) {
        return new Joins.SingularJoin(parent, member, jt);
    }

    private FromImpl<?, ?> getMembers(Join<?, ?> join, List<Members.SingularAttributeImpl<?, ?>> members, List<JoinType> jts) {
        PathImpl parent = (PathImpl)join.getParentPath();
        Members.SingularAttributeImpl member = (Members.SingularAttributeImpl)((Joins.SingularJoin)join).getMember();
        JoinType jt = join.getJoinType();
        FromImpl<?, ?> root = null;
        if (parent instanceof RootImpl) {
            members.add(member);
            jts.add(jt);
            return (FromImpl)parent;
        }
        root = this.getMembers((Join)parent, members, jts);
        members.add(member);
        jts.add(jt);
        return root;
    }

    public <X, Y> CollectionJoin<X, Y> correlate(CollectionJoin<X, Y> join) {
        this._delegate.from(join.getModel().getBindableJavaType());
        return join;
    }

    public <X, Y> SetJoin<X, Y> correlate(SetJoin<X, Y> join) {
        this._delegate.from(join.getModel().getBindableJavaType());
        return join;
    }

    public <X, Y> ListJoin<X, Y> correlate(ListJoin<X, Y> join) {
        this._delegate.from(join.getModel().getBindableJavaType());
        return join;
    }

    public <X, K, V> MapJoin<X, K, V> correlate(MapJoin<X, K, V> join) {
        this._delegate.from(join.getModel().getBindableJavaType());
        return join;
    }

    public Set<Join<?, ?>> getJoins() {
        return this._joins;
    }

    org.apache.openjpa.kernel.exps.Subquery getSubQ() {
        return this._subq;
    }

    @Override
    public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> q) {
        boolean subclasses = true;
        CriteriaExpressionBuilder exprBuilder = new CriteriaExpressionBuilder();
        String alias = q.getAlias(this);
        ClassMetaData candidate = this.getCandidate();
        this._subq = factory.newSubquery(candidate, true, alias);
        this._subq.setMetaData(candidate);
        Stack<Context> contexts = this.getContexts();
        Context context = new Context(null, this._subq, contexts.peek());
        contexts.push(context);
        this._delegate.setContexts(contexts);
        QueryExpressions subexp = exprBuilder.getQueryExpressions(factory, this._delegate);
        this._subq.setQueryExpressions(subexp);
        if (subexp.projections.length > 0) {
            JPQLExpressionBuilder.checkEmbeddable(subexp.projections[0], null);
        }
        contexts.pop();
        return this._subq;
    }

    private ClassMetaData getCandidate() {
        FromImpl corrJoin;
        if (this.getRoots().isEmpty() && this._corrJoins != null && (corrJoin = (FromImpl)this._corrJoins.get(0)).getJoins() != null) {
            FromImpl join = (FromImpl)corrJoin.getJoins().iterator().next();
            return this.getInnermostCandidate(join);
        }
        RootImpl root = (RootImpl)this.getRoot();
        if (root != null && root.getCorrelatedPath() != null && !root.getJoins().isEmpty()) {
            FromImpl join = (FromImpl)root.getJoins().iterator().next();
            return this.getInnermostCandidate(join);
        }
        return ((AbstractManagedType)root.getModel()).meta;
    }

    private ClassMetaData getInnermostCandidate(FromImpl<?, ?> from) {
        if (!from.getJoins().isEmpty()) {
            from = (FromImpl)from.getJoins().iterator().next();
            return this.getInnermostCandidate(from);
        }
        return this.getCandidate(from);
    }

    private ClassMetaData getCandidate(FromImpl<?, ?> from) {
        return SubqueryImpl.getFieldType(from._member.fmd);
    }

    private static ClassMetaData getFieldType(FieldMetaData fmd) {
        if (fmd == null) {
            return null;
        }
        ClassMetaData cmd = null;
        ValueMetaData vmd = fmd.getElement();
        if (vmd != null) {
            cmd = vmd.getDeclaredTypeMetaData();
        } else {
            vmd = fmd.getKey();
            if (vmd != null) {
                cmd = vmd.getDeclaredTypeMetaData();
            } else {
                vmd = fmd.getValue();
                if (vmd != null) {
                    cmd = vmd.getDeclaredTypeMetaData();
                }
            }
        }
        if (cmd == null || cmd.getDescribedType() == Object.class) {
            cmd = fmd.getDeclaredTypeMetaData();
        }
        if (cmd == null && fmd.isElementCollection()) {
            cmd = fmd.getDefiningMetaData();
        }
        return cmd;
    }

    public Class<T> getResultType() {
        return this.getJavaType();
    }

    @Override
    public StringBuilder asValue(AliasContext q) {
        StringBuilder buffer = new StringBuilder();
        this._delegate.render(buffer, this._delegate.getRoots(), this._corrJoins);
        return buffer;
    }

    @Override
    public StringBuilder asVariable(AliasContext q) {
        return this.asValue(q);
    }
}

