/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.ColumnResult;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FieldResult;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassMappingInfo;
import org.apache.openjpa.jdbc.meta.DiscriminatorMappingInfo;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingInfo;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.meta.SequenceMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.EnumValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.persistence.AnnotationBuilder;
import org.apache.openjpa.persistence.AnnotationPersistenceMetaDataSerializer;
import org.apache.openjpa.persistence.PersistenceStrategy;
import serp.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationPersistenceMappingSerializer
extends AnnotationPersistenceMetaDataSerializer {
    private static final int TYPE_RESULTMAP = 21;
    private List<QueryResultMapping> _results = null;
    private boolean _sync = false;
    private Map<QueryResultMapping, List<AnnotationBuilder>> _rsmAnnos = null;

    public AnnotationPersistenceMappingSerializer(JDBCConfiguration conf) {
        super(conf);
    }

    public boolean getSyncMappingInfo() {
        return this._sync;
    }

    public void setSyncMappingInfo(boolean sync) {
        this._sync = sync;
    }

    public void addQueryResultMapping(QueryResultMapping meta) {
        if (this._results == null) {
            this._results = new ArrayList<QueryResultMapping>();
        }
        this._results.add(meta);
    }

    public boolean removeQueryResultMapping(QueryResultMapping meta) {
        return this._results != null && this._results.remove(meta);
    }

    @Override
    public void addAll(MetaDataRepository repos) {
        super.addAll(repos);
        for (QueryResultMapping res : ((MappingRepository)repos).getQueryResultMappings()) {
            this.addQueryResultMapping(res);
        }
    }

    @Override
    public boolean removeAll(MetaDataRepository repos) {
        boolean removed = super.removeAll(repos);
        for (QueryResultMapping res : ((MappingRepository)repos).getQueryResultMappings()) {
            removed |= this.removeQueryResultMapping(res);
        }
        return removed;
    }

    @Override
    public void clear() {
        super.clear();
        if (this._results != null) {
            this._results.clear();
        }
    }

    protected void addAnnotation(AnnotationBuilder ab, QueryResultMapping meta) {
        List<AnnotationBuilder> list;
        if (this._rsmAnnos == null) {
            this._rsmAnnos = new HashMap<QueryResultMapping, List<AnnotationBuilder>>();
        }
        if ((list = this._rsmAnnos.get(meta)) == null) {
            list = new ArrayList<AnnotationBuilder>();
            this._rsmAnnos.put(meta, list);
        }
        list.add(ab);
    }

    protected AnnotationBuilder addAnnotation(Class<? extends Annotation> annType, QueryResultMapping meta) {
        AnnotationBuilder ab = this.newAnnotationBuilder(annType);
        if (meta == null) {
            return ab;
        }
        this.addAnnotation(ab, meta);
        return ab;
    }

    @Override
    protected void serializeClass(ClassMetaData meta) {
        ClassMapping cls;
        if (this._sync && this.isMappingMode() && meta instanceof ClassMapping && ((cls = (ClassMapping)meta).getResolve() & 2) != 0 && cls.isMapped()) {
            cls.syncMappingInfo();
            cls.getDiscriminator().syncMappingInfo();
            cls.getVersion().syncMappingInfo();
            FieldMapping[] fields = cls.getEmbeddingMetaData() == null ? cls.getDefinedFieldMappings() : cls.getFieldMappings();
            for (FieldMapping f : fields) {
                f.syncMappingInfo();
            }
        }
        super.serializeClass(meta);
    }

    @Override
    protected void serializeClassMappingContent(ClassMetaData mapping) {
        ClassMapping cls = (ClassMapping)mapping;
        ClassMappingInfo info = cls.getMappingInfo();
        AnnotationBuilder abTable = this.addAnnotation(Table.class, mapping);
        this.serializeTable(info.getTableName(), Strings.getClassName(mapping.getDescribedType()), null, info.getUniques(info.getTableName()), abTable);
        this.serializeColumns(info, ColType.PK_JOIN, null, abTable, cls);
        for (String second : info.getSecondaryTableNames()) {
            AnnotationBuilder abSecTable = this.addAnnotation(SecondaryTable.class, mapping);
            this.serializeTable(second, null, info, info.getUniques(second), abSecTable);
        }
    }

    @Override
    protected void serializeInheritanceContent(ClassMetaData mapping) {
        ClassMapping cls = (ClassMapping)mapping;
        ClassMappingInfo info = cls.getMappingInfo();
        DiscriminatorMappingInfo dinfo = cls.getDiscriminator().getMappingInfo();
        String strat = info.getHierarchyStrategy();
        if (null == strat) {
            return;
        }
        String itypecls = Strings.getClassName(InheritanceType.class);
        AnnotationBuilder abInheritance = this.addAnnotation(Inheritance.class, mapping);
        if ("flat".equals(strat)) {
            abInheritance.add("strategy", itypecls + ".SINGLE_TABLE");
        } else if ("vertical".equals(strat)) {
            abInheritance.add("strategy", itypecls + ".JOINED");
        } else if ("full".equals(strat)) {
            abInheritance.add("strategy", itypecls + ".TABLE_PER_CLASS");
        }
        if (dinfo.getValue() != null) {
            AnnotationBuilder abDiscVal = this.addAnnotation(DiscriminatorValue.class, mapping);
            abDiscVal.add(null, dinfo.getValue());
        }
        AnnotationBuilder abDiscCol = this.addAnnotation(DiscriminatorColumn.class, mapping);
        this.serializeColumns(dinfo, ColType.DISC, null, abDiscCol, null);
    }

    private void serializeTable(String table, String defaultName, ClassMappingInfo secondaryInfo, Unique[] uniques, AnnotationBuilder ab) {
        boolean print;
        List cols = null;
        if (secondaryInfo != null) {
            cols = secondaryInfo.getSecondaryTableJoinColumns(table);
        }
        boolean bl = print = cols != null && cols.size() > 0 || uniques != null && uniques.length > 0;
        if (!(table == null || defaultName != null && defaultName.equals(table))) {
            print = true;
            int index = table.indexOf(46);
            if (index < 0) {
                ab.add("name", table);
            } else {
                ab.add("schema", table.substring(0, index));
                ab.add("name", table.substring(index + 1));
            }
        }
        if (print) {
            if (cols != null) {
                for (Column col : cols) {
                    this.serializeColumn(col, ColType.PK_JOIN, null, false, ab, null);
                }
            }
            if (uniques != null) {
                for (Unique unique : uniques) {
                    AnnotationBuilder abUniqueConst = this.newAnnotationBuilder(UniqueConstraint.class);
                    this.serializeUniqueConstraint(unique, abUniqueConst);
                    ab.add("uniqueConstraints", abUniqueConst);
                }
            }
        }
    }

    @Override
    protected boolean serializeAttributeOverride(FieldMetaData fmd, FieldMetaData orig) {
        if (orig == null || fmd == orig) {
            return false;
        }
        FieldMapping field = (FieldMapping)fmd;
        FieldMapping field2 = (FieldMapping)orig;
        if (field.getMappingInfo().hasSchemaComponents() || field2.getMappingInfo().hasSchemaComponents()) {
            return true;
        }
        ValueMappingInfo info = field.getValueInfo();
        List cols = info.getColumns();
        if (cols == null || cols.size() == 0) {
            return false;
        }
        ValueMappingInfo info2 = field2.getValueInfo();
        List cols2 = info2.getColumns();
        if (cols2 == null || cols2.size() != cols.size()) {
            return true;
        }
        if (cols.size() != 1) {
            return true;
        }
        for (int i = 0; i < cols.size(); ++i) {
            Column col = (Column)cols.get(i);
            Column col2 = (Column)cols2.get(i);
            if (!StringUtils.equals((String)col.getName(), (String)col2.getName())) {
                return true;
            }
            if (!StringUtils.equals((String)col.getTypeName(), (String)col2.getTypeName())) {
                return true;
            }
            if (col.getSize() != col2.getSize()) {
                return true;
            }
            if (col.getDecimalDigits() != col2.getDecimalDigits()) {
                return true;
            }
            if (col.getFlag(2) != col2.getFlag(2)) {
                return true;
            }
            if (col.getFlag(4) == col2.getFlag(4)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void serializeAttributeOverrideMappingContent(FieldMetaData fmd, FieldMetaData orig, AnnotationBuilder ab) {
        FieldMapping fm = (FieldMapping)fmd;
        this.serializeColumns(fm.getValueInfo(), ColType.COL, fm.getMappingInfo().getTableName(), ab, fmd);
    }

    @Override
    protected PersistenceStrategy getStrategy(FieldMetaData fmd) {
        PersistenceStrategy strat = super.getStrategy(fmd);
        FieldMapping field = (FieldMapping)fmd;
        switch (strat) {
            case MANY_MANY: {
                if (field.getMappedBy() != null || field.getMappingInfo().getJoinDirection() != 0 && field.getElementMapping().getValueInfo().getUnique() == null) break;
                return PersistenceStrategy.ONE_MANY;
            }
            case MANY_ONE: {
                if (field.getValueInfo().getJoinDirection() == 2 || field.getValueInfo().getUnique() != null) {
                    return PersistenceStrategy.ONE_ONE;
                }
                List cols = field.getValueInfo().getColumns();
                boolean pkJoin = cols != null && cols.size() > 0;
                for (int i = 0; pkJoin && i < cols.size(); ++i) {
                    pkJoin = ((Column)cols.get(i)).getFlag(128);
                }
                if (!pkJoin) break;
                return PersistenceStrategy.ONE_ONE;
            }
        }
        return strat;
    }

    @Override
    protected void serializeFieldMappingContent(FieldMetaData fmd, PersistenceStrategy strategy, AnnotationBuilder ab) {
        EnumType enumType;
        TemporalType temporal;
        if (fmd.getMappedBy() != null) {
            return;
        }
        FieldMapping field = (FieldMapping)fmd;
        switch (strategy) {
            case MANY_ONE: 
            case ONE_ONE: {
                this.serializeColumns(field.getValueInfo(), ColType.JOIN, field.getMappingInfo().getTableName(), null, fmd);
                return;
            }
            case ONE_MANY: {
                if (field.getMappingInfo().getJoinDirection() == 0) {
                    this.serializeColumns(field.getElementMapping().getValueInfo(), ColType.JOIN, null, null, fmd);
                    return;
                }
            }
            case MANY_MANY: {
                if (field.getMappingInfo().hasSchemaComponents() || field.getElementMapping().getValueInfo().hasSchemaComponents()) {
                    AnnotationBuilder abJoinTbl = this.addAnnotation(JoinTable.class, fmd);
                    String table = field.getMappingInfo().getTableName();
                    if (table != null) {
                        int index = table.indexOf(46);
                        if (index < 0) {
                            abJoinTbl.add("name", table);
                        } else {
                            abJoinTbl.add("schema", table.substring(0, index));
                            abJoinTbl.add("name", table.substring(index + 1));
                        }
                    }
                    this.serializeColumns(field.getMappingInfo(), ColType.JOIN, null, abJoinTbl, null);
                    this.serializeColumns(field.getElementMapping().getValueInfo(), ColType.INVERSE, null, abJoinTbl, null);
                }
                return;
            }
        }
        this.serializeColumns(field.getValueInfo(), ColType.COL, field.getMappingInfo().getTableName(), null, fmd);
        if (strategy == PersistenceStrategy.BASIC && this.isLob(field)) {
            this.addAnnotation(Lob.class, fmd);
        }
        if ((temporal = this.getTemporal(field)) != null) {
            this.addAnnotation(Temporal.class, fmd).add(null, (Enum)temporal);
        }
        if ((enumType = this.getEnumType(field)) != null && enumType != EnumType.ORDINAL) {
            this.addAnnotation(Enumerated.class, fmd).add(null, (Enum)enumType);
        }
    }

    private boolean isLob(FieldMapping field) {
        for (Column col : field.getValueInfo().getColumns()) {
            if (col.getType() != 2004 && col.getType() != 2005) continue;
            return true;
        }
        return false;
    }

    private TemporalType getTemporal(FieldMapping field) {
        if (field.getDeclaredTypeCode() != 14 && field.getDeclaredTypeCode() != 28) {
            return null;
        }
        DBDictionary dict = ((JDBCConfiguration)this.getConfiguration()).getDBDictionaryInstance();
        int def = dict.getJDBCType(field.getTypeCode(), false);
        for (Column col : field.getValueInfo().getColumns()) {
            if (col.getType() == def) continue;
            switch (col.getType()) {
                case 91: {
                    return TemporalType.DATE;
                }
                case 92: {
                    return TemporalType.TIME;
                }
                case 93: {
                    return TemporalType.TIMESTAMP;
                }
            }
        }
        return null;
    }

    protected EnumType getEnumType(FieldMapping field) {
        if (field.getDeclaredTypeCode() != 8) {
            return null;
        }
        if (!(field.getHandler() instanceof EnumValueHandler)) {
            return null;
        }
        return ((EnumValueHandler)field.getHandler()).getStoreOrdinal() ? EnumType.ORDINAL : EnumType.STRING;
    }

    private void serializeColumns(MappingInfo info, ColType type, String secondary, AnnotationBuilder ab, Object meta) {
        Class grpType;
        List cols = info.getColumns();
        if (cols == null) {
            return;
        }
        AnnotationBuilder abContainer = ab;
        if (cols.size() > 1 && null != (grpType = type.getColumnGroupAnnotationType())) {
            AnnotationBuilder abGrp = this.newAnnotationBuilder(grpType);
            if (null == ab) {
                this.addAnnotation(abGrp, meta);
            } else {
                ab.add(null, abGrp);
            }
            abContainer = abGrp;
        }
        for (Column col : cols) {
            this.serializeColumn(col, type, secondary, info.getUnique() != null, abContainer, meta);
        }
    }

    private void serializeColumn(Column col, ColType type, String secondary, boolean unique, AnnotationBuilder ab, Object meta) {
        FieldMetaData fmd = meta instanceof FieldMetaData ? (FieldMetaData)meta : null;
        AnnotationBuilder abCol = this.newAnnotationBuilder(type.getColumnAnnotationType());
        if (!(col.getName() == null || null != fmd && col.getName().equalsIgnoreCase(fmd.getName()))) {
            abCol.add("name", col.getName());
        }
        if (col.getTypeName() != null) {
            abCol.add("columnDefinition", col.getTypeName());
        }
        if (col.getTarget() != null && (type == ColType.JOIN || type == ColType.INVERSE || type == ColType.PK_JOIN)) {
            abCol.add("referencedColumnName", col.getTarget());
        }
        if (type == ColType.COL || type == ColType.JOIN || type == ColType.PK_JOIN) {
            if (unique) {
                abCol.add("unique", true);
            }
            if (col.isNotNull()) {
                abCol.add("nullable", false);
            }
            if (col.getFlag(2)) {
                abCol.add("insertable", false);
            }
            if (col.getFlag(4)) {
                abCol.add("updatable", false);
            }
            if (secondary != null) {
                abCol.add("table", secondary);
            }
            if (type == ColType.COL) {
                if (col.getSize() > 0 && col.getSize() != 255) {
                    abCol.add("length", col.getSize());
                }
                if (col.getDecimalDigits() != 0) {
                    abCol.add("scale", col.getDecimalDigits());
                }
            }
        }
        if (type != ColType.COL || abCol.hasComponents()) {
            if (null != ab) {
                String key = null;
                if (ab.getType() == JoinTable.class) {
                    switch (type) {
                        case JOIN: {
                            key = "joinColumns";
                            break;
                        }
                        case INVERSE: {
                            key = "inverseJoinColumns";
                        }
                    }
                }
                ab.add(key, abCol);
            } else {
                this.addAnnotation(abCol, meta);
            }
        }
    }

    private void serializeUniqueConstraint(Unique unique, AnnotationBuilder ab) {
        Column[] columns;
        StringBuilder sb = new StringBuilder();
        for (Column column : columns = unique.getColumns()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(column.getName());
        }
        if (columns.length > 1) {
            sb.insert(0, "{").append("}");
        }
        ab.add("columnNames", sb.toString());
        if (StringUtils.isNotEmpty((String)unique.getName())) {
            ab.add("name", unique.getName());
        }
    }

    @Override
    protected AnnotationPersistenceMetaDataSerializer.SerializationComparator newSerializationComparator() {
        return new MappingSerializationComparator();
    }

    @Override
    protected void addSystemMappingElements(Collection toSerialize) {
        if (this.isQueryMode()) {
            toSerialize.addAll(this.getQueryResultMappings(null));
        }
    }

    @Override
    protected int type(Object o) {
        int type = super.type(o);
        if (type == -1 && o instanceof QueryResultMapping) {
            return 21;
        }
        return type;
    }

    private List<QueryResultMapping> getQueryResultMappings(ClassMetaData cm) {
        if (this._results == null || this._results.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<QueryResultMapping> result = null;
        for (int i = 0; i < this._results.size(); ++i) {
            QueryResultMapping element = this._results.get(i);
            if (cm == null && element.getSourceScope() != null || cm != null && element.getSourceScope() != cm.getDescribedType()) continue;
            if (result == null) {
                result = new ArrayList<QueryResultMapping>(this._results.size() - i);
            }
            result.add(element);
        }
        return result == null ? Collections.EMPTY_LIST : result;
    }

    @Override
    protected void serializeSystemMappingElement(Object obj) {
        if (obj instanceof QueryResultMapping) {
            this.serializeQueryResultMapping((QueryResultMapping)obj, null);
        }
    }

    @Override
    protected void serializeQueryMappings(ClassMetaData meta) {
        for (QueryResultMapping res : this.getQueryResultMappings(meta)) {
            this.serializeQueryResultMapping(res, meta);
        }
    }

    private void serializeQueryResultMapping(QueryResultMapping meta, ClassMetaData clsmeta) {
        AnnotationBuilder ab = this.addAnnotation(SqlResultSetMapping.class, meta);
        if (null != clsmeta) {
            this.addAnnotation(ab, clsmeta);
        }
        ab.add("name", meta.getName());
        for (QueryResultMapping.PCResult pc : meta.getPCResults()) {
            AnnotationBuilder abEntRes = this.newAnnotationBuilder(EntityResult.class);
            ab.add("entities", abEntRes);
            abEntRes.add("entityClass", pc.getCandidateType());
            Object discrim = pc.getMapping("<discriminator>");
            if (discrim != null) {
                abEntRes.add("discriminatorColumn", discrim.toString());
            }
            for (String path : pc.getMappingPaths()) {
                AnnotationBuilder abFldRes = this.newAnnotationBuilder(FieldResult.class);
                abEntRes.add("fields", abFldRes);
                abFldRes.add("name", path);
                abFldRes.add("column", pc.getMapping(path).toString());
            }
        }
        for (Object col : meta.getColumnResults()) {
            AnnotationBuilder abColRes = this.newAnnotationBuilder(ColumnResult.class);
            abColRes.add("name", col.toString());
        }
    }

    @Override
    protected void serializeSequence(SequenceMetaData meta) {
        if ("value-table".equals(meta.getSequencePlugin())) {
            super.serializeSequence(meta);
            return;
        }
        AnnotationBuilder abTblGen = this.addAnnotation(TableGenerator.class, meta);
        SequenceMapping seq = (SequenceMapping)meta;
        abTblGen.add("name", seq.getName());
        String table = seq.getTable();
        if (table != null) {
            int dotIdx = table.indexOf(46);
            if (dotIdx == -1) {
                abTblGen.add("table", table);
            } else {
                abTblGen.add("table", table.substring(dotIdx + 1));
                abTblGen.add("schema", table.substring(0, dotIdx));
            }
        }
        if (!StringUtils.isEmpty((String)seq.getPrimaryKeyColumn())) {
            abTblGen.add("pkColumnName", seq.getPrimaryKeyColumn());
        }
        if (!StringUtils.isEmpty((String)seq.getSequenceColumn())) {
            abTblGen.add("valueColumnName", seq.getSequenceColumn());
        }
        if (!StringUtils.isEmpty((String)seq.getPrimaryKeyValue())) {
            abTblGen.add("pkColumnValue", seq.getPrimaryKeyValue());
        }
        if (seq.getAllocate() != 50 && seq.getAllocate() != -1) {
            abTblGen.add("allocationSize", seq.getAllocate() + "");
        }
        if (seq.getInitialValue() != 0 && seq.getInitialValue() != -1) {
            abTblGen.add("initialValue", seq.getInitialValue() + "");
        }
    }

    protected class MappingSerializationComparator
    extends AnnotationPersistenceMetaDataSerializer.SerializationComparator {
        protected MappingSerializationComparator() {
        }

        protected int compareUnknown(Object o1, Object o2) {
            int listingIndex2;
            if (!(o1 instanceof QueryResultMapping)) {
                return super.compareUnknown(o1, o2);
            }
            QueryResultMapping res1 = (QueryResultMapping)o1;
            QueryResultMapping res2 = (QueryResultMapping)o2;
            Object scope1 = res1.getSourceScope();
            Object scope2 = res2.getSourceScope();
            if (scope1 == null && scope2 != null) {
                return -1;
            }
            if (scope1 != null && scope2 == null) {
                return 1;
            }
            int listingIndex1 = res1.getListingIndex();
            if (listingIndex1 != (listingIndex2 = res2.getListingIndex())) {
                return listingIndex1 - listingIndex2;
            }
            return res1.getName().compareTo(res2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ColType {
        COL,
        JOIN,
        INVERSE,
        PK_JOIN,
        DISC;


        private Class<? extends Annotation> getColumnAnnotationType() {
            switch (this) {
                case COL: {
                    return javax.persistence.Column.class;
                }
                case JOIN: 
                case INVERSE: {
                    return JoinColumn.class;
                }
                case PK_JOIN: {
                    return PrimaryKeyJoinColumn.class;
                }
                case DISC: {
                    return DiscriminatorColumn.class;
                }
            }
            return null;
        }

        private Class<? extends Annotation> getColumnGroupAnnotationType() {
            switch (this) {
                case JOIN: 
                case INVERSE: {
                    return JoinColumns.class;
                }
                case PK_JOIN: {
                    return PrimaryKeyJoinColumns.class;
                }
            }
            return null;
        }
    }
}

