/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.PessimisticLockManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.jdbc.sql.SQLFactory;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.OptimisticException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixedLockManager
extends PessimisticLockManager {
    private static final Localizer _loc = Localizer.forPackage(MixedLockManager.class);

    @Override
    public boolean selectForUpdate(Select sel, int lockLevel) {
        return lockLevel >= 30 ? super.selectForUpdate(sel, lockLevel) : false;
    }

    @Override
    protected void lockInternal(OpenJPAStateManager sm, int level, int timeout, Object sdata, boolean postLockVersionCheck) {
        if (level >= 50) {
            this.setVersionCheckOnReadLock(true);
            this.setVersionUpdateOnWriteLock(true);
            super.lockInternal(sm, level, timeout, sdata, postLockVersionCheck);
        } else if (level >= 30) {
            this.setVersionCheckOnReadLock(true);
            this.setVersionUpdateOnWriteLock(false);
            super.lockInternal(sm, level, timeout, sdata, postLockVersionCheck);
        } else if (level >= 10) {
            this.setVersionCheckOnReadLock(true);
            this.setVersionUpdateOnWriteLock(true);
            this.optimisticLockInternal(sm, level, timeout, sdata, postLockVersionCheck);
        }
    }

    @Override
    protected List<SQLBuffer> getLockRows(DBDictionary dict, Object id, ClassMapping mapping, JDBCFetchConfiguration fetch, SQLFactory factory) {
        List<SQLBuffer> sqls = super.getLockRows(dict, id, mapping, fetch, factory);
        if (!dict.supportsLockingWithMultipleTables) {
            FieldMapping[] fms;
            HashMap<DBIdentifier, FieldMapping> colsMappedToSecTable = new HashMap<DBIdentifier, FieldMapping>();
            for (FieldMapping fm : fms = mapping.getFieldMappings()) {
                DBIdentifier secTableName = fm.getMappingInfo().getTableIdentifier();
                if (DBIdentifier.isNull(secTableName)) continue;
                colsMappedToSecTable.put(secTableName, fm);
            }
            for (DBIdentifier secTableName : colsMappedToSecTable.keySet()) {
                FieldMapping fm = (FieldMapping)colsMappedToSecTable.get(secTableName);
                Select select = factory.newSelect();
                select.select(fm.getColumns());
                select.whereForeignKey(fm.getJoinForeignKey(), id, mapping, this._store);
                sqls.add(select.toSelect(true, fetch));
            }
        }
        return sqls;
    }

    @Override
    protected void optimisticLockInternal(OpenJPAStateManager sm, int level, int timeout, Object sdata, boolean postLockVersionCheck) {
        super.optimisticLockInternal(sm, level, timeout, sdata, postLockVersionCheck);
        if (postLockVersionCheck && level >= 30) {
            ClassMapping mapping = (ClassMapping)sm.getMetaData();
            try {
                if (!mapping.getVersion().checkVersion(sm, this.getStore(), false)) {
                    throw new OptimisticException((Object)_loc.get("optimistic-violation-lock").getMessage()).setFailedObject(sm.getObjectId());
                }
            }
            catch (SQLException se) {
                throw SQLExceptions.getStore(se, sm.getObjectId(), this.getStore().getDBDictionary());
            }
        }
    }

    @Override
    public boolean skipRelationFieldLock() {
        return true;
    }
}

