/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import org.apache.openjpa.persistence.query.AbstractVisitable;
import org.apache.openjpa.persistence.query.AliasContext;
import org.apache.openjpa.persistence.query.AndPredicate;
import org.apache.openjpa.persistence.query.Expression;
import org.apache.openjpa.persistence.query.ExpressionImpl;
import org.apache.openjpa.persistence.query.OrPredicate;
import org.apache.openjpa.persistence.query.Predicate;
import org.apache.openjpa.persistence.query.UnaryConditionalOperator;
import org.apache.openjpa.persistence.query.Visitable;

class UnaryExpressionPredicate
extends AbstractVisitable
implements Predicate,
Visitable {
    protected final Expression _e;
    protected final UnaryConditionalOperator _op;
    private final UnaryConditionalOperator _nop;

    public UnaryExpressionPredicate(Expression e, UnaryConditionalOperator op, UnaryConditionalOperator nop) {
        this._e = e;
        this._op = op;
        this._nop = nop;
    }

    public Expression getOperand() {
        return this._e;
    }

    public UnaryConditionalOperator getOperator() {
        return this._op;
    }

    public Predicate and(Predicate predicate) {
        return new AndPredicate(this, predicate);
    }

    public Predicate or(Predicate predicate) {
        return new OrPredicate(this, predicate);
    }

    public Predicate not() {
        if (this._nop == null) {
            throw new UnsupportedOperationException(this.toString());
        }
        return new UnaryExpressionPredicate(this._e, this._nop, this._op);
    }

    public String asExpression(AliasContext ctx) {
        return (Object)((Object)this._op) + "(" + ((ExpressionImpl)this._e).asExpression(ctx) + ")";
    }
}

