/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.rop;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.openjpa.lib.rop.AbstractListIterator;
import org.apache.openjpa.lib.rop.AbstractSequentialResultList;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.rop.ResultObjectProvider;

public class LazyForwardResultList
extends AbstractSequentialResultList
implements ResultList {
    private static final int OPEN = 0;
    private static final int CLOSED = 1;
    private static final int FREED = 2;
    private ResultObjectProvider _rop = null;
    private final List _list = new ArrayList();
    private int _state = 0;
    private int _size = -1;

    public LazyForwardResultList(ResultObjectProvider rop) {
        this._rop = rop;
        try {
            this._rop.open();
        }
        catch (RuntimeException re) {
            this.close();
            throw re;
        }
        catch (Exception e) {
            this.close();
            this._rop.handleCheckedException(e);
        }
    }

    public boolean isProviderOpen() {
        return this._state == 0;
    }

    public boolean isClosed() {
        return this._state == 1;
    }

    public void close() {
        if (this._state != 1) {
            this.free();
            this._state = 1;
        }
    }

    public Object get(int index) {
        this.assertOpen();
        if (index == this._list.size()) {
            this.addNext();
        }
        if (index < this._list.size()) {
            return this._list.get(index);
        }
        return super.get(index);
    }

    protected ListIterator itr(int index) {
        return this._state != 0 ? this._list.listIterator(index) : new Itr(index);
    }

    public int size() {
        this.assertOpen();
        if (this._size != -1) {
            return this._size;
        }
        if (this._state != 0) {
            return this._list.size();
        }
        try {
            this._size = this._rop.size();
            return this._size;
        }
        catch (RuntimeException re) {
            this.close();
            throw re;
        }
        catch (Exception e) {
            this.close();
            this._rop.handleCheckedException(e);
            return -1;
        }
    }

    private boolean addNext() {
        try {
            if (!this._rop.next()) {
                this.free();
                return false;
            }
            this._list.add(this._rop.getResultObject());
            return true;
        }
        catch (RuntimeException re) {
            this.close();
            throw re;
        }
        catch (Exception e) {
            this.close();
            this._rop.handleCheckedException(e);
            return false;
        }
    }

    private void free() {
        if (this._state == 0) {
            try {
                this._rop.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._state = 2;
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        if (this._state == 0) {
            ListIterator itr = this.itr(this._list.size());
            while (itr.hasNext()) {
                itr.next();
            }
        }
        return this._list;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object other) {
        return other == this;
    }

    public List subList(int fromIndex, int toIndex) {
        this.assertOpen();
        return this._list.subList(fromIndex, toIndex);
    }

    private class Itr
    extends AbstractListIterator {
        private int _idx = 0;

        public Itr(int index) {
            this._idx = Math.min(index, LazyForwardResultList.this._list.size());
            while (this._idx < index) {
                this.next();
            }
        }

        public int nextIndex() {
            return this._idx;
        }

        public int previousIndex() {
            return this._idx - 1;
        }

        public boolean hasNext() {
            if (LazyForwardResultList.this._list.size() > this._idx) {
                return true;
            }
            if (LazyForwardResultList.this._state != 0) {
                return false;
            }
            return LazyForwardResultList.this.addNext();
        }

        public boolean hasPrevious() {
            return this._idx > 0;
        }

        public Object previous() {
            if (this._idx == 0) {
                throw new NoSuchElementException();
            }
            return LazyForwardResultList.this._list.get(--this._idx);
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return LazyForwardResultList.this._list.get(this._idx++);
        }
    }
}

