/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Enumeration;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;

public final class IntrospectorMetaBeanFactory
implements MetaBeanFactory {
    public void buildMetaBean(MetaBean meta) throws Exception {
        if (meta.getBeanClass() == null) {
            return;
        }
        BeanInfo info = Introspector.getBeanInfo(meta.getBeanClass());
        if (info.getBeanDescriptor() != null) {
            meta.setName(info.getBeanDescriptor().getName());
        }
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            if (pd instanceof IndexedPropertyDescriptor || pd.getName().equals("class")) continue;
            MetaProperty metaProp = this.buildMetaProperty(pd);
            meta.putProperty(pd.getName(), metaProp);
        }
    }

    protected MetaProperty buildMetaProperty(PropertyDescriptor pd) {
        MetaProperty meta = new MetaProperty();
        meta.setName(pd.getName());
        meta.setType(pd.getPropertyType());
        if (pd.isHidden()) {
            meta.putFeature("hidden", Boolean.TRUE);
        }
        if (pd.isPreferred()) {
            meta.putFeature("preferred", Boolean.TRUE);
        }
        if (pd.isConstrained()) {
            meta.putFeature("readonly", Boolean.TRUE);
        }
        Enumeration<String> enumeration = pd.attributeNames();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            Object value = pd.getValue(key);
            meta.putFeature(key, value);
        }
        return meta;
    }
}

