/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.Selection;
import org.apache.openjpa.kernel.FillStrategy;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.persistence.TupleFactory;
import org.apache.openjpa.persistence.TupleImpl;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.CriteriaExpression;
import org.apache.openjpa.persistence.criteria.Expressions;
import org.apache.openjpa.persistence.criteria.SelectionImpl;

class CompoundSelections {
    private static Localizer _loc = Localizer.forPackage(CompoundSelections.class);

    CompoundSelections() {
    }

    static <X> FillStrategy<X> getFillStrategy(Selection<X> s) {
        if (s instanceof CompoundSelectionImpl) {
            return ((CompoundSelectionImpl)s).getFillStrategy();
        }
        return new FillStrategy.Assign();
    }

    static class MultiSelection<T>
    extends CompoundSelectionImpl<T> {
        public MultiSelection(Class<T> result, Selection<?>[] selections) {
            super(result, selections);
        }

        @Override
        public FillStrategy<T> getFillStrategy() {
            Class<Object> resultClass = this.getJavaType();
            List<Selection<?>> terms = this.getCompoundSelectionItems();
            FillStrategy<Object> strategy = null;
            if (javax.persistence.Tuple.class.isAssignableFrom(resultClass)) {
                TupleFactory factory = new TupleFactory(terms.toArray(new TupleElement[terms.size()]));
                strategy = new FillStrategy.Factory<javax.persistence.Tuple>(factory, TupleImpl.PUT);
            } else if (resultClass == Object.class) {
                if (terms.size() > 1) {
                    resultClass = Object[].class;
                    strategy = new FillStrategy.Array<Object[]>(Object[].class);
                } else {
                    strategy = new FillStrategy.Assign();
                }
            } else {
                strategy = resultClass.isArray() ? new FillStrategy.Array(resultClass) : new FillStrategy.NewInstance(resultClass);
            }
            return strategy;
        }
    }

    static class Tuple
    extends CompoundSelectionImpl<javax.persistence.Tuple> {
        public Tuple(Selection<?>[] selections) {
            super(javax.persistence.Tuple.class, selections);
        }

        @Override
        public FillStrategy<javax.persistence.Tuple> getFillStrategy() {
            List<Selection<?>> terms = this.getCompoundSelectionItems();
            TupleFactory factory = new TupleFactory(terms.toArray(new TupleElement[terms.size()]));
            return new FillStrategy.Factory<javax.persistence.Tuple>(factory, TupleImpl.PUT);
        }
    }

    static class NewInstance<X>
    extends CompoundSelectionImpl<X> {
        private FillStrategy.NewInstance<X> strategy;

        public NewInstance(Class<X> cls, Selection<?> ... selections) {
            super(cls, selections);
            this.strategy = new FillStrategy.NewInstance<X>(this.findConstructor(cls, selections));
        }

        @Override
        public FillStrategy<X> getFillStrategy() {
            return this.strategy;
        }

        private Constructor<X> findConstructor(Class<X> cls, Selection<?> ... selections) {
            Object[] types;
            Object[] objectArray = types = selections == null ? null : new Class[selections.length];
            if (selections != null) {
                for (int i = 0; i < selections.length; ++i) {
                    types[i] = selections[i].getJavaType();
                }
            }
            try {
                return cls.getConstructor((Class<?>[])types);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(_loc.get("select-no-ctor", cls, types == null ? "[]" : Arrays.toString(types)).getMessage());
            }
        }

        @Override
        public StringBuilder asValue(AliasContext q) {
            return new StringBuilder("NEW ").append(this.getJavaType().getName()).append("(").append((CharSequence)super.asValue(q)).append(")");
        }
    }

    static class Array<X>
    extends CompoundSelectionImpl<X> {
        public Array(Class<X> cls, Selection<?> ... terms) {
            super(cls, terms);
            if (!cls.isArray()) {
                throw new IllegalArgumentException(cls + " is not an array. " + this + " needs an array");
            }
        }

        @Override
        public FillStrategy<X> getFillStrategy() {
            return new FillStrategy.Array(this.getJavaType());
        }
    }

    private static abstract class CompoundSelectionImpl<X>
    extends SelectionImpl<X>
    implements CompoundSelection<X> {
        private final List<Selection<?>> _args;

        public CompoundSelectionImpl(Class<X> cls, Selection<?> ... args) {
            super(cls);
            this._args = args == null ? Collections.EMPTY_LIST : Arrays.asList(args);
        }

        @Override
        public final boolean isCompoundSelection() {
            return true;
        }

        @Override
        public final List<Selection<?>> getCompoundSelectionItems() {
            return Expressions.returnCopy(this._args);
        }

        void assertNoCompoundSelection(Selection<?> ... args) {
            if (args == null) {
                return;
            }
            for (Selection<?> s : args) {
                if (!s.isCompoundSelection() || s.getClass() == NewInstance.class) continue;
                throw new IllegalArgumentException("compound selection " + s + " can not be nested in " + this);
            }
        }

        abstract FillStrategy<X> getFillStrategy();

        @Override
        public StringBuilder asValue(AliasContext q) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this._args.size(); ++i) {
                buffer.append((CharSequence)((CriteriaExpression)((Object)this._args.get(i))).asValue(q));
                if (i + 1 == this._args.size()) continue;
                buffer.append(", ");
            }
            return buffer;
        }

        @Override
        public StringBuilder asProjection(AliasContext q) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < this._args.size(); ++i) {
                buffer.append((CharSequence)((CriteriaExpression)((Object)this._args.get(i))).asProjection(q));
                if (i + 1 == this._args.size()) continue;
                buffer.append(", ");
            }
            return buffer;
        }
    }
}

