/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCSeq;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.StoreException;

public abstract class AbstractJDBCSeq
implements JDBCSeq {
    protected int type = 0;
    protected Object current = null;
    private transient Transaction _outerTransaction;

    public void setType(int type) {
        this.type = type;
    }

    public Object next(StoreContext ctx, ClassMetaData meta) {
        JDBCStore store = this.getStore(ctx);
        try {
            this.current = this.nextInternal(store, (ClassMapping)meta);
            return this.current;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, store.getDBDictionary());
        }
        catch (Exception e) {
            throw new StoreException((Throwable)e);
        }
    }

    public Object current(StoreContext ctx, ClassMetaData meta) {
        JDBCStore store = this.getStore(ctx);
        try {
            return this.currentInternal(store, (ClassMapping)meta);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, store.getDBDictionary());
        }
        catch (Exception e) {
            throw new StoreException((Throwable)e);
        }
    }

    public void allocate(int additional, StoreContext ctx, ClassMetaData meta) {
        JDBCStore store = this.getStore(ctx);
        try {
            this.allocateInternal(additional, store, (ClassMapping)meta);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, store.getDBDictionary());
        }
        catch (Exception e) {
            throw new StoreException((Throwable)e);
        }
    }

    public void addSchema(ClassMapping mapping, SchemaGroup group) {
    }

    public void close() {
    }

    protected abstract Object nextInternal(JDBCStore var1, ClassMapping var2) throws Exception;

    public abstract JDBCConfiguration getConfiguration();

    protected Object currentInternal(JDBCStore store, ClassMapping mapping) throws Exception {
        return this.current;
    }

    protected void allocateInternal(int additional, JDBCStore store, ClassMapping mapping) throws Exception {
    }

    private JDBCStore getStore(StoreContext ctx) {
        return (JDBCStore)ctx.getStoreManager().getInnermostDelegate();
    }

    protected Connection getConnection(JDBCStore store) throws SQLException {
        if (this.type == 2 || this.type == 3) {
            return store.getConnection();
        }
        if (this.suspendInJTA()) {
            try {
                TransactionManager tm = this.getConfiguration().getManagedRuntimeInstance().getTransactionManager();
                this._outerTransaction = tm.suspend();
                tm.begin();
                return store.getConnection();
            }
            catch (Exception e) {
                throw new StoreException((Throwable)e);
            }
        }
        JDBCConfiguration conf = store.getConfiguration();
        DataSource ds = conf.getDataSource2(store.getContext());
        Connection conn = ds.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        return conn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void closeConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        if (this.type == 2 || this.type == 3) {
            return;
        }
        if (this.suspendInJTA()) {
            try {
                TransactionManager tm = this.getConfiguration().getManagedRuntimeInstance().getTransactionManager();
                tm.commit();
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (this._outerTransaction == null) return;
                tm.resume(this._outerTransaction);
                return;
            }
            catch (Exception e) {
                throw new StoreException((Throwable)e);
            }
            finally {
                this._outerTransaction = null;
            }
        }
        try {
            conn.commit();
            return;
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException se) {}
        }
    }

    protected boolean suspendInJTA() {
        return this.getConfiguration().isConnectionFactoryModeManaged() && this.getConfiguration().getConnectionFactory2() == null;
    }
}

