/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.JDBCPath;
import org.apache.openjpa.jdbc.kernel.exps.SubQ;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.kernel.exps.Variable;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.XMLMetaData;
import org.apache.openjpa.util.UserException;

public class PCPath
extends AbstractVal
implements JDBCPath {
    private static final int PATH = 0;
    private static final int BOUND_VAR = 1;
    private static final int UNBOUND_VAR = 2;
    private static final int UNACCESSED_VAR = 3;
    private static final int XPATH = 4;
    private static final Localizer _loc = Localizer.forPackage(PCPath.class);
    private final ClassMapping _candidate;
    private ClassMapping _class = null;
    private LinkedList _actions = null;
    private boolean _key = false;
    private int _type = 0;
    private String _varName = null;
    private Class _cast = null;
    private boolean _cid = false;
    private FieldMetaData _xmlfield = null;

    public PCPath(ClassMapping type) {
        this._candidate = type;
    }

    public PCPath(ClassMapping candidate, Variable var) {
        this._candidate = candidate;
        this._actions = new LinkedList();
        PCPath other = var.getPCPath();
        Action action = new Action();
        if (other == null) {
            this._type = 2;
            action.op = 5;
            action.data = var;
        } else {
            this._type = 3;
            this._actions.addAll(other._actions);
            this._key = other._key;
            action.op = 3;
            action.data = var.getName();
        }
        this._actions.add(action);
        this._cast = var.getType();
    }

    public PCPath(SubQ sub) {
        this._candidate = sub.getCandidate();
        this._actions = new LinkedList();
        Action action = new Action();
        action.op = 4;
        action.data = sub.getCandidateAlias();
        this._actions.add(action);
        this._cast = sub.getType();
        this._varName = sub.getCandidateAlias();
    }

    public void addVariableAction(Variable var) {
        this._varName = var.getName();
    }

    public boolean isUnaccessedVariable() {
        return this._type == 3;
    }

    public boolean isVariablePath() {
        return this._type != 0;
    }

    public synchronized void setContainsId(String id) {
        if (this._cid) {
            return;
        }
        Action action = new Action();
        action.op = 3;
        action.data = id;
        if (this._actions == null) {
            this._actions = new LinkedList();
        }
        this._actions.add(action);
        this._cid = true;
    }

    public ClassMetaData getMetaData() {
        return this._class;
    }

    public void setMetaData(ClassMetaData meta) {
        this._class = (ClassMapping)meta;
    }

    public boolean isKey() {
        return this._key;
    }

    public boolean isXPath() {
        return this._type == 4;
    }

    public String getXPath() {
        Action action;
        StringBuffer xpath = new StringBuffer();
        Iterator itr = this._actions.iterator();
        do {
            action = (Action)itr.next();
        } while (action.op != 7);
        while (itr.hasNext()) {
            action = (Action)itr.next();
            if (((XMLMetaData)action.data).getXmlname() != null) {
                xpath.append(((XMLMetaData)action.data).getXmlname());
            } else {
                xpath.append("*");
            }
            if (!itr.hasNext()) continue;
            xpath.append("/");
        }
        return xpath.toString();
    }

    public String getPath() {
        if (this._actions == null) {
            return this._varName == null ? "" : this._varName + ".";
        }
        StringBuffer path = new StringBuffer();
        for (Action action : this._actions) {
            if (action.op == 3 || action.op == 4) {
                path.append(action.data);
            } else if (action.op == 5) {
                path.append(((Variable)action.data).getName());
            } else {
                path.append(((FieldMapping)action.data).getName());
            }
            path.append('.');
        }
        if (this._varName != null) {
            path.append(this._varName).append('.');
        }
        return path.toString();
    }

    public ClassMapping getClassMapping(ExpState state) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            return this._class;
        }
        if (this._key) {
            if (pstate.field.getKey().getTypeCode() == 15) {
                return pstate.field.getKeyMapping().getTypeMapping();
            }
            return null;
        }
        if (pstate.field.getElement().getTypeCode() == 15) {
            return pstate.field.getElementMapping().getTypeMapping();
        }
        if (pstate.field.getTypeCode() == 15) {
            return pstate.field.getTypeMapping();
        }
        return null;
    }

    public FieldMapping getFieldMapping(ExpState state) {
        return ((PathExpState)state).field;
    }

    public Column[] getColumns(ExpState state) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.cols == null) {
            pstate.cols = this.calculateColumns(pstate);
        }
        return pstate.cols;
    }

    private Column[] calculateColumns(PathExpState pstate) {
        if (this._key) {
            if (!pstate.joinedRel && pstate.field.getKey().getValueMappedBy() != null) {
                this.joinRelation(pstate, this._key, false, false);
            } else if (pstate.joinedRel && pstate.field.getKey().getTypeCode() == 15) {
                return pstate.field.getKeyMapping().getTypeMapping().getPrimaryKeyColumns();
            }
            return pstate.field.getKeyMapping().getColumns();
        }
        if (pstate.field != null) {
            switch (pstate.field.getTypeCode()) {
                case 11: 
                case 12: 
                case 13: {
                    ValueMapping elem = pstate.field.getElementMapping();
                    if (pstate.joinedRel && elem.getTypeCode() == 15) {
                        return elem.getTypeMapping().getPrimaryKeyColumns();
                    }
                    if (elem.getColumns().length > 0) {
                        return elem.getColumns();
                    }
                    return pstate.field.getColumns();
                }
                case 15: {
                    if (pstate.joinedRel) {
                        return pstate.field.getTypeMapping().getPrimaryKeyColumns();
                    }
                    return pstate.field.getColumns();
                }
            }
            return pstate.field.getColumns();
        }
        return this._class == null ? Schemas.EMPTY_COLUMNS : this._class.getPrimaryKeyColumns();
    }

    public boolean isVariable() {
        if (this._actions == null) {
            return false;
        }
        Action action = (Action)this._actions.getLast();
        return action.op == 5 || action.op == 3;
    }

    public void get(FieldMetaData field, boolean nullTraversal) {
        if (this._actions == null) {
            this._actions = new LinkedList();
        }
        Action action = new Action();
        action.op = nullTraversal ? 1 : 0;
        action.data = field;
        this._actions.add(action);
        if (this._type == 3) {
            this._type = 1;
        }
        this._cast = null;
        this._key = false;
    }

    public void get(FieldMetaData fmd, XMLMetaData meta) {
        if (this._actions == null) {
            this._actions = new LinkedList();
        }
        Action action = new Action();
        action.op = 7;
        action.data = meta;
        this._actions.add(action);
        this._cast = null;
        this._key = false;
        this._type = 4;
        this._xmlfield = fmd;
    }

    public void get(XMLMetaData meta, String name) {
        Action action = new Action();
        action.op = 7;
        action.data = meta.getFieldMapping(name);
        this._actions.add(action);
        this._cast = null;
        this._key = false;
        this._type = 4;
    }

    public XMLMetaData getXmlMapping() {
        Action act = (Action)this._actions.getLast();
        if (act != null) {
            return (XMLMetaData)act.data;
        }
        return null;
    }

    public synchronized void getKey() {
        if (this._cid) {
            return;
        }
        Action action = (Action)this._actions.getLast();
        action.op = 2;
        this._cast = null;
        this._key = true;
    }

    public FieldMetaData last() {
        Action act = this.lastFieldAction();
        return act == null ? null : (this.isXPath() ? this._xmlfield : (FieldMetaData)act.data);
    }

    private Action lastFieldAction() {
        if (this._actions == null) {
            return null;
        }
        if (this.isXPath()) {
            return (Action)this._actions.getLast();
        }
        ListIterator itr = this._actions.listIterator(this._actions.size());
        while (itr.hasPrevious()) {
            Action prev = (Action)itr.previous();
            if (prev.op != 0 && prev.op != 1 && prev.op != 2) continue;
            return prev;
        }
        return null;
    }

    public Class getType() {
        boolean key;
        if (this._cast != null) {
            return this._cast;
        }
        Action act = this.lastFieldAction();
        if (act != null && act.op == 7) {
            return ((XMLMetaData)act.data).getType();
        }
        FieldMetaData fld = act == null ? null : (FieldMetaData)act.data;
        boolean bl = key = act != null && act.op == 2;
        if (fld != null) {
            switch (fld.getDeclaredTypeCode()) {
                case 11: {
                    if (fld.getDeclaredType() == byte[].class || fld.getDeclaredType() == Byte[].class || fld.getDeclaredType() == char[].class || fld.getDeclaredType() == Character[].class) {
                        return fld.getDeclaredType();
                    }
                    return fld.getElement().getDeclaredType();
                }
                case 13: {
                    if (key) {
                        return fld.getKey().getDeclaredType();
                    }
                    return fld.getElement().getDeclaredType();
                }
                case 12: {
                    return fld.getElement().getDeclaredType();
                }
            }
            return fld.getDeclaredType();
        }
        if (this._class != null) {
            return this._class.getDescribedType();
        }
        return Object.class;
    }

    public void setImplicitType(Class type) {
        this._cast = type;
    }

    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        Iterator itr;
        PathExpState pstate = new PathExpState(sel.newJoins());
        boolean key = false;
        boolean forceOuter = false;
        ClassMapping rel = this._candidate;
        Iterator iterator = itr = this._actions == null ? null : this._actions.iterator();
        while (itr != null && itr.hasNext()) {
            FieldMapping field;
            Action action = (Action)itr.next();
            if (action.op == 3) {
                pstate.joins = pstate.joins.setVariable((String)action.data);
                continue;
            }
            if (action.op == 4) {
                pstate.joins = pstate.joins.setSubselect((String)action.data);
                continue;
            }
            if (action.op == 5) {
                Variable var = (Variable)action.data;
                rel = (ClassMapping)var.getMetaData();
                pstate.joins = pstate.joins.setVariable(var.getName());
                pstate.joins = pstate.joins.crossJoin(this._candidate.getTable(), rel.getTable());
                continue;
            }
            FieldMapping fieldMapping = field = action.op == 7 ? (FieldMapping)this._xmlfield : (FieldMapping)action.data;
            if (pstate.field != null) {
                if (!itr.hasNext() && (flags & 4) == 0 && PCPath.isJoinedField(pstate.field, key, field)) {
                    pstate.cmpfield = field;
                    break;
                }
                rel = this.traverseField(pstate, key, forceOuter, false);
            }
            key = action.op == 2;
            forceOuter |= action.op == 1;
            pstate.field = field;
            ClassMapping owner = pstate.field.getDefiningMapping();
            if (pstate.field.getManagement() != 3) {
                throw new UserException(_loc.get("non-pers-field", (Object)pstate.field));
            }
            if (rel != owner && rel != null) {
                ClassMapping to;
                ClassMapping from;
                if (rel.getDescribedType().isAssignableFrom(owner.getDescribedType())) {
                    from = owner;
                    to = rel;
                } else {
                    from = rel;
                    to = owner;
                }
                while (from != null && from != to) {
                    pstate.joins = from.joinSuperclass(pstate.joins, false);
                    from = from.getJoinablePCSuperclassMapping();
                }
            }
            if (action.op != 7) continue;
        }
        if (this._varName != null) {
            pstate.joins = pstate.joins.setVariable(this._varName);
        }
        if ((flags & 2) == 0) {
            this.traverseField(pstate, key, forceOuter, true);
        }
        pstate.joinedRel = false;
        if ((flags & 4) != 0) {
            this.joinRelation(pstate, key, forceOuter || (flags & 8) != 0, false);
        }
        return pstate;
    }

    private static boolean isJoinedField(FieldMapping src, boolean key, FieldMapping target) {
        Column[] pks;
        ValueMapping vm;
        switch (src.getTypeCode()) {
            case 11: 
            case 12: {
                vm = src.getElementMapping();
                break;
            }
            case 13: {
                vm = key ? src.getKeyMapping() : src.getElementMapping();
                break;
            }
            default: {
                vm = src;
            }
        }
        if (vm.getJoinDirection() != 0) {
            return false;
        }
        ForeignKey fk = vm.getForeignKey();
        if (fk == null) {
            return false;
        }
        Column[] rels = fk.getColumns();
        if (rels.length != (pks = target.getColumns()).length) {
            return false;
        }
        for (int i = 0; i < rels.length; ++i) {
            if (fk.getPrimaryKeyColumn(rels[i]) == pks[i]) continue;
            return false;
        }
        return true;
    }

    private ClassMapping traverseField(PathExpState pstate, boolean key, boolean forceOuter, boolean last) {
        if (pstate.field == null) {
            return null;
        }
        pstate.joins = key ? pstate.field.joinKey(pstate.joins, forceOuter) : pstate.field.join(pstate.joins, forceOuter);
        if (!last) {
            this.joinRelation(pstate, key, forceOuter, true);
        }
        if (key) {
            return pstate.field.getKeyMapping().getTypeMapping();
        }
        if (pstate.field.getElement().getTypeCode() == 15) {
            return pstate.field.getElementMapping().getTypeMapping();
        }
        return pstate.field.getTypeMapping();
    }

    private void joinRelation(PathExpState pstate, boolean key, boolean forceOuter, boolean traverse) {
        if (pstate.field == null) {
            return;
        }
        pstate.joins = key ? pstate.field.joinKeyRelation(pstate.joins, forceOuter, traverse) : pstate.field.joinRelation(pstate.joins, forceOuter, traverse);
        pstate.joinedRel = true;
    }

    public Object toDataStoreValue(Select sel, ExpContext ctx, ExpState state, Object val) {
        FieldMapping field;
        PathExpState pstate = (PathExpState)state;
        FieldMapping fieldMapping = field = pstate.cmpfield != null ? pstate.cmpfield : pstate.field;
        if (this.isXPath()) {
            return val;
        }
        if (field != null) {
            if (this._key) {
                return field.toKeyDataStoreValue(val, ctx.store);
            }
            if (field.getElement().getDeclaredTypeCode() != 8) {
                return field.toDataStoreValue(val, ctx.store);
            }
            val = field.getExternalValue(val, ctx.store.getContext());
            return field.toDataStoreValue(val, ctx.store);
        }
        return this._class.toDataStoreValue(val, this._class.getPrimaryKeyColumns(), ctx.store);
    }

    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        this.selectColumns(sel, ctx, state, pks);
    }

    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        ClassMapping mapping = this.getClassMapping(state);
        PathExpState pstate = (PathExpState)state;
        if (mapping == null || !pstate.joinedRel) {
            sel.select(this.getColumns(state), pstate.joins);
        } else if (pks) {
            sel.select(mapping.getPrimaryKeyColumns(), pstate.joins);
        } else {
            int subs = this._type == 2 ? 1 : 3;
            sel.select(mapping, subs, ctx.store, ctx.fetch, 0, sel.outer(pstate.joins));
        }
    }

    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
        ClassMapping mapping = this.getClassMapping(state);
        PathExpState pstate = (PathExpState)state;
        if (mapping == null || !pstate.joinedRel) {
            sel.groupBy(this.getColumns(state), sel.outer(pstate.joins));
        } else {
            int subs = this._type == 2 ? 1 : 3;
            sel.groupBy(mapping, subs, ctx.store, ctx.fetch, sel.outer(pstate.joins));
        }
    }

    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
        sel.orderBy(this.getColumns(state), asc, sel.outer(state.joins), false);
    }

    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        return this.load(ctx, state, res, false);
    }

    Object load(ExpContext ctx, ExpState state, Result res, boolean pks) throws SQLException {
        ClassMapping mapping = this.getClassMapping(state);
        PathExpState pstate = (PathExpState)state;
        if (!(mapping == null || pstate.field != null && pstate.field.isEmbedded())) {
            if (pks) {
                return mapping.getObjectId(ctx.store, res, null, true, pstate.joins);
            }
            return res.load(mapping, ctx.store, ctx.fetch, pstate.joins);
        }
        Object ret = this._key ? pstate.field.loadKeyProjection(ctx.store, ctx.fetch, res, pstate.joins) : pstate.field.loadProjection(ctx.store, ctx.fetch, res, pstate.joins);
        if (this._cast != null) {
            ret = Filters.convert((Object)ret, (Class)this._cast);
        }
        return ret;
    }

    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
    }

    public int length(Select sel, ExpContext ctx, ExpState state) {
        return this.getColumns(state).length;
    }

    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql, int index) {
        Column col = this.getColumns(state)[index];
        if (sel == null) {
            sql.append(col.getName());
        } else if (this._type == 4) {
            sql.append(this.getXPath());
        } else {
            sql.append(sel.getColumnAlias(col, state.joins));
        }
    }

    public void appendIsEmpty(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            sql.append("1 <> 1");
        } else {
            pstate.field.appendIsEmpty(sql, sel, pstate.joins);
        }
    }

    public void appendIsNotEmpty(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            sql.append("1 <> 1");
        } else {
            pstate.field.appendIsNotEmpty(sql, sel, pstate.joins);
        }
    }

    public void appendSize(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            sql.append("1");
        } else {
            pstate.field.appendSize(sql, sel, pstate.joins);
        }
    }

    public void appendIsNull(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            sql.append("1 <> 1");
        } else {
            pstate.field.appendIsNull(sql, sel, pstate.joins);
        }
    }

    public void appendIsNotNull(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql) {
        PathExpState pstate = (PathExpState)state;
        if (pstate.field == null) {
            sql.append("1 = 1");
        } else {
            pstate.field.appendIsNotNull(sql, sel, pstate.joins);
        }
    }

    public int hashCode() {
        if (this._actions == null) {
            return this._candidate.hashCode();
        }
        return this._candidate.hashCode() ^ this._actions.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof PCPath)) {
            return false;
        }
        PCPath path = (PCPath)other;
        return ObjectUtils.equals((Object)this._candidate, (Object)path._candidate) && ObjectUtils.equals((Object)this._actions, (Object)path._actions);
    }

    private static class Action
    implements Serializable {
        public static final int GET = 0;
        public static final int GET_OUTER = 1;
        public static final int GET_KEY = 2;
        public static final int VAR = 3;
        public static final int SUBQUERY = 4;
        public static final int UNBOUND_VAR = 5;
        public static final int CAST = 6;
        public static final int GET_XPATH = 7;
        public int op = -1;
        public Object data = null;

        private Action() {
        }

        public String toString() {
            return this.op + "|" + this.data;
        }

        public int hashCode() {
            if (this.data == null) {
                return this.op;
            }
            return this.op ^ this.data.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            Action a = (Action)other;
            return this.op == a.op && ObjectUtils.equals((Object)this.data, (Object)a.data);
        }
    }

    public static class PathExpState
    extends ExpState {
        public FieldMapping field = null;
        public FieldMapping cmpfield = null;
        public Column[] cols = null;
        public boolean joinedRel = false;

        public PathExpState(Joins joins) {
            super(joins);
        }
    }
}

