/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.MappingInfo;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.lib.meta.SourceTracker;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.xml.Commentable;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.util.UserException;

public class ClassMappingInfo
extends MappingInfo
implements SourceTracker,
Commentable {
    private static final Localizer _loc = Localizer.forPackage(ClassMappingInfo.class);
    private String _className = Object.class.getName();
    private DBIdentifier _tableName = DBIdentifier.NULL;
    private DBIdentifier _schemaName = DBIdentifier.NULL;
    private boolean _joined = false;
    private Map<DBIdentifier, List<Column>> _seconds = null;
    private String _subStrat = null;
    private File _file = null;
    private int _srcType = 0;
    private String[] _comments = null;
    private int _lineNum = 0;
    private int _colNum = 0;
    private Map<DBIdentifier, List<Unique>> _uniques;

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String name) {
        this._className = name;
    }

    public String getHierarchyStrategy() {
        return this._subStrat;
    }

    public void setHierarchyStrategy(String strategy) {
        this._subStrat = strategy;
    }

    public String getTableName() {
        return this.getTableIdentifier().getName();
    }

    public DBIdentifier getTableIdentifier() {
        return this._tableName == null ? DBIdentifier.NULL : this._tableName;
    }

    public void setTableName(String table) {
        this.setTableIdentifier(DBIdentifier.newTable(table));
    }

    public void setTableIdentifier(DBIdentifier table) {
        this._tableName = table;
    }

    public String getSchemaName() {
        return this.getSchemaIdentifier().getName();
    }

    public DBIdentifier getSchemaIdentifier() {
        return this._schemaName == null ? DBIdentifier.NULL : this._schemaName;
    }

    public void setSchemaName(String schema) {
        this.setSchemaIdentifier(DBIdentifier.newSchema(schema));
    }

    public void setSchemaIdentifier(DBIdentifier schema) {
        this._schemaName = schema;
    }

    public boolean isJoinedSubclass() {
        return this._joined;
    }

    public void setJoinedSubclass(boolean joined) {
        this._joined = joined;
    }

    public String[] getSecondaryTableNames() {
        if (this._seconds == null) {
            return new String[0];
        }
        return DBIdentifier.toStringArray(this._seconds.keySet().toArray(new DBIdentifier[0]));
    }

    public DBIdentifier[] getSecondaryTableIdentifiers() {
        if (this._seconds == null) {
            return new DBIdentifier[0];
        }
        return this._seconds.keySet().toArray(new DBIdentifier[this._seconds.size()]);
    }

    public String getSecondaryTableName(String tableName) {
        return this.getSecondaryTableIdentifier(DBIdentifier.newTable(tableName)).getName();
    }

    public DBIdentifier getSecondaryTableIdentifier(DBIdentifier tableName) {
        QualifiedDBIdentifier path = QualifiedDBIdentifier.getPath(tableName);
        if (this._seconds == null || DBIdentifier.isNull(tableName) || this._seconds.containsKey(tableName) || !DBIdentifier.isNull(path.getSchemaName())) {
            return tableName;
        }
        DBIdentifier best = tableName;
        int pts = 0;
        DBIdentifier fullJoin2 = DBIdentifier.NULL;
        DBIdentifier join = DBIdentifier.NULL;
        for (DBIdentifier fullJoin2 : this._seconds.keySet()) {
            QualifiedDBIdentifier joinPath = QualifiedDBIdentifier.getPath(fullJoin2);
            if (joinPath.isUnqualifiedObject() && pts < 2 && fullJoin2.equalsIgnoreCase(tableName)) {
                best = fullJoin2;
                pts = 2;
            } else if (joinPath.isUnqualifiedObject()) continue;
            join = joinPath.getIdentifier();
            if (join.equals(tableName)) {
                return fullJoin2;
            }
            if (pts >= 1 || !join.equalsIgnoreCase(tableName)) continue;
            best = fullJoin2;
            pts = 1;
        }
        return best;
    }

    public List<Column> getSecondaryTableJoinColumns(String tableName) {
        return this.getSecondaryTableJoinColumns(DBIdentifier.newTable(tableName));
    }

    public List<Column> getSecondaryTableJoinColumns(DBIdentifier tableName) {
        QualifiedDBIdentifier path;
        if (this._seconds == null || DBIdentifier.isNull(tableName)) {
            return Collections.emptyList();
        }
        List<Column> cols = this._seconds.get(this.getSecondaryTableIdentifier(tableName));
        if (cols == null && !DBIdentifier.isNull((path = QualifiedDBIdentifier.getPath(tableName)).getSchemaName())) {
            tableName = path.getIdentifier();
            cols = this._seconds.get(this.getSecondaryTableIdentifier(tableName));
        }
        if (cols == null) {
            return Collections.emptyList();
        }
        return cols;
    }

    public void addSecondaryTable(String second) {
        this.setSecondaryTableJoinColumns(DBIdentifier.newTable(second), null);
    }

    public void addSecondaryTable(DBIdentifier second) {
        this.setSecondaryTableJoinColumns(second, null);
    }

    public void setSecondaryTableJoinColumns(String tableName, List<Column> cols) {
        if (cols == null) {
            cols = Collections.emptyList();
        }
        this.setSecondaryTableJoinColumns(DBIdentifier.newTable(tableName), cols);
    }

    public void setSecondaryTableJoinColumns(DBIdentifier tableName, List<Column> cols) {
        if (cols == null) {
            cols = Collections.emptyList();
        }
        if (this._seconds == null) {
            this._seconds = new LinkedHashMap<DBIdentifier, List<Column>>();
        }
        this._seconds.put(tableName, cols);
    }

    public Table getTable(ClassMapping cls, String tableName, boolean adapt) {
        return this.getTable(cls, DBIdentifier.newTable(tableName), adapt);
    }

    public Table getTable(final ClassMapping cls, DBIdentifier tableName, boolean adapt) {
        if (this._schemaName != null && this._schemaName.getType() == DBIdentifier.DBIdentifierType.NULL) {
            String name = cls.getMappingRepository().getMetaDataFactory().getDefaults().getDefaultSchema();
            this._schemaName = name != null ? DBIdentifier.newSchema(name) : this._schemaName;
        }
        Table t = this.createTable((MetaDataContext)cls, new MappingInfo.TableDefaults(){

            @Override
            public String get(Schema schema) {
                return cls.getMappingRepository().getMappingDefaults().getTableName(cls, schema);
            }

            @Override
            public DBIdentifier getIdentifier(Schema schema) {
                return cls.getMappingRepository().getMappingDefaults().getTableIdentifier(cls, schema);
            }
        }, this._schemaName, tableName, adapt);
        t.setComment(cls.getTypeAlias() == null ? cls.getDescribedType().getName() : cls.getTypeAlias());
        return t;
    }

    public Table getTable(ClassMapping cls, boolean adapt) {
        return this.getTable(cls, this._tableName, adapt);
    }

    public Column[] getDataStoreIdColumns(ClassMapping cls, Column[] tmplates, Table table, boolean adapt) {
        cls.getMappingRepository().getMappingDefaults().populateDataStoreIdColumns(cls, table, tmplates);
        return this.createColumns((MetaDataContext)cls, "datastoreid", tmplates, table, adapt);
    }

    public ForeignKey getSuperclassJoin(final ClassMapping cls, Table table, boolean adapt) {
        ClassMapping sup = cls.getJoinablePCSuperclassMapping();
        if (sup == null) {
            return null;
        }
        MappingInfo.ForeignKeyDefaults def = new MappingInfo.ForeignKeyDefaults(){

            @Override
            public ForeignKey get(Table local, Table foreign, boolean inverse) {
                return cls.getMappingRepository().getMappingDefaults().getJoinForeignKey(cls, local, foreign);
            }

            @Override
            public void populate(Table local, Table foreign, Column col, Object target, boolean inverse, int pos, int cols) {
                cls.getMappingRepository().getMappingDefaults().populateJoinColumn(cls, local, foreign, col, target, pos, cols);
            }
        };
        return this.createForeignKey((MetaDataContext)cls, "superclass", this.getColumns(), def, table, cls, sup, false, adapt);
    }

    public void syncWith(ClassMapping cls) {
        String strat;
        this.clear(false);
        ClassMapping sup = cls.getMappedPCSuperclassMapping();
        if (cls.getTable() != null && (sup == null || sup.getTable() != cls.getTable())) {
            this._tableName = cls.getMappingRepository().getDBDictionary().getFullIdentifier(cls.getTable(), true);
        }
        this.setColumnIO(cls.getColumnIO());
        if (cls.getJoinForeignKey() != null && sup != null && sup.getTable() != null) {
            this.syncForeignKey((MetaDataContext)cls, cls.getJoinForeignKey(), cls.getTable(), sup.getTable());
        } else if (cls.getIdentityType() == 1) {
            this.syncColumns((MetaDataContext)cls, cls.getPrimaryKeyColumns(), false);
        }
        String string = strat = cls.getStrategy() == null ? null : cls.getStrategy().getAlias();
        if (!(strat == null || cls.getPCSuperclass() == null && "full".equals(strat))) {
            this.setStrategy(strat);
        }
    }

    @Override
    public boolean hasSchemaComponents() {
        return super.hasSchemaComponents() || !DBIdentifier.isNull(this._tableName);
    }

    @Override
    protected void clear(boolean canFlags) {
        super.clear(canFlags);
        this._tableName = DBIdentifier.NULL;
    }

    @Override
    public void copy(MappingInfo info) {
        super.copy(info);
        if (!(info instanceof ClassMappingInfo)) {
            return;
        }
        ClassMappingInfo cinfo = (ClassMappingInfo)info;
        if (DBIdentifier.isNull(this._tableName)) {
            this._tableName = cinfo.getTableIdentifier();
        }
        if (this._subStrat == null) {
            this._subStrat = cinfo.getHierarchyStrategy();
        }
        if (cinfo._seconds != null) {
            if (this._seconds == null) {
                this._seconds = new HashMap<DBIdentifier, List<Column>>();
            }
            for (DBIdentifier key : cinfo._seconds.keySet()) {
                if (this._seconds.containsKey(key)) continue;
                this._seconds.put(key, cinfo._seconds.get(key));
            }
        }
        if (cinfo._uniques != null) {
            if (this._uniques == null) {
                this._uniques = new HashMap<DBIdentifier, List<Unique>>();
            }
            for (Map.Entry<DBIdentifier, List<Unique>> entry : cinfo._uniques.entrySet()) {
                if (this._uniques.containsKey(entry.getKey())) continue;
                this._uniques.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addUnique(String table, Unique unique) {
        this.addUnique(DBIdentifier.newTable(table), unique);
    }

    public void addUnique(DBIdentifier table, Unique unique) {
        if (!(DBIdentifier.equal(this._tableName, table) || this._seconds != null && this._seconds.containsKey(table))) {
            throw new UserException(_loc.get("unique-no-table", new Object[]{table, this._className, this._tableName, this._seconds == null ? "" : this._seconds.keySet()}));
        }
        if (unique == null) {
            return;
        }
        if (this._uniques == null) {
            this._uniques = new HashMap<DBIdentifier, List<Unique>>();
        }
        unique.setTableIdentifier(table);
        List<Unique> uniques = this._uniques.get(table);
        if (uniques == null) {
            uniques = new ArrayList<Unique>();
            uniques.add(unique);
            this._uniques.put(table, uniques);
        } else {
            uniques.add(unique);
        }
    }

    public Unique[] getUniques(String table) {
        return this.getUniques(DBIdentifier.newTable(table));
    }

    public Unique[] getUniques(DBIdentifier table) {
        if (this._uniques == null || this._uniques.isEmpty() || this._uniques.containsKey(table)) {
            return new Unique[0];
        }
        List<Unique> uniques = this._uniques.get(table);
        return uniques.toArray(new Unique[uniques.size()]);
    }

    public Unique[] getUniques(MetaDataContext cm, boolean adapt) {
        if (this._uniques == null || this._uniques.isEmpty()) {
            return new Unique[0];
        }
        ArrayList<Unique> result = new ArrayList<Unique>();
        for (DBIdentifier tableName : this._uniques.keySet()) {
            List<Unique> uniqueConstraints = this._uniques.get(tableName);
            for (Unique template : uniqueConstraints) {
                Column[] templateColumns = template.getColumns();
                Column[] uniqueColumns = new Column[templateColumns.length];
                Table table = this.getTable((ClassMapping)cm, tableName, adapt);
                for (int i = 0; i < uniqueColumns.length; ++i) {
                    Column uniqueColumn;
                    DBIdentifier columnName = templateColumns[i].getIdentifier();
                    if (!table.containsColumn(columnName)) {
                        throw new UserException(_loc.get("unique-missing-column", new Object[]{cm, columnName, tableName, Arrays.toString(table.getColumnNames())}));
                    }
                    uniqueColumns[i] = uniqueColumn = table.getColumn(columnName);
                }
                Unique unique = this.createUnique(cm, "unique", template, uniqueColumns, adapt);
                if (unique == null) continue;
                result.add(unique);
            }
        }
        return result.toArray(new Unique[result.size()]);
    }

    public File getSourceFile() {
        return this._file;
    }

    public Object getSourceScope() {
        return null;
    }

    public int getSourceType() {
        return this._srcType;
    }

    public void setSource(File file, int srcType) {
        this._file = file;
        this._srcType = srcType;
    }

    public String getResourceName() {
        return this._className;
    }

    public String[] getComments() {
        return this._comments == null ? EMPTY_COMMENTS : this._comments;
    }

    public void setComments(String[] comments) {
        this._comments = comments;
    }

    public int getLineNumber() {
        return this._lineNum;
    }

    public void setLineNumber(int lineNum) {
        this._lineNum = lineNum;
    }

    public int getColNumber() {
        return this._colNum;
    }

    public void setColNumber(int colNum) {
        this._colNum = colNum;
    }
}

