/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.openjpa.jdbc.kernel.AbstractUpdateManager;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedStatementManager;
import org.apache.openjpa.jdbc.kernel.PreparedStatementManagerImpl;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.sql.PrimaryRow;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.RowManagerImpl;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.OpenJPAStateManager;

public class OperationOrderUpdateManager
extends AbstractUpdateManager {
    @Override
    public boolean orderDirty() {
        return true;
    }

    @Override
    protected RowManager newRowManager() {
        return new RowManagerImpl(true);
    }

    @Override
    protected PreparedStatementManager newPreparedStatementManager(JDBCStore store, Connection conn) {
        return new PreparedStatementManagerImpl(store, conn);
    }

    @Override
    protected Collection flush(RowManager rowMgr, PreparedStatementManager psMgr, Collection exceps) {
        RowManagerImpl rmimpl = (RowManagerImpl)rowMgr;
        this.flush(rmimpl.getAllRowDeletes(), psMgr);
        this.flush(rmimpl.getSecondaryDeletes(), psMgr);
        this.flush(rmimpl.getAllRowUpdates(), psMgr);
        Collection constraintUpdates = null;
        Iterator<PrimaryRow> itr = rmimpl.getDeletes().iterator();
        while (itr.hasNext()) {
            try {
                constraintUpdates = this.analyzeDeleteConstraints(rmimpl, itr.next(), constraintUpdates);
            }
            catch (SQLException se) {
                exceps = this.addException(exceps, (Exception)((Object)SQLExceptions.getStore(se, this.dict)));
            }
        }
        if (constraintUpdates != null) {
            this.flush(constraintUpdates, psMgr);
            constraintUpdates.clear();
        }
        itr = rmimpl.getOrdered().iterator();
        while (itr.hasNext()) {
            try {
                constraintUpdates = this.flushPrimaryRow(rmimpl, itr.next(), psMgr, constraintUpdates);
            }
            catch (SQLException se) {
                exceps = this.addException(exceps, (Exception)((Object)SQLExceptions.getStore(se, this.dict)));
            }
        }
        if (constraintUpdates != null) {
            this.flush(constraintUpdates, psMgr);
        }
        this.flush(rmimpl.getSecondaryUpdates(), psMgr);
        psMgr.flush();
        return exceps;
    }

    private Collection analyzeDeleteConstraints(RowManagerImpl rowMgr, PrimaryRow row, Collection updates) throws SQLException {
        ForeignKey[] fks;
        if (!row.isValid()) {
            return updates;
        }
        for (ForeignKey fk : fks = row.getTable().getForeignKeys()) {
            PrimaryRow rel;
            OpenJPAStateManager sm = row.getForeignKeySet(fk);
            if (sm == null) {
                sm = row.getForeignKeyWhere(fk);
            }
            if (sm == null || (rel = (PrimaryRow)rowMgr.getRow(fk.getPrimaryKeyTable(), 2, sm, false)) == null || !rel.isValid() || rel.getIndex() >= row.getIndex()) continue;
            PrimaryRow update = new PrimaryRow(row.getTable(), 0, null);
            row.copyInto(update, true);
            ((RowImpl)update).setForeignKey(fk, row.getForeignKeyIO(fk), null);
            if (updates == null) {
                updates = new ArrayList<PrimaryRow>();
            }
            updates.add(update);
        }
        return updates;
    }

    private Collection flushPrimaryRow(RowManagerImpl rowMgr, PrimaryRow row, PreparedStatementManager psMgr, Collection updates) throws SQLException {
        ForeignKey[] fks;
        if (!row.isValid()) {
            return updates;
        }
        if (row.getAction() == 2) {
            psMgr.flush(row);
            return updates;
        }
        for (ForeignKey fk : fks = row.getTable().getForeignKeys()) {
            PrimaryRow rel;
            OpenJPAStateManager sm = row.getForeignKeySet(fk);
            if (sm == null || (rel = (PrimaryRow)rowMgr.getRow(fk.getPrimaryKeyTable(), 1, sm, false)) == null || !rel.isValid() || rel.getIndex() < row.getIndex() || rel == row && !fk.isDeferred() && !fk.isLogical()) continue;
            PrimaryRow update = new PrimaryRow(row.getTable(), 0, null);
            if (row.getAction() == 1) {
                update.wherePrimaryKey(row.getPrimaryKey());
            } else {
                row.copyInto(update, true);
            }
            update.setForeignKey(fk, row.getForeignKeyIO(fk), sm);
            row.clearForeignKey(fk);
            if (updates == null) {
                updates = new ArrayList<PrimaryRow>();
            }
            updates.add(update);
        }
        if (row.isValid()) {
            psMgr.flush(row);
        }
        return updates;
    }

    protected void flush(Collection rows, PreparedStatementManager psMgr) {
        if (rows.isEmpty()) {
            return;
        }
        for (Object o : rows) {
            RowImpl row = (RowImpl)o;
            if (!row.isValid()) continue;
            psMgr.flush(row);
        }
    }
}

