/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.BitSet;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.AttachManager;
import org.apache.openjpa.kernel.AttachStrategy;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.OptimisticException;

class DetachedStateAttachStrategy
extends AttachStrategy {
    private static final Localizer _loc = Localizer.forPackage((Class)DetachedStateAttachStrategy.class);

    DetachedStateAttachStrategy() {
    }

    protected Object getDetachedObjectId(AttachManager manager, Object toAttach) {
        if (toAttach == null) {
            return null;
        }
        BrokerImpl broker = manager.getBroker();
        PersistenceCapable pc = ImplHelper.toPersistenceCapable(toAttach, broker.getConfiguration());
        ClassMetaData meta = broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(ImplHelper.getManagedInstance(toAttach).getClass(), broker.getClassLoader(), true);
        switch (meta.getIdentityType()) {
            case 1: {
                Object[] state = (Object[])pc.pcGetDetachedState();
                if (state == null) {
                    return null;
                }
                return broker.newObjectId(toAttach.getClass(), state[0]);
            }
            case 2: {
                return ApplicationIds.create(pc, meta);
            }
        }
        throw new InternalException();
    }

    protected void provideField(Object toAttach, StateManagerImpl sm, int field) {
        sm.provideField(ImplHelper.toPersistenceCapable(toAttach, sm.getContext().getConfiguration()), this, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object attach(AttachManager manager, Object toAttach, ClassMetaData meta, PersistenceCapable into, OpenJPAStateManager owner, ValueMetaData ownerMeta, boolean explicit) {
        int offset;
        StateManagerImpl sm;
        boolean embedded;
        BrokerImpl broker = manager.getBroker();
        PersistenceCapable pc = ImplHelper.toPersistenceCapable(toAttach, manager.getBroker().getConfiguration());
        Object[] state = (Object[])pc.pcGetDetachedState();
        boolean bl = embedded = ownerMeta != null && ownerMeta.isEmbeddedPC();
        if (embedded && (state == null || into == null || broker.getStateManager(into) == null)) {
            if (into == null) {
                into = pc.pcNewInstance(null, false);
            }
            sm = (StateManagerImpl)broker.embed(into, null, owner, ownerMeta);
            into = sm.getPersistenceCapable();
        } else if (state == null) {
            sm = this.persist(manager, pc, meta, ApplicationIds.create(pc, meta), explicit);
            into = sm.getPersistenceCapable();
        } else if (!embedded && into == null) {
            Object id = this.getDetachedObjectId(manager, pc);
            if (id != null) {
                into = ImplHelper.toPersistenceCapable(broker.find(id, true, null), manager.getBroker().getConfiguration());
            }
            if (into == null) {
                boolean isNew;
                offset = meta.getIdentityType() == 1 ? 1 : 0;
                boolean bl2 = isNew = state.length == 3 + offset;
                if (!isNew) {
                    throw new OptimisticException(_loc.get("attach-deleted", ImplHelper.getManagedInstance(pc).getClass(), id)).setFailedObject(id);
                }
                sm = this.persist(manager, pc, meta, id, explicit);
                into = sm.getPersistenceCapable();
                state = null;
            } else {
                sm = manager.assertManaged(into);
            }
        } else {
            sm = manager.assertManaged(into);
        }
        manager.setAttachedCopy(pc, into);
        meta = sm.getMetaData();
        manager.fireBeforeAttach(pc, meta);
        offset = meta.getIdentityType() == 1 ? 1 : 0;
        pc.pcReplaceStateManager(sm);
        BitSet fields = state == null ? null : (BitSet)state[1 + offset];
        try {
            FieldMetaData[] fmds = meta.getFields();
            for (int i = 0; i < fmds.length; ++i) {
                if (fields != null && !fields.get(i)) continue;
                this.attachField(manager, pc, sm, fmds[i], true);
            }
        }
        finally {
            pc.pcReplaceStateManager(null);
        }
        if (state != null && !embedded) {
            if (fields != null && !fields.equals(sm.getLoaded())) {
                BitSet toLoad = (BitSet)fields.clone();
                toLoad.andNot(sm.getLoaded());
                if (toLoad.length() > 0) {
                    sm.loadFields(toLoad, null, 0, null, false);
                }
            }
            Object version = state[offset];
            DelegatingStoreManager store = broker.getStoreManager();
            switch (store.compareVersion(sm, version, sm.getVersion())) {
                case 1: {
                    sm.setVersion(version);
                    break;
                }
                case 2: 
                case 4: {
                    sm.setVersion(version);
                    throw new OptimisticException(into);
                }
            }
        }
        return ImplHelper.getManagedInstance(into);
    }
}

