/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.lang.instrument.Instrumentation;
import java.security.AccessController;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.enhance.InstrumentationFactory;
import org.apache.openjpa.enhance.PCClassFileTransformer;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.util.ClassResolver;

public class PCEnhancerAgent {
    public static void premain(String args, Instrumentation inst) {
        Options opts = Configurations.parseProperties((String)args);
        if (opts.containsKey((Object)"ClassLoadEnhancement") || opts.containsKey((Object)"classLoadEnhancement")) {
            if (opts.getBooleanProperty("ClassLoadEnhancement", "classLoadEnhancement", true)) {
                PCEnhancerAgent.registerClassLoadEnhancer(inst, opts);
            }
        } else if (opts.containsKey((Object)"RuntimeEnhancement") || opts.containsKey((Object)"runtimeEnhancement")) {
            if (opts.getBooleanProperty("RuntimeEnhancement", "runtimeEnhancement", true)) {
                PCEnhancerAgent.registerClassLoadEnhancer(inst, opts);
            }
        } else {
            PCEnhancerAgent.registerClassLoadEnhancer(inst, opts);
        }
        if (opts.getBooleanProperty("RuntimeRedefinition", "runtimeRedefinition", true)) {
            InstrumentationFactory.setInstrumentation(inst);
        } else {
            InstrumentationFactory.setDynamicallyInstallAgent(false);
        }
    }

    private static void registerClassLoadEnhancer(Instrumentation inst, Options opts) {
        OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl();
        Configurations.populateConfiguration((Configuration)conf, (Options)opts);
        conf.setConnectionUserName(null);
        conf.setConnectionPassword(null);
        conf.setConnectionURL(null);
        conf.setConnectionDriverName(null);
        conf.setConnectionFactoryName(null);
        final ClassLoader tmpLoader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.newTemporaryClassLoaderAction((ClassLoader)((ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()))));
        conf.setClassResolver(new ClassResolver(){

            public ClassLoader getClassLoader(Class context, ClassLoader env) {
                return tmpLoader;
            }
        });
        conf.setReadOnly(1);
        conf.instantiateAll();
        PCClassFileTransformer transformer = new PCClassFileTransformer(conf.newMetaDataRepositoryInstance(), opts, tmpLoader);
        inst.addTransformer(transformer);
    }
}

