/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.UserException;

public class Reflection {
    private static final Localizer _loc = Localizer.forPackage(Reflection.class);

    public static Method findGetter(Class cls, String prop, boolean mustExist) {
        prop = StringUtils.capitalize((String)prop);
        String name = "get" + prop;
        try {
            for (Class c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
                Method m = Reflection.getDeclaredMethod(c, name, null);
                if (m != null) {
                    return m;
                }
                m = Reflection.getDeclaredMethod(c, "is" + prop, null);
                if (m == null || m.getReturnType() != Boolean.TYPE && m.getReturnType() != Boolean.class) continue;
                return m;
            }
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        if (mustExist) {
            throw new UserException(_loc.get("bad-getter", (Object)cls, (Object)prop));
        }
        return null;
    }

    public static Method findSetter(Class cls, String prop, boolean mustExist) {
        Method getter = Reflection.findGetter(cls, prop, mustExist);
        return getter == null ? null : Reflection.findSetter(cls, prop, getter.getReturnType(), mustExist);
    }

    public static Method findSetter(Class cls, String prop, Class param, boolean mustExist) {
        String name = "set" + StringUtils.capitalize((String)prop);
        try {
            for (Class c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
                Method m = Reflection.getDeclaredMethod(c, name, param);
                if (m == null) continue;
                return m;
            }
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        if (mustExist) {
            throw new UserException(_loc.get("bad-setter", (Object)cls, (Object)prop));
        }
        return null;
    }

    static Method getDeclaredMethod(Class cls, String name, Class param) {
        Method[] methods = (Method[])AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodsAction((Class)cls));
        Method candidate = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!name.equals(methods[i].getName())) continue;
            Class<?>[] methodParams = methods[i].getParameterTypes();
            if (param == null && methodParams.length == 0) {
                candidate = Reflection.mostDerived(methods[i], candidate);
                continue;
            }
            if (param == null || methodParams.length != 1 || !param.equals(methodParams[0])) continue;
            candidate = Reflection.mostDerived(methods[i], candidate);
        }
        return candidate;
    }

    static Method mostDerived(Method meth1, Method meth2) {
        if (meth1 == null) {
            return meth2;
        }
        if (meth2 == null) {
            return meth1;
        }
        Class<?> cls2 = meth2.getDeclaringClass();
        Class<?> cls1 = meth1.getDeclaringClass();
        if (cls1.equals(cls2)) {
            Class<?> ret2;
            Class<?> ret1 = meth1.getReturnType();
            if (ret1.isAssignableFrom(ret2 = meth2.getReturnType())) {
                return meth2;
            }
            if (ret2.isAssignableFrom(ret1)) {
                return meth1;
            }
            throw new IllegalArgumentException(_loc.get("most-derived-unrelated-same-type", (Object)meth1, (Object)meth2).getMessage());
        }
        if (cls1.isAssignableFrom(cls2)) {
            return meth2;
        }
        if (cls2.isAssignableFrom(cls1)) {
            return meth1;
        }
        throw new IllegalArgumentException(_loc.get("most-derived-unrelated", (Object)meth1, (Object)meth2).getMessage());
    }

    public static Field findField(Class cls, String name, boolean mustExist) {
        try {
            for (Class c = cls; c != null && c != Object.class; c = c.getSuperclass()) {
                Field f = Reflection.getDeclaredField(c, name);
                if (f == null) continue;
                return f;
            }
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        if (mustExist) {
            throw new UserException(_loc.get("bad-field", (Object)cls, (Object)name));
        }
        return null;
    }

    private static Field getDeclaredField(Class cls, String name) {
        Field[] fields = (Field[])AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldsAction((Class)cls));
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName())) continue;
            return fields[i];
        }
        return null;
    }

    public static Object get(Object target, Field field) {
        if (target == null || field == null) {
            return null;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.get(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    private static void makeAccessible(AccessibleObject ao, int mods) {
        try {
            if (!Modifier.isPublic(mods) && !ao.isAccessible()) {
                AccessController.doPrivileged(J2DoPrivHelper.setAccessibleAction((AccessibleObject)ao, (boolean)true));
            }
        }
        catch (SecurityException se) {
            throw new UserException(_loc.get("reflect-security", (Object)ao)).setFatal(true);
        }
    }

    private static RuntimeException wrapReflectionException(Throwable t) {
        if (t instanceof InvocationTargetException) {
            t = ((InvocationTargetException)t).getTargetException();
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new GeneralException(t);
    }

    public static boolean getBoolean(Object target, Field field) {
        if (target == null || field == null) {
            return false;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getBoolean(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static byte getByte(Object target, Field field) {
        if (target == null || field == null) {
            return 0;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getByte(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static char getChar(Object target, Field field) {
        if (target == null || field == null) {
            return '\u0000';
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getChar(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static double getDouble(Object target, Field field) {
        if (target == null || field == null) {
            return 0.0;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getDouble(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static float getFloat(Object target, Field field) {
        if (target == null || field == null) {
            return 0.0f;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getFloat(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static int getInt(Object target, Field field) {
        if (target == null || field == null) {
            return 0;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getInt(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static long getLong(Object target, Field field) {
        if (target == null || field == null) {
            return 0L;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getLong(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static short getShort(Object target, Field field) {
        if (target == null || field == null) {
            return 0;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            return field.getShort(target);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static Object get(Object target, Method getter) {
        if (target == null || getter == null) {
            return null;
        }
        Reflection.makeAccessible(getter, getter.getModifiers());
        try {
            return getter.invoke(target, (Object[])null);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static boolean getBoolean(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? false : (Boolean)o;
    }

    public static byte getByte(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? (byte)0 : ((Number)o).byteValue();
    }

    public static char getChar(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? (char)'\u0000' : ((Character)o).charValue();
    }

    public static double getDouble(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    public static float getFloat(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? 0.0f : ((Number)o).floatValue();
    }

    public static int getInt(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? 0 : ((Number)o).intValue();
    }

    public static long getLong(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? 0L : ((Number)o).longValue();
    }

    public static short getShort(Object target, Method getter) {
        Object o = Reflection.get(target, getter);
        return o == null ? (short)0 : ((Number)o).shortValue();
    }

    public static void set(Object target, Field field, Object value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.set(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static void set(Object target, Field field, boolean value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setBoolean(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static void set(Object target, Field field, byte value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setByte(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static void set(Object target, Field field, char value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setChar(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static void set(Object target, Field field, double value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setDouble(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static void set(Object target, Field field, float value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setFloat(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static void set(Object target, Field field, int value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setInt(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static void set(Object target, Field field, long value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setLong(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static void set(Object target, Field field, short value) {
        if (target == null || field == null) {
            return;
        }
        Reflection.makeAccessible(field, field.getModifiers());
        try {
            field.setShort(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static void set(Object target, Object value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, boolean value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, byte value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, char value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, double value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, float value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, int value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, long value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, short value, Field field) {
        Reflection.set(target, field, value);
    }

    public static void set(Object target, Method setter, Object value) {
        if (target == null || setter == null) {
            return;
        }
        Reflection.makeAccessible(setter, setter.getModifiers());
        try {
            setter.invoke(target, value);
        }
        catch (Throwable t) {
            throw Reflection.wrapReflectionException(t);
        }
    }

    public static void set(Object target, Method setter, boolean value) {
        Reflection.set(target, setter, (Object)(value ? Boolean.TRUE : Boolean.FALSE));
    }

    public static void set(Object target, Method setter, byte value) {
        Reflection.set(target, setter, (Object)new Byte(value));
    }

    public static void set(Object target, Method setter, char value) {
        Reflection.set(target, setter, (Object)new Character(value));
    }

    public static void set(Object target, Method setter, double value) {
        Reflection.set(target, setter, (Object)new Double(value));
    }

    public static void set(Object target, Method setter, float value) {
        Reflection.set(target, setter, (Object)new Float(value));
    }

    public static void set(Object target, Method setter, int value) {
        Reflection.set(target, setter, (Object)new Integer(value));
    }

    public static void set(Object target, Method setter, long value) {
        Reflection.set(target, setter, (Object)new Long(value));
    }

    public static void set(Object target, Method setter, short value) {
        Reflection.set(target, setter, (Object)new Short(value));
    }
}

