/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.OrderingMergedResultObjectProvider;
import org.apache.openjpa.kernel.Query;
import org.apache.openjpa.kernel.ResultPacker;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.Constant;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.kernel.exps.Literal;
import org.apache.openjpa.kernel.exps.Val;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.rop.EagerResultList;
import org.apache.openjpa.lib.rop.MergedResultObjectProvider;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.ReferenceHashSet;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.NoResultException;
import org.apache.openjpa.util.NonUniqueResultException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;
import serp.util.Numbers;
import serp.util.Strings;

public class QueryImpl
implements Query {
    private static final Localizer _loc = Localizer.forPackage(QueryImpl.class);
    private final String _language;
    private final StoreQuery _storeQuery;
    private final transient BrokerImpl _broker;
    private final transient Log _log;
    private transient ClassLoader _loader = null;
    private final ReentrantLock _lock;
    private Class _class = null;
    private boolean _subclasses = true;
    private boolean _readOnly = false;
    private String _query = null;
    private String _params = null;
    private transient Compilation _compiled = null;
    private transient boolean _compiling = false;
    private transient ResultPacker _packer = null;
    private transient Collection _collection = null;
    private transient Extent _extent = null;
    private Map _filtListeners = null;
    private Map _aggListeners = null;
    private FetchConfiguration _fc = null;
    private boolean _ignoreChanges = false;
    private Class _resultMappingScope = null;
    private String _resultMappingName = null;
    private Boolean _unique = null;
    private Class _resultClass = null;
    private transient long _startIdx = 0L;
    private transient long _endIdx = Long.MAX_VALUE;
    private transient boolean _rangeSet = false;
    private final transient Collection _resultLists = new ReferenceHashSet(2);

    public QueryImpl(Broker broker, String language, StoreQuery storeQuery) {
        this._broker = (BrokerImpl)broker;
        this._language = language;
        this._storeQuery = storeQuery;
        this._fc = (FetchConfiguration)broker.getFetchConfiguration().clone();
        this._log = broker.getConfiguration().getLog("openjpa.Query");
        this._storeQuery.setContext(this);
        this._lock = this._broker != null && this._broker.getMultithreaded() ? new ReentrantLock() : null;
    }

    public StoreQuery getStoreQuery() {
        return this._storeQuery;
    }

    public Broker getBroker() {
        return this._broker;
    }

    public Query getQuery() {
        return this;
    }

    public StoreContext getStoreContext() {
        return this._broker;
    }

    public String getLanguage() {
        return this._language;
    }

    public FetchConfiguration getFetchConfiguration() {
        return this._fc;
    }

    public String getQueryString() {
        return this._query;
    }

    public boolean getIgnoreChanges() {
        this.assertOpen();
        return this._ignoreChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIgnoreChanges(boolean flag) {
        this.lock();
        try {
            this.assertOpen();
            this._ignoreChanges = flag;
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public boolean isReadOnly() {
        this.assertOpen();
        return this._readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnly(boolean flag) {
        this.lock();
        try {
            this.assertOpen();
            this._readOnly = flag;
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilterListener(FilterListener listener) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            if (this._filtListeners == null) {
                this._filtListeners = new HashMap(5);
            }
            this._filtListeners.put(listener.getTag(), listener);
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilterListener(FilterListener listener) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            if (this._filtListeners != null) {
                this._filtListeners.remove(listener.getTag());
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Collection getFilterListeners() {
        return this._filtListeners == null ? Collections.EMPTY_LIST : this._filtListeners.values();
    }

    public FilterListener getFilterListener(String tag) {
        FilterListener listen;
        if (this._filtListeners != null && (listen = (FilterListener)this._filtListeners.get(tag)) != null) {
            return listen;
        }
        FilterListener[] confListeners = this._broker.getConfiguration().getFilterListenerInstances();
        for (int i = 0; i < confListeners.length; ++i) {
            if (!confListeners[i].getTag().equals(tag)) continue;
            return confListeners[i];
        }
        return this._storeQuery.getFilterListener(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAggregateListener(AggregateListener listener) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            if (this._aggListeners == null) {
                this._aggListeners = new HashMap(5);
            }
            this._aggListeners.put(listener.getTag(), listener);
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAggregateListener(AggregateListener listener) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            if (this._aggListeners != null) {
                this._aggListeners.remove(listener.getTag());
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Collection getAggregateListeners() {
        return this._aggListeners == null ? Collections.EMPTY_LIST : this._aggListeners.values();
    }

    public AggregateListener getAggregateListener(String tag) {
        AggregateListener listen;
        if (this._aggListeners != null && (listen = (AggregateListener)this._aggListeners.get(tag)) != null) {
            return listen;
        }
        AggregateListener[] confListeners = this._broker.getConfiguration().getAggregateListenerInstances();
        for (int i = 0; i < confListeners.length; ++i) {
            if (!confListeners[i].getTag().equals(tag)) continue;
            return confListeners[i];
        }
        return this._storeQuery.getAggregateListener(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extent getCandidateExtent() {
        this.lock();
        try {
            Class cls = this.getCandidateType();
            if (this._extent == null && this._collection == null && this._broker != null && cls != null) {
                this._extent = this._broker.newExtent(cls, this._subclasses);
                this._extent.setIgnoreChanges(this._ignoreChanges);
            } else if (this._extent != null && this._extent.getIgnoreChanges() != this._ignoreChanges && cls != null) {
                this._extent = this._broker.newExtent(cls, this._extent.hasSubclasses());
                this._extent.setIgnoreChanges(this._ignoreChanges);
            }
            Extent extent = this._extent;
            Object var4_3 = null;
            this.unlock();
            return extent;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCandidateExtent(Extent candidateExtent) {
        block8: {
            block7: {
                this.lock();
                try {
                    this.assertOpen();
                    this.assertNotReadOnly();
                    if (candidateExtent == this._extent) {
                        Object var4_2 = null;
                        this.unlock();
                        return;
                    }
                    if (candidateExtent == null) {
                        this._extent = null;
                        break block7;
                    }
                    this._extent = candidateExtent;
                    this._collection = null;
                    boolean invalidate = false;
                    if (this._extent.getElementType() != this._class) {
                        this._class = this._extent.getElementType();
                        this._loader = null;
                        invalidate = true;
                    }
                    if (this._extent.hasSubclasses() != this._subclasses) {
                        this._subclasses = this._extent.hasSubclasses();
                        invalidate = true;
                    }
                    if (invalidate) {
                        this.invalidateCompilation();
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.unlock();
                    throw throwable;
                }
            }
            Object var4_3 = null;
            this.unlock();
            return;
        }
        Object var4_4 = null;
        this.unlock();
    }

    public Collection getCandidateCollection() {
        this.assertOpen();
        return this._collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCandidateCollection(Collection candidateCollection) {
        if (!this._storeQuery.supportsInMemoryExecution()) {
            throw new UnsupportedException(_loc.get("query-nosupport", (Object)this._language));
        }
        this.lock();
        try {
            this.assertOpen();
            this._collection = candidateCollection;
            if (this._collection != null) {
                this._extent = null;
            }
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getCandidateType() {
        block3: {
            this.lock();
            try {
                this.assertOpen();
                if (this._class == null && this._compiled == null && this._query != null && this._broker != null) break block3;
                Class clazz = this._class;
                Object var3_3 = null;
                this.unlock();
                return clazz;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.unlock();
                throw throwable;
            }
        }
        this.compileForCompilation();
        Class clazz = this._class;
        Object var3_4 = null;
        this.unlock();
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCandidateType(Class candidateClass, boolean subs) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            this._class = candidateClass;
            this._subclasses = subs;
            this._loader = null;
            this.invalidateCompilation();
            Object var4_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    public boolean hasSubclasses() {
        return this._subclasses;
    }

    public String getResultMappingName() {
        this.assertOpen();
        return this._resultMappingName;
    }

    public Class getResultMappingScope() {
        this.assertOpen();
        return this._resultMappingScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultMapping(Class scope, String name) {
        this.lock();
        try {
            this.assertOpen();
            this._resultMappingScope = scope;
            this._resultMappingName = name;
            this._packer = null;
            Object var4_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnique() {
        StoreQuery.Executor ex;
        block9: {
            block8: {
                block7: {
                    block6: {
                        this.lock();
                        try {
                            this.assertOpen();
                            if (this._unique == null) break block6;
                            boolean bl = this._unique;
                            Object var4_5 = null;
                            this.unlock();
                            return bl;
                        }
                        catch (Throwable throwable) {
                            Object var4_10 = null;
                            this.unlock();
                            throw throwable;
                        }
                    }
                    if (this._query != null && !this._compiling && this._broker != null) break block7;
                    boolean bl = false;
                    Object var4_6 = null;
                    this.unlock();
                    return bl;
                }
                if (this._compiled != null) break block8;
                this.compileForCompilation();
                if (this._unique == null) break block8;
                boolean bl = this._unique;
                Object var4_7 = null;
                this.unlock();
                return bl;
            }
            ex = this.compileForExecutor();
            if (ex.isAggregate(this._storeQuery)) break block9;
            boolean bl = false;
            Object var4_8 = null;
            this.unlock();
            return bl;
        }
        boolean bl = !ex.hasGrouping(this._storeQuery);
        Object var4_9 = null;
        this.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnique(boolean unique) {
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            this._unique = unique ? Boolean.TRUE : Boolean.FALSE;
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getResultType() {
        block3: {
            this.lock();
            try {
                this.assertOpen();
                if (this._resultClass == null && this._compiled == null && this._query != null && this._broker != null) break block3;
                Class clazz = this._resultClass;
                Object var3_3 = null;
                this.unlock();
                return clazz;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.unlock();
                throw throwable;
            }
        }
        this.compileForCompilation();
        Class clazz = this._resultClass;
        Object var3_4 = null;
        this.unlock();
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResultType(Class cls) {
        this.lock();
        try {
            this.assertOpen();
            this._resultClass = cls;
            this._packer = null;
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public long getStartRange() {
        this.assertOpen();
        return this._startIdx;
    }

    public long getEndRange() {
        this.assertOpen();
        return this._endIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRange(long start, long end) {
        if (start < 0L || end < 0L) {
            throw new UserException(_loc.get("invalid-range", (Object)String.valueOf(start), (Object)String.valueOf(end)));
        }
        if (end - start > Integer.MAX_VALUE && end != Long.MAX_VALUE) {
            throw new UserException(_loc.get("range-too-big", (Object)String.valueOf(start), (Object)String.valueOf(end)));
        }
        this.lock();
        try {
            this.assertOpen();
            this._startIdx = start;
            this._endIdx = end;
            this._rangeSet = true;
            Object var6_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameterDeclaration() {
        block3: {
            this.lock();
            try {
                this.assertOpen();
                if (this._params == null && this._compiled == null && !this._compiling && this._broker != null) break block3;
                String string = this._params;
                Object var3_3 = null;
                this.unlock();
                return string;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.unlock();
                throw throwable;
            }
        }
        this.compileForCompilation();
        String string = this._params;
        Object var3_4 = null;
        this.unlock();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareParameters(String params) {
        if (!this._storeQuery.supportsParameterDeclarations()) {
            throw new UnsupportedException(_loc.get("query-nosupport", (Object)this._language));
        }
        this.lock();
        try {
            this.assertOpen();
            this.assertNotReadOnly();
            this._params = StringUtils.trimToNull((String)params);
            this.invalidateCompilation();
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() {
        this.lock();
        try {
            this.assertOpen();
            StoreQuery.Executor ex = this.compileForExecutor();
            this.getResultPacker(this._storeQuery, ex);
            ex.validate(this._storeQuery);
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCompilation() {
        this.lock();
        try {
            Object object = this.compileForCompilation().storeData;
            Object var3_2 = null;
            this.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Compilation compileForCompilation() {
        if (this._compiled != null) return this._compiled;
        if (this._compiling) {
            return this._compiled;
        }
        this.assertNotSerialized();
        this.assertOpen();
        boolean readOnly = this._readOnly;
        this._readOnly = false;
        this._compiling = true;
        try {
            try {
                Compilation compilation = this._compiled = this.compilationFromCache();
                Object var4_5 = null;
                this._compiling = false;
                this._readOnly = readOnly;
                return compilation;
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this._compiling = false;
            this._readOnly = readOnly;
            throw throwable;
        }
    }

    protected Compilation compilationFromCache() {
        Map compCache = this._broker.getConfiguration().getQueryCompilationCacheInstance();
        if (compCache == null) {
            return this.newCompilation();
        }
        CompilationKey key = new CompilationKey();
        key.queryType = this._storeQuery.getClass();
        key.candidateType = this.getCandidateType();
        key.subclasses = this.hasSubclasses();
        key.query = this.getQueryString();
        key.language = this.getLanguage();
        key.storeKey = this._storeQuery.newCompilationKey();
        Compilation comp = (Compilation)compCache.get(key);
        boolean cache = false;
        if (comp == null) {
            comp = this.newCompilation();
            cache = comp.storeData != null;
        } else {
            this._storeQuery.populateFromCompilation(comp.storeData);
        }
        if (cache) {
            compCache.put(key, comp);
        }
        return comp;
    }

    private Compilation newCompilation() {
        Compilation comp = new Compilation();
        comp.storeData = this._storeQuery.newCompilation();
        this._storeQuery.populateFromCompilation(comp.storeData);
        return comp;
    }

    private StoreQuery.Executor compileForExecutor() {
        Compilation comp = this.compileForCompilation();
        if (this._collection == null) {
            if (comp.datastore != null) {
                return comp.datastore;
            }
            if (comp.memory != null) {
                return comp.memory;
            }
            if (this._storeQuery.supportsDataStoreExecution()) {
                return this.compileForDataStore(comp);
            }
            return this.compileForInMemory(comp);
        }
        if (comp.memory != null) {
            return comp.memory;
        }
        if (comp.datastore != null) {
            return comp.datastore;
        }
        if (this._storeQuery.supportsInMemoryExecution()) {
            return this.compileForInMemory(comp);
        }
        return this.compileForDataStore(comp);
    }

    private StoreQuery.Executor compileForDataStore(Compilation comp) {
        if (comp.datastore == null) {
            comp.datastore = this.createExecutor(false);
        }
        return comp.datastore;
    }

    private StoreQuery.Executor compileForInMemory(Compilation comp) {
        if (comp.memory == null) {
            comp.memory = this.createExecutor(true);
        }
        return comp.memory;
    }

    private StoreQuery.Executor createExecutor(boolean inMem) {
        this.assertCandidateType();
        MetaDataRepository repos = this._broker.getConfiguration().getMetaDataRepositoryInstance();
        ClassMetaData meta = repos.getMetaData(this._class, this._broker.getClassLoader(), false);
        ClassMetaData[] metas = this._class == null || this._storeQuery.supportsAbstractExecutors() ? new ClassMetaData[]{meta} : (this._subclasses && (meta == null || meta.isManagedInterface()) ? repos.getImplementorMetaDatas(this._class, this._broker.getClassLoader(), true) : (meta != null && (this._subclasses || meta.isMapped()) ? new ClassMetaData[]{meta} : StoreQuery.EMPTY_METAS));
        if (metas.length == 0) {
            throw new UserException(_loc.get("no-impls", (Object)this._class));
        }
        try {
            if (metas.length == 1) {
                if (inMem) {
                    return this._storeQuery.newInMemoryExecutor(metas[0], this._subclasses);
                }
                return this._storeQuery.newDataStoreExecutor(metas[0], this._subclasses);
            }
            StoreQuery.Executor[] es = new StoreQuery.Executor[metas.length];
            for (int i = 0; i < es.length; ++i) {
                es[i] = inMem ? this._storeQuery.newInMemoryExecutor(metas[i], true) : this._storeQuery.newDataStoreExecutor(metas[i], true);
            }
            return new MergedExecutor(es);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
    }

    private boolean invalidateCompilation() {
        if (this._compiling) {
            return false;
        }
        this._storeQuery.invalidateCompilation();
        this._compiled = null;
        this._packer = null;
        return true;
    }

    public Object execute() {
        return this.execute((Object[])null);
    }

    public Object execute(Object[] params) {
        return this.execute(1, params);
    }

    public Object execute(Map params) {
        return this.execute(1, params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object execute(int operation, Object[] params) {
        if (params == null) {
            params = StoreQuery.EMPTY_OBJECTS;
        }
        this.lock();
        try {
            block14: {
                StoreQuery.Executor ex;
                block13: {
                    block12: {
                        this.assertNotSerialized();
                        this._broker.beginOperation(true);
                        this.assertOpen();
                        this._broker.assertNontransactionalRead();
                        Compilation comp = this.compileForCompilation();
                        ex = this.isInMemory(operation) ? this.compileForInMemory(comp) : this.compileForDataStore(comp);
                        this.assertParameters(this._storeQuery, ex, params);
                        if (this._log.isTraceEnabled()) {
                            this.logExecution(operation, ex.getParameterTypes(this._storeQuery), params);
                        }
                        if (operation != 1) break block12;
                        Object object = this.execute(this._storeQuery, ex, params);
                        Object var7_10 = null;
                        this._broker.endOperation();
                        Object var9_14 = null;
                        this.unlock();
                        return object;
                    }
                    if (operation != 2) break block13;
                    Number number = this.delete(this._storeQuery, ex, params);
                    Object var7_11 = null;
                    this._broker.endOperation();
                    Object var9_15 = null;
                    this.unlock();
                    return number;
                }
                if (operation != 3) break block14;
                Number number = this.update(this._storeQuery, ex, params);
                Object var7_12 = null;
                this._broker.endOperation();
                Object var9_16 = null;
                this.unlock();
                return number;
            }
            try {
                try {
                    throw new UnsupportedException();
                }
                catch (OpenJPAException ke) {
                    throw ke;
                }
                catch (Exception e) {
                    throw new UserException(e);
                }
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                this._broker.endOperation();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var9_17 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object execute(int operation, Map params) {
        if (params == null) {
            params = Collections.EMPTY_MAP;
        }
        this.lock();
        try {
            block14: {
                Object[] arr;
                StoreQuery.Executor ex;
                block13: {
                    block12: {
                        this._broker.beginOperation(true);
                        this.assertNotSerialized();
                        this.assertOpen();
                        this._broker.assertNontransactionalRead();
                        Compilation comp = this.compileForCompilation();
                        ex = this.isInMemory(operation) ? this.compileForInMemory(comp) : this.compileForDataStore(comp);
                        arr = params.isEmpty() ? StoreQuery.EMPTY_OBJECTS : this.toParameterArray(ex.getParameterTypes(this._storeQuery), params);
                        this.assertParameters(this._storeQuery, ex, arr);
                        if (this._log.isTraceEnabled()) {
                            this.logExecution(operation, params);
                        }
                        if (operation != 1) break block12;
                        Object object = this.execute(this._storeQuery, ex, arr);
                        Object var8_11 = null;
                        this._broker.endOperation();
                        Object var10_15 = null;
                        this.unlock();
                        return object;
                    }
                    if (operation != 2) break block13;
                    Number number = this.delete(this._storeQuery, ex, arr);
                    Object var8_12 = null;
                    this._broker.endOperation();
                    Object var10_16 = null;
                    this.unlock();
                    return number;
                }
                if (operation != 3) break block14;
                Number number = this.update(this._storeQuery, ex, arr);
                Object var8_13 = null;
                this._broker.endOperation();
                Object var10_17 = null;
                this.unlock();
                return number;
            }
            try {
                try {
                    throw new UnsupportedException();
                }
                catch (OpenJPAException ke) {
                    throw ke;
                }
                catch (Exception e) {
                    throw new UserException(e);
                }
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                this._broker.endOperation();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var10_18 = null;
            this.unlock();
            throw throwable;
        }
    }

    public long deleteAll() {
        return this.deleteAll((Object[])null);
    }

    public long deleteAll(Object[] params) {
        return ((Number)this.execute(2, params)).longValue();
    }

    public long deleteAll(Map params) {
        return ((Number)this.execute(2, params)).longValue();
    }

    public long updateAll() {
        return this.updateAll((Object[])null);
    }

    public long updateAll(Object[] params) {
        return ((Number)this.execute(3, params)).longValue();
    }

    public long updateAll(Map params) {
        return ((Number)this.execute(3, params)).longValue();
    }

    private Object[] toParameterArray(LinkedMap paramTypes, Map params) {
        if (params == null || params.isEmpty()) {
            return StoreQuery.EMPTY_OBJECTS;
        }
        Object[] arr = new Object[params.size()];
        int base = -1;
        for (Map.Entry entry : params.entrySet()) {
            int idx;
            Object key = entry.getKey();
            int n = idx = paramTypes == null ? -1 : paramTypes.indexOf(key);
            if (idx != -1) {
                arr[idx] = entry.getValue();
                continue;
            }
            if (key instanceof Number) {
                if (base == -1) {
                    base = QueryImpl.positionalParameterBase(params.keySet());
                }
                arr[((Number)key).intValue() - base] = entry.getValue();
                continue;
            }
            throw new UserException(_loc.get("bad-param-name", key));
        }
        return arr;
    }

    private static int positionalParameterBase(Collection params) {
        int low = Integer.MAX_VALUE;
        for (Object obj : params) {
            if (!(obj instanceof Number)) {
                return 0;
            }
            int val = ((Number)obj).intValue();
            if (val == 0) {
                return val;
            }
            if (val >= low) continue;
            low = val;
        }
        return low;
    }

    private boolean isInMemory(int operation) {
        boolean inMem;
        boolean bl = inMem = !this._storeQuery.supportsDataStoreExecution() || this._collection != null;
        if (!inMem && (!this._ignoreChanges || operation != 1) && this._broker.isActive() && this.isAccessPathDirty()) {
            int flush = this._fc.getFlushBeforeQueries();
            if ((flush == 0 || flush == 2 && this._broker.hasConnection() || operation != 1 || !this._storeQuery.supportsInMemoryExecution()) && this._broker.getConfiguration().supportedOptions().contains("openjpa.option.IncrementalFlush")) {
                this._broker.flush();
            } else {
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)_loc.get("force-in-mem", (Object)this._class));
                }
                inMem = true;
            }
        }
        if (inMem && !this._storeQuery.supportsInMemoryExecution()) {
            throw new InvalidStateException(_loc.get("cant-exec-inmem", (Object)this._language));
        }
        return inMem;
    }

    private Object execute(StoreQuery q, StoreQuery.Executor ex, Object[] params) throws Exception {
        StoreQuery.Range range = new StoreQuery.Range(this._startIdx, this._endIdx);
        if (!this._rangeSet) {
            ex.getRange(q, params, range);
        }
        if (range.start >= range.end) {
            return this.emptyResult(q, ex);
        }
        range.lrs = this.isLRS(range.start, range.end);
        ResultObjectProvider rop = ex.executeQuery(q, params, range);
        try {
            return this.toResult(q, ex, rop, range);
        }
        catch (Exception e) {
            if (rop != null) {
                try {
                    rop.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    private Number delete(StoreQuery q, StoreQuery.Executor ex, Object[] params) throws Exception {
        this.assertBulkModify(q, ex, params);
        return ex.executeDelete(q, params);
    }

    public Number deleteInMemory(StoreQuery q, StoreQuery.Executor executor, Object[] params) {
        try {
            Set<Object> o = this.execute(q, executor, params);
            if (!(o instanceof Collection)) {
                o = Collections.singleton(o);
            }
            int size = 0;
            Iterator i = ((Collection)o).iterator();
            while (i.hasNext()) {
                this._broker.delete(i.next(), null);
                ++size;
            }
            return Numbers.valueOf((int)size);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new UserException(e);
        }
    }

    private Number update(StoreQuery q, StoreQuery.Executor ex, Object[] params) throws Exception {
        this.assertBulkModify(q, ex, params);
        return ex.executeUpdate(q, params);
    }

    public Number updateInMemory(StoreQuery q, StoreQuery.Executor executor, Object[] params) {
        try {
            Set<Object> o = this.execute(q, executor, params);
            if (!(o instanceof Collection)) {
                o = Collections.singleton(o);
            }
            int size = 0;
            Iterator i = ((Collection)o).iterator();
            while (i.hasNext()) {
                this.updateInMemory(i.next(), params);
                ++size;
            }
            return Numbers.valueOf((int)size);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new UserException(e);
        }
    }

    private void updateInMemory(Object ob, Object[] params) {
        block12: for (Map.Entry e : this.getUpdates().entrySet()) {
            Object val;
            FieldMetaData fmd = (FieldMetaData)e.getKey();
            Object value = e.getValue();
            if (value instanceof Val) {
                val = ((Val)value).evaluate(ob, null, this.getStoreContext(), params);
            } else if (value instanceof Literal) {
                val = ((Literal)value).getValue();
            } else if (value instanceof Constant) {
                val = ((Constant)value).getValue(params);
            } else {
                throw new UserException(_loc.get("only-update-primitives"));
            }
            OpenJPAStateManager sm = this._broker.getStateManager(ob);
            int i = fmd.getIndex();
            PersistenceCapable into = ImplHelper.toPersistenceCapable(ob, this._broker.getConfiguration());
            int set = 0;
            switch (fmd.getDeclaredTypeCode()) {
                case 0: {
                    sm.settingBooleanField(into, i, sm.fetchBooleanField(i), val == null ? false : (Boolean)val, set);
                    continue block12;
                }
                case 1: {
                    sm.settingByteField(into, i, sm.fetchByteField(i), val == null ? (byte)0 : ((Number)val).byteValue(), set);
                    continue block12;
                }
                case 2: {
                    sm.settingCharField(into, i, sm.fetchCharField(i), val == null ? (char)'\u0000' : val.toString().charAt(0), set);
                    continue block12;
                }
                case 3: {
                    sm.settingDoubleField(into, i, sm.fetchDoubleField(i), val == null ? 0.0 : ((Number)val).doubleValue(), set);
                    continue block12;
                }
                case 4: {
                    sm.settingFloatField(into, i, sm.fetchFloatField(i), val == null ? 0.0f : ((Number)val).floatValue(), set);
                    continue block12;
                }
                case 5: {
                    sm.settingIntField(into, i, sm.fetchIntField(i), val == null ? 0 : ((Number)val).intValue(), set);
                    continue block12;
                }
                case 6: {
                    sm.settingLongField(into, i, sm.fetchLongField(i), val == null ? 0L : ((Number)val).longValue(), set);
                    continue block12;
                }
                case 7: {
                    sm.settingShortField(into, i, sm.fetchShortField(i), val == null ? (short)0 : ((Number)val).shortValue(), set);
                    continue block12;
                }
                case 9: {
                    sm.settingStringField(into, i, sm.fetchStringField(i), val == null ? null : val.toString(), set);
                    continue block12;
                }
                case 8: 
                case 10: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 29: {
                    sm.settingObjectField(into, i, sm.fetchObjectField(i), val, set);
                    continue block12;
                }
            }
            throw new UserException(_loc.get("only-update-primitives"));
        }
    }

    private void logExecution(int op, LinkedMap types, Object[] params) {
        HashMap<Object, Object> pmap = Collections.EMPTY_MAP;
        if (params.length > 0) {
            pmap = new HashMap<Object, Object>((int)((double)params.length * 1.33 + 1.0));
            if (types != null && types.size() == params.length) {
                int i = 0;
                Iterator itr = types.keySet().iterator();
                while (itr.hasNext()) {
                    pmap.put(itr.next(), params[i++]);
                }
            } else {
                for (int i = 0; i < params.length; ++i) {
                    pmap.put(String.valueOf(i), params[i]);
                }
            }
        }
        this.logExecution(op, pmap);
    }

    private void logExecution(int op, Map params) {
        String s = this._query;
        if (StringUtils.isEmpty((String)s)) {
            s = this.toString();
        }
        String msg = "executing-query";
        if (!params.isEmpty()) {
            msg = msg + "-with-params";
        }
        this._log.trace((Object)_loc.get(msg, (Object)s, (Object)params));
    }

    private boolean isLRS(long start, long end) {
        long range = end - start;
        return this._fc.getFetchBatchSize() >= 0 && range > (long)this._fc.getFetchBatchSize() && (this._fc.getFetchBatchSize() != 0 || range > 50L);
    }

    protected Object toResult(StoreQuery q, StoreQuery.Executor ex, ResultObjectProvider rop, StoreQuery.Range range) throws Exception {
        ResultPacker packer;
        String[] aliases = ex.getProjectionAliases(q);
        if (!(ex.isPacking(q) || (packer = this.getResultPacker(q, ex)) == null && aliases.length != 1)) {
            rop = new PackingResultObjectProvider(rop, packer, aliases.length);
        }
        if (this._unique == Boolean.TRUE || aliases.length > 0 && !ex.hasGrouping(q) && ex.isAggregate(q)) {
            return this.singleResult(rop, range);
        }
        boolean detach = (this._broker.getAutoDetach() & 8) > 0 && !this._broker.isActive();
        boolean lrs = range.lrs && !ex.isAggregate(q) && !ex.hasGrouping(q);
        EagerResultList res = !detach && lrs ? this._fc.newResultList(rop) : new EagerResultList(rop);
        this._resultLists.add(this.decorateResultList((ResultList)res));
        return res;
    }

    protected ResultList decorateResultList(ResultList res) {
        return new RemoveOnCloseResultList(res);
    }

    private ResultPacker getResultPacker(StoreQuery q, StoreQuery.Executor ex) {
        Class resultClass;
        if (this._packer != null) {
            return this._packer;
        }
        Class clazz = resultClass = this._resultClass != null ? this._resultClass : ex.getResultClass(q);
        if (resultClass == null) {
            return null;
        }
        String[] aliases = ex.getProjectionAliases(q);
        if (aliases.length == 0) {
            this._packer = new ResultPacker(this._class, this.getAlias(), resultClass);
        } else if (resultClass != null) {
            Class[] types = ex.getProjectionTypes(q);
            this._packer = new ResultPacker(types, aliases, resultClass);
        }
        return this._packer;
    }

    private Object emptyResult(StoreQuery q, StoreQuery.Executor ex) {
        if (this._unique == Boolean.TRUE || this._unique == null && !ex.hasGrouping(q) && ex.isAggregate(q)) {
            return null;
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object singleResult(ResultObjectProvider rop, StoreQuery.Range range) throws Exception {
        Object single;
        block8: {
            block9: {
                List list;
                rop.open();
                try {
                    boolean next = rop.next();
                    single = null;
                    if (next) {
                        single = rop.getResultObject();
                        if (range.end != range.start + 1L && rop.next()) {
                            throw new NonUniqueResultException(_loc.get("not-unique", (Object)this._class, (Object)this._query));
                        }
                    } else if (this._unique == Boolean.TRUE) {
                        throw new NoResultException(_loc.get("no-result", (Object)this._class, (Object)this._query));
                    }
                    if (this._unique != Boolean.FALSE) break block8;
                    if (next) break block9;
                    list = Collections.EMPTY_LIST;
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    rop.close();
                    throw throwable;
                }
                rop.close();
                return list;
            }
            List<Object> list = Arrays.asList(single);
            Object var7_9 = null;
            rop.close();
            return list;
        }
        Object object = single;
        Object var7_10 = null;
        rop.close();
        return object;
    }

    private boolean isAccessPathDirty() {
        return QueryImpl.isAccessPathDirty(this._broker, this.getAccessPathMetaDatas());
    }

    public static boolean isAccessPathDirty(Broker broker, ClassMetaData[] accessMetas) {
        Collection persisted = broker.getPersistedTypes();
        Collection updated = broker.getUpdatedTypes();
        Collection deleted = broker.getDeletedTypes();
        if (persisted.isEmpty() && updated.isEmpty() && deleted.isEmpty()) {
            return false;
        }
        if (accessMetas.length == 0) {
            return true;
        }
        for (int i = 0; i < accessMetas.length; ++i) {
            Class accClass = accessMetas[i].getDescribedType();
            if (persisted.contains(accClass) || updated.contains(accClass) || deleted.contains(accClass)) {
                return true;
            }
            Iterator dirty = persisted.iterator();
            while (dirty.hasNext()) {
                if (!accClass.isAssignableFrom((Class)dirty.next())) continue;
                return true;
            }
            dirty = updated.iterator();
            while (dirty.hasNext()) {
                if (!accClass.isAssignableFrom((Class)dirty.next())) continue;
                return true;
            }
            dirty = deleted.iterator();
            while (dirty.hasNext()) {
                if (!accClass.isAssignableFrom((Class)dirty.next())) continue;
                return true;
            }
        }
        return false;
    }

    public void closeAll() {
        this.closeResults(true);
    }

    public void closeResources() {
        this.closeResults(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeResults(boolean force) {
        this.lock();
        try {
            this.assertOpen();
            for (RemoveOnCloseResultList res : this._resultLists) {
                if (!force && !res.isProviderOpen()) continue;
                res.close(false);
            }
            this._resultLists.clear();
            Object var5_4 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getDataStoreActions(Map params) {
        if (params == null) {
            params = Collections.EMPTY_MAP;
        }
        this.lock();
        try {
            String[] stringArray;
            try {
                this.assertNotSerialized();
                this.assertOpen();
                StoreQuery.Executor ex = this.compileForExecutor();
                Object[] arr = this.toParameterArray(ex.getParameterTypes(this._storeQuery), params);
                this.assertParameters(this._storeQuery, ex, arr);
                StoreQuery.Range range = new StoreQuery.Range(this._startIdx, this._endIdx);
                if (!this._rangeSet) {
                    ex.getRange(this._storeQuery, arr, range);
                }
                stringArray = ex.getDataStoreActions(this._storeQuery, arr, range);
                Object var7_8 = null;
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (Exception e) {
                throw new UserException(e);
            }
            this.unlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setQuery(Object query) {
        block8: {
            block7: {
                this.lock();
                try {
                    this.assertOpen();
                    this.assertNotReadOnly();
                    if (query != null && !(query instanceof String)) break block7;
                    this.invalidateCompilation();
                    this._query = (String)query;
                    if (this._query != null) {
                        this._query = this._query.trim();
                    }
                    boolean bl = true;
                    Object var5_5 = null;
                    this.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    this.unlock();
                    throw throwable;
                }
            }
            if (query instanceof QueryImpl) break block8;
            boolean bl = this._storeQuery.setQuery(query);
            Object var5_6 = null;
            this.unlock();
            return bl;
        }
        this.invalidateCompilation();
        QueryImpl q = (QueryImpl)query;
        this._class = q._class;
        this._subclasses = q._subclasses;
        this._query = q._query;
        this._ignoreChanges = q._ignoreChanges;
        this._unique = q._unique;
        this._resultClass = q._resultClass;
        this._params = q._params;
        this._resultMappingScope = q._resultMappingScope;
        this._resultMappingName = q._resultMappingName;
        this._readOnly = q._readOnly;
        this._fc.copy(q._fc);
        if (q._filtListeners != null) {
            this._filtListeners = new HashMap(q._filtListeners);
        }
        if (q._aggListeners != null) {
            this._aggListeners = new HashMap(q._aggListeners);
        }
        boolean bl = true;
        Object var5_7 = null;
        this.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAlias() {
        this.lock();
        try {
            String alias = this.compileForExecutor().getAlias(this._storeQuery);
            if (alias == null) {
                alias = Strings.getClassName((Class)this._class);
            }
            String string = alias;
            Object var4_3 = null;
            this.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getProjectionAliases() {
        this.lock();
        try {
            String[] stringArray = this.compileForExecutor().getProjectionAliases(this._storeQuery);
            Object var3_2 = null;
            this.unlock();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getProjectionTypes() {
        this.lock();
        try {
            Class[] classArray = this.compileForExecutor().getProjectionTypes(this._storeQuery);
            Object var3_2 = null;
            this.unlock();
            return classArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOperation() {
        this.lock();
        try {
            int n = this.compileForExecutor().getOperation(this._storeQuery);
            Object var3_2 = null;
            this.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAggregate() {
        this.lock();
        try {
            boolean bl = this.compileForExecutor().isAggregate(this._storeQuery);
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGrouping() {
        this.lock();
        try {
            boolean bl = this.compileForExecutor().hasGrouping(this._storeQuery);
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassMetaData[] getAccessPathMetaDatas() {
        this.lock();
        try {
            ClassMetaData[] metas = this.compileForExecutor().getAccessPathMetaDatas(this._storeQuery);
            ClassMetaData[] classMetaDataArray = metas == null ? StoreQuery.EMPTY_METAS : metas;
            Object var4_3 = null;
            this.unlock();
            return classMetaDataArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedMap getParameterTypes() {
        this.lock();
        try {
            LinkedMap linkedMap = this.compileForExecutor().getParameterTypes(this._storeQuery);
            Object var3_2 = null;
            this.unlock();
            return linkedMap;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getUpdates() {
        this.lock();
        try {
            Map map = this.compileForExecutor().getUpdates(this._storeQuery);
            Object var3_2 = null;
            this.unlock();
            return map;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    public void unlock() {
        if (this._lock != null && this._lock.isLocked()) {
            this._lock.unlock();
        }
    }

    public Class classForName(String name, String[] imports) {
        String fullName;
        Class type = this.toClass(name);
        if (type != null) {
            return type;
        }
        ClassLoader loader = this._class == null ? this._loader : (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction((Class)this._class));
        ClassMetaData meta = this._broker.getConfiguration().getMetaDataRepositoryInstance().getMetaData(name, loader, false);
        if (meta != null) {
            return meta.getDescribedType();
        }
        if (this._class != null && (type = this.toClass(fullName = this._class.getName().substring(0, this._class.getName().lastIndexOf(46) + 1) + name)) != null) {
            return type;
        }
        type = this.toClass("java.lang." + name);
        if (type != null) {
            return type;
        }
        if (imports != null && imports.length > 0) {
            String dotName = "." + name;
            for (int i = 0; i < imports.length; ++i) {
                String importName = imports[i];
                if (importName.endsWith(dotName)) {
                    type = this.toClass(importName);
                } else if (importName.endsWith(".*")) {
                    importName = importName.substring(0, importName.length() - 1);
                    type = this.toClass(importName + name);
                }
                if (type == null) continue;
                return type;
            }
        }
        return null;
    }

    private Class toClass(String name) {
        if (this._loader == null) {
            this._loader = this._broker.getConfiguration().getClassResolverInstance().getClassLoader(this._class, this._broker.getClassLoader());
        }
        try {
            return Strings.toClass((String)name, (ClassLoader)this._loader);
        }
        catch (RuntimeException re) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    public void assertOpen() {
        if (this._broker != null) {
            this._broker.assertOpen();
        }
    }

    public void assertNotReadOnly() {
        if (this._readOnly) {
            throw new InvalidStateException(_loc.get("read-only"));
        }
    }

    public void assertNotSerialized() {
        if (this._broker == null) {
            throw new InvalidStateException(_loc.get("serialized"));
        }
    }

    private void assertCandidateType() {
        if (this._class == null && this._storeQuery.requiresCandidateType()) {
            throw new InvalidStateException(_loc.get("no-class"));
        }
    }

    private void assertBulkModify(StoreQuery q, StoreQuery.Executor ex, Object[] params) {
        this._broker.assertActiveTransaction();
        if (this._startIdx != 0L || this._endIdx != Long.MAX_VALUE) {
            throw new UserException(_loc.get("no-modify-range"));
        }
        if (this._resultClass != null) {
            throw new UserException(_loc.get("no-modify-resultclass"));
        }
        StoreQuery.Range range = new StoreQuery.Range();
        ex.getRange(q, params, range);
        if (range.start != 0L || range.end != Long.MAX_VALUE) {
            throw new UserException(_loc.get("no-modify-range"));
        }
    }

    protected void assertParameters(StoreQuery q, StoreQuery.Executor ex, Object[] params) {
        if (!q.requiresParameterDeclarations()) {
            return;
        }
        LinkedMap paramTypes = ex.getParameterTypes(q);
        int typeCount = paramTypes.size();
        if (typeCount > params.length) {
            throw new UserException(_loc.get("unbound-params", (Object)paramTypes.keySet()));
        }
        Iterator itr = paramTypes.entrySet().iterator();
        int i = 0;
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            if (((Class)entry.getValue()).isPrimitive() && params[i] == null) {
                throw new UserException(_loc.get("null-primitive-param", entry.getKey()));
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append("Query: ").append(super.toString());
        buf.append("; candidate class: ").append(this._class);
        buf.append("; query: ").append(this._query);
        return buf.toString();
    }

    public class RemoveOnCloseResultList
    implements ResultList {
        private final ResultList _res;

        public RemoveOnCloseResultList(ResultList res) {
            this._res = res;
        }

        public ResultList getDelegate() {
            return this._res;
        }

        public boolean isProviderOpen() {
            return this._res.isProviderOpen();
        }

        public boolean isClosed() {
            return this._res.isClosed();
        }

        public void close() {
            this.close(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(boolean remove) {
            if (this.isClosed()) {
                return;
            }
            this._res.close();
            if (!remove) {
                return;
            }
            QueryImpl.this.lock();
            try {
                Iterator itr = QueryImpl.this._resultLists.iterator();
                while (itr.hasNext()) {
                    if (itr.next() != this) continue;
                    itr.remove();
                    break;
                }
                Object var4_3 = null;
                QueryImpl.this.unlock();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                QueryImpl.this.unlock();
                throw throwable;
            }
        }

        public int size() {
            return this._res.size();
        }

        public boolean isEmpty() {
            return this._res.isEmpty();
        }

        public boolean contains(Object o) {
            return this._res.contains(o);
        }

        public Iterator iterator() {
            return this._res.iterator();
        }

        public Object[] toArray() {
            return this._res.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this._res.toArray(a);
        }

        public boolean add(Object o) {
            return this._res.add(o);
        }

        public boolean remove(Object o) {
            return this._res.remove(o);
        }

        public boolean containsAll(Collection c) {
            return this._res.containsAll(c);
        }

        public boolean addAll(Collection c) {
            return this._res.addAll(c);
        }

        public boolean addAll(int idx, Collection c) {
            return this._res.addAll(idx, c);
        }

        public boolean removeAll(Collection c) {
            return this._res.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            return this._res.retainAll(c);
        }

        public void clear() {
            this._res.clear();
        }

        public Object get(int idx) {
            return this._res.get(idx);
        }

        public Object set(int idx, Object o) {
            return this._res.set(idx, o);
        }

        public void add(int idx, Object o) {
            this._res.add(idx, o);
        }

        public Object remove(int idx) {
            return this._res.remove(idx);
        }

        public int indexOf(Object o) {
            return this._res.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this._res.lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return this._res.listIterator();
        }

        public ListIterator listIterator(int idx) {
            return this._res.listIterator(idx);
        }

        public List subList(int start, int end) {
            return this._res.subList(start, end);
        }

        public boolean equals(Object o) {
            return this._res.equals(o);
        }

        public int hashCode() {
            return this._res.hashCode();
        }

        public String toString() {
            return this._res.toString();
        }

        public Object writeReplace() {
            return this._res;
        }
    }

    private static class PackingResultObjectProvider
    implements ResultObjectProvider {
        private final ResultObjectProvider _delegate;
        private final ResultPacker _packer;
        private final int _len;

        public PackingResultObjectProvider(ResultObjectProvider delegate, ResultPacker packer, int resultLength) {
            this._delegate = delegate;
            this._packer = packer;
            this._len = resultLength;
        }

        public boolean supportsRandomAccess() {
            return this._delegate.supportsRandomAccess();
        }

        public void open() throws Exception {
            this._delegate.open();
        }

        public Object getResultObject() throws Exception {
            Object ob = this._delegate.getResultObject();
            if (this._packer == null && this._len == 1) {
                return ((Object[])ob)[0];
            }
            if (this._packer == null) {
                return ob;
            }
            if (this._len == 0) {
                return this._packer.pack(ob);
            }
            return this._packer.pack((Object[])ob);
        }

        public boolean next() throws Exception {
            return this._delegate.next();
        }

        public boolean absolute(int pos) throws Exception {
            return this._delegate.absolute(pos);
        }

        public int size() throws Exception {
            return this._delegate.size();
        }

        public void reset() throws Exception {
            this._delegate.reset();
        }

        public void close() throws Exception {
            this._delegate.close();
        }

        public void handleCheckedException(Exception e) {
            this._delegate.handleCheckedException(e);
        }
    }

    private static class MergedExecutor
    implements StoreQuery.Executor {
        private final StoreQuery.Executor[] _executors;

        public MergedExecutor(StoreQuery.Executor[] executors) {
            this._executors = executors;
        }

        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            if (this._executors.length == 1) {
                return this._executors[0].executeQuery(q, params, range);
            }
            StoreQuery.Range ropRange = new StoreQuery.Range(0L, range.end);
            ropRange.lrs = range.lrs || range.start > 0L && q.getContext().getFetchConfiguration().getFetchBatchSize() >= 0;
            ResultObjectProvider[] rops = new ResultObjectProvider[this._executors.length];
            for (int i = 0; i < this._executors.length; ++i) {
                rops[i] = this._executors[i].executeQuery(q, params, ropRange);
            }
            boolean[] asc = this._executors[0].getAscending(q);
            Object rop = asc.length == 0 ? new MergedResultObjectProvider(rops) : new OrderingMergedResultObjectProvider(rops, asc, this._executors, q, params);
            if (range.start != 0L) {
                rop = new RangeResultObjectProvider((ResultObjectProvider)rop, range.start, range.end);
            }
            return rop;
        }

        public Number executeDelete(StoreQuery q, Object[] params) {
            long num = 0L;
            for (int i = 0; i < this._executors.length; ++i) {
                num += this._executors[i].executeDelete(q, params).longValue();
            }
            return Numbers.valueOf((long)num);
        }

        public Number executeUpdate(StoreQuery q, Object[] params) {
            long num = 0L;
            for (int i = 0; i < this._executors.length; ++i) {
                num += this._executors[i].executeUpdate(q, params).longValue();
            }
            return Numbers.valueOf((long)num);
        }

        public String[] getDataStoreActions(StoreQuery q, Object[] params, StoreQuery.Range range) {
            if (this._executors.length == 1) {
                return this._executors[0].getDataStoreActions(q, params, range);
            }
            ArrayList<String> results = new ArrayList<String>(this._executors.length);
            StoreQuery.Range ropRange = new StoreQuery.Range(0L, range.end);
            for (int i = 0; i < this._executors.length; ++i) {
                String[] actions = this._executors[i].getDataStoreActions(q, params, ropRange);
                if (actions == null || actions.length <= 0) continue;
                results.addAll(Arrays.asList(actions));
            }
            return results.toArray(new String[results.size()]);
        }

        public void validate(StoreQuery q) {
            this._executors[0].validate(q);
        }

        public void getRange(StoreQuery q, Object[] params, StoreQuery.Range range) {
            this._executors[0].getRange(q, params, range);
        }

        public Object getOrderingValue(StoreQuery q, Object[] params, Object resultObject, int idx) {
            return this._executors[0].getOrderingValue(q, params, resultObject, idx);
        }

        public boolean[] getAscending(StoreQuery q) {
            return this._executors[0].getAscending(q);
        }

        public String getAlias(StoreQuery q) {
            return this._executors[0].getAlias(q);
        }

        public String[] getProjectionAliases(StoreQuery q) {
            return this._executors[0].getProjectionAliases(q);
        }

        public Class getResultClass(StoreQuery q) {
            return this._executors[0].getResultClass(q);
        }

        public Class[] getProjectionTypes(StoreQuery q) {
            return this._executors[0].getProjectionTypes(q);
        }

        public boolean isPacking(StoreQuery q) {
            return this._executors[0].isPacking(q);
        }

        public ClassMetaData[] getAccessPathMetaDatas(StoreQuery q) {
            if (this._executors.length == 1) {
                return this._executors[0].getAccessPathMetaDatas(q);
            }
            List metas = null;
            for (int i = 0; i < this._executors.length; ++i) {
                metas = Filters.addAccessPathMetaDatas(metas, this._executors[i].getAccessPathMetaDatas(q));
            }
            if (metas == null) {
                return StoreQuery.EMPTY_METAS;
            }
            return metas.toArray(new ClassMetaData[metas.size()]);
        }

        public boolean isAggregate(StoreQuery q) {
            if (!this._executors[0].isAggregate(q)) {
                return false;
            }
            throw new UnsupportedException(_loc.get("merged-aggregate", (Object)q.getContext().getCandidateType(), (Object)q.getContext().getQueryString()));
        }

        public int getOperation(StoreQuery q) {
            return this._executors[0].getOperation(q);
        }

        public boolean hasGrouping(StoreQuery q) {
            return this._executors[0].hasGrouping(q);
        }

        public LinkedMap getParameterTypes(StoreQuery q) {
            return this._executors[0].getParameterTypes(q);
        }

        public Map getUpdates(StoreQuery q) {
            return this._executors[0].getUpdates(q);
        }
    }

    private static class CompilationKey
    implements Serializable {
        public Class queryType = null;
        public Class candidateType = null;
        public boolean subclasses = true;
        public String query = null;
        public String language = null;
        public Object storeKey = null;

        private CompilationKey() {
        }

        public int hashCode() {
            int rs = 17;
            rs = 37 * rs + (this.queryType == null ? 0 : this.queryType.hashCode());
            rs = 37 * rs + (this.query == null ? 0 : this.query.hashCode());
            rs = 37 * rs + (this.language == null ? 0 : this.language.hashCode());
            rs = 37 * rs + (this.storeKey == null ? 0 : this.storeKey.hashCode());
            if (this.subclasses) {
                ++rs;
            }
            return rs;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            CompilationKey key = (CompilationKey)other;
            if (key.queryType != this.queryType || !StringUtils.equals((String)key.query, (String)this.query) || !StringUtils.equals((String)key.language, (String)this.language)) {
                return false;
            }
            if (key.subclasses != this.subclasses) {
                return false;
            }
            if (!ObjectUtils.equals((Object)key.storeKey, (Object)this.storeKey)) {
                return false;
            }
            return key.candidateType == null || this.candidateType == null || key.candidateType == this.candidateType;
        }
    }

    protected static class Compilation
    implements Serializable {
        public StoreQuery.Executor memory = null;
        public StoreQuery.Executor datastore = null;
        public Object storeData = null;

        protected Compilation() {
        }
    }
}

