/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCachePCData;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.InvalidStateException;

public class InverseManager
implements Configurable {
    private static final Localizer _loc = Localizer.forPackage(InverseManager.class);
    protected static final Object NONE = new Object();
    public static final int ACTION_MANAGE = 0;
    public static final int ACTION_WARN = 1;
    public static final int ACTION_EXCEPTION = 2;
    private boolean _manageLRS = false;
    private int _action = 0;
    private Log _log;

    public boolean getManageLRS() {
        return this._manageLRS;
    }

    public void setManageLRS(boolean manage) {
        this._manageLRS = manage;
    }

    public int getAction() {
        return this._action;
    }

    public void setAction(int action) {
        this._action = action;
    }

    public void setAction(String action) {
        if ("exception".equals(action)) {
            this._action = 2;
        } else if ("warn".equals(action)) {
            this._action = 1;
        } else if ("manage".equals(action)) {
            this._action = 0;
        } else {
            throw new IllegalArgumentException(action);
        }
    }

    public void startConfiguration() {
    }

    public void endConfiguration() {
    }

    public void setConfiguration(Configuration conf) {
        this._log = conf.getLog("openjpa.Runtime");
    }

    public void correctRelations(OpenJPAStateManager sm, FieldMetaData fmd, Object value) {
        if (fmd.getDeclaredTypeCode() != 15 && (fmd.getDeclaredTypeCode() != 12 || fmd.getElement().getDeclaredTypeCode() != 15)) {
            return;
        }
        if (!this.getManageLRS() && fmd.isLRS()) {
            return;
        }
        FieldMetaData[] inverses = fmd.getInverseMetaDatas();
        if (inverses.length == 0) {
            return;
        }
        this.clearInverseRelations(sm, fmd, inverses, value);
        if (value != null) {
            StoreContext ctx = sm.getContext();
            switch (fmd.getDeclaredTypeCode()) {
                case 15: {
                    this.createInverseRelations(ctx, sm.getManagedInstance(), value, fmd, inverses);
                    break;
                }
                case 12: {
                    Iterator itr = ((Collection)value).iterator();
                    while (itr.hasNext()) {
                        this.createInverseRelations(ctx, sm.getManagedInstance(), itr.next(), fmd, inverses);
                    }
                    break;
                }
            }
        }
    }

    protected void createInverseRelations(StoreContext ctx, Object fromRef, Object toRef, FieldMetaData fmd, FieldMetaData[] inverses) {
        OpenJPAStateManager other = ctx.getStateManager(toRef);
        if (other == null || other.isDeleted()) {
            return;
        }
        block4: for (int i = 0; i < inverses.length; ++i) {
            if (!this.getManageLRS() && inverses[i].isLRS()) continue;
            boolean owned = fmd == inverses[i].getMappedByMetaData() && this._action == 0 && !this.isLoaded(other, inverses[i].getIndex());
            switch (inverses[i].getDeclaredTypeCode()) {
                case 15: {
                    if (owned && inverses[i].getCascadeDelete() != 2) continue block4;
                    this.storeField(other, inverses[i], NONE, fromRef);
                    continue block4;
                }
                case 12: {
                    if (owned && inverses[i].getElement().getCascadeDelete() != 2) continue block4;
                    this.addToCollection(other, inverses[i], fromRef);
                }
            }
        }
    }

    private boolean isLoaded(OpenJPAStateManager sm, int field) {
        if (sm.getLoaded().get(field)) {
            return true;
        }
        DataCache cache = sm.getMetaData().getDataCache();
        if (cache == null) {
            return false;
        }
        if (sm.isEmbedded()) {
            return true;
        }
        DataCachePCData pc = cache.get(sm.getObjectId());
        if (pc == null) {
            return false;
        }
        return pc.isLoaded(field);
    }

    protected void clearInverseRelations(OpenJPAStateManager sm, FieldMetaData fmd, FieldMetaData[] inverses, Object newValue) {
        if (sm.isNew() && !sm.getFlushed().get(fmd.getIndex())) {
            return;
        }
        if (fmd.getDeclaredTypeCode() == 15) {
            Object initial = sm.fetchInitialField(fmd.getIndex());
            this.clearInverseRelations(sm, initial, fmd, inverses);
        } else {
            Collection initial = (Collection)sm.fetchInitialField(fmd.getIndex());
            if (initial == null) {
                return;
            }
            Collection coll = (Collection)newValue;
            for (Object elem : initial) {
                if (coll != null && coll.contains(elem)) continue;
                this.clearInverseRelations(sm, elem, fmd, inverses);
            }
        }
    }

    protected void clearInverseRelations(OpenJPAStateManager sm, Object val, FieldMetaData fmd, FieldMetaData[] inverses) {
        if (val == null) {
            return;
        }
        OpenJPAStateManager other = sm.getContext().getStateManager(val);
        if (other == null || other.isDeleted()) {
            return;
        }
        block4: for (int i = 0; i < inverses.length; ++i) {
            if (!this.getManageLRS() && inverses[i].isLRS()) continue;
            boolean owned = fmd == inverses[i].getMappedByMetaData() && this._action == 0 && !this.isLoaded(other, inverses[i].getIndex());
            switch (inverses[i].getDeclaredTypeCode()) {
                case 15: {
                    if (owned && inverses[i].getCascadeDelete() != 2) continue block4;
                    this.storeNull(other, inverses[i], sm.getManagedInstance());
                    continue block4;
                }
                case 12: {
                    if (owned && inverses[i].getElement().getCascadeDelete() != 2) continue block4;
                    this.removeFromCollection(other, inverses[i], sm.getManagedInstance());
                }
            }
        }
    }

    protected void storeNull(OpenJPAStateManager sm, FieldMetaData fmd, Object compare) {
        this.storeField(sm, fmd, compare, null);
    }

    protected void storeField(OpenJPAStateManager sm, FieldMetaData fmd, Object compare, Object val) {
        Object oldValue = sm.fetchObjectField(fmd.getIndex());
        if (oldValue == val) {
            return;
        }
        if (compare != NONE && oldValue != compare) {
            return;
        }
        switch (this._action) {
            case 0: {
                sm.settingObjectField(sm.getPersistenceCapable(), fmd.getIndex(), oldValue, val, 0);
                break;
            }
            case 1: {
                this.warnConsistency(sm, fmd);
                break;
            }
            case 2: {
                this.throwException(sm, fmd);
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected void removeFromCollection(OpenJPAStateManager sm, FieldMetaData fmd, Object val) {
        Collection coll = (Collection)sm.fetchObjectField(fmd.getIndex());
        if (coll != null) {
            switch (this._action) {
                case 0: {
                    for (int i = 0; coll.remove(val) && (i != 0 || !(coll instanceof Set)); ++i) {
                    }
                    break;
                }
                case 1: {
                    if (!coll.contains(val)) break;
                    this.warnConsistency(sm, fmd);
                    break;
                }
                case 2: {
                    if (!coll.contains(val)) break;
                    this.throwException(sm, fmd);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    protected void addToCollection(OpenJPAStateManager sm, FieldMetaData fmd, Object val) {
        Collection coll = (Collection)sm.fetchObjectField(fmd.getIndex());
        if (coll == null) {
            coll = (Collection)sm.newFieldProxy(fmd.getIndex());
            sm.storeObjectField(fmd.getIndex(), coll);
        }
        if (!coll.contains(val)) {
            switch (this._action) {
                case 0: {
                    coll.add(val);
                    break;
                }
                case 1: {
                    this.warnConsistency(sm, fmd);
                    break;
                }
                case 2: {
                    this.throwException(sm, fmd);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    protected void warnConsistency(OpenJPAStateManager sm, FieldMetaData fmd) {
        if (this._log.isWarnEnabled()) {
            this._log.warn((Object)_loc.get("inverse-consistency", (Object)fmd, sm.getId(), (Object)sm.getContext()));
        }
    }

    protected void throwException(OpenJPAStateManager sm, FieldMetaData fmd) {
        throw new InvalidStateException(_loc.get("inverse-consistency", (Object)fmd, sm.getId(), (Object)sm.getContext())).setFailedObject(sm.getManagedInstance()).setFatal(true);
    }
}

