/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Val;

public class NullIf
extends Val {
    private final Val _val1;
    private final Val _val2;

    NullIf(Val val1, Val val2) {
        this._val1 = val1;
        this._val2 = val2;
    }

    protected Object eval(Object candidate, Object orig, StoreContext ctx, Object[] params) {
        Object o1 = this._val1.eval(candidate, orig, ctx, params);
        Object o2 = this._val2.eval(candidate, orig, ctx, params);
        if (o1 != null && o2 != null) {
            Class<?> c = Filters.promote(o1.getClass(), o2.getClass());
            o1 = Filters.convert(o1, c);
            o2 = Filters.convert(o2, c);
        }
        if (this.compare(o1, o2)) {
            return null;
        }
        return o1;
    }

    protected Object eval(Object candidate, StoreContext ctx, Object[] params) {
        Object o1 = this._val1.eval(candidate, null, ctx, params);
        Object o2 = this._val2.eval(candidate, null, ctx, params);
        if (o1 != null && o2 != null) {
            Class<?> c = Filters.promote(o1.getClass(), o2.getClass());
            o1 = Filters.convert(o1, c);
            o2 = Filters.convert(o2, c);
        }
        if (this.compare(o1, o2)) {
            return null;
        }
        return o1;
    }

    protected boolean compare(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public Val getVal1() {
        return this._val1;
    }

    public Val getVal2() {
        return this._val2;
    }

    public Class getType() {
        return this._val1.getType();
    }

    public void setImplicitType(Class type) {
    }

    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter(this);
        this._val1.acceptVisit(visitor);
        this._val2.acceptVisit(visitor);
        visitor.exit(this);
    }
}

