/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.apache.openjpa.event.MethodLifecycleCallbacks;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UserException;

public class BeanLifecycleCallbacks
extends MethodLifecycleCallbacks {
    private static final Localizer _loc = Localizer.forPackage(BeanLifecycleCallbacks.class);
    private transient Object _listener;

    public BeanLifecycleCallbacks(Class cls, String method, boolean arg, Class type) {
        Class[] classArray;
        if (arg) {
            Class[] classArray2 = new Class[2];
            classArray2[0] = Object.class;
            classArray = classArray2;
            classArray2[1] = type;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = type;
        }
        this(cls, BeanLifecycleCallbacks.getMethod(cls, method, classArray), arg);
    }

    public BeanLifecycleCallbacks(Class cls, Method method, boolean arg) {
        super(method, arg);
        this._listener = this.newListener(cls);
    }

    private Object newListener(Class cls) {
        try {
            return AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction((Class)cls));
        }
        catch (Throwable t2) {
            Exception t2;
            if (t2 instanceof PrivilegedActionException) {
                t2 = ((PrivilegedActionException)t2).getException();
            }
            throw new UserException(_loc.get("bean-constructor", (Object)cls.getName()), (Throwable)t2);
        }
    }

    @Override
    public void makeCallback(Object obj, Object rel, int eventType) throws Exception {
        Method callback = this.getCallbackMethod();
        if (!callback.isAccessible()) {
            AccessController.doPrivileged(J2DoPrivHelper.setAccessibleAction((AccessibleObject)callback, (boolean)true));
        }
        if (this.requiresArgument()) {
            callback.invoke(this._listener, obj, rel);
        } else {
            callback.invoke(this._listener, obj);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        Class cls = (Class)in.readObject();
        this._listener = this.newListener(cls);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._listener.getClass());
    }
}

