/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.lib.xml.Commentable;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.Extensions;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.meta.MetaDataModes;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.Order;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.meta.ValueStrategies;
import org.apache.openjpa.util.Exceptions;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;
import serp.util.Strings;

public class FieldMetaData
extends Extensions
implements ValueMetaData,
MetaDataContext,
MetaDataModes,
Commentable {
    public static final int NULL_UNSET = -1;
    public static final int NULL_NONE = 0;
    public static final int NULL_DEFAULT = 1;
    public static final int NULL_EXCEPTION = 2;
    public static final int MANAGE_PERSISTENT = 3;
    public static final int MANAGE_TRANSACTIONAL = 1;
    public static final int MANAGE_NONE = 0;
    public static final int ONE_TO_ONE = 1;
    public static final int ONE_TO_MANY = 2;
    public static final int MANY_TO_ONE = 3;
    public static final int MANY_TO_MANY = 4;
    private static final Localizer _loc = Localizer.forPackage(FieldMetaData.class);
    private static final int DFG_FALSE = 1;
    private static final int DFG_TRUE = 2;
    private static final int DFG_EXPLICIT = 4;
    private static final Method DEFAULT_METHOD;
    private final ValueMetaData _val;
    private final ValueMetaData _key;
    private final ValueMetaData _elem;
    private final ClassMetaData _owner;
    private final String _name;
    private Class<?> _dec = null;
    private ClassMetaData _decMeta = null;
    private String _fullName = null;
    private String _embedFullName = null;
    private int _resMode = 0;
    private String _mappedByIdValue = null;
    private int _access = AccessCode.UNKNOWN;
    private String[] _comments = null;
    private int _listIndex = -1;
    private Class<?> _proxyClass = null;
    private Object _initializer = null;
    private boolean _transient = false;
    private boolean _primKey = false;
    private Boolean _version = null;
    private int _nullValue = -1;
    private int _manage = 3;
    private int _index = -1;
    private int _decIndex = -1;
    private int _pkIndex = -1;
    private boolean _explicit = false;
    private int _dfg = 0;
    private Set<String> _fgSet = null;
    private String[] _fgs = null;
    private String _lfg = null;
    private Boolean _lrs = null;
    private Boolean _stream = null;
    private String _extName = null;
    private String _factName = null;
    private String _extString = null;
    private Map _extValues = Collections.EMPTY_MAP;
    private Map _fieldValues = Collections.EMPTY_MAP;
    private Boolean _enumField = null;
    private Boolean _lobField = null;
    private Boolean _serializableField = null;
    private boolean _generated = false;
    private MemberProvider _backingMember = null;
    private transient Method _extMethod = DEFAULT_METHOD;
    private transient Member _factMethod = DEFAULT_METHOD;
    private boolean _intermediate = true;
    private Boolean _implData = Boolean.TRUE;
    private int _valStrategy = -1;
    private int _upStrategy = -1;
    private String _seqName = "`";
    private SequenceMetaData _seqMeta = null;
    private String _mappedBy = null;
    private FieldMetaData _mappedByMeta = null;
    private FieldMetaData[] _inverses = null;
    private String _inverse = "`";
    private Order[] _orders = null;
    private String _orderDec = null;
    private boolean _usedInOrderBy = false;
    private boolean _isElementCollection = false;
    private int _associationType;
    private boolean _persistentCollection = false;
    private Class<?> _relationType = Unknown.class;

    protected FieldMetaData(String name, Class<?> type, ClassMetaData owner) {
        this._name = name;
        this._owner = owner;
        this._dec = null;
        this._decMeta = null;
        this._val = owner.getRepository().newValueMetaData(this);
        this._key = owner.getRepository().newValueMetaData(this);
        this._elem = owner.getRepository().newValueMetaData(this);
        this.setDeclaredType(type);
    }

    public void backingMember(Member member) {
        Class[] types;
        Class<?> type;
        if (member == null) {
            return;
        }
        if (Modifier.isTransient(member.getModifiers())) {
            this._transient = true;
        }
        this._backingMember = new MemberProvider(member);
        if (member instanceof Field) {
            Field f = (Field)member;
            type = f.getType();
            types = JavaVersions.getParameterizedTypes((Field)f);
            this.setAccessType(AccessCode.FIELD);
        } else {
            Method meth = (Method)member;
            type = meth.getReturnType();
            types = JavaVersions.getParameterizedTypes((Method)meth);
            this.setAccessType(AccessCode.PROPERTY);
        }
        this.setDeclaredType(type);
        if (Collection.class.isAssignableFrom(type) && this._elem.getDeclaredType() == Object.class && types.length == 1) {
            this._elem.setDeclaredType(types[0]);
        } else if (Map.class.isAssignableFrom(type) && types.length == 2) {
            if (this._key.getDeclaredType() == Object.class) {
                this._key.setDeclaredType(types[0]);
            }
            if (this._elem.getDeclaredType() == Object.class) {
                this._elem.setDeclaredType(types[1]);
            }
        }
    }

    public Member getBackingMember() {
        return this._backingMember == null ? null : this._backingMember.getMember();
    }

    @Override
    public MetaDataRepository getRepository() {
        return this._owner.getRepository();
    }

    public ClassMetaData getDefiningMetaData() {
        return this._owner;
    }

    public Class<?> getDeclaringType() {
        return this._dec == null ? this._owner.getDescribedType() : this._dec;
    }

    public void setDeclaringType(Class<?> cls) {
        this._dec = cls;
        this._decMeta = null;
        this._fullName = null;
        this._embedFullName = null;
    }

    public ClassMetaData getDeclaringMetaData() {
        if (this._dec == null) {
            return this._owner;
        }
        if (this._decMeta == null) {
            this._decMeta = this.getRepository().getMetaData(this._dec, this._owner.getEnvClassLoader(), true);
        }
        return this._decMeta;
    }

    public String getName() {
        return this._name;
    }

    public String getFullName() {
        return this.getFullName(false);
    }

    public String getFullName(boolean embedOwner) {
        if (this._fullName == null) {
            this._fullName = this.getDeclaringType().getName() + "." + this._name;
        }
        if (embedOwner && this._embedFullName == null) {
            this._embedFullName = this._owner.getEmbeddingMetaData() == null ? this._fullName : this._owner.getEmbeddingMetaData().getFieldMetaData().getFullName(true) + "." + this._fullName;
        }
        return embedOwner ? this._embedFullName : this._fullName;
    }

    public String getRealName() {
        return this.getDefiningMetaData().getDescribedType().getName() + "." + this._name;
    }

    public ValueMetaData getValue() {
        return this._val;
    }

    public ValueMetaData getKey() {
        return this._key;
    }

    public ValueMetaData getElement() {
        return this._elem;
    }

    public boolean isMapped() {
        return this._manage == 3 && this._owner.isMapped();
    }

    public Class<?> getProxyType() {
        return this._proxyClass == null ? this.getDeclaredType() : this._proxyClass;
    }

    public void setProxyType(Class<?> type) {
        this._proxyClass = type;
    }

    public Object getInitializer() {
        return this._initializer;
    }

    public void setInitializer(Object initializer) {
        this._initializer = initializer;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean trans) {
        this._transient = trans;
    }

    public int getIndex() {
        return this._index;
    }

    public void setIndex(int index) {
        this._index = index;
    }

    public int getDeclaredIndex() {
        return this._decIndex;
    }

    public void setDeclaredIndex(int index) {
        this._decIndex = index;
    }

    public int getListingIndex() {
        return this._listIndex;
    }

    public void setListingIndex(int index) {
        this._listIndex = index;
    }

    public int getPrimaryKeyIndex() {
        return this._pkIndex;
    }

    public void setPrimaryKeyIndex(int index) {
        this._pkIndex = index;
    }

    public int getManagement() {
        return this._manage;
    }

    public void setManagement(int manage) {
        if (this._manage == 0 != (manage == 0)) {
            this._owner.clearFieldCache();
        }
        this._manage = manage;
    }

    public boolean isPrimaryKey() {
        return this._primKey;
    }

    public void setPrimaryKey(boolean primKey) {
        this._primKey = primKey;
    }

    public int getObjectIdFieldTypeCode() {
        ClassMetaData relmeta = this.getDeclaredTypeMetaData();
        if (relmeta == null) {
            return this.getDeclaredTypeCode();
        }
        if (relmeta.getIdentityType() == 1) {
            boolean unwrap = this.getRepository().getMetaDataFactory().getDefaults().isDataStoreObjectIdFieldUnwrapped();
            return unwrap ? 6 : 8;
        }
        if (relmeta.isOpenJPAIdentity()) {
            return relmeta.getPrimaryKeyFields()[0].getObjectIdFieldTypeCode();
        }
        return 8;
    }

    public Class<?> getObjectIdFieldType() {
        ClassMetaData relmeta = this.getDeclaredTypeMetaData();
        if (relmeta == null || this.getValue().isEmbedded()) {
            return this.getDeclaredType();
        }
        switch (relmeta.getIdentityType()) {
            case 1: {
                boolean unwrap = this.getRepository().getMetaDataFactory().getDefaults().isDataStoreObjectIdFieldUnwrapped();
                return unwrap ? Long.TYPE : Object.class;
            }
            case 2: {
                if (relmeta.isOpenJPAIdentity()) {
                    return relmeta.getPrimaryKeyFields()[0].getObjectIdFieldType();
                }
                return relmeta.getObjectIdType() == null ? Object.class : relmeta.getObjectIdType();
            }
        }
        return Object.class;
    }

    public boolean isVersion() {
        return this._version == Boolean.TRUE;
    }

    public void setVersion(boolean version) {
        this._version = version ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isInDefaultFetchGroup() {
        if (this._dfg == 0) {
            if (this._manage != 3 || this.isPrimaryKey() || this.isVersion()) {
                this._dfg = 1;
            } else {
                switch (this.getTypeCode()) {
                    case 8: {
                        if (this.isSerializable() || this.isEnum()) {
                            this._dfg = 2;
                            break;
                        }
                        this._dfg = 1;
                        break;
                    }
                    case 11: {
                        if (this.isLobArray()) {
                            this._dfg = 2;
                            break;
                        }
                        this._dfg = 1;
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 15: 
                    case 27: {
                        this._dfg = 1;
                        break;
                    }
                    default: {
                        this._dfg = 2;
                    }
                }
            }
        }
        return (this._dfg & 2) > 0;
    }

    private boolean isEnum() {
        if (this._enumField == null) {
            Class decl = this.getDeclaredType();
            this._enumField = Enum.class.isAssignableFrom(decl) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._enumField;
    }

    private boolean isSerializable() {
        if (this._serializableField == null) {
            Class decl = this.getDeclaredType();
            this._serializableField = Serializable.class.isAssignableFrom(decl) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._serializableField;
    }

    private boolean isLobArray() {
        if (this._lobField == null) {
            Class decl = this.getDeclaredType();
            this._lobField = decl == byte[].class || decl == Byte[].class || decl == char[].class || decl == Character[].class ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._lobField;
    }

    public void setInDefaultFetchGroup(boolean dfg) {
        this._dfg = dfg ? 2 : 1;
        this._dfg |= 4;
    }

    public boolean isDefaultFetchGroupExplicit() {
        return (this._dfg & 4) > 0;
    }

    public void setDefaultFetchGroupExplicit(boolean explicit) {
        this._dfg = explicit ? (this._dfg |= 4) : (this._dfg &= 0xFFFFFFFB);
    }

    public String[] getCustomFetchGroups() {
        if (this._fgs == null) {
            this._fgs = this._fgSet == null || this._manage != 3 || this.isPrimaryKey() || this.isVersion() ? new String[0] : this._fgSet.toArray(new String[this._fgSet.size()]);
        }
        return this._fgs;
    }

    public String getLoadFetchGroup() {
        return this._lfg;
    }

    public void setLoadFetchGroup(String lfg) {
        if ("".equals(lfg)) {
            lfg = null;
        }
        this._lfg = lfg;
    }

    public boolean isInFetchGroup(String fg) {
        if (this._manage != 3 || this.isPrimaryKey() || this.isVersion()) {
            return false;
        }
        if ("all".equals(fg)) {
            return true;
        }
        if ("default".equals(fg)) {
            return this.isInDefaultFetchGroup();
        }
        return this._fgSet != null && this._fgSet.contains(fg);
    }

    public void setInFetchGroup(String fg, boolean in) {
        if (StringUtils.isEmpty((String)fg)) {
            throw new MetaDataException(_loc.get("empty-fg-name", (Object)this));
        }
        if (fg.equals("all")) {
            return;
        }
        if (fg.equals("default")) {
            this.setInDefaultFetchGroup(in);
            return;
        }
        if (this._owner.getFetchGroup(fg) == null) {
            throw new MetaDataException(_loc.get("unknown-fg", (Object)fg, (Object)this));
        }
        if (in && this._fgSet == null) {
            this._fgSet = new HashSet<String>();
        }
        if (in && this._fgSet.add(fg) || !in && this._fgSet != null && this._fgSet.remove(fg)) {
            this._fgs = null;
        }
    }

    public int getNullValue() {
        return this._nullValue;
    }

    public void setNullValue(int nullValue) {
        this._nullValue = nullValue;
    }

    public boolean isExplicit() {
        return this._explicit;
    }

    public void setExplicit(boolean explicit) {
        this._explicit = explicit;
    }

    public String getMappedBy() {
        return this._mappedBy;
    }

    public void setMappedBy(String mapped) {
        this._mappedBy = mapped;
        this._mappedByMeta = null;
    }

    public FieldMetaData getMappedByMetaData() {
        if (this._mappedBy != null && this._mappedByMeta == null) {
            FieldMetaData field;
            ClassMetaData meta = null;
            switch (this.getTypeCode()) {
                case 15: {
                    meta = this.getTypeMetaData();
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    meta = this._elem.getTypeMetaData();
                }
            }
            FieldMetaData fieldMetaData = field = meta == null ? null : this.getMappedByField(meta, this._mappedBy);
            if (field == null) {
                throw new MetaDataException(_loc.get("no-mapped-by", (Object)this, (Object)this._mappedBy));
            }
            if (field.getMappedBy() != null) {
                throw new MetaDataException(_loc.get("circ-mapped-by", (Object)this, (Object)this._mappedBy));
            }
            OpenJPAConfiguration conf = this.getRepository().getConfiguration();
            boolean isAbstractMappingUniDirectional = this.getRepository().getMetaDataFactory().getDefaults().isAbstractMappingUniDirectional(conf);
            if (isAbstractMappingUniDirectional) {
                if (field.getDeclaringMetaData().isAbstract()) {
                    throw new MetaDataException(_loc.get("no-mapped-by-in-mapped-super", (Object)field, (Object)field.getDeclaringMetaData()));
                }
                if (this.getDeclaringMetaData().isAbstract()) {
                    throw new MetaDataException(_loc.get("no-mapped-by-in-mapped-super", (Object)this, (Object)this.getDeclaringMetaData()));
                }
            }
            this._mappedByMeta = field;
        }
        return this._mappedByMeta;
    }

    public FieldMetaData getMappedByField(ClassMetaData meta, String mappedBy) {
        FieldMetaData field = meta.getField(mappedBy);
        if (field != null) {
            return field;
        }
        int dotIdx = mappedBy.indexOf(".");
        if (dotIdx == -1) {
            return null;
        }
        String fieldName = mappedBy.substring(0, dotIdx);
        FieldMetaData field1 = meta.getField(fieldName);
        if (field1 == null) {
            return null;
        }
        ClassMetaData meta1 = field1.getEmbeddedMetaData();
        if (meta1 == null) {
            return null;
        }
        String mappedBy1 = mappedBy.substring(dotIdx + 1);
        return this.getMappedByField(meta1, mappedBy1);
    }

    public String getInverse() {
        if ("`".equals(this._inverse)) {
            this._inverse = null;
        }
        return this._inverse;
    }

    public void setInverse(String inverse) {
        this._inverses = null;
        this._inverse = inverse;
    }

    public FieldMetaData[] getInverseMetaDatas() {
        if (this._inverses == null) {
            String inv = this.getInverse();
            if (this._mappedBy != null && inv != null && !this._mappedBy.equals(inv)) {
                throw new MetaDataException(_loc.get("mapped-not-inverse", (Object)this));
            }
            ClassMetaData meta = null;
            switch (this.getTypeCode()) {
                case 15: {
                    meta = this.getTypeMetaData();
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    meta = this._elem.getTypeMetaData();
                }
            }
            ArrayList<FieldMetaData> inverses = null;
            if (meta != null) {
                FieldMetaData field = this.getMappedByMetaData();
                if (field != null) {
                    if (field.getTypeCode() == 15 || field.getElement().getTypeCode() == 15) {
                        inverses = new ArrayList<FieldMetaData>(3);
                        inverses.add(field);
                    }
                } else if (inv != null) {
                    field = meta.getField(inv);
                    if (field == null) {
                        throw new MetaDataException(_loc.get("no-inverse", (Object)this, (Object)inv));
                    }
                    inverses = new ArrayList(3);
                    inverses.add(field);
                }
                FieldMetaData[] fields = meta.getFields();
                Class<?> type = this.getDeclaringMetaData().getDescribedType();
                block8: for (int i = 0; i < fields.length; ++i) {
                    switch (fields[i].getTypeCode()) {
                        case 15: {
                            if (type.isAssignableFrom(fields[i].getType())) break;
                            continue block8;
                        }
                        case 11: 
                        case 12: {
                            if (type.isAssignableFrom(fields[i].getElement().getType())) break;
                            continue block8;
                        }
                        default: {
                            continue block8;
                        }
                    }
                    if (!this._name.equals(fields[i].getMappedBy()) && !this._name.equals(fields[i].getInverse())) continue;
                    if (inverses == null) {
                        inverses = new ArrayList(3);
                    }
                    if (inverses.contains(fields[i])) continue;
                    inverses.add(fields[i]);
                }
            }
            MetaDataRepository repos = this.getRepository();
            this._inverses = inverses == null ? repos.EMPTY_FIELDS : inverses.toArray(repos.newFieldMetaDataArray(inverses.size()));
        }
        return this._inverses;
    }

    public int getValueStrategy() {
        if (this._valStrategy == -1) {
            this._valStrategy = 0;
        }
        return this._valStrategy;
    }

    public void setValueStrategy(int strategy) {
        this._valStrategy = strategy;
        if (strategy != 2) {
            this.setValueSequenceName(null);
        }
    }

    public String getValueSequenceName() {
        if ("`".equals(this._seqName)) {
            this._seqName = null;
        }
        return this._seqName;
    }

    public void setValueSequenceName(String seqName) {
        this._seqName = seqName;
        this._seqMeta = null;
        if (seqName != null) {
            this.setValueStrategy(2);
        }
    }

    public SequenceMetaData getValueSequenceMetaData() {
        if (this._seqMeta == null && this.getValueSequenceName() != null) {
            this._seqMeta = this.getRepository().getSequenceMetaData(this._owner, this.getValueSequenceName(), true);
        }
        return this._seqMeta;
    }

    public int getUpdateStrategy() {
        if (this.isVersion()) {
            return 2;
        }
        if (this._upStrategy == -1) {
            this._upStrategy = 0;
        }
        return this._upStrategy;
    }

    public void setUpdateStrategy(int strategy) {
        this._upStrategy = strategy;
    }

    public boolean isLRS() {
        return this._lrs == Boolean.TRUE && this._manage == 3;
    }

    public void setLRS(boolean lrs) {
        this._lrs = lrs ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isStream() {
        return this._stream == Boolean.TRUE && this._manage == 3;
    }

    public void setStream(boolean stream) {
        this._stream = stream ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean usesIntermediate() {
        return this._intermediate;
    }

    public void setUsesIntermediate(boolean intermediate) {
        this._intermediate = intermediate;
        this._owner.clearExtraFieldDataTable();
    }

    public Boolean usesImplData() {
        return this._implData;
    }

    public void setUsesImplData(Boolean implData) {
        this._implData = implData;
        this._owner.clearExtraFieldDataTable();
    }

    public Order[] getOrders() {
        if (this._orders == null) {
            if (this._orderDec == null) {
                this._orders = this.getRepository().EMPTY_ORDERS;
            } else {
                String[] decs = Strings.split((String)this._orderDec, (String)",", (int)0);
                Order[] orders = this.getRepository().newOrderArray(decs.length);
                for (int i = 0; i < decs.length; ++i) {
                    FieldMetaData fmd;
                    boolean asc;
                    decs[i] = decs[i].trim();
                    int spc = decs[i].indexOf(32);
                    if (spc == -1) {
                        asc = true;
                    } else {
                        asc = decs[i].substring(spc + 1).trim().toLowerCase().startsWith("asc");
                        decs[i] = decs[i].substring(0, spc);
                    }
                    orders[i] = this.getRepository().newOrder(this, decs[i], asc);
                    ClassMetaData elemCls = this.getElement().getDeclaredTypeMetaData();
                    if (elemCls == null || (fmd = elemCls.getDeclaredField(decs[i])) == null) continue;
                    fmd.setUsedInOrderBy(true);
                }
                this._orders = orders;
            }
        }
        return this._orders;
    }

    public void setOrders(Order[] orders) {
        this._orderDec = null;
        this._orders = orders;
    }

    public String getOrderDeclaration() {
        if (this._orderDec == null && this._orders != null) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this._orders.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this._orders[i].getName()).append(" ");
                buf.append(this._orders[i].isAscending() ? "asc" : "desc");
            }
            this._orderDec = buf.toString();
        }
        return this._orderDec;
    }

    public void setOrderDeclaration(String dec) {
        this._orderDec = StringUtils.trimToNull((String)dec);
        this._orders = null;
    }

    public Object order(Object val) {
        Comparator comp;
        if (val == null) {
            return null;
        }
        Order[] orders = this.getOrders();
        if (orders.length == 0) {
            return val;
        }
        if (orders.length == 1) {
            comp = orders[0].getComparator();
        } else {
            ArrayList<Comparator> comps = null;
            for (int i = 0; i < orders.length; ++i) {
                Comparator curComp = orders[i].getComparator();
                if (curComp == null) continue;
                if (comps == null) {
                    comps = new ArrayList<Comparator>(orders.length);
                }
                if (i != comps.size()) {
                    throw new MetaDataException(_loc.get("mixed-inmem-ordering", (Object)this));
                }
                comps.add(curComp);
            }
            comp = comps == null ? null : new ComparatorChain(comps);
        }
        if (comp == null) {
            return val;
        }
        switch (this.getTypeCode()) {
            case 11: {
                List l = JavaTypes.toList(val, this._elem.getType(), true);
                Collections.sort(l, comp);
                return JavaTypes.toArray(l, this._elem.getType());
            }
            case 12: {
                if (val instanceof List) {
                    Collections.sort((List)val, comp);
                }
                return val;
            }
        }
        throw new MetaDataException(_loc.get("cant-order", (Object)this));
    }

    public boolean isExternalized() {
        return this.getExternalizerMethod() != null || this.getExternalValueMap() != null;
    }

    public Object getExternalValue(Object val, StoreContext ctx) {
        Map extValues = this.getExternalValueMap();
        if (extValues != null) {
            Object foundVal = extValues.get(val);
            if (foundVal == null) {
                throw new UserException(_loc.get("bad-externalized-value", new Object[]{val, extValues.keySet(), this})).setFatal(true).setFailedObject(val);
            }
            return foundVal;
        }
        Method externalizer = this.getExternalizerMethod();
        if (externalizer == null) {
            return val;
        }
        if (val != null && this.getType().isInstance(val) && (!this.getDeclaredType().isInstance(val) || this.getDeclaredType() == Object.class)) {
            return val;
        }
        try {
            if (Modifier.isStatic(externalizer.getModifiers())) {
                if (externalizer.getParameterTypes().length == 1) {
                    return externalizer.invoke(null, val);
                }
                return externalizer.invoke(null, val, ctx);
            }
            if (val == null) {
                return null;
            }
            if (externalizer.getParameterTypes().length == 0) {
                return externalizer.invoke(val, (Object[])null);
            }
            return externalizer.invoke(val, ctx);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new MetaDataException(_loc.get("externalizer-err", (Object)this, (Object)Exceptions.toString(val), (Object)e.toString())).setCause(e);
        }
    }

    public Object getFieldValue(Object val, StoreContext ctx) {
        Map fieldValues = this.getFieldValueMap();
        if (fieldValues != null) {
            return fieldValues.get(val);
        }
        Member factory = this.getFactoryMethod();
        if (factory == null) {
            return val;
        }
        try {
            if (val == null && this.getNullValue() == 1) {
                return AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction((Class)this.getDeclaredType()));
            }
            if (factory instanceof Constructor) {
                if (val == null) {
                    return null;
                }
                return ((Constructor)factory).newInstance(val);
            }
            Method meth = (Method)factory;
            if (meth.getParameterTypes().length == 1) {
                return meth.invoke(null, val);
            }
            return meth.invoke(null, val, ctx);
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable t = ((InvocationTargetException)e).getTargetException();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                e = (Exception)t;
                if (val == null && (e instanceof NullPointerException || e instanceof IllegalArgumentException)) {
                    return null;
                }
            }
            if (e instanceof OpenJPAException) {
                throw (OpenJPAException)e;
            }
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            throw new MetaDataException(_loc.get("factory-err", (Object)this, (Object)Exceptions.toString(val), (Object)e.toString())).setCause(e);
        }
    }

    public String getExternalizer() {
        return this._extName;
    }

    public void setExternalizer(String externalizer) {
        this._extName = externalizer;
        this._extMethod = DEFAULT_METHOD;
    }

    public String getFactory() {
        return this._factName;
    }

    public void setFactory(String factory) {
        this._factName = factory;
        this._factMethod = DEFAULT_METHOD;
    }

    public String getExternalValues() {
        return this._extString;
    }

    public void setExternalValues(String values) {
        this._extString = values;
        this._extValues = null;
    }

    public Map getExternalValueMap() {
        this.parseExternalValues();
        return this._extValues;
    }

    public Map getFieldValueMap() {
        this.parseExternalValues();
        return this._fieldValues;
    }

    private void parseExternalValues() {
        if (this._extValues != Collections.EMPTY_MAP && this._fieldValues != Collections.EMPTY_MAP) {
            return;
        }
        if (this._extString == null) {
            this._extValues = null;
            this._fieldValues = null;
            return;
        }
        Options values = Configurations.parseProperties((String)this._extString);
        if (values.isEmpty()) {
            throw new MetaDataException(_loc.get("no-external-values", (Object)this, (Object)this._extString));
        }
        HashMap<Object, Object> extValues = new HashMap<Object, Object>((int)((double)values.size() * 1.33 + 1.0));
        HashMap<Object, Object> fieldValues = new HashMap<Object, Object>((int)((double)values.size() * 1.33 + 1.0));
        for (Map.Entry entry : values.entrySet()) {
            Object fieldValue = this.transform((String)entry.getKey(), this.getDeclaredTypeCode());
            Object extValue = this.transform((String)entry.getValue(), this.getTypeCode());
            extValues.put(fieldValue, extValue);
            fieldValues.put(extValue, fieldValue);
        }
        this._extValues = extValues;
        this._fieldValues = fieldValues;
    }

    private Object transform(String val, int typeCode) {
        if ("null".equals(val)) {
            return null;
        }
        switch (typeCode) {
            case 0: 
            case 16: {
                return Boolean.valueOf(val);
            }
            case 1: 
            case 17: {
                return Byte.valueOf(val);
            }
            case 5: 
            case 21: {
                return Integer.valueOf(val);
            }
            case 6: 
            case 22: {
                return Long.valueOf(val);
            }
            case 7: 
            case 23: {
                return Short.valueOf(val);
            }
            case 3: 
            case 19: {
                return Double.valueOf(val);
            }
            case 4: 
            case 20: {
                return Float.valueOf(val);
            }
            case 2: 
            case 18: {
                return Character.valueOf(val.charAt(0));
            }
            case 9: {
                return val;
            }
            case 32: {
                return Enum.valueOf(this.getDeclaredType(), val);
            }
        }
        throw new MetaDataException(_loc.get("bad-external-type", (Object)this));
    }

    public Method getExternalizerMethod() {
        if (this._manage != 3) {
            return null;
        }
        if (this._extMethod == DEFAULT_METHOD) {
            if (this._extName != null) {
                this._extMethod = this.findMethod(this._extName);
                if (this._extMethod == null) {
                    throw new MetaDataException(_loc.get("bad-externalizer", (Object)this, (Object)this._extName));
                }
            } else {
                this._extMethod = null;
            }
        }
        return this._extMethod;
    }

    public Member getFactoryMethod() {
        if (this._manage != 3) {
            return null;
        }
        if (this._factMethod == DEFAULT_METHOD) {
            if (this.getExternalizerMethod() == null) {
                this._factMethod = null;
            } else {
                try {
                    this._factMethod = this._factName == null ? this.getDeclaredType().getConstructor(this.getType()) : this.findMethodByNameAndType(this._factName, this.getType());
                }
                catch (OpenJPAException ke) {
                    throw ke;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!(this._factMethod instanceof Constructor) && !(this._factMethod instanceof Method)) {
                    throw new MetaDataException(_loc.get("bad-factory", (Object)this));
                }
            }
        }
        return this._factMethod;
    }

    private Method findMethod(String method) {
        return this.findMethodByNameAndType(method, null);
    }

    private Method findMethodByNameAndType(String method, Class<?> type) {
        if (StringUtils.isEmpty((String)method)) {
            return null;
        }
        String methodName = Strings.getClassName((String)method);
        String clsName = Strings.getPackageName((String)method);
        Class<?> cls = null;
        Class<?> owner = this._owner.getDescribedType();
        cls = clsName.length() == 0 ? this.getDeclaredType() : (clsName.equals(owner.getName()) || clsName.equals(Strings.getClassName(owner)) ? owner : JavaTypes.classForName(clsName, this));
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            Class<?>[] params = methods[i].getParameterTypes();
            if (Modifier.isStatic(methods[i].getModifiers()) && (params.length == 1 || params.length == 2 && FieldMetaData.isStoreContextParameter(params[1]))) {
                if (type == null) {
                    return methods[i];
                }
                if (this.isConvertibleToByMethodInvocationConversion(type, params[0])) {
                    return methods[i];
                }
            }
            if (Modifier.isStatic(methods[i].getModifiers()) || params.length != 0 && (params.length != 1 || !FieldMetaData.isStoreContextParameter(params[0]))) continue;
            return methods[i];
        }
        return null;
    }

    private boolean isConvertibleToByMethodInvocationConversion(Class<?> sourceType, Class<?> destType) {
        if (sourceType.isPrimitive()) {
            return this.isConvertibleToByIdentityPrimitiveConversion(sourceType, destType) || this.isConvertibleToByWideningPrimitive(sourceType, destType) || destType.isAssignableFrom(this.box(sourceType));
        }
        return this.isConvertibleToByIdentityPrimitiveConversion(this.unbox(sourceType), destType) || this.isConvertibleToByWideningPrimitive(this.unbox(sourceType), destType) || destType.isAssignableFrom(sourceType);
    }

    private Class<?> unbox(Class<?> sourceType) {
        if (sourceType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (sourceType == Byte.class) {
            return Byte.TYPE;
        }
        if (sourceType == Short.class) {
            return Short.TYPE;
        }
        if (sourceType == Character.class) {
            return Character.TYPE;
        }
        if (sourceType == Integer.class) {
            return Integer.TYPE;
        }
        if (sourceType == Long.class) {
            return Long.TYPE;
        }
        if (sourceType == Float.class) {
            return Float.TYPE;
        }
        if (sourceType == Double.class) {
            return Double.TYPE;
        }
        return null;
    }

    private Class<?> box(Class<?> sourceType) {
        if (sourceType.isPrimitive()) {
            if (sourceType == Boolean.TYPE) {
                return Boolean.class;
            }
            if (sourceType == Byte.TYPE) {
                return Byte.class;
            }
            if (sourceType == Short.TYPE) {
                return Short.class;
            }
            if (sourceType == Character.TYPE) {
                return Character.class;
            }
            if (sourceType == Integer.TYPE) {
                return Integer.class;
            }
            if (sourceType == Long.TYPE) {
                return Long.class;
            }
            if (sourceType == Float.TYPE) {
                return Float.class;
            }
            if (sourceType == Double.TYPE) {
                return Double.class;
            }
            return null;
        }
        throw new IllegalArgumentException("Cannot box a type that is not a primitive.");
    }

    private boolean isConvertibleToByWideningPrimitive(Class<?> sourceType, Class<?> destType) {
        if (sourceType == Byte.TYPE) {
            return destType == Short.TYPE || destType == Integer.TYPE || destType == Long.TYPE || destType == Float.TYPE || destType == Double.TYPE;
        }
        if (sourceType == Short.TYPE) {
            return destType == Integer.TYPE || destType == Long.TYPE || destType == Float.TYPE || destType == Double.TYPE;
        }
        if (sourceType == Character.TYPE) {
            return destType == Integer.TYPE || destType == Long.TYPE || destType == Float.TYPE || destType == Double.TYPE;
        }
        if (sourceType == Integer.TYPE) {
            return destType == Long.TYPE || destType == Float.TYPE || destType == Double.TYPE;
        }
        if (sourceType == Long.TYPE) {
            return destType == Float.TYPE || destType == Double.TYPE;
        }
        if (sourceType == Float.TYPE) {
            return destType == Double.TYPE;
        }
        return false;
    }

    private boolean isConvertibleToByIdentityPrimitiveConversion(Class<?> sourceType, Class<?> destType) {
        return sourceType != null && sourceType.isPrimitive() && sourceType == destType;
    }

    private static boolean isStoreContextParameter(Class<?> type) {
        return StoreContext.class.getName().equals(type.getName());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FieldMetaData)) {
            return false;
        }
        return this.getFullName(true).equals(((FieldMetaData)other).getFullName(true));
    }

    public int hashCode() {
        return this.getFullName(true).hashCode();
    }

    public int compareTo(Object other) {
        if (other == null) {
            return 1;
        }
        return this.getFullName(true).compareTo(((FieldMetaData)other).getFullName(true));
    }

    public String toString() {
        return this.getFullName(true);
    }

    @Override
    public int getResolve() {
        return this._resMode;
    }

    @Override
    public void setResolve(int mode) {
        this._resMode = mode;
    }

    @Override
    public void setResolve(int mode, boolean on) {
        this._resMode = mode == 0 ? mode : (on ? (this._resMode |= mode) : (this._resMode &= ~mode));
    }

    @Override
    public boolean resolve(int mode) {
        if ((this._resMode & mode) == mode) {
            return true;
        }
        int cur = this._resMode;
        this._resMode |= mode;
        Log log = this.getRepository().getLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)_loc.get("resolve-field", (Object)(this._owner + "@" + System.identityHashCode(this._owner) + "." + this._name)));
        }
        if ((mode & 1) == 0 || (cur & 1) != 0) {
            return false;
        }
        Method externalizer = this.getExternalizerMethod();
        if (externalizer != null) {
            this.setType(externalizer.getReturnType());
        }
        this._val.resolve(1);
        this._key.resolve(1);
        this._elem.resolve(1);
        MetaDataRepository repos = this.getRepository();
        int validate = repos.getValidate();
        if (!((validate & 1) == 0 || ImplHelper.isManagedType(repos.getConfiguration(), this._owner.getDescribedType()) && (validate & 4) != 0)) {
            this.validateLRS();
            if ((validate & 8) == 0) {
                this.validateSupportedType();
            }
            this.validateValue();
            this.validateExtensionKeys();
        }
        return false;
    }

    private void validateLRS() {
        if (!this.isLRS()) {
            return;
        }
        if (this.getTypeCode() == 11) {
            throw new MetaDataException(_loc.get("bad-lrs-array", (Object)this));
        }
        if (this.getExternalizerMethod() != null) {
            throw new MetaDataException(_loc.get("bad-lrs-extern", (Object)this));
        }
        if (this.getType() != Collection.class && this.getType() != Map.class && this.getType() != Set.class) {
            throw new MetaDataException(_loc.get("bad-lrs-concrete", (Object)this));
        }
    }

    private void validateSupportedType() {
        OpenJPAConfiguration conf = this.getRepository().getConfiguration();
        Collection<String> opts = conf.supportedOptions();
        Log log = conf.getLog("openjpa.MetaData");
        switch (this.getTypeCode()) {
            case 15: {
                if (this.isEmbedded() && !opts.contains("openjpa.option.EmbeddedRelation")) {
                    this.setEmbedded(false);
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)_loc.get("cant-embed", (Object)this));
                    break;
                }
                if (!this.isEmbedded() || this.getDeclaredTypeCode() == 15) break;
                this.setEmbedded(false);
                if (!log.isWarnEnabled()) break;
                log.warn((Object)_loc.get("cant-embed-extern", (Object)this));
                break;
            }
            case 12: {
                if (!opts.contains("openjpa.option.Collection")) {
                    throw new UnsupportedException(_loc.get("type-not-supported", (Object)"Collection", (Object)this));
                }
                if (!this._elem.isEmbeddedPC() || opts.contains("openjpa.option.EmbeddedCollectionRelation")) break;
                this._elem.setEmbedded(false);
                if (!log.isWarnEnabled()) break;
                log.warn((Object)_loc.get("cant-embed-element", (Object)this));
                break;
            }
            case 11: {
                if (!opts.contains("openjpa.option.Array")) {
                    throw new UnsupportedException(_loc.get("type-not-supported", (Object)"Array", (Object)this));
                }
                if (!this._elem.isEmbeddedPC() || opts.contains("openjpa.option.EmbeddedCollectionRelation")) break;
                this._elem.setEmbedded(false);
                if (!log.isWarnEnabled()) break;
                log.warn((Object)_loc.get("cant-embed-element", (Object)this));
                break;
            }
            case 13: {
                if (!opts.contains("openjpa.option.Map")) {
                    throw new UnsupportedException(_loc.get("type-not-supported", (Object)"Map", (Object)this));
                }
                if (this._elem.isEmbeddedPC() && !opts.contains("openjpa.option.EmbeddedMapRelation")) {
                    this._elem.setEmbedded(false);
                    if (log.isWarnEnabled()) {
                        log.warn((Object)_loc.get("cant-embed-element", (Object)this));
                    }
                }
                if (!this._key.isEmbeddedPC() || opts.contains("openjpa.option.EmbeddedMapRelation")) break;
                this._key.setEmbedded(false);
                if (!log.isWarnEnabled()) break;
                log.warn((Object)_loc.get("cant-embed-key", (Object)this));
            }
        }
    }

    private void validateValue() {
        if (this.getExternalizerMethod() != null && this.getExternalValueMap() != null) {
            throw new MetaDataException(_loc.get("extern-externvalues", (Object)this));
        }
        if (this.getValueStrategy() == 2 && this.getValueSequenceName() == null) {
            throw new MetaDataException(_loc.get("no-seq-name", (Object)this));
        }
        ValueStrategies.assertSupported(this.getValueStrategy(), this, "value strategy");
    }

    public void copy(FieldMetaData field) {
        super.copy(field);
        this._intermediate = field.usesIntermediate();
        this._implData = field.usesImplData();
        this._proxyClass = field.getProxyType();
        this._initializer = field.getInitializer();
        this._transient = field.isTransient();
        this._nullValue = field.getNullValue();
        this._manage = field.getManagement();
        this._explicit = field.isExplicit();
        this._extName = field.getExternalizer();
        this._extMethod = DEFAULT_METHOD;
        this._factName = field.getFactory();
        this._factMethod = DEFAULT_METHOD;
        this._extString = field.getExternalValues();
        this._extValues = Collections.EMPTY_MAP;
        this._fieldValues = Collections.EMPTY_MAP;
        this._primKey = field.isPrimaryKey();
        this._backingMember = field._backingMember;
        this._enumField = field._enumField;
        this._lobField = field._lobField;
        this._serializableField = field._serializableField;
        this._generated = field._generated;
        this._mappedByIdValue = field._mappedByIdValue;
        this._isElementCollection = field._isElementCollection;
        this._access = field._access;
        this._orderDec = field._orderDec;
        if (this._owner.getEmbeddingMetaData() == null && this._version == null) {
            Boolean bl = this._version = field.isVersion() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this._dfg == 0) {
            int n = this._dfg = field.isInDefaultFetchGroup() ? 2 : 1;
            if (field.isDefaultFetchGroupExplicit()) {
                this._dfg |= 4;
            }
        }
        if (this._fgSet == null && field._fgSet != null) {
            this._fgSet = new HashSet<String>(field._fgSet);
        }
        if (this._lfg == null) {
            this._lfg = field.getLoadFetchGroup();
        }
        if (this._lrs == null) {
            Boolean bl = this._lrs = field.isLRS() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this._valStrategy == -1) {
            this._valStrategy = field.getValueStrategy();
        }
        if (this._upStrategy == -1) {
            this._upStrategy = field.getUpdateStrategy();
        }
        if ("`".equals(this._seqName)) {
            this._seqName = field.getValueSequenceName();
            this._seqMeta = null;
        }
        if ("`".equals(this._inverse)) {
            this._inverse = field.getInverse();
        }
        this._val.copy(field);
        this._key.copy(field.getKey());
        this._elem.copy(field.getElement());
    }

    @Override
    protected void addExtensionKeys(Collection exts) {
        this.getRepository().getMetaDataFactory().addFieldExtensionKeys(exts);
    }

    public String[] getComments() {
        return this._comments == null ? EMPTY_COMMENTS : this._comments;
    }

    public void setComments(String[] comments) {
        this._comments = comments;
    }

    @Override
    public FieldMetaData getFieldMetaData() {
        return this;
    }

    @Override
    public Class getType() {
        return this._val.getType();
    }

    @Override
    public void setType(Class type) {
        this._val.setType(type);
        if (type.isArray()) {
            this._elem.setType(type.getComponentType());
        } else if (type == Properties.class) {
            this._key.setType(String.class);
            this._elem.setType(String.class);
        }
    }

    @Override
    public int getTypeCode() {
        return this._val.getTypeCode();
    }

    @Override
    public void setTypeCode(int code) {
        this._val.setTypeCode(code);
    }

    @Override
    public boolean isTypePC() {
        return this._val.isTypePC();
    }

    @Override
    public ClassMetaData getTypeMetaData() {
        return this._val.getTypeMetaData();
    }

    @Override
    public Class getDeclaredType() {
        return this._val.getDeclaredType();
    }

    @Override
    public void setDeclaredType(Class type) {
        this._val.setDeclaredType(type);
        if (type.isArray()) {
            this._elem.setDeclaredType(type.getComponentType());
        } else if (type == Properties.class) {
            this._key.setDeclaredType(String.class);
            this._elem.setDeclaredType(String.class);
        }
    }

    @Override
    public int getDeclaredTypeCode() {
        return this._val.getDeclaredTypeCode();
    }

    @Override
    public void setDeclaredTypeCode(int type) {
        this._val.setDeclaredTypeCode(type);
    }

    @Override
    public boolean isDeclaredTypePC() {
        return this._val.isDeclaredTypePC();
    }

    @Override
    public ClassMetaData getDeclaredTypeMetaData() {
        return this._val.getDeclaredTypeMetaData();
    }

    @Override
    public boolean isEmbedded() {
        return this._val.isEmbedded();
    }

    @Override
    public void setEmbedded(boolean embedded) {
        this._val.setEmbedded(embedded);
    }

    @Override
    public boolean isEmbeddedPC() {
        return this._val.isEmbeddedPC();
    }

    @Override
    public ClassMetaData getEmbeddedMetaData() {
        return this._val.getEmbeddedMetaData();
    }

    @Override
    public ClassMetaData addEmbeddedMetaData(int access) {
        return this._val.addEmbeddedMetaData(access);
    }

    @Override
    public ClassMetaData addEmbeddedMetaData() {
        return this._val.addEmbeddedMetaData();
    }

    @Override
    public int getCascadeDelete() {
        return this._val.getCascadeDelete();
    }

    @Override
    public void setCascadeDelete(int delete) {
        this._val.setCascadeDelete(delete);
    }

    @Override
    public int getCascadePersist() {
        return this._val.getCascadePersist();
    }

    @Override
    public void setCascadePersist(int persist) {
        this._val.setCascadePersist(persist);
    }

    @Override
    public int getCascadeAttach() {
        return this._val.getCascadeAttach();
    }

    @Override
    public void setCascadeAttach(int attach) {
        this._val.setCascadeAttach(attach);
    }

    @Override
    public int getCascadeDetach() {
        return this._val.getCascadeDetach();
    }

    @Override
    public void setCascadeDetach(int detach) {
        this._val.setCascadeDetach(detach);
    }

    @Override
    public int getCascadeRefresh() {
        return this._val.getCascadeRefresh();
    }

    @Override
    public void setCascadeRefresh(int refresh) {
        this._val.setCascadeRefresh(refresh);
    }

    @Override
    public boolean isSerialized() {
        return this._val.isSerialized();
    }

    @Override
    public void setSerialized(boolean serialized) {
        this._val.setSerialized(serialized);
    }

    @Override
    public String getValueMappedBy() {
        return this._val.getValueMappedBy();
    }

    @Override
    public void setValueMappedBy(String mapped) {
        this._val.setValueMappedBy(mapped);
    }

    @Override
    public FieldMetaData getValueMappedByMetaData() {
        return this._val.getValueMappedByMetaData();
    }

    @Override
    public Class<?> getTypeOverride() {
        return this._val.getTypeOverride();
    }

    @Override
    public void setTypeOverride(Class type) {
        this._val.setTypeOverride(type);
    }

    @Override
    public void copy(ValueMetaData vmd) {
        this._val.copy(vmd);
    }

    public boolean isUsedInOrderBy() {
        return this._usedInOrderBy;
    }

    public void setUsedInOrderBy(boolean isUsed) {
        this._usedInOrderBy = isUsed;
    }

    public boolean isValueGenerated() {
        return this._generated;
    }

    public void setValueGenerated(boolean generated) {
        this._generated = generated;
    }

    public boolean isElementCollection() {
        return this._isElementCollection;
    }

    public void setElementCollection(boolean isElementCollection) {
        this._isElementCollection = isElementCollection;
    }

    public String getMappedByIdValue() {
        return this._mappedByIdValue;
    }

    public void setMappedByIdValue(String mappedByIdValue) {
        this._mappedByIdValue = mappedByIdValue;
    }

    public boolean isMappedById() {
        return this._mappedByIdValue != null;
    }

    public int getAccessType() {
        if (AccessCode.isUnknown(this._access)) {
            int fCode = AccessCode.toFieldCode(this.getDeclaringMetaData().getAccessType());
            return fCode;
        }
        return this._access;
    }

    public void setAccessType(int fCode) {
        ClassMetaData owner = this.getDeclaringMetaData();
        owner.mergeFieldAccess(this, fCode);
        this._access = fCode;
    }

    public int getAssociationType() {
        return this._associationType;
    }

    public void setAssociationType(int type) {
        this._associationType = type;
    }

    public boolean isPersistentCollection() {
        return this._persistentCollection;
    }

    public void setPersistentCollection(boolean persistentCollection) {
        this._persistentCollection = persistentCollection;
    }

    public Class<?> getRelationType() {
        if (this._relationType == Unknown.class) {
            this._relationType = this.isDeclaredTypePC() ? this.getDeclaredType() : (this.getElement().isDeclaredTypePC() ? this.getElement().getDeclaredType() : (this.getKey().isDeclaredTypePC() ? this.getKey().getDeclaredType() : null));
        }
        return this._relationType;
    }

    static {
        try {
            DEFAULT_METHOD = Object.class.getMethod("wait", null);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    private class Unknown {
        private Unknown() {
        }
    }

    public static class MemberProvider
    implements Externalizable {
        private transient Member _member;

        public MemberProvider() {
        }

        MemberProvider(Member member) {
            if (member instanceof Constructor) {
                throw new IllegalArgumentException();
            }
            this._member = member;
        }

        public Member getMember() {
            return this._member;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            boolean isField = in.readBoolean();
            Class cls = (Class)in.readObject();
            String memberName = (String)in.readObject();
            try {
                if (isField) {
                    this._member = (Member)AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldAction((Class)cls, (String)memberName));
                } else {
                    Class[] parameterTypes = (Class[])in.readObject();
                    this._member = (Member)AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodAction((Class)cls, (String)memberName, (Class[])parameterTypes));
                }
            }
            catch (SecurityException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            catch (PrivilegedActionException pae) {
                IOException ioe = new IOException(pae.getException().getMessage());
                ioe.initCause(pae);
                throw ioe;
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            boolean isField = this._member instanceof Field;
            out.writeBoolean(isField);
            out.writeObject(this._member.getDeclaringClass());
            out.writeObject(this._member.getName());
            if (!isField) {
                out.writeObject(((Method)this._member).getParameterTypes());
            }
        }
    }
}

