/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import org.apache.openjpa.kernel.OpCallbacks;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StateManagerImpl;

class PDirtyState
extends PCState {
    PDirtyState() {
    }

    @Override
    void initialize(StateManagerImpl context, PCState previous) {
        context.saveFields(false);
    }

    @Override
    void beforeFlush(StateManagerImpl context, boolean logical, OpCallbacks call) {
        context.preFlush(logical, call);
    }

    @Override
    PCState commit(StateManagerImpl context) {
        return HOLLOW;
    }

    @Override
    PCState commitRetain(StateManagerImpl context) {
        return PNONTRANS;
    }

    @Override
    PCState rollback(StateManagerImpl context) {
        return HOLLOW;
    }

    @Override
    PCState rollbackRestore(StateManagerImpl context) {
        context.restoreFields();
        return PNONTRANS;
    }

    @Override
    PCState delete(StateManagerImpl context) {
        context.preDelete();
        return PDELETED;
    }

    @Override
    PCState nontransactional(StateManagerImpl context) {
        return this.error("dirty", context);
    }

    @Override
    PCState release(StateManagerImpl context) {
        return this.error("dirty", context);
    }

    @Override
    boolean isVersionCheckRequired(StateManagerImpl context) {
        return !context.isFlushed() || context.isFlushedDirty();
    }

    @Override
    PCState afterRefresh() {
        return PCLEAN;
    }

    @Override
    PCState afterOptimisticRefresh() {
        return PNONTRANS;
    }

    @Override
    boolean isTransactional() {
        return true;
    }

    @Override
    boolean isPersistent() {
        return true;
    }

    @Override
    boolean isDirty() {
        return true;
    }

    public String toString() {
        return "Persistent-Dirty";
    }
}

