/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util;

import java.util.Arrays;
import java.util.Collection;

public class StringDistance {
    public static String getClosestLevenshteinDistance(String str, String[] candidates) {
        if (candidates == null) {
            return null;
        }
        return StringDistance.getClosestLevenshteinDistance(str, Arrays.asList(candidates));
    }

    public static String getClosestLevenshteinDistance(String str, Collection candidates) {
        return StringDistance.getClosestLevenshteinDistance(str, candidates, Integer.MAX_VALUE);
    }

    public static String getClosestLevenshteinDistance(String str, String[] candidates, int threshold) {
        if (candidates == null) {
            return null;
        }
        return StringDistance.getClosestLevenshteinDistance(str, Arrays.asList(candidates), threshold);
    }

    public static String getClosestLevenshteinDistance(String str, String[] candidates, float thresholdPercentage) {
        if (candidates == null) {
            return null;
        }
        return StringDistance.getClosestLevenshteinDistance(str, Arrays.asList(candidates), thresholdPercentage);
    }

    public static String getClosestLevenshteinDistance(String str, Collection candidates, float thresholdPercentage) {
        if (str == null) {
            return null;
        }
        thresholdPercentage = Math.min(thresholdPercentage, 1.0f);
        thresholdPercentage = Math.max(thresholdPercentage, 0.0f);
        return StringDistance.getClosestLevenshteinDistance(str, candidates, (int)((float)str.length() * thresholdPercentage));
    }

    public static String getClosestLevenshteinDistance(String str, Collection candidates, int threshold) {
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        String minString = null;
        int minValue = Integer.MAX_VALUE;
        for (String candidate : candidates) {
            int distance = StringDistance.getLevenshteinDistance(str, candidate);
            if (distance >= minValue) continue;
            minValue = distance;
            minString = candidate;
        }
        if (minValue <= threshold) {
            return minString;
        }
        return null;
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] matrix = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            matrix[i][0] = i;
        }
        for (int j = 0; j <= m; ++j) {
            matrix[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char si = s.charAt(i - 1);
            for (int j = 1; j <= m; ++j) {
                char tj = t.charAt(j - 1);
                int cost = si == tj ? 0 : 1;
                matrix[i][j] = StringDistance.min(matrix[i - 1][j] + 1, matrix[i][j - 1] + 1, matrix[i - 1][j - 1] + cost);
            }
        }
        return matrix[n][m];
    }

    private static int min(int a, int b, int c) {
        int mi = a;
        if (b < mi) {
            mi = b;
        }
        if (c < mi) {
            mi = c;
        }
        return mi;
    }
}

