/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.identifier;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.identifier.IdentifierConfiguration;
import org.apache.openjpa.lib.identifier.IdentifierRule;
import org.apache.openjpa.lib.identifier.IdentifierUtil;
import org.apache.openjpa.lib.util.Localizer;

public class IdentifierUtilImpl
implements IdentifierUtil,
Configurable {
    private static final Localizer _loc = Localizer.forPackage(IdentifierUtilImpl.class);
    private IdentifierConfiguration _config = null;

    public IdentifierUtilImpl() {
    }

    public IdentifierUtilImpl(IdentifierConfiguration config) {
        this._config = config;
    }

    public void setIdentifierConfiguration(IdentifierConfiguration config) {
        this._config = config;
    }

    public IdentifierConfiguration getIdentifierConfiguration() {
        return this._config;
    }

    public String combineNames(String rule, String name1, String name2) {
        return this.combineNames(this.getNamingRule(rule), name1, name2);
    }

    public String combineNames(String rule, String[] names) {
        return this.combineNames(this.getNamingRule(rule), names);
    }

    public String combineNames(IdentifierConfiguration config, String rule, String[] names) {
        return this.combineNames(config, this.getNamingRule(rule), names);
    }

    public String combineNames(IdentifierRule rule, IdentifierRule[] rules, String[] names) {
        return this.combineNames(this._config, rule, rules, names);
    }

    public String combineNames(IdentifierConfiguration config, IdentifierRule rule, IdentifierRule[] rules, String[] names) {
        boolean delimited = false;
        String combined = null;
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (this.isDelimited(rules[i], name)) {
                delimited = true;
                name = this.removeDelimiters(config, rules[i], name);
            }
            combined = i == 0 ? name : combined + config.getIdentifierConcatenator() + name;
        }
        if (delimited) {
            combined = this.delimit(config, rule, combined.toString()).toString();
        }
        return combined;
    }

    public String combineNames(IdentifierConfiguration config, IdentifierRule rule, String name1, String name2) {
        boolean delimit = false;
        if (this.isDelimited(rule, name1)) {
            name1 = this.removeDelimiters(config, rule, name1);
            delimit = true;
        }
        if (this.isDelimited(rule, name2)) {
            name2 = this.removeDelimiters(config, rule, name2);
            delimit = true;
        }
        String name = name1 + config.getIdentifierConcatenator() + name2;
        return this.delimit(config, rule, name, delimit).toString();
    }

    public String combineNames(IdentifierConfiguration config, IdentifierRule namingRule, String[] names) {
        boolean delimited = false;
        String combined = null;
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            if (this.isDelimited(config, namingRule, name)) {
                delimited = true;
                name = this.removeDelimiters(config, namingRule, name);
            }
            combined = i == 0 ? name : combined + config.getIdentifierConcatenator() + name;
        }
        if (delimited) {
            combined = this.delimit(config, namingRule, combined.toString()).toString();
        }
        return combined;
    }

    public String appendNames(IdentifierRule rule, String name1, String name2) {
        if (this.isDelimited(rule, name1)) {
            name1 = this.removeDelimiters(rule, name1);
        }
        if (this.isDelimited(rule, name2)) {
            name2 = this.removeDelimiters(rule, name2);
        }
        if (name1 == null) {
            name1 = "";
        }
        if (name2 == null) {
            name2 = "";
        }
        String name = name1 + name2;
        return this.delimit(rule, name).toString();
    }

    public String joinNames(IdentifierRule[] rules, String[] names) {
        if (names == null || names.length == 0) {
            return null;
        }
        StringBuilder combinedName = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            combinedName.append(this.delimit(rules[i], names[i]));
            if (i >= names.length - 1) continue;
            combinedName.append(this._config.getIdentifierDelimiter());
        }
        return combinedName.toString();
    }

    public String joinNames(String rule, String[] names) {
        return this.joinNames(this._config, this.getNamingRule(rule), names, this._config.getIdentifierDelimiter());
    }

    public String joinNames(IdentifierRule rule, String[] names) {
        return this.joinNames(this._config, rule, names, this._config.getIdentifierDelimiter());
    }

    public String joinNames(IdentifierRule rule, String[] names, String delimiter) {
        return this.joinNames(this._config, rule, names, delimiter);
    }

    public String joinNames(String rule, String[] names, String delimiter) {
        return this.joinNames(this._config, this.getNamingRule(rule), names, delimiter);
    }

    public String joinNames(IdentifierConfiguration config, IdentifierRule rule, String[] names, String delimiter) {
        if (names == null || names.length == 0) {
            return null;
        }
        StringBuilder combinedName = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) continue;
            combinedName.append(this.delimit(config, rule, names[i], false));
            if (i >= names.length - 1) continue;
            combinedName.append(delimiter);
        }
        return combinedName.toString();
    }

    public String[] splitName(IdentifierConfiguration config, IdentifierRule nrule, String name) {
        return this.splitName(nrule, name, config.getIdentifierDelimiter());
    }

    public String[] splitName(IdentifierRule nrule, String name) {
        return this.splitName(nrule, name, this._config.getIdentifierDelimiter());
    }

    public String[] splitName(IdentifierRule nrule, String name, String nameDelim) {
        if (!this.canSplit(nrule, name, nameDelim) || StringUtils.isEmpty((String)name)) {
            return new String[]{name};
        }
        ArrayList<String> names = new ArrayList<String>(2);
        String pname = name;
        int ndLen = nameDelim.length();
        while (!StringUtils.isEmpty((String)name)) {
            pname = this.splitNameCharDelimiters(name, nameDelim);
            names.add(pname);
            if (pname.length() + ndLen >= name.length()) break;
            name = name.substring(pname.length() + ndLen);
        }
        return names.toArray(new String[names.size()]);
    }

    private String splitNameCharDelimiters(String name, String nameDelim) {
        StringBuilder sname = new StringBuilder("");
        char ld = this._config.getLeadingDelimiter().charAt(0);
        char td = this._config.getTrailingDelimiter().charAt(0);
        char nd = nameDelim.charAt(0);
        int dlvl = 0;
        boolean wasLd = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ld) {
                if (td == ld && wasLd) {
                    --dlvl;
                    wasLd = false;
                } else {
                    wasLd = true;
                    ++dlvl;
                }
            } else if (c == td) {
                --dlvl;
            } else if (c == nd && dlvl == 0 && sname.length() > 0) {
                return sname.toString();
            }
            sname.append(c);
        }
        return sname.toString();
    }

    public static boolean isDoubleQuoted(String name) {
        if (name == null || name.length() < 3) {
            return false;
        }
        return name.startsWith("\"") && name.endsWith("\"");
    }

    public String delimit(IdentifierConfiguration config, IdentifierRule rule, String name) {
        return this.delimit(config, rule, name, false);
    }

    public String delimit(IdentifierRule rule, String name) {
        return this.delimit(this._config, rule, name, false);
    }

    public String delimit(IdentifierRule rule, String name, boolean force) {
        return this.delimit(this._config, rule, name, force);
    }

    public String delimit(IdentifierConfiguration config, IdentifierRule rule, String name, boolean force) {
        if (!rule.getCanDelimit() || StringUtils.isEmpty((String)name)) {
            return name;
        }
        if (force && !this.isDelimited(config, rule, name) || this.requiresDelimiters(config, rule, name)) {
            return config.getLeadingDelimiter() + name + config.getTrailingDelimiter();
        }
        return name;
    }

    public boolean isDelimited(IdentifierRule rule, String name) {
        return this.isDelimited(this._config, rule, name);
    }

    public boolean isDelimited(IdentifierConfiguration config, IdentifierRule rule, String name) {
        if (name == null || name.length() <= 3) {
            return false;
        }
        return name.startsWith(config.getLeadingDelimiter()) && name.endsWith(config.getTrailingDelimiter());
    }

    public String removeDelimiters(IdentifierConfiguration config, String rule, String name) {
        return this.removeDelimiters(this._config, this.getNamingRule(rule), name, this._config.getLeadingDelimiter(), this._config.getTrailingDelimiter());
    }

    public String removeDelimiters(IdentifierRule rule, String name) {
        return this.removeDelimiters(this._config, rule, name, this._config.getLeadingDelimiter(), this._config.getTrailingDelimiter());
    }

    public String removeDelimiters(IdentifierConfiguration config, IdentifierRule rule, String name) {
        return this.removeDelimiters(config, rule, name, this._config.getLeadingDelimiter(), this._config.getTrailingDelimiter());
    }

    public boolean requiresDelimiters(IdentifierRule rule, String name) {
        return this.requiresDelimiters(this._config, rule, name);
    }

    public boolean requiresDelimiters(IdentifierConfiguration config, IdentifierRule rule, String name) {
        if (rule == null) {
            throw new IllegalArgumentException(_loc.get("no-rules-provided").getMessage());
        }
        return rule.getCanDelimit() && !this.isDelimited(config, rule, name) && rule.requiresDelimiters(name);
    }

    public boolean isReservedWord(IdentifierRule rule, String name) {
        if (rule == null) {
            System.out.println("NAmingConfig: " + this._config.getClass().getName());
            throw new IllegalArgumentException("Naming rule is null!");
        }
        if (rule.getReservedWords() == null) {
            return false;
        }
        if (!this.isDelimited(rule, name)) {
            name = name.toUpperCase();
        }
        return rule.getReservedWords().contains(name);
    }

    public boolean isReservedWord(String rule, String name) {
        return this.isReservedWord(this._config.getIdentifierRule(rule), name);
    }

    protected String removeDelimiters(IdentifierConfiguration config, IdentifierRule rule, String name, String leading, String trailing) {
        if (name == null) {
            return null;
        }
        if (this.isDelimited(config, rule, name)) {
            String id = name.substring(leading.length(), name.length() - trailing.length());
            return id;
        }
        return name;
    }

    public String combineNames(String rule, String[] rules, String[] names) {
        return this.combineNames(this.getNamingRule(rule), this.getNamingRules(rules), names);
    }

    public String truncateName(String rule, String name, int length) {
        return this.truncateName(this.getNamingRule(rule), name, length);
    }

    public String truncateName(IdentifierRule namingRule, String name, int length) {
        String tName = name;
        boolean delimited = this.isDelimited(namingRule, name);
        if (delimited) {
            tName = this.removeDelimiters(namingRule, name);
        }
        if (tName.length() <= length) {
            return name;
        }
        tName = tName.substring(0, tName.length() - length);
        if (delimited) {
            tName = this.delimit(namingRule, tName).toString();
        }
        return tName;
    }

    public String delimit(String rule, String name) {
        return this.delimit(this.getNamingRule(rule), name);
    }

    public String delimit(String rule, String name, boolean force) {
        return this.delimit(this.getNamingRule(rule), name, force);
    }

    public boolean isDelimited(String rule, String name) {
        return this.isDelimited(this.getNamingRule(rule), name);
    }

    public String removeDelimiters(String rule, String name) {
        return this.removeDelimiters(this.getNamingRule(rule), name);
    }

    public boolean requiresDelimiters(String rule, String name) {
        return this.requiresDelimiters(this.getNamingRule(rule), name);
    }

    public String[] splitName(IdentifierConfiguration config, String rule, String name) {
        return this.splitName(config, this.getNamingRule(rule), name);
    }

    public String[] splitName(String rule, String name) {
        return this.splitName(this._config, this.getNamingRule(rule), name);
    }

    public String joinNames(String[] rules, String[] names) {
        return this.joinNames(this.getNamingRules(rules), names);
    }

    private IdentifierRule getNamingRule(String rule) {
        return this._config.getIdentifierRule(rule);
    }

    public String appendNames(String rule, String name1, String name2) {
        return this.appendNames(this.getNamingRule(rule), name1, name2);
    }

    public String removeHungarianNotation(IdentifierRule rule, String name) {
        boolean delimited = this.isDelimited(rule, name);
        if (delimited) {
            name = this.removeDelimiters(rule, name);
        }
        char[] chname = name.toCharArray();
        int newStart = 0;
        for (int i = 0; i < chname.length; ++i) {
            if (!Character.isUpperCase(chname[i])) continue;
            newStart = i;
            break;
        }
        name = name.substring(newStart);
        if (delimited) {
            name = this.delimit(rule, name).toString();
        }
        return name;
    }

    public String removeHungarianNotation(String rule, String name) {
        return this.removeHungarianNotation(this.getNamingRule(rule), name);
    }

    public String[] splitName(String nrule, String name, String nameDelim) {
        return this.splitName(this.getNamingRule(nrule), name, nameDelim);
    }

    public String convert(IdentifierConfiguration config, String rule, String name) {
        if (!this.needsConversion(config)) {
            return name;
        }
        IdentifierRule orule = this.getIdentifierConfiguration().getIdentifierRule(rule);
        IdentifierRule nrule = config.getIdentifierRule(rule);
        boolean delimit = this.isDelimited(config, orule, name);
        if (delimit) {
            name = this.removeDelimiters(config, orule, name, config.getLeadingDelimiter(), config.getTrailingDelimiter());
            return this.delimit(this.getIdentifierConfiguration(), nrule, name, delimit).toString();
        }
        return name;
    }

    public String convertFull(IdentifierConfiguration config, String rule, String fullName) {
        if (!this.needsConversion(config)) {
            return fullName;
        }
        String[] names = this.splitName(config, rule, fullName);
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.convert(config, rule, names[i]);
        }
        if (names.length == 1) {
            return names[0];
        }
        return this.joinNames(this.getIdentifierConfiguration(), config.getIdentifierRule(rule), names, this.getIdentifierConfiguration().getIdentifierDelimiter());
    }

    public String combineFull(IdentifierConfiguration config, String rule, String fullName) {
        if (!this.needsConversion(config)) {
            return fullName;
        }
        String[] names = this.splitName(config, rule, fullName);
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.convert(config, rule, names[i]);
        }
        return this.joinNames(config, config.getIdentifierRule(rule), names, config.getIdentifierDelimiter());
    }

    protected boolean needsConversion(IdentifierConfiguration config) {
        return !config.getConversionKey().equals(this.getIdentifierConfiguration().getConversionKey());
    }

    private IdentifierRule[] getNamingRules(String[] rules) {
        IdentifierRule[] nrules = new IdentifierRule[rules.length];
        for (int i = 0; i < rules.length; ++i) {
            nrules[i] = this._config.getIdentifierRule(rules[i]);
        }
        return nrules;
    }

    public void endConfiguration() {
    }

    public void setConfiguration(Configuration conf) {
    }

    public void startConfiguration() {
    }

    public boolean canSplit(String rule, String name) {
        return this.canSplit(this.getNamingRule(rule), name, this._config.getIdentifierDelimiter());
    }

    public boolean canSplit(IdentifierRule rule, String name) {
        return this.canSplit(rule, name, this._config.getIdentifierDelimiter());
    }

    public boolean canSplit(String rule, String name, String delim) {
        return this.canSplit(this.getNamingRule(rule), name);
    }

    public boolean canSplit(IdentifierRule rule, String name, String delim) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return name.contains(delim);
    }

    public String combineNames(IdentifierRule rule, String[] names) {
        return this.combineNames(this._config, rule, names);
    }

    public String combineNames(IdentifierRule rule, String name1, String name2) {
        return this.combineNames(this._config, rule, name1, name2);
    }
}

