/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.enhance.PCClassFileTransformer;
import org.apache.openjpa.kernel.Bootstrap;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.PersistenceProductDerivation;
import org.apache.openjpa.util.ClassResolver;

public class PersistenceProviderImpl
implements PersistenceProvider {
    static final String CLASS_TRANSFORMER_OPTIONS = "ClassTransformerOptions";
    private static final String EMF_POOL = "EntityManagerFactoryPool";
    private static final Localizer _loc = Localizer.forPackage(PersistenceProviderImpl.class);

    public OpenJPAEntityManagerFactory createEntityManagerFactory(String name, String resource, Map m) {
        PersistenceProductDerivation pd = new PersistenceProductDerivation();
        try {
            Object poolValue = Configurations.removeProperty((String)EMF_POOL, (Map)m);
            ConfigurationProvider cp = pd.load(resource, name, m);
            if (cp == null) {
                return null;
            }
            BrokerFactory factory = this.getBrokerFactory(cp, poolValue, null);
            return JPAFacadeHelper.toEntityManagerFactory(factory);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    private BrokerFactory getBrokerFactory(ConfigurationProvider cp, Object poolValue, ClassLoader loader) {
        if (poolValue instanceof String && ("true".equalsIgnoreCase((String)poolValue) || "false".equalsIgnoreCase((String)poolValue))) {
            poolValue = Boolean.valueOf((String)poolValue);
        }
        if (poolValue != null && !(poolValue instanceof Boolean)) {
            throw new IllegalArgumentException(poolValue.toString());
        }
        if (poolValue == null || !((Boolean)poolValue).booleanValue()) {
            return Bootstrap.newBrokerFactory((ConfigurationProvider)cp, (ClassLoader)loader);
        }
        return Bootstrap.getBrokerFactory((ConfigurationProvider)cp, (ClassLoader)loader);
    }

    public OpenJPAEntityManagerFactory createEntityManagerFactory(String name, Map m) {
        return this.createEntityManagerFactory(name, null, m);
    }

    public OpenJPAEntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo pui, Map m) {
        PersistenceProductDerivation pd = new PersistenceProductDerivation();
        try {
            Object poolValue = Configurations.removeProperty((String)EMF_POOL, (Map)m);
            ConfigurationProvider cp = pd.load(pui, m);
            if (cp == null) {
                return null;
            }
            Exception transformerException = null;
            String ctOpts = (String)Configurations.getProperty((String)CLASS_TRANSFORMER_OPTIONS, (Map)pui.getProperties());
            try {
                pui.addTransformer((ClassTransformer)new ClassTransformerImpl(cp, ctOpts, pui.getNewTempClassLoader(), this.newConfigurationImpl()));
            }
            catch (Exception e) {
                transformerException = e;
            }
            if (!Configurations.containsProperty((String)"BrokerImpl", (Map)cp.getProperties())) {
                cp.addProperty("openjpa.BrokerImpl", (Object)this.getDefaultBrokerAlias());
            }
            BrokerFactory factory = this.getBrokerFactory(cp, poolValue, pui.getClassLoader());
            if (transformerException != null) {
                Log log = factory.getConfiguration().getLog("openjpa.Runtime");
                if (log.isTraceEnabled()) {
                    log.warn((Object)_loc.get("transformer-registration-error-ex", (Object)pui), (Throwable)transformerException);
                } else {
                    log.warn((Object)_loc.get("transformer-registration-error", (Object)pui));
                }
            }
            return JPAFacadeHelper.toEntityManagerFactory(factory);
        }
        catch (Exception e) {
            throw PersistenceExceptions.toPersistenceException(e);
        }
    }

    protected String getDefaultBrokerAlias() {
        return "non-finalizing";
    }

    protected OpenJPAConfiguration newConfigurationImpl() {
        return new OpenJPAConfigurationImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassTransformerImpl
    implements ClassTransformer {
        private final ClassFileTransformer _trans;

        private ClassTransformerImpl(ConfigurationProvider cp, String props, final ClassLoader tmpLoader, OpenJPAConfiguration conf) {
            cp.setInto((Configuration)conf);
            conf.setClassResolver(new ClassResolver(){

                public ClassLoader getClassLoader(Class context, ClassLoader env) {
                    return tmpLoader;
                }
            });
            conf.setReadOnly(1);
            MetaDataRepository repos = conf.getMetaDataRepositoryInstance();
            repos.setResolve(2, false);
            this._trans = new PCClassFileTransformer(repos, Configurations.parseProperties((String)props), tmpLoader);
        }

        public byte[] transform(ClassLoader cl, String name, Class<?> previousVersion, ProtectionDomain pd, byte[] bytes) throws IllegalClassFormatException {
            return this._trans.transform(cl, name, previousVersion, pd, bytes);
        }
    }
}

