/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.criteria;

import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import org.apache.openjpa.kernel.exps.AbstractExpressionBuilder;
import org.apache.openjpa.kernel.exps.Context;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.persistence.criteria.AliasContext;
import org.apache.openjpa.persistence.criteria.CriteriaQueryImpl;
import org.apache.openjpa.persistence.criteria.FromImpl;
import org.apache.openjpa.persistence.criteria.SubqueryImpl;
import org.apache.openjpa.persistence.meta.MetamodelImpl;
import org.apache.openjpa.persistence.meta.Types;

class RootImpl<X>
extends FromImpl<X, X>
implements Root<X> {
    private final Types.Entity<X> _entity;

    public RootImpl(Types.Entity<X> type) {
        super(type);
        this._entity = type;
    }

    @Override
    public EntityType<X> getModel() {
        return this._entity;
    }

    public void addToContext(ExpressionFactory factory, MetamodelImpl model, CriteriaQueryImpl<?> q) {
        String alias = q.getAlias(this);
        Value var = factory.newBoundVariable(alias, AbstractExpressionBuilder.TYPE_OBJECT);
        var.setMetaData(this._entity.meta);
        Context currContext = q.ctx();
        currContext.addSchema(alias, this._entity.meta);
        currContext.addVariable(alias, var);
        if (currContext.schemaAlias == null) {
            currContext.schemaAlias = alias;
        }
    }

    @Override
    public Value toValue(ExpressionFactory factory, CriteriaQueryImpl<?> c) {
        SubqueryImpl<?> subquery = c.getDelegator();
        Path var = null;
        Value val = null;
        String alias = c.getAlias(this);
        if (!alias.equalsIgnoreCase(c.ctx().schemaAlias) && (val = c.getRegisteredRootVariable(this)) != null) {
            var = factory.newPath(val);
        } else if (this.inSubquery(subquery)) {
            Subquery subQ = subquery.getSubQ();
            var = factory.newPath((Value)subQ);
        } else {
            var = factory.newPath();
            var.setSchemaAlias(alias);
        }
        var.setMetaData(this._entity.meta);
        return var;
    }

    @Override
    public Expression toKernelExpression(ExpressionFactory factory, CriteriaQueryImpl<?> c) {
        Value path = this.toValue(factory, c);
        Value var = factory.newBoundVariable(c.getAlias(this), this._entity.meta.getDescribedType());
        return factory.bindVariable(var, path);
    }

    @Override
    public StringBuilder asValue(AliasContext q) {
        Value v = q.getRegisteredRootVariable(this);
        if (v != null) {
            return new StringBuilder(v.getAlias());
        }
        v = q.getRegisteredValue(this);
        if (v != null) {
            return new StringBuilder(v.getAlias());
        }
        if (q.isRegistered(this)) {
            return new StringBuilder(q.getRegisteredValue(this).getName());
        }
        return new StringBuilder().append(Character.toLowerCase(this._entity.getName().charAt(0)));
    }

    @Override
    public StringBuilder asVariable(AliasContext q) {
        return new StringBuilder(this._entity.getName()).append(" ").append((CharSequence)this.asValue(q));
    }
}

