/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jdbc;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.ColumnResult;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FieldResult;
import javax.persistence.Inheritance;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.ClassMappingInfo;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingInfo;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.meta.SequenceMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.EnumValueHandler;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPriv5Helper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.AnnotationPersistenceMetaDataParser;
import org.apache.openjpa.persistence.jdbc.ClassCriteria;
import org.apache.openjpa.persistence.jdbc.Columns;
import org.apache.openjpa.persistence.jdbc.ContainerTable;
import org.apache.openjpa.persistence.jdbc.DataStoreIdColumn;
import org.apache.openjpa.persistence.jdbc.DiscriminatorStrategy;
import org.apache.openjpa.persistence.jdbc.EagerFetchMode;
import org.apache.openjpa.persistence.jdbc.ElementClassCriteria;
import org.apache.openjpa.persistence.jdbc.ElementColumn;
import org.apache.openjpa.persistence.jdbc.ElementColumns;
import org.apache.openjpa.persistence.jdbc.ElementEmbeddedMapping;
import org.apache.openjpa.persistence.jdbc.ElementForeignKey;
import org.apache.openjpa.persistence.jdbc.ElementIndex;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumn;
import org.apache.openjpa.persistence.jdbc.ElementJoinColumns;
import org.apache.openjpa.persistence.jdbc.ElementNonpolymorphic;
import org.apache.openjpa.persistence.jdbc.ElementStrategy;
import org.apache.openjpa.persistence.jdbc.EmbeddedMapping;
import org.apache.openjpa.persistence.jdbc.FetchMode;
import org.apache.openjpa.persistence.jdbc.ForeignKey;
import org.apache.openjpa.persistence.jdbc.ForeignKeyAction;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.persistence.jdbc.KeyClassCriteria;
import org.apache.openjpa.persistence.jdbc.KeyColumn;
import org.apache.openjpa.persistence.jdbc.KeyColumns;
import org.apache.openjpa.persistence.jdbc.KeyEmbeddedMapping;
import org.apache.openjpa.persistence.jdbc.KeyForeignKey;
import org.apache.openjpa.persistence.jdbc.KeyIndex;
import org.apache.openjpa.persistence.jdbc.KeyJoinColumn;
import org.apache.openjpa.persistence.jdbc.KeyJoinColumns;
import org.apache.openjpa.persistence.jdbc.KeyNonpolymorphic;
import org.apache.openjpa.persistence.jdbc.KeyStrategy;
import org.apache.openjpa.persistence.jdbc.MappingOverride;
import org.apache.openjpa.persistence.jdbc.MappingOverrides;
import org.apache.openjpa.persistence.jdbc.MappingTag;
import org.apache.openjpa.persistence.jdbc.Nonpolymorphic;
import org.apache.openjpa.persistence.jdbc.NonpolymorphicType;
import org.apache.openjpa.persistence.jdbc.OrderColumn;
import org.apache.openjpa.persistence.jdbc.Strategy;
import org.apache.openjpa.persistence.jdbc.SubclassFetchMode;
import org.apache.openjpa.persistence.jdbc.Unique;
import org.apache.openjpa.persistence.jdbc.VersionColumn;
import org.apache.openjpa.persistence.jdbc.VersionColumns;
import org.apache.openjpa.persistence.jdbc.VersionStrategy;
import org.apache.openjpa.persistence.jdbc.XEmbeddedMapping;
import org.apache.openjpa.persistence.jdbc.XJoinColumn;
import org.apache.openjpa.persistence.jdbc.XJoinColumns;
import org.apache.openjpa.persistence.jdbc.XMappingOverride;
import org.apache.openjpa.persistence.jdbc.XMappingOverrides;
import org.apache.openjpa.persistence.jdbc.XSecondaryTable;
import org.apache.openjpa.persistence.jdbc.XSecondaryTables;
import org.apache.openjpa.persistence.jdbc.XTable;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.UnsupportedException;
import org.apache.openjpa.util.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationPersistenceMappingParser
extends AnnotationPersistenceMetaDataParser {
    protected static final int TRUE = 1;
    protected static final int FALSE = 2;
    private static final Localizer _loc = Localizer.forPackage(AnnotationPersistenceMappingParser.class);
    private static final Map<Class, MappingTag> _tags = new HashMap<Class, MappingTag>();

    public AnnotationPersistenceMappingParser(JDBCConfiguration conf) {
        super((OpenJPAConfiguration)conf);
    }

    protected void parsePackageMappingAnnotations(Package pkg) {
        block3: for (Annotation anno : pkg.getDeclaredAnnotations()) {
            MappingTag tag = _tags.get(anno.annotationType());
            if (tag == null) {
                this.handleUnknownPackageMappingAnnotation(pkg, anno);
                continue;
            }
            switch (tag) {
                case TABLE_GEN: {
                    this.parseTableGenerator(pkg, (TableGenerator)anno);
                    continue block3;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", (Object)pkg, (Object)((Object)anno).toString()));
                }
            }
        }
    }

    protected boolean handleUnknownPackageMappingAnnotation(Package pkg, Annotation anno) {
        return false;
    }

    private void parseTableGenerator(AnnotatedElement el, TableGenerator gen) {
        SequenceMapping meta;
        String name = gen.name();
        if (StringUtils.isEmpty((String)name)) {
            throw new MetaDataException(_loc.get("no-gen-name", (Object)el));
        }
        Log log = this.getLog();
        if (log.isTraceEnabled()) {
            log.trace((Object)_loc.get("parse-gen", (Object)name));
        }
        if ((meta = (SequenceMapping)this.getRepository().getCachedSequenceMetaData(name)) != null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)_loc.get("dup-gen", (Object)name, (Object)el));
            }
            return;
        }
        meta = (SequenceMapping)this.getRepository().addSequenceMetaData(name);
        meta.setSequencePlugin("value-table");
        meta.setTable(AnnotationPersistenceMappingParser.toTableName(gen.schema(), gen.table()));
        meta.setPrimaryKeyColumn(gen.pkColumnName());
        meta.setSequenceColumn(gen.valueColumnName());
        meta.setPrimaryKeyValue(gen.pkColumnValue());
        meta.setInitialValue(gen.initialValue());
        meta.setAllocate(gen.allocationSize());
        meta.setSource(this.getSourceFile(), (Object)(el instanceof Class ? el : null), 1);
        if (gen.uniqueConstraints().length > 0 && log.isWarnEnabled()) {
            log.warn((Object)_loc.get("unique-constraints", (Object)name));
        }
    }

    protected void parseClassMappingAnnotations(ClassMetaData meta) {
        ClassMapping cm = (ClassMapping)meta;
        Class cls = cm.getDescribedType();
        block29: for (Annotation anno : cls.getDeclaredAnnotations()) {
            MappingTag tag = _tags.get(anno.annotationType());
            if (tag == null) {
                this.handleUnknownClassMappingAnnotation(cm, anno);
                continue;
            }
            switch (tag) {
                case ASSOC_OVERRIDE: {
                    this.parseAssociationOverrides(cm, (AssociationOverride)anno);
                    continue block29;
                }
                case ASSOC_OVERRIDES: {
                    this.parseAssociationOverrides(cm, ((AssociationOverrides)anno).value());
                    continue block29;
                }
                case ATTR_OVERRIDE: {
                    this.parseAttributeOverrides(cm, (AttributeOverride)anno);
                    continue block29;
                }
                case ATTR_OVERRIDES: {
                    this.parseAttributeOverrides(cm, ((AttributeOverrides)anno).value());
                    continue block29;
                }
                case DISCRIM_COL: {
                    this.parseDiscriminatorColumn(cm, (DiscriminatorColumn)anno);
                    continue block29;
                }
                case DISCRIM_VAL: {
                    cm.getDiscriminator().getMappingInfo().setValue(((DiscriminatorValue)anno).value());
                    if (!Modifier.isAbstract(cm.getDescribedType().getModifiers()) || !this.getLog().isInfoEnabled()) continue block29;
                    this.getLog().info((Object)_loc.get("discriminator-on-abstract-class", (Object)cm.getDescribedType().getName()));
                    continue block29;
                }
                case INHERITANCE: {
                    this.parseInheritance(cm, (Inheritance)anno);
                    continue block29;
                }
                case PK_JOIN_COL: {
                    this.parsePrimaryKeyJoinColumns(cm, (PrimaryKeyJoinColumn)anno);
                    continue block29;
                }
                case PK_JOIN_COLS: {
                    this.parsePrimaryKeyJoinColumns(cm, ((PrimaryKeyJoinColumns)anno).value());
                    continue block29;
                }
                case SECONDARY_TABLE: {
                    this.parseSecondaryTables(cm, (SecondaryTable)anno);
                    continue block29;
                }
                case SECONDARY_TABLES: {
                    this.parseSecondaryTables(cm, ((SecondaryTables)anno).value());
                    continue block29;
                }
                case SQL_RESULT_SET_MAPPING: {
                    this.parseSQLResultSetMappings(cm, (SqlResultSetMapping)anno);
                    continue block29;
                }
                case SQL_RESULT_SET_MAPPINGS: {
                    this.parseSQLResultSetMappings(cm, ((SqlResultSetMappings)anno).value());
                    continue block29;
                }
                case TABLE: {
                    this.parseTable(cm, (Table)anno);
                    continue block29;
                }
                case TABLE_GEN: {
                    this.parseTableGenerator(cls, (TableGenerator)anno);
                    continue block29;
                }
                case DATASTORE_ID_COL: {
                    this.parseDataStoreIdColumn(cm, (DataStoreIdColumn)anno);
                    continue block29;
                }
                case DISCRIM_STRAT: {
                    cm.getDiscriminator().getMappingInfo().setStrategy(((DiscriminatorStrategy)anno).value());
                    continue block29;
                }
                case FK: {
                    this.parseForeignKey((MappingInfo)cm.getMappingInfo(), (ForeignKey)anno);
                    continue block29;
                }
                case MAPPING_OVERRIDE: {
                    this.parseMappingOverrides(cm, (MappingOverride)anno);
                    continue block29;
                }
                case MAPPING_OVERRIDES: {
                    this.parseMappingOverrides(cm, ((MappingOverrides)anno).value());
                    continue block29;
                }
                case STRAT: {
                    cm.getMappingInfo().setStrategy(((Strategy)anno).value());
                    continue block29;
                }
                case SUBCLASS_FETCH_MODE: {
                    cm.setSubclassFetchMode(AnnotationPersistenceMappingParser.toEagerFetchModeConstant(((SubclassFetchMode)anno).value()));
                    continue block29;
                }
                case VERSION_COL: {
                    this.parseVersionColumns(cm, (VersionColumn)anno);
                    continue block29;
                }
                case VERSION_COLS: {
                    this.parseVersionColumns(cm, ((VersionColumns)anno).value());
                    continue block29;
                }
                case VERSION_STRAT: {
                    cm.getVersion().getMappingInfo().setStrategy(((VersionStrategy)anno).value());
                    continue block29;
                }
                case X_MAPPING_OVERRIDE: {
                    this.parseMappingOverrides(cm, (XMappingOverride)anno);
                    continue block29;
                }
                case X_MAPPING_OVERRIDES: {
                    this.parseMappingOverrides(cm, ((XMappingOverrides)anno).value());
                    continue block29;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", (Object)cm, (Object)anno));
                }
            }
        }
    }

    protected boolean handleUnknownClassMappingAnnotation(ClassMapping cls, Annotation anno) {
        return false;
    }

    private void parseAssociationOverrides(ClassMapping cm, AssociationOverride ... assocs) {
        for (AssociationOverride assoc : assocs) {
            JoinColumn[] scols;
            if (StringUtils.isEmpty((String)assoc.name())) {
                throw new MetaDataException(_loc.get("no-override-name", (Object)cm));
            }
            FieldMapping sup = (FieldMapping)cm.getDefinedSuperclassField(assoc.name());
            if (sup == null) {
                sup = (FieldMapping)cm.addDefinedSuperclassField(assoc.name(), Object.class, Object.class);
            }
            if ((scols = assoc.joinColumns()) == null || scols.length == 0) continue;
            ArrayList<Column> jcols = new ArrayList<Column>(scols.length);
            int unique = 0;
            for (JoinColumn scol : scols) {
                unique |= scol.unique() ? 1 : 2;
                jcols.add(AnnotationPersistenceMappingParser.newColumn(scol));
            }
            this.setColumns(sup, (MappingInfo)sup.getValueInfo(), jcols, unique);
        }
    }

    private void parseAttributeOverrides(ClassMapping cm, AttributeOverride ... attrs) {
        for (AttributeOverride attr : attrs) {
            if (StringUtils.isEmpty((String)attr.name())) {
                throw new MetaDataException(_loc.get("no-override-name", (Object)cm));
            }
            FieldMapping sup = (FieldMapping)cm.getDefinedSuperclassField(attr.name());
            if (sup == null) {
                sup = (FieldMapping)cm.addDefinedSuperclassField(attr.name(), Object.class, Object.class);
            }
            if (attr.column() == null) continue;
            this.parseColumns(sup, attr.column());
        }
    }

    private void parsePrimaryKeyJoinColumns(ClassMapping cm, PrimaryKeyJoinColumn ... joins) {
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        for (PrimaryKeyJoinColumn join : joins) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(join));
        }
        cm.getMappingInfo().setColumns(cols);
    }

    private static Column newColumn(PrimaryKeyJoinColumn join) {
        Column col = new Column();
        col.setFlag(128, true);
        if (!StringUtils.isEmpty((String)join.name())) {
            col.setName(join.name());
        }
        if (!StringUtils.isEmpty((String)join.columnDefinition())) {
            col.setTypeName(join.columnDefinition());
        }
        if (!StringUtils.isEmpty((String)join.referencedColumnName())) {
            col.setTarget(join.referencedColumnName());
        }
        return col;
    }

    private void parseSecondaryTables(ClassMapping cm, SecondaryTable ... tables) {
        ClassMappingInfo info = cm.getMappingInfo();
        Log log = this.getLog();
        boolean warnUnique = false;
        for (SecondaryTable table : tables) {
            String name = table.name();
            if (StringUtils.isEmpty((String)name)) {
                throw new MetaDataException(_loc.get("second-name", (Object)cm));
            }
            if (!StringUtils.isEmpty((String)table.schema())) {
                name = table.schema() + "." + name;
            }
            if (table.pkJoinColumns().length > 0) {
                ArrayList<Column> joins = new ArrayList<Column>(table.pkJoinColumns().length);
                for (PrimaryKeyJoinColumn join : table.pkJoinColumns()) {
                    joins.add(AnnotationPersistenceMappingParser.newColumn(join));
                }
                info.setSecondaryTableJoinColumns(name, joins);
            }
            warnUnique |= table.uniqueConstraints().length > 0;
        }
        if (warnUnique && log.isWarnEnabled()) {
            log.warn((Object)_loc.get("unique-constraints", (Object)cm));
        }
    }

    private void parseTable(ClassMapping cm, Table table) {
        String tableName = AnnotationPersistenceMappingParser.toTableName(table.schema(), table.name());
        if (tableName != null) {
            cm.getMappingInfo().setTableName(tableName);
        }
        for (UniqueConstraint uniqueConstraint : table.uniqueConstraints()) {
            org.apache.openjpa.jdbc.schema.Unique unique = AnnotationPersistenceMappingParser.newUnique(cm, null, uniqueConstraint.columnNames());
            cm.getMappingInfo().addUnique(unique);
        }
    }

    private static String toTableName(String schema, String table) {
        if (StringUtils.isEmpty((String)table)) {
            return null;
        }
        if (StringUtils.isEmpty((String)schema)) {
            return table;
        }
        return schema + "." + table;
    }

    private void parseSQLResultSetMappings(ClassMapping cm, SqlResultSetMapping ... annos) {
        MappingRepository repos = (MappingRepository)this.getRepository();
        Log log = this.getLog();
        for (SqlResultSetMapping anno : annos) {
            QueryResultMapping result;
            if (log.isTraceEnabled()) {
                log.trace((Object)_loc.get("parse-sqlrsmapping", (Object)anno.name()));
            }
            if ((result = repos.getCachedQueryResultMapping(null, anno.name())) != null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)_loc.get("dup-sqlrsmapping", (Object)anno.name(), (Object)cm));
                continue;
            }
            result = repos.addQueryResultMapping(null, anno.name());
            result.setSource(this.getSourceFile(), (Object)cm.getDescribedType(), 1);
            for (EntityResult entityResult : anno.entities()) {
                QueryResultMapping.PCResult entityResult2 = result.addPCResult(entityResult.entityClass());
                if (!StringUtils.isEmpty((String)entityResult.discriminatorColumn())) {
                    entityResult2.addMapping("<discriminator>", (Object)entityResult.discriminatorColumn());
                }
                for (FieldResult field : entityResult.fields()) {
                    entityResult2.addMapping(field.name(), (Object)field.column());
                }
            }
            for (EntityResult entityResult : anno.columns()) {
                result.addColumnResult((Object)entityResult.name());
            }
        }
    }

    private void parseDiscriminatorColumn(ClassMapping cm, DiscriminatorColumn dcol) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)dcol.name())) {
            col.setName(dcol.name());
        }
        if (!StringUtils.isEmpty((String)dcol.columnDefinition())) {
            col.setTypeName(dcol.columnDefinition());
        }
        Discriminator discrim = cm.getDiscriminator();
        switch (dcol.discriminatorType()) {
            case CHAR: {
                col.setJavaType(2);
                discrim.setJavaType(2);
                break;
            }
            case INTEGER: {
                col.setJavaType(5);
                if (dcol.length() != 31) {
                    col.setSize(dcol.length());
                }
                discrim.setJavaType(5);
                break;
            }
            default: {
                col.setJavaType(9);
                col.setSize(dcol.length());
                discrim.setJavaType(9);
            }
        }
        cm.getDiscriminator().getMappingInfo().setColumns(Arrays.asList(col));
    }

    private void parseInheritance(ClassMapping cm, Inheritance inherit) {
        ClassMappingInfo info = cm.getMappingInfo();
        switch (inherit.strategy()) {
            case SINGLE_TABLE: {
                info.setHierarchyStrategy("flat");
                break;
            }
            case JOINED: {
                info.setHierarchyStrategy("vertical");
                break;
            }
            case TABLE_PER_CLASS: {
                info.setHierarchyStrategy("full");
                break;
            }
            default: {
                throw new InternalException();
            }
        }
    }

    private void parseMappingOverrides(ClassMapping cm, MappingOverride ... overs) {
        for (MappingOverride over : overs) {
            if (StringUtils.isEmpty((String)over.name())) {
                throw new MetaDataException(_loc.get("no-override-name", (Object)cm));
            }
            FieldMapping sup = (FieldMapping)cm.getDefinedSuperclassField(over.name());
            if (sup == null) {
                sup = (FieldMapping)cm.addDefinedSuperclassField(over.name(), Object.class, Object.class);
            }
            this.populate(sup, over);
        }
    }

    private void populate(FieldMapping fm, MappingOverride over) {
        if (over.containerTable().specified()) {
            this.parseContainerTable(fm, over.containerTable());
        }
        this.parseColumns(fm, over.columns());
        this.parseXJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, over.joinColumns());
        this.parseElementJoinColumns(fm, over.elementJoinColumns());
    }

    private void parseDataStoreIdColumn(ClassMapping cm, DataStoreIdColumn id) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)id.name())) {
            col.setName(id.name());
        }
        if (!StringUtils.isEmpty((String)id.columnDefinition())) {
            col.setTypeName(id.columnDefinition());
        }
        if (id.precision() != 0) {
            col.setSize(id.precision());
        }
        col.setFlag(2, !id.insertable());
        col.setFlag(4, !id.updatable());
        cm.getMappingInfo().setColumns(Arrays.asList(col));
    }

    private void parseForeignKey(MappingInfo info, ForeignKey fk) {
        this.parseForeignKey(info, fk.name(), fk.enabled(), fk.deferred(), fk.deleteAction(), fk.updateAction());
    }

    protected void parseForeignKey(MappingInfo info, String name, boolean enabled, boolean deferred, ForeignKeyAction deleteAction, ForeignKeyAction updateAction) {
        if (!enabled) {
            info.setCanForeignKey(false);
            return;
        }
        org.apache.openjpa.jdbc.schema.ForeignKey fk = new org.apache.openjpa.jdbc.schema.ForeignKey();
        if (!StringUtils.isEmpty((String)name)) {
            fk.setName(name);
        }
        fk.setDeferred(deferred);
        fk.setDeleteAction(this.toForeignKeyAction(deleteAction));
        fk.setUpdateAction(this.toForeignKeyAction(updateAction));
        info.setForeignKey(fk);
    }

    private int toForeignKeyAction(ForeignKeyAction action) {
        switch (action) {
            case RESTRICT: {
                return 2;
            }
            case CASCADE: {
                return 3;
            }
            case NULL: {
                return 4;
            }
            case DEFAULT: {
                return 5;
            }
        }
        throw new InternalException();
    }

    private void parseIndex(MappingInfo info, Index idx) {
        this.parseIndex(info, idx.name(), idx.enabled(), idx.unique());
    }

    protected void parseIndex(MappingInfo info, String name, boolean enabled, boolean unique) {
        if (!enabled) {
            info.setCanIndex(false);
            return;
        }
        org.apache.openjpa.jdbc.schema.Index idx = new org.apache.openjpa.jdbc.schema.Index();
        if (!StringUtils.isEmpty((String)name)) {
            idx.setName(name);
        }
        idx.setUnique(unique);
        info.setIndex(idx);
    }

    private void parseUnique(FieldMapping fm, Unique anno) {
        ValueMappingInfo info = fm.getValueInfo();
        if (!anno.enabled()) {
            info.setCanUnique(false);
            return;
        }
        org.apache.openjpa.jdbc.schema.Unique unq = new org.apache.openjpa.jdbc.schema.Unique();
        if (!StringUtils.isEmpty((String)anno.name())) {
            unq.setName(anno.name());
        }
        unq.setDeferred(anno.deferred());
        info.setUnique(unq);
    }

    private void parseVersionColumns(ClassMapping cm, VersionColumn ... vcols) {
        if (vcols.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(vcols.length);
        for (VersionColumn vcol : vcols) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(vcol));
        }
        cm.getVersion().getMappingInfo().setColumns(cols);
    }

    private static Column newColumn(VersionColumn anno) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)anno.name())) {
            col.setName(anno.name());
        }
        if (!StringUtils.isEmpty((String)anno.columnDefinition())) {
            col.setTypeName(anno.columnDefinition());
        }
        if (anno.precision() != 0) {
            col.setSize(anno.precision());
        } else if (anno.length() != 255) {
            col.setSize(anno.length());
        }
        col.setNotNull(!anno.nullable());
        col.setDecimalDigits(anno.scale());
        col.setFlag(2, !anno.insertable());
        col.setFlag(4, !anno.updatable());
        return col;
    }

    private void parseMappingOverrides(ClassMapping cm, XMappingOverride ... overs) {
        for (XMappingOverride over : overs) {
            if (StringUtils.isEmpty((String)over.name())) {
                throw new MetaDataException(_loc.get("no-override-name", (Object)cm));
            }
            FieldMapping sup = (FieldMapping)cm.getDefinedSuperclassField(over.name());
            if (sup == null) {
                sup = (FieldMapping)cm.addDefinedSuperclassField(over.name(), Object.class, Object.class);
            }
            this.populate(sup, over);
        }
    }

    private void populate(FieldMapping fm, XMappingOverride over) {
        if (over.containerTable().specified()) {
            this.parseContainerTable(fm, over.containerTable());
        }
        this.parseColumns(fm, over.columns());
        this.parseXJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, over.joinColumns());
        this.parseElementColumns(fm, over.elementColumns());
        this.parseElementJoinColumns(fm, over.elementJoinColumns());
        this.parseKeyColumns(fm, over.keyColumns());
        this.parseKeyJoinColumns(fm, over.keyJoinColumns());
    }

    private void parseElementColumns(FieldMapping fm, ElementColumn ... pcols) {
        if (pcols.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(pcols.length);
        int unique = 0;
        for (int i = 0; i < pcols.length; ++i) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(pcols[i]));
            unique |= pcols[i].unique() ? 1 : 2;
        }
        this.setColumns(fm, (MappingInfo)fm.getElementMapping().getValueInfo(), cols, unique);
    }

    private static Column newColumn(ElementColumn anno) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)anno.name())) {
            col.setName(anno.name());
        }
        if (!StringUtils.isEmpty((String)anno.columnDefinition())) {
            col.setTypeName(anno.columnDefinition());
        }
        if (anno.precision() != 0) {
            col.setSize(anno.precision());
        } else if (anno.length() != 255) {
            col.setSize(anno.length());
        }
        col.setNotNull(!anno.nullable());
        col.setDecimalDigits(anno.scale());
        col.setFlag(2, !anno.insertable());
        col.setFlag(4, !anno.updatable());
        return col;
    }

    private void parseKeyJoinColumns(FieldMapping fm, KeyJoinColumn ... joins) {
        if (joins.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        int unique = 0;
        for (int i = 0; i < joins.length; ++i) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(joins[i]));
            unique |= joins[i].unique() ? 1 : 2;
        }
        this.setColumns(fm, (MappingInfo)fm.getKeyMapping().getValueInfo(), cols, unique);
    }

    private static Column newColumn(KeyJoinColumn join) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)join.name())) {
            col.setName(join.name());
        }
        if (!StringUtils.isEmpty((String)join.columnDefinition())) {
            col.setTypeName(join.columnDefinition());
        }
        if (!StringUtils.isEmpty((String)join.referencedColumnName())) {
            col.setTarget(join.referencedColumnName());
        }
        if (!StringUtils.isEmpty((String)join.referencedAttributeName())) {
            col.setTargetField(join.referencedAttributeName());
        }
        col.setNotNull(!join.nullable());
        col.setFlag(2, !join.insertable());
        col.setFlag(4, !join.updatable());
        return col;
    }

    private static int toEagerFetchModeConstant(FetchMode mode) {
        switch (mode) {
            case NONE: {
                return 0;
            }
            case JOIN: {
                return 1;
            }
            case PARALLEL: {
                return 2;
            }
        }
        throw new InternalException();
    }

    protected void parseLobMapping(FieldMetaData fmd) {
        Column col = new Column();
        if (fmd.getDeclaredTypeCode() == 9 || fmd.getDeclaredType() == char[].class || fmd.getDeclaredType() == Character[].class) {
            col.setType(2005);
        } else {
            col.setType(2004);
        }
        ((FieldMapping)fmd).getValueInfo().setColumns(Arrays.asList(col));
    }

    protected void parseMemberMappingAnnotations(FieldMetaData fmd) {
        FieldMapping fm = (FieldMapping)fmd;
        AnnotatedElement el = (AnnotatedElement)((Object)this.getRepository().getMetaDataFactory().getDefaults().getBackingMember(fmd));
        block49: for (Annotation anno : el.getDeclaredAnnotations()) {
            MappingTag tag = _tags.get(anno.annotationType());
            if (tag == null) {
                this.handleUnknownMemberMappingAnnotation(fm, anno);
                continue;
            }
            switch (tag) {
                case ASSOC_OVERRIDE: {
                    this.parseAssociationOverrides(fm, (AssociationOverride)anno);
                    continue block49;
                }
                case ASSOC_OVERRIDES: {
                    this.parseAssociationOverrides(fm, ((AssociationOverrides)anno).value());
                    continue block49;
                }
                case ATTR_OVERRIDE: {
                    this.parseAttributeOverrides(fm, (AttributeOverride)anno);
                    continue block49;
                }
                case ATTR_OVERRIDES: {
                    this.parseAttributeOverrides(fm, ((AttributeOverrides)anno).value());
                    continue block49;
                }
                case COL: {
                    this.parseColumns(fm, (javax.persistence.Column)anno);
                    continue block49;
                }
                case COLS: {
                    this.parseColumns(fm, ((Columns)anno).value());
                    continue block49;
                }
                case ENUMERATED: {
                    this.parseEnumerated(fm, (Enumerated)anno);
                    continue block49;
                }
                case JOIN_COL: {
                    this.parseJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, (JoinColumn)anno);
                    continue block49;
                }
                case JOIN_COLS: {
                    this.parseJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, ((JoinColumns)anno).value());
                    continue block49;
                }
                case JOIN_TABLE: {
                    this.parseJoinTable(fm, (JoinTable)anno);
                    continue block49;
                }
                case KEY_CLASS_CRIT: {
                    fm.getKeyMapping().getValueInfo().setUseClassCriteria(((KeyClassCriteria)anno).value());
                    continue block49;
                }
                case KEY_COL: {
                    this.parseKeyColumns(fm, (KeyColumn)anno);
                    continue block49;
                }
                case KEY_COLS: {
                    this.parseKeyColumns(fm, ((KeyColumns)anno).value());
                    continue block49;
                }
                case KEY_EMBEDDED_MAPPING: {
                    KeyEmbeddedMapping kembed = (KeyEmbeddedMapping)anno;
                    this.parseEmbeddedMapping(fm.getKeyMapping(), kembed.nullIndicatorColumnName(), kembed.nullIndicatorAttributeName(), kembed.overrides());
                    continue block49;
                }
                case KEY_FK: {
                    KeyForeignKey kfk = (KeyForeignKey)anno;
                    this.parseForeignKey((MappingInfo)fm.getKeyMapping().getValueInfo(), kfk.name(), kfk.enabled(), kfk.deferred(), kfk.deleteAction(), kfk.updateAction());
                    continue block49;
                }
                case KEY_INDEX: {
                    KeyIndex kidx = (KeyIndex)anno;
                    this.parseIndex((MappingInfo)fm.getKeyMapping().getValueInfo(), kidx.name(), kidx.enabled(), kidx.unique());
                    continue block49;
                }
                case KEY_JOIN_COL: {
                    this.parseKeyJoinColumns(fm, (KeyJoinColumn)anno);
                    continue block49;
                }
                case KEY_JOIN_COLS: {
                    this.parseKeyJoinColumns(fm, ((KeyJoinColumns)anno).value());
                    continue block49;
                }
                case KEY_NONPOLY: {
                    fm.getKeyMapping().setPolymorphic(AnnotationPersistenceMappingParser.toPolymorphicConstant(((KeyNonpolymorphic)anno).value()));
                    continue block49;
                }
                case KEY_STRAT: {
                    fm.getKeyMapping().getValueInfo().setStrategy(((KeyStrategy)anno).value());
                    continue block49;
                }
                case PK_JOIN_COL: {
                    this.parsePrimaryKeyJoinColumns(fm, (PrimaryKeyJoinColumn)anno);
                    continue block49;
                }
                case PK_JOIN_COLS: {
                    this.parsePrimaryKeyJoinColumns(fm, ((PrimaryKeyJoinColumns)anno).value());
                    continue block49;
                }
                case TABLE_GEN: {
                    this.parseTableGenerator(el, (TableGenerator)anno);
                    continue block49;
                }
                case TEMPORAL: {
                    this.parseTemporal(fm, (Temporal)anno);
                    continue block49;
                }
                case CLASS_CRIT: {
                    fm.getValueInfo().setUseClassCriteria(((ClassCriteria)anno).value());
                    continue block49;
                }
                case CONTAINER_TABLE: {
                    this.parseContainerTable(fm, (ContainerTable)anno);
                    continue block49;
                }
                case EAGER_FETCH_MODE: {
                    fm.setEagerFetchMode(AnnotationPersistenceMappingParser.toEagerFetchModeConstant(((EagerFetchMode)anno).value()));
                    continue block49;
                }
                case ELEM_CLASS_CRIT: {
                    fm.getElementMapping().getValueInfo().setUseClassCriteria(((ElementClassCriteria)anno).value());
                    continue block49;
                }
                case ELEM_COL: {
                    this.parseElementColumns(fm, (ElementColumn)anno);
                    continue block49;
                }
                case ELEM_COLS: {
                    this.parseElementColumns(fm, ((ElementColumns)anno).value());
                    continue block49;
                }
                case ELEM_EMBEDDED_MAPPING: {
                    ElementEmbeddedMapping ee = (ElementEmbeddedMapping)anno;
                    this.parseEmbeddedMapping(fm.getElementMapping(), ee.nullIndicatorAttributeName(), ee.nullIndicatorColumnName(), ee.overrides());
                    continue block49;
                }
                case ELEM_FK: {
                    ElementForeignKey efk = (ElementForeignKey)anno;
                    this.parseForeignKey((MappingInfo)fm.getElementMapping().getValueInfo(), efk.name(), efk.enabled(), efk.deferred(), efk.deleteAction(), efk.updateAction());
                    continue block49;
                }
                case ELEM_INDEX: {
                    ElementIndex eidx = (ElementIndex)anno;
                    this.parseIndex((MappingInfo)fm.getElementMapping().getValueInfo(), eidx.name(), eidx.enabled(), eidx.unique());
                    continue block49;
                }
                case ELEM_JOIN_COL: {
                    this.parseElementJoinColumns(fm, (ElementJoinColumn)anno);
                    continue block49;
                }
                case ELEM_JOIN_COLS: {
                    this.parseElementJoinColumns(fm, ((ElementJoinColumns)anno).value());
                    continue block49;
                }
                case ELEM_NONPOLY: {
                    fm.getElementMapping().setPolymorphic(AnnotationPersistenceMappingParser.toPolymorphicConstant(((ElementNonpolymorphic)anno).value()));
                    continue block49;
                }
                case ELEM_STRAT: {
                    fm.getElementMapping().getValueInfo().setStrategy(((ElementStrategy)anno).value());
                    continue block49;
                }
                case EMBEDDED_MAPPING: {
                    this.parseEmbeddedMapping(fm, (EmbeddedMapping)anno);
                    continue block49;
                }
                case FK: {
                    this.parseForeignKey((MappingInfo)fm.getValueInfo(), (ForeignKey)anno);
                    continue block49;
                }
                case INDEX: {
                    this.parseIndex((MappingInfo)fm.getValueInfo(), (Index)anno);
                    continue block49;
                }
                case NONPOLY: {
                    fm.setPolymorphic(AnnotationPersistenceMappingParser.toPolymorphicConstant(((Nonpolymorphic)anno).value()));
                    continue block49;
                }
                case ORDER_COL: {
                    this.parseOrderColumn(fm, (OrderColumn)anno);
                    continue block49;
                }
                case STRAT: {
                    fm.getValueInfo().setStrategy(((Strategy)anno).value());
                    continue block49;
                }
                case UNIQUE: {
                    this.parseUnique(fm, (Unique)anno);
                    continue block49;
                }
                case X_EMBEDDED_MAPPING: {
                    XEmbeddedMapping embed = (XEmbeddedMapping)anno;
                    this.parseEmbeddedMapping((ValueMapping)fm, embed.nullIndicatorColumnName(), embed.nullIndicatorAttributeName(), embed.overrides());
                    continue block49;
                }
                case X_JOIN_COL: {
                    this.parseXJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, (XJoinColumn)anno);
                    continue block49;
                }
                case X_JOIN_COLS: {
                    this.parseXJoinColumns(fm, (MappingInfo)fm.getValueInfo(), true, ((XJoinColumns)anno).value());
                    continue block49;
                }
                default: {
                    throw new UnsupportedException(_loc.get("unsupported", (Object)fm, (Object)((Object)anno).toString()));
                }
            }
        }
    }

    protected boolean handleUnknownMemberMappingAnnotation(FieldMapping fm, Annotation anno) {
        return false;
    }

    protected static int toPolymorphicConstant(NonpolymorphicType val) {
        switch (val) {
            case EXACT: {
                return 1;
            }
            case JOINABLE: {
                return 2;
            }
            case FALSE: {
                return 0;
            }
        }
        throw new InternalException();
    }

    private void parseAssociationOverrides(FieldMapping fm, AssociationOverride ... assocs) {
        ClassMapping embed = fm.getEmbeddedMapping();
        if (embed == null) {
            throw new MetaDataException(_loc.get("not-embedded", (Object)fm));
        }
        for (AssociationOverride assoc : assocs) {
            FieldMapping efm = embed.getFieldMapping(assoc.name());
            if (efm == null) {
                throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)assoc.name()));
            }
            JoinColumn[] ecols = assoc.joinColumns();
            if (ecols == null || ecols.length == 0) continue;
            int unique = 0;
            ArrayList<Column> jcols = new ArrayList<Column>(ecols.length);
            for (JoinColumn ecol : ecols) {
                unique |= ecol.unique() ? 1 : 2;
                jcols.add(AnnotationPersistenceMappingParser.newColumn(ecol));
            }
            this.setColumns(efm, (MappingInfo)efm.getValueInfo(), jcols, unique);
        }
    }

    private void parseAttributeOverrides(FieldMapping fm, AttributeOverride ... attrs) {
        ClassMapping embed = fm.getEmbeddedMapping();
        if (embed == null) {
            throw new MetaDataException(_loc.get("not-embedded", (Object)fm));
        }
        for (AttributeOverride attr : attrs) {
            FieldMapping efm = embed.getFieldMapping(attr.name());
            if (efm == null) {
                throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)attr.name()));
            }
            if (attr.column() == null) continue;
            this.parseColumns(efm, attr.column());
        }
    }

    private void parseEnumerated(FieldMapping fm, Enumerated anno) {
        String strat = EnumValueHandler.class.getName() + "(StoreOrdinal=" + String.valueOf(anno.value() == EnumType.ORDINAL) + ")";
        fm.getValueInfo().setStrategy(strat);
    }

    private void parseTemporal(FieldMapping fm, Temporal anno) {
        List<Column> cols = fm.getValueInfo().getColumns();
        if (!cols.isEmpty() && cols.size() != 1) {
            throw new MetaDataException(_loc.get("num-cols-mismatch", (Object)fm, (Object)String.valueOf(cols.size()), (Object)"1"));
        }
        if (cols.isEmpty()) {
            cols = Arrays.asList(new Column());
            fm.getValueInfo().setColumns(cols);
        }
        Column col = (Column)cols.get(0);
        switch (anno.value()) {
            case DATE: {
                col.setType(91);
                break;
            }
            case TIME: {
                col.setType(92);
                break;
            }
            case TIMESTAMP: {
                col.setType(93);
            }
        }
    }

    protected void parseColumns(FieldMapping fm, javax.persistence.Column ... pcols) {
        if (pcols.length == 0) {
            return;
        }
        ArrayList<Column> cols = fm.getValueInfo().getColumns();
        if (!cols.isEmpty() && cols.size() != pcols.length) {
            throw new MetaDataException(_loc.get("num-cols-mismatch", (Object)fm, (Object)String.valueOf(cols.size()), (Object)String.valueOf(pcols.length)));
        }
        Class<?> xmlTypeClass = null;
        try {
            xmlTypeClass = Class.forName("javax.xml.bind.annotation.XmlType");
        }
        catch (Exception e) {
            // empty catch block
        }
        int unique = 0;
        String secondary = null;
        for (int i = 0; i < pcols.length; ++i) {
            if (cols.size() > i) {
                AnnotationPersistenceMappingParser.setupColumn((Column)cols.get(i), pcols[i]);
            } else {
                if (cols.isEmpty()) {
                    cols = new ArrayList<Column>(pcols.length);
                }
                cols.add(AnnotationPersistenceMappingParser.newColumn(pcols[i]));
            }
            if (xmlTypeClass != null && StringUtils.isEmpty((String)pcols[i].columnDefinition()) && ((Boolean)AccessController.doPrivileged(J2DoPriv5Helper.isAnnotationPresentAction((AnnotatedElement)fm.getDeclaredType(), xmlTypeClass))).booleanValue()) {
                DBDictionary dict = ((MappingRepository)this.getRepository()).getDBDictionary();
                if (dict.supportsXMLColumn) {
                    ((Column)cols.get(i)).setTypeName(dict.xmlTypeName);
                }
            }
            unique |= pcols[i].unique() ? 1 : 2;
            secondary = this.trackSecondaryTable(fm, secondary, pcols[i].table(), i);
        }
        this.setColumns(fm, (MappingInfo)fm.getValueInfo(), (List<Column>)cols, unique);
        if (secondary != null) {
            fm.getMappingInfo().setTableName(secondary);
        }
    }

    private static Column newColumn(javax.persistence.Column anno) {
        Column col = new Column();
        AnnotationPersistenceMappingParser.setupColumn(col, anno);
        return col;
    }

    private static void setupColumn(Column col, javax.persistence.Column anno) {
        if (!StringUtils.isEmpty((String)anno.name())) {
            col.setName(anno.name());
        }
        if (!StringUtils.isEmpty((String)anno.columnDefinition())) {
            col.setTypeName(anno.columnDefinition());
        }
        if (anno.precision() != 0) {
            col.setSize(anno.precision());
        } else if (anno.length() != 255) {
            col.setSize(anno.length());
        }
        col.setNotNull(!anno.nullable());
        col.setDecimalDigits(anno.scale());
        col.setFlag(2, !anno.insertable());
        col.setFlag(4, !anno.updatable());
    }

    protected void setColumns(FieldMapping fm, MappingInfo info, List<Column> cols, int unique) {
        Log log;
        info.setColumns(cols);
        if (unique == 1) {
            info.setUnique(new org.apache.openjpa.jdbc.schema.Unique());
        }
        if ((log = this.getLog()).isWarnEnabled() && unique == 3) {
            log.warn((Object)_loc.get("inconsist-col-attrs", (Object)fm));
        }
    }

    private String trackSecondaryTable(FieldMapping fm, String secondary, String colSecondary, int col) {
        if (StringUtils.isEmpty((String)colSecondary)) {
            colSecondary = null;
        }
        if (col == 0) {
            return colSecondary;
        }
        if (!StringUtils.equalsIgnoreCase((String)secondary, (String)colSecondary)) {
            throw new MetaDataException(_loc.get("second-inconsist", (Object)fm));
        }
        return secondary;
    }

    private void parseJoinTable(FieldMapping fm, JoinTable join) {
        fm.getMappingInfo().setTableName(AnnotationPersistenceMappingParser.toTableName(join.schema(), join.name()));
        this.parseJoinColumns(fm, (MappingInfo)fm.getMappingInfo(), false, join.joinColumns());
        this.parseJoinColumns(fm, (MappingInfo)fm.getElementMapping().getValueInfo(), false, join.inverseJoinColumns());
    }

    private void parseJoinColumns(FieldMapping fm, MappingInfo info, boolean secondaryAllowed, JoinColumn ... joins) {
        if (joins.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        int unique = 0;
        String secondary = null;
        for (int i = 0; i < joins.length; ++i) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(joins[i]));
            unique |= joins[i].unique() ? 1 : 2;
            secondary = this.trackSecondaryTable(fm, secondary, joins[i].table(), i);
            if (secondaryAllowed || secondary == null) continue;
            throw new MetaDataException(_loc.get("bad-second", (Object)fm));
        }
        this.setColumns(fm, info, cols, unique);
        if (secondary != null) {
            fm.getMappingInfo().setTableName(secondary);
        }
    }

    private static Column newColumn(JoinColumn join) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)join.name())) {
            col.setName(join.name());
        }
        if (!StringUtils.isEmpty((String)join.columnDefinition())) {
            col.setTypeName(join.columnDefinition());
        }
        if (!StringUtils.isEmpty((String)join.referencedColumnName())) {
            col.setTarget(join.referencedColumnName());
        }
        col.setNotNull(!join.nullable());
        col.setFlag(2, !join.insertable());
        col.setFlag(4, !join.updatable());
        return col;
    }

    private void parseKeyColumns(FieldMapping fm, KeyColumn ... pcols) {
        if (pcols.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(pcols.length);
        int unique = 0;
        for (int i = 0; i < pcols.length; ++i) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(pcols[i]));
            unique |= pcols[i].unique() ? 1 : 2;
        }
        this.setColumns(fm, (MappingInfo)fm.getKeyMapping().getValueInfo(), cols, unique);
    }

    private static Column newColumn(KeyColumn anno) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)anno.name())) {
            col.setName(anno.name());
        }
        if (!StringUtils.isEmpty((String)anno.columnDefinition())) {
            col.setTypeName(anno.columnDefinition());
        }
        if (anno.precision() != 0) {
            col.setSize(anno.precision());
        } else if (anno.length() != 255) {
            col.setSize(anno.length());
        }
        col.setNotNull(!anno.nullable());
        col.setDecimalDigits(anno.scale());
        col.setFlag(2, !anno.insertable());
        col.setFlag(4, !anno.updatable());
        return col;
    }

    private void parsePrimaryKeyJoinColumns(FieldMapping fm, PrimaryKeyJoinColumn ... joins) {
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        for (PrimaryKeyJoinColumn join : joins) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(join));
        }
        this.setColumns(fm, (MappingInfo)fm.getValueInfo(), cols, 0);
    }

    protected void parseXJoinColumns(FieldMapping fm, MappingInfo info, boolean secondaryAllowed, XJoinColumn ... joins) {
        if (joins.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        int unique = 0;
        String secondary = null;
        for (int i = 0; i < joins.length; ++i) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(joins[i]));
            unique |= joins[i].unique() ? 1 : 2;
            secondary = this.trackSecondaryTable(fm, secondary, joins[i].table(), i);
            if (secondaryAllowed || secondary == null) continue;
            throw new MetaDataException(_loc.get("bad-second", (Object)fm));
        }
        this.setColumns(fm, info, cols, unique);
        if (secondary != null) {
            fm.getMappingInfo().setTableName(secondary);
        }
    }

    private static Column newColumn(XJoinColumn join) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)join.name())) {
            col.setName(join.name());
        }
        if (!StringUtils.isEmpty((String)join.columnDefinition())) {
            col.setTypeName(join.columnDefinition());
        }
        if (!StringUtils.isEmpty((String)join.referencedColumnName())) {
            col.setTarget(join.referencedColumnName());
        }
        if (!StringUtils.isEmpty((String)join.referencedAttributeName())) {
            col.setTargetField(join.referencedAttributeName());
        }
        col.setNotNull(!join.nullable());
        col.setFlag(2, !join.insertable());
        col.setFlag(4, !join.updatable());
        return col;
    }

    private void parseEmbeddedMapping(FieldMapping fm, EmbeddedMapping anno) {
        ClassMapping embed = fm.getEmbeddedMapping();
        if (embed == null) {
            throw new MetaDataException(_loc.get("not-embedded", (Object)fm));
        }
        for (MappingOverride over : anno.overrides()) {
            FieldMapping efm = embed.getFieldMapping(over.name());
            if (efm == null) {
                throw new MetaDataException(_loc.get("embed-override-name", (Object)fm, (Object)over.name()));
            }
            this.populate(efm, over);
        }
        String nullInd = null;
        if (!StringUtils.isEmpty((String)anno.nullIndicatorAttributeName())) {
            nullInd = anno.nullIndicatorAttributeName();
        } else if (!StringUtils.isEmpty((String)anno.nullIndicatorColumnName())) {
            nullInd = anno.nullIndicatorColumnName();
        }
        if (nullInd == null) {
            return;
        }
        ValueMappingInfo info = fm.getValueInfo();
        this.populateNullIndicator(nullInd, info);
    }

    private void parseEmbeddedMapping(ValueMapping vm, String nullIndicatorAttribute, String nullIndicatorColumn, XMappingOverride[] overrides) {
        ClassMapping embed = vm.getEmbeddedMapping();
        if (embed == null) {
            throw new MetaDataException(_loc.get("not-embedded", (Object)vm));
        }
        for (XMappingOverride over : overrides) {
            FieldMapping efm = embed.getFieldMapping(over.name());
            if (efm == null) {
                throw new MetaDataException(_loc.get("embed-override-name", (Object)vm, (Object)over.name()));
            }
            this.populate(efm, over);
        }
        String nullInd = null;
        if (!StringUtils.isEmpty((String)nullIndicatorAttribute)) {
            nullInd = nullIndicatorAttribute;
        } else if (!StringUtils.isEmpty((String)nullIndicatorColumn)) {
            nullInd = nullIndicatorColumn;
        }
        if (nullInd == null) {
            return;
        }
        ValueMappingInfo info = vm.getValueInfo();
        this.populateNullIndicator(nullInd, info);
    }

    private void populateNullIndicator(String nullInd, ValueMappingInfo info) {
        if ("false".equals(nullInd)) {
            info.setCanIndicateNull(false);
        } else {
            Column col = new Column();
            if (!"true".equals(nullInd)) {
                col.setName(nullInd);
            }
            info.setColumns(Arrays.asList(col));
        }
    }

    protected void parseContainerTable(FieldMapping fm, ContainerTable ctbl) {
        fm.getMappingInfo().setTableName(AnnotationPersistenceMappingParser.toTableName(ctbl.schema(), ctbl.name()));
        this.parseXJoinColumns(fm, (MappingInfo)fm.getMappingInfo(), false, ctbl.joinColumns());
        if (ctbl.joinForeignKey().specified()) {
            this.parseForeignKey((MappingInfo)fm.getMappingInfo(), ctbl.joinForeignKey());
        }
        if (ctbl.joinIndex().specified()) {
            this.parseIndex((MappingInfo)fm.getMappingInfo(), ctbl.joinIndex());
        }
    }

    private void parseOrderColumn(FieldMapping fm, OrderColumn order) {
        if (!order.enabled()) {
            fm.getMappingInfo().setCanOrderColumn(false);
            return;
        }
        Column col = new Column();
        if (!StringUtils.isEmpty((String)order.name())) {
            col.setName(order.name());
        }
        if (!StringUtils.isEmpty((String)order.columnDefinition())) {
            col.setTypeName(order.columnDefinition());
        }
        if (order.precision() != 0) {
            col.setSize(order.precision());
        }
        col.setFlag(2, !order.insertable());
        col.setFlag(4, !order.updatable());
        fm.getMappingInfo().setOrderColumn(col);
    }

    protected void parseElementJoinColumns(FieldMapping fm, ElementJoinColumn ... joins) {
        if (joins.length == 0) {
            return;
        }
        ArrayList<Column> cols = new ArrayList<Column>(joins.length);
        int unique = 0;
        for (int i = 0; i < joins.length; ++i) {
            cols.add(AnnotationPersistenceMappingParser.newColumn(joins[i]));
            unique |= joins[i].unique() ? 1 : 2;
        }
        this.setColumns(fm, (MappingInfo)fm.getElementMapping().getValueInfo(), cols, unique);
    }

    private static Column newColumn(ElementJoinColumn join) {
        Column col = new Column();
        if (!StringUtils.isEmpty((String)join.name())) {
            col.setName(join.name());
        }
        if (!StringUtils.isEmpty((String)join.columnDefinition())) {
            col.setTypeName(join.columnDefinition());
        }
        if (!StringUtils.isEmpty((String)join.referencedColumnName())) {
            col.setTarget(join.referencedColumnName());
        }
        if (!StringUtils.isEmpty((String)join.referencedAttributeName())) {
            col.setTargetField(join.referencedAttributeName());
        }
        col.setNotNull(!join.nullable());
        col.setFlag(2, !join.insertable());
        col.setFlag(4, !join.updatable());
        return col;
    }

    private static org.apache.openjpa.jdbc.schema.Unique newUnique(ClassMapping cm, String name, String[] columnNames) {
        if (columnNames == null || columnNames.length == 0) {
            return null;
        }
        org.apache.openjpa.jdbc.schema.Unique uniqueConstraint = new org.apache.openjpa.jdbc.schema.Unique();
        uniqueConstraint.setName(name);
        for (int i = 0; i < columnNames.length; ++i) {
            if (StringUtils.isEmpty((String)columnNames[i])) {
                throw new UserException(_loc.get("empty-unique-column", (Object)Arrays.toString(columnNames), (Object)cm));
            }
            Column column = new Column();
            column.setName(columnNames[i]);
            uniqueConstraint.addColumn(column);
        }
        return uniqueConstraint;
    }

    static {
        _tags.put(AssociationOverride.class, MappingTag.ASSOC_OVERRIDE);
        _tags.put(AssociationOverrides.class, MappingTag.ASSOC_OVERRIDES);
        _tags.put(AttributeOverride.class, MappingTag.ATTR_OVERRIDE);
        _tags.put(AttributeOverrides.class, MappingTag.ATTR_OVERRIDES);
        _tags.put(javax.persistence.Column.class, MappingTag.COL);
        _tags.put(ColumnResult.class, MappingTag.COLUMN_RESULT);
        _tags.put(DiscriminatorColumn.class, MappingTag.DISCRIM_COL);
        _tags.put(DiscriminatorValue.class, MappingTag.DISCRIM_VAL);
        _tags.put(ElementColumn.class, MappingTag.ELEM_COL);
        _tags.put(ElementColumns.class, MappingTag.ELEM_COLS);
        _tags.put(ElementEmbeddedMapping.class, MappingTag.ELEM_EMBEDDED_MAPPING);
        _tags.put(ElementStrategy.class, MappingTag.ELEM_STRAT);
        _tags.put(EntityResult.class, MappingTag.ENTITY_RESULT);
        _tags.put(Enumerated.class, MappingTag.ENUMERATED);
        _tags.put(FieldResult.class, MappingTag.FIELD_RESULT);
        _tags.put(Inheritance.class, MappingTag.INHERITANCE);
        _tags.put(JoinColumn.class, MappingTag.JOIN_COL);
        _tags.put(JoinColumns.class, MappingTag.JOIN_COLS);
        _tags.put(JoinTable.class, MappingTag.JOIN_TABLE);
        _tags.put(KeyColumn.class, MappingTag.KEY_COL);
        _tags.put(KeyColumns.class, MappingTag.KEY_COLS);
        _tags.put(KeyClassCriteria.class, MappingTag.KEY_CLASS_CRIT);
        _tags.put(KeyEmbeddedMapping.class, MappingTag.KEY_EMBEDDED_MAPPING);
        _tags.put(KeyForeignKey.class, MappingTag.KEY_FK);
        _tags.put(KeyIndex.class, MappingTag.KEY_INDEX);
        _tags.put(KeyJoinColumn.class, MappingTag.KEY_JOIN_COL);
        _tags.put(KeyJoinColumns.class, MappingTag.KEY_JOIN_COLS);
        _tags.put(KeyNonpolymorphic.class, MappingTag.KEY_NONPOLY);
        _tags.put(KeyStrategy.class, MappingTag.KEY_STRAT);
        _tags.put(PrimaryKeyJoinColumn.class, MappingTag.PK_JOIN_COL);
        _tags.put(PrimaryKeyJoinColumns.class, MappingTag.PK_JOIN_COLS);
        _tags.put(SecondaryTable.class, MappingTag.SECONDARY_TABLE);
        _tags.put(SecondaryTables.class, MappingTag.SECONDARY_TABLES);
        _tags.put(SqlResultSetMapping.class, MappingTag.SQL_RESULT_SET_MAPPING);
        _tags.put(SqlResultSetMappings.class, MappingTag.SQL_RESULT_SET_MAPPINGS);
        _tags.put(Table.class, MappingTag.TABLE);
        _tags.put(Temporal.class, MappingTag.TEMPORAL);
        _tags.put(TableGenerator.class, MappingTag.TABLE_GEN);
        _tags.put(ClassCriteria.class, MappingTag.CLASS_CRIT);
        _tags.put(Columns.class, MappingTag.COLS);
        _tags.put(ContainerTable.class, MappingTag.CONTAINER_TABLE);
        _tags.put(DataStoreIdColumn.class, MappingTag.DATASTORE_ID_COL);
        _tags.put(DiscriminatorStrategy.class, MappingTag.DISCRIM_STRAT);
        _tags.put(EagerFetchMode.class, MappingTag.EAGER_FETCH_MODE);
        _tags.put(ElementClassCriteria.class, MappingTag.ELEM_CLASS_CRIT);
        _tags.put(ElementForeignKey.class, MappingTag.ELEM_FK);
        _tags.put(ElementIndex.class, MappingTag.ELEM_INDEX);
        _tags.put(ElementJoinColumn.class, MappingTag.ELEM_JOIN_COL);
        _tags.put(ElementJoinColumns.class, MappingTag.ELEM_JOIN_COLS);
        _tags.put(ElementNonpolymorphic.class, MappingTag.ELEM_NONPOLY);
        _tags.put(EmbeddedMapping.class, MappingTag.EMBEDDED_MAPPING);
        _tags.put(ForeignKey.class, MappingTag.FK);
        _tags.put(Index.class, MappingTag.INDEX);
        _tags.put(MappingOverride.class, MappingTag.MAPPING_OVERRIDE);
        _tags.put(MappingOverrides.class, MappingTag.MAPPING_OVERRIDES);
        _tags.put(Nonpolymorphic.class, MappingTag.NONPOLY);
        _tags.put(OrderColumn.class, MappingTag.ORDER_COL);
        _tags.put(Strategy.class, MappingTag.STRAT);
        _tags.put(SubclassFetchMode.class, MappingTag.SUBCLASS_FETCH_MODE);
        _tags.put(org.apache.openjpa.jdbc.schema.Unique.class, MappingTag.UNIQUE);
        _tags.put(VersionColumn.class, MappingTag.VERSION_COL);
        _tags.put(VersionColumns.class, MappingTag.VERSION_COLS);
        _tags.put(VersionStrategy.class, MappingTag.VERSION_STRAT);
        _tags.put(XEmbeddedMapping.class, MappingTag.X_EMBEDDED_MAPPING);
        _tags.put(XJoinColumn.class, MappingTag.X_JOIN_COL);
        _tags.put(XJoinColumns.class, MappingTag.X_JOIN_COLS);
        _tags.put(XMappingOverride.class, MappingTag.X_MAPPING_OVERRIDE);
        _tags.put(XMappingOverrides.class, MappingTag.X_MAPPING_OVERRIDES);
        _tags.put(XSecondaryTable.class, MappingTag.X_SECONDARY_TABLE);
        _tags.put(XSecondaryTables.class, MappingTag.X_SECONDARY_TABLES);
        _tags.put(XTable.class, MappingTag.X_TABLE);
    }
}

