/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.ConnectionInfo;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.ResultSetResult;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.QueryLanguages;
import org.apache.openjpa.kernel.Seq;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.ExpressionParser;
import org.apache.openjpa.lib.rop.MergedResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.ConcreteClassGenerator;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.slice.DistributedConfiguration;
import org.apache.openjpa.slice.DistributedStoreManager;
import org.apache.openjpa.slice.Slice;
import org.apache.openjpa.slice.SliceImplHelper;
import org.apache.openjpa.slice.SliceInfo;
import org.apache.openjpa.slice.SliceThread;
import org.apache.openjpa.slice.jdbc.DistributedConnection;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfiguration;
import org.apache.openjpa.slice.jdbc.DistributedStoreQuery;
import org.apache.openjpa.slice.jdbc.SliceStoreManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DistributedJDBCStoreManager
extends JDBCStoreManager
implements DistributedStoreManager {
    private final List<SliceStoreManager> _slices;
    private JDBCStoreManager _master;
    private final DistributedJDBCConfiguration _conf;
    private static final Localizer _loc = Localizer.forPackage(DistributedJDBCStoreManager.class);
    private static final Constructor<JDBCStoreManager.ClientConnection> clientConnectionImpl;
    private static final Constructor<JDBCStoreManager.RefCountConnection> refCountConnectionImpl;

    public DistributedJDBCStoreManager(DistributedJDBCConfiguration conf) {
        this._conf = conf;
        this._slices = new ArrayList<SliceStoreManager>();
        List sliceNames = conf.getActiveSliceNames();
        for (String name : sliceNames) {
            SliceStoreManager slice = new SliceStoreManager(conf.getSlice(name));
            this._slices.add(slice);
            if (!slice.getName().equals(this._conf.getMaster().getName())) continue;
            this._master = slice;
        }
    }

    public DistributedJDBCConfiguration getConfiguration() {
        return this._conf;
    }

    public SliceStoreManager getSlice(int i) {
        return this._slices.get(i);
    }

    @Override
    public SliceStoreManager addSlice(Slice slice) {
        SliceStoreManager result = new SliceStoreManager(slice);
        result.setContext(this.getContext(), (JDBCConfiguration)slice.getConfiguration());
        this._slices.add(result);
        return result;
    }

    protected SliceInfo findSliceNames(OpenJPAStateManager sm, Object edata) {
        String origin;
        if (SliceImplHelper.isSliceAssigned(sm)) {
            return SliceImplHelper.getSliceInfo(sm);
        }
        SliceInfo result = null;
        PersistenceCapable pc = sm.getPersistenceCapable();
        StoreContext ctx = this.getContext();
        result = SliceImplHelper.isReplicated(sm) ? SliceImplHelper.getSlicesByPolicy(pc, (DistributedConfiguration)this._conf, (Object)ctx) : ((origin = this.estimateSlice(sm, edata)) == null ? SliceImplHelper.getSlicesByPolicy(pc, (DistributedConfiguration)this._conf, (Object)ctx) : new SliceInfo(origin));
        return result;
    }

    private void assignSlice(OpenJPAStateManager sm, String hint) {
        if (SliceImplHelper.isReplicated(sm)) {
            SliceImplHelper.getSlicesByPolicy(sm, (DistributedConfiguration)this._conf, (Object)this.getContext()).setInto(sm);
            return;
        }
        new SliceInfo(hint).setInto(sm);
    }

    private String estimateSlice(OpenJPAStateManager sm, Object edata) {
        if (edata == null || !(edata instanceof ConnectionInfo)) {
            return null;
        }
        Result result = ((ConnectionInfo)edata).result;
        if (result instanceof ResultSetResult) {
            JDBCStore store = ((ResultSetResult)result).getStore();
            for (SliceStoreManager slice : this._slices) {
                if (slice != store) continue;
                return slice.getName();
            }
        }
        return null;
    }

    private StoreManager selectStore(OpenJPAStateManager sm, Object edata) {
        int i$ = 0;
        String[] targets = this.findSliceNames(sm, edata).getSlices();
        String[] arr$ = targets;
        int len$ = arr$.length;
        if (i$ < len$) {
            String target = arr$[i$];
            SliceStoreManager slice = this.lookup(target);
            if (slice == null) {
                throw new InternalException(_loc.get("wrong-slice", (Object)target, (Object)sm));
            }
            return slice;
        }
        return null;
    }

    public boolean assignField(OpenJPAStateManager sm, int field, boolean preFlush) {
        return this.selectStore(sm, null).assignField(sm, field, preFlush);
    }

    public boolean assignObjectId(OpenJPAStateManager sm, boolean preFlush) {
        return this._master.assignObjectId(sm, preFlush);
    }

    public void beforeStateChange(OpenJPAStateManager sm, PCState fromState, PCState toState) {
        this._master.beforeStateChange(sm, fromState, toState);
    }

    public void beginOptimistic() {
        for (SliceStoreManager slice : this._slices) {
            slice.beginOptimistic();
        }
    }

    public boolean cancelAll() {
        boolean ret = true;
        for (SliceStoreManager slice : this._slices) {
            ret = slice.cancelAll() & ret;
        }
        return ret;
    }

    public int compareVersion(OpenJPAStateManager sm, Object v1, Object v2) {
        return this.selectStore(sm, null).compareVersion(sm, v1, v2);
    }

    public Object copyDataStoreId(Object oid, ClassMetaData meta) {
        return this._master.copyDataStoreId(oid, meta);
    }

    public ResultObjectProvider executeExtent(ClassMetaData meta, boolean subclasses, FetchConfiguration fetch) {
        int i = 0;
        List<SliceStoreManager> targets = this.getTargets(fetch);
        ResultObjectProvider[] tmp = new ResultObjectProvider[targets.size()];
        for (SliceStoreManager slice : targets) {
            tmp[i++] = slice.executeExtent(meta, subclasses, fetch);
        }
        return new MergedResultObjectProvider(tmp);
    }

    public boolean exists(OpenJPAStateManager sm, Object edata) {
        String origin = null;
        for (SliceStoreManager slice : this._slices) {
            if (!slice.exists(sm, edata)) continue;
            origin = slice.getName();
            break;
        }
        if (origin != null) {
            this.assignSlice(sm, origin);
        }
        return origin != null;
    }

    public Collection flush(Collection sms) {
        ArrayList exceptions = new ArrayList();
        ArrayList<Future<Collection>> futures = new ArrayList<Future<Collection>>();
        Map<String, StateManagerSet> subsets = this.bin(sms, null);
        ArrayList<StateManagerSet> remaining = new ArrayList<StateManagerSet>(subsets.values());
        ExecutorService threadPool = SliceThread.newPool(this._slices.size());
        for (int i = 0; i < this._slices.size(); ++i) {
            SliceStoreManager sliceStoreManager = this._slices.get(i);
            StateManagerSet subset = subsets.get(sliceStoreManager.getName());
            if (subset.isEmpty()) continue;
            if (subset.containsReplicated()) {
                Map<OpenJPAStateManager, Object> oldVersions = this.cacheVersion(subset.getReplicated());
                this.collectException(sliceStoreManager.flush(subset), exceptions);
                remaining.remove(subset);
                this.rollbackVersion(subset.getReplicated(), oldVersions, remaining);
                continue;
            }
            futures.add(threadPool.submit(new Flusher(sliceStoreManager, subset)));
        }
        for (Future future : futures) {
            try {
                this.collectException((Collection)future.get(), exceptions);
            }
            catch (InterruptedException e) {
                throw new StoreException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw new StoreException(e.getCause());
            }
        }
        return exceptions;
    }

    private void collectException(Collection error, Collection holder) {
        if (error != null && !error.isEmpty()) {
            holder.addAll(error);
        }
    }

    private Map<OpenJPAStateManager, Object> cacheVersion(List<OpenJPAStateManager> sms) {
        HashMap<OpenJPAStateManager, Object> result = new HashMap<OpenJPAStateManager, Object>();
        for (OpenJPAStateManager sm : sms) {
            result.put(sm, sm.getVersion());
        }
        return result;
    }

    private void rollbackVersion(List<OpenJPAStateManager> sms, Map<OpenJPAStateManager, Object> oldVersions, Collection<StateManagerSet> reminder) {
        if (reminder.isEmpty()) {
            return;
        }
        for (OpenJPAStateManager sm : sms) {
            if (!this.occurs(sm, reminder)) continue;
            sm.setVersion(oldVersions.get(sm));
        }
    }

    boolean occurs(OpenJPAStateManager sm, Collection<StateManagerSet> reminder) {
        for (StateManagerSet set : reminder) {
            if (!set.contains(sm)) continue;
            return true;
        }
        return false;
    }

    private Map<String, StateManagerSet> bin(Collection sms, Object edata) {
        HashMap<String, StateManagerSet> subsets = new HashMap<String, StateManagerSet>();
        for (SliceStoreManager slice : this._slices) {
            subsets.put(slice.getName(), new StateManagerSet());
        }
        for (SliceStoreManager x : sms) {
            String[] targets;
            OpenJPAStateManager sm = (OpenJPAStateManager)x;
            for (String slice : targets = this.findSliceNames(sm, edata).getSlices()) {
                ((StateManagerSet)subsets.get(slice)).add(sm);
            }
        }
        return subsets;
    }

    public Object getClientConnection() {
        return ConcreteClassGenerator.newInstance(clientConnectionImpl, (Object[])new Object[]{this.getConnection()});
    }

    public Seq getDataStoreIdSequence(ClassMetaData forClass) {
        return this._master.getDataStoreIdSequence(forClass);
    }

    public Class<?> getDataStoreIdType(ClassMetaData meta) {
        return this._master.getDataStoreIdType(meta);
    }

    public Class<?> getManagedType(Object oid) {
        return this._master.getManagedType(oid);
    }

    public Seq getValueSequence(FieldMetaData forField) {
        return this._master.getValueSequence(forField);
    }

    public boolean initialize(OpenJPAStateManager sm, PCState state, FetchConfiguration fetch, Object edata) {
        String origin;
        if (edata instanceof ConnectionInfo && (origin = this.estimateSlice(sm, edata)) != null && this.lookup(origin).initialize(sm, state, fetch, edata)) {
            this.assignSlice(sm, origin);
            return true;
        }
        List<SliceStoreManager> targets = this.getTargets(fetch);
        for (SliceStoreManager slice : targets) {
            if (!slice.initialize(sm, state, fetch, edata)) continue;
            this.assignSlice(sm, slice.getName());
            return true;
        }
        return false;
    }

    public boolean load(OpenJPAStateManager sm, BitSet fields, FetchConfiguration fetch, int lockLevel, Object edata) {
        return this.selectStore(sm, edata).load(sm, fields, fetch, lockLevel, edata);
    }

    public Collection loadAll(Collection sms, PCState state, int load, FetchConfiguration fetch, Object edata) {
        Map<String, StateManagerSet> subsets = this.bin(sms, edata);
        ArrayList result = new ArrayList();
        for (SliceStoreManager slice : this._slices) {
            Collection tmp;
            StateManagerSet subset = subsets.get(slice.getName());
            if (subset.isEmpty() || (tmp = slice.loadAll(subset, state, load, fetch, edata)) == null || tmp.isEmpty()) continue;
            result.addAll(tmp);
        }
        return result;
    }

    public Object newDataStoreId(Object oidVal, ClassMetaData meta) {
        return this._master.newDataStoreId(oidVal, meta);
    }

    public FetchConfiguration newFetchConfiguration() {
        return this._master.newFetchConfiguration();
    }

    public StoreQuery newQuery(String language) {
        ExpressionParser parser = QueryLanguages.parserForLanguage((String)language);
        DistributedStoreQuery ret = new DistributedStoreQuery((JDBCStore)this, parser);
        for (SliceStoreManager slice : this._slices) {
            ret.add(slice.newQuery(language));
        }
        return ret;
    }

    public void setContext(StoreContext ctx) {
        super.setContext(ctx);
        for (SliceStoreManager store : this._slices) {
            store.setContext(ctx, (JDBCConfiguration)store.getSlice().getConfiguration());
        }
    }

    private SliceStoreManager lookup(String name) {
        for (SliceStoreManager slice : this._slices) {
            if (!slice.getName().equals(name)) continue;
            return slice;
        }
        return null;
    }

    public boolean syncVersion(OpenJPAStateManager sm, Object edata) {
        String[] targets = this.findSliceNames(sm, edata).getSlices();
        boolean sync = true;
        for (String replica : targets) {
            SliceStoreManager slice = this.lookup(replica);
            sync &= slice.syncVersion(sm, edata);
        }
        return sync;
    }

    protected JDBCStoreManager.RefCountConnection connectInternal() throws SQLException {
        ArrayList<Connection> list = new ArrayList<Connection>();
        for (SliceStoreManager slice : this._slices) {
            list.add(slice.getConnection());
        }
        DistributedConnection con = DistributedConnection.newInstance(list);
        return (JDBCStoreManager.RefCountConnection)ConcreteClassGenerator.newInstance(refCountConnectionImpl, (Object[])new Object[]{this, con});
    }

    List<SliceStoreManager> getTargets(FetchConfiguration fetch) {
        if (fetch == null) {
            return this._slices;
        }
        Object hint = fetch.getHint("openjpa.hint.slice.Target");
        if (hint == null || !(hint instanceof String)) {
            return this._slices;
        }
        List<String> targetNames = Arrays.asList(hint.toString().split("\\,"));
        ArrayList<SliceStoreManager> targets = new ArrayList<SliceStoreManager>();
        for (SliceStoreManager slice : this._slices) {
            if (!targetNames.contains(slice.getName())) continue;
            targets.add(slice);
        }
        if (targets.isEmpty()) {
            return this._slices;
        }
        return targets;
    }

    static {
        try {
            clientConnectionImpl = ConcreteClassGenerator.getConcreteConstructor(JDBCStoreManager.ClientConnection.class, (Class[])new Class[]{Connection.class});
            refCountConnectionImpl = ConcreteClassGenerator.getConcreteConstructor(JDBCStoreManager.RefCountConnection.class, (Class[])new Class[]{JDBCStoreManager.class, Connection.class});
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StateManagerSet
    extends HashSet<OpenJPAStateManager> {
        List<OpenJPAStateManager> replicated;

        private StateManagerSet() {
        }

        @Override
        public boolean add(OpenJPAStateManager sm) {
            boolean isReplicated = sm.getMetaData().isReplicated();
            if (isReplicated) {
                if (this.replicated == null) {
                    this.replicated = new ArrayList<OpenJPAStateManager>();
                }
                this.replicated.add(sm);
            }
            return super.add(sm);
        }

        @Override
        public boolean remove(Object sm) {
            throw new UnsupportedOperationException();
        }

        boolean containsReplicated() {
            return this.replicated != null && !this.replicated.isEmpty();
        }

        List<OpenJPAStateManager> getReplicated() {
            return this.replicated;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Flusher
    implements Callable<Collection> {
        final SliceStoreManager store;
        final StateManagerSet toFlush;

        Flusher(SliceStoreManager store, StateManagerSet toFlush) {
            this.store = store;
            this.toFlush = toFlush;
        }

        @Override
        public Collection call() throws Exception {
            return this.store.flush(this.toFlush);
        }
    }
}

