/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.SQLStoreQuery;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OrderingMergedResultObjectProvider;
import org.apache.openjpa.kernel.QueryContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.lib.rop.MergedResultObjectProvider;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.slice.DistributedConfiguration;
import org.apache.openjpa.slice.SliceThread;
import org.apache.openjpa.slice.jdbc.DistributedJDBCStoreManager;
import org.apache.openjpa.slice.jdbc.SliceStoreManager;
import org.apache.openjpa.slice.jdbc.UniqueResultObjectProvider;
import org.apache.openjpa.util.StoreException;

class DistributedSQLStoreQuery
extends SQLStoreQuery {
    private List<StoreQuery> _queries = new ArrayList<StoreQuery>();

    public DistributedSQLStoreQuery(JDBCStore store) {
        super(store);
    }

    void add(StoreQuery q) {
        this._queries.add(q);
    }

    public DistributedJDBCStoreManager getDistributedStore() {
        return (DistributedJDBCStoreManager)this.getStore();
    }

    public StoreQuery.Executor newDataStoreExecutor(ClassMetaData meta, boolean subs) {
        boolean parallel = !this.getContext().getStoreContext().getBroker().getMultithreaded();
        ParallelExecutor ex = new ParallelExecutor(this, meta, parallel);
        for (StoreQuery q : this._queries) {
            ex.addExecutor(q.newDataStoreExecutor(meta, subs));
        }
        return ex;
    }

    public void setContext(QueryContext ctx) {
        super.setContext(ctx);
        for (StoreQuery q : this._queries) {
            q.setContext(ctx);
        }
    }

    static class UpdateExecutor
    implements Callable<Number> {
        StoreQuery query;
        StoreQuery.Executor executor;
        Object[] params;

        UpdateExecutor() {
        }

        @Override
        public Number call() throws Exception {
            return this.executor.executeUpdate(this.query, this.params);
        }
    }

    static class DeleteExecutor
    implements Callable<Number> {
        StoreQuery query;
        StoreQuery.Executor executor;
        Object[] params;

        DeleteExecutor() {
        }

        @Override
        public Number call() throws Exception {
            return this.executor.executeDelete(this.query, this.params);
        }
    }

    static class QueryExecutor
    implements Callable<ResultObjectProvider> {
        StoreQuery query;
        StoreQuery.Executor executor;
        Object[] params;
        StoreQuery.Range range;

        QueryExecutor() {
        }

        @Override
        public ResultObjectProvider call() throws Exception {
            return this.executor.executeQuery(this.query, this.params, this.range);
        }
    }

    public static class ParallelExecutor
    extends SQLStoreQuery.SQLExecutor {
        private List<StoreQuery.Executor> executors = new ArrayList<StoreQuery.Executor>();
        private DistributedSQLStoreQuery owner = null;

        public ParallelExecutor(DistributedSQLStoreQuery dsq, ClassMetaData meta, boolean p) {
            super((SQLStoreQuery)dsq, meta);
            this.owner = dsq;
        }

        public void addExecutor(StoreQuery.Executor ex) {
            this.executors.add(ex);
        }

        /*
         * WARNING - void declaration
         */
        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            void var12_22;
            boolean hasRange;
            ArrayList<Future<ResultObjectProvider>> futures = new ArrayList<Future<ResultObjectProvider>>();
            ArrayList<StoreQuery.Executor> usedExecutors = new ArrayList<StoreQuery.Executor>();
            ArrayList rops = new ArrayList();
            List<SliceStoreManager> targets = this.findTargets();
            QueryContext ctx = q.getContext();
            boolean isReplicated = this.containsReplicated(ctx);
            ExecutorService threadPool = SliceThread.getPool();
            for (int i = 0; i < this.owner._queries.size() && (!isReplicated || usedExecutors.isEmpty()); ++i) {
                SliceStoreManager sliceStoreManager = this.owner.getDistributedStore().getSlice(i);
                if (!targets.contains((Object)sliceStoreManager)) continue;
                StoreQuery query = (StoreQuery)this.owner._queries.get(i);
                StoreQuery.Executor executor = this.executors.get(i);
                if (!targets.contains((Object)sliceStoreManager)) continue;
                usedExecutors.add(executor);
                QueryExecutor call = new QueryExecutor();
                call.executor = executor;
                call.query = query;
                call.params = params;
                call.range = range;
                futures.add(threadPool.submit(call));
            }
            for (Future future : futures) {
                try {
                    rops.add(future.get());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new StoreException(e.getCause());
                }
            }
            ResultObjectProvider[] tmp = rops.toArray(new ResultObjectProvider[rops.size()]);
            Object var12_16 = null;
            boolean[] ascending = this.getAscending(q);
            boolean isAscending = ascending.length > 0;
            boolean isAggregate = ctx.isAggregate();
            boolean bl = hasRange = ctx.getEndRange() != Long.MAX_VALUE;
            if (isAggregate) {
                UniqueResultObjectProvider uniqueResultObjectProvider = new UniqueResultObjectProvider(tmp, q, this.getQueryExpressions());
            } else if (isAscending) {
                OrderingMergedResultObjectProvider orderingMergedResultObjectProvider = new OrderingMergedResultObjectProvider(tmp, ascending, usedExecutors.toArray(new StoreQuery.Executor[usedExecutors.size()]), q, params);
            } else {
                MergedResultObjectProvider mergedResultObjectProvider = new MergedResultObjectProvider(tmp);
            }
            if (hasRange) {
                void var12_20;
                RangeResultObjectProvider rangeResultObjectProvider = new RangeResultObjectProvider((ResultObjectProvider)var12_20, ctx.getStartRange(), ctx.getEndRange());
            }
            return var12_22;
        }

        boolean containsReplicated(QueryContext query) {
            Class candidate = query.getCandidateType();
            DistributedConfiguration conf = (DistributedConfiguration)query.getStoreContext().getConfiguration();
            if (candidate != null) {
                return conf.isReplicated(candidate);
            }
            ClassMetaData[] metas = query.getAccessPathMetaDatas();
            if (metas == null || metas.length < 1) {
                return false;
            }
            for (ClassMetaData meta : metas) {
                if (!conf.isReplicated(meta.getDescribedType())) continue;
                return true;
            }
            return false;
        }

        public Number executeDelete(StoreQuery q, Object[] params) {
            Iterator qs = this.owner._queries.iterator();
            ArrayList<Future<Number>> futures = null;
            int result = 0;
            ExecutorService threadPool = SliceThread.getPool();
            for (StoreQuery.Executor executor : this.executors) {
                if (futures == null) {
                    futures = new ArrayList<Future<Number>>();
                }
                DeleteExecutor call = new DeleteExecutor();
                call.executor = executor;
                call.query = (StoreQuery)qs.next();
                call.params = params;
                futures.add(threadPool.submit(call));
            }
            for (Future future : futures) {
                try {
                    Number n = (Number)future.get();
                    if (n == null) continue;
                    result += n.intValue();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new StoreException(e.getCause());
                }
            }
            return result;
        }

        public Number executeUpdate(StoreQuery q, Object[] params) {
            Iterator qs = this.owner._queries.iterator();
            ArrayList<Future<Number>> futures = null;
            int result = 0;
            ExecutorService threadPool = SliceThread.getPool();
            for (StoreQuery.Executor executor : this.executors) {
                if (futures == null) {
                    futures = new ArrayList<Future<Number>>();
                }
                UpdateExecutor call = new UpdateExecutor();
                call.executor = executor;
                call.query = (StoreQuery)qs.next();
                call.params = params;
                futures.add(threadPool.submit(call));
            }
            for (Future future : futures) {
                try {
                    Number n = (Number)future.get();
                    result += n == null ? 0 : n.intValue();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new StoreException(e.getCause());
                }
            }
            return result;
        }

        List<SliceStoreManager> findTargets() {
            FetchConfiguration fetch = this.owner.getContext().getFetchConfiguration();
            return this.owner.getDistributedStore().getTargets(fetch);
        }
    }
}

