/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.basic;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.entity.basic.ErrorValue;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ErrorDao {
    private static final Logger log = Red5LoggerFactory.getLogger(ErrorDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public Long addErrorValues(Long id, ErrorValue.Type type, Long labelId) {
        try {
            ErrorValue eValue = new ErrorValue();
            eValue.setId(id);
            eValue.setType(type);
            eValue.setDeleted(false);
            eValue.setInserted(new Date());
            eValue.setLabelId(labelId);
            eValue = (ErrorValue)this.em.merge((Object)eValue);
            return eValue.getId();
        }
        catch (Exception ex2) {
            log.error("[addErrorValues]: ", (Throwable)ex2);
            return null;
        }
    }

    public Long getErrorValueById(ErrorValue.Type type, Long labelId) {
        try {
            ErrorValue eValue = new ErrorValue();
            eValue.setType(type);
            eValue.setInserted(new Date());
            eValue.setLabelId(labelId);
            eValue = (ErrorValue)this.em.merge((Object)eValue);
            return eValue.getId();
        }
        catch (Exception ex2) {
            log.error("[getErrorValueById]: ", (Throwable)ex2);
            return null;
        }
    }

    public Long updateErrorValues(ErrorValue.Type type, Long labelId) {
        try {
            ErrorValue eValue = new ErrorValue();
            eValue.setType(type);
            eValue.setInserted(new Date());
            eValue.setLabelId(labelId);
            eValue = (ErrorValue)this.em.merge((Object)eValue);
            return eValue.getId();
        }
        catch (Exception ex2) {
            log.error("[addErrorType]: ", (Throwable)ex2);
            return null;
        }
    }

    public ErrorValue get(Long id) {
        try {
            TypedQuery query = this.em.createNamedQuery("getErrorValueById", ErrorValue.class);
            query.setParameter("id", (Object)id);
            ErrorValue e = null;
            try {
                e = (ErrorValue)query.getSingleResult();
            }
            catch (NoResultException ex) {
                // empty catch block
            }
            return e;
        }
        catch (Exception ex2) {
            log.error("[get]", (Throwable)ex2);
            return null;
        }
    }
}

