/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.label;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.label.StringLabel;
import org.apache.openmeetings.db.util.ApplicationHelper;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.XmlExport;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.util.string.Strings;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LabelDao
implements IDataProviderDao<StringLabel> {
    private static final Logger log = Red5LoggerFactory.getLogger(LabelDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    private static final String ENTRY_ELEMENT = "entry";
    private static final String KEY_ATTR = "key";
    public static final String APP_RESOURCES_EN = "Application.properties.xml";
    public static final String APP_RESOURCES = "Application_%s.properties.xml";
    public static final LinkedHashMap<Long, Locale> languages = new LinkedHashMap();
    public static final ConcurrentHashMap<Locale, List<StringLabel>> labelCache = new ConcurrentHashMap();
    public static final Set<String> keys = new HashSet<String>();
    private static Class<?> APP = null;

    public List<Map<String, Object>> getStrings(Long language_id, int start, int count) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (int i = 0; i < count; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", start + i);
            map.put("value", this.getString(start + i, (long)language_id));
            result.add(map);
        }
        return result;
    }

    private static void storeLanguages() throws Exception {
        Document d = XmlExport.createDocument();
        Element r = XmlExport.createRoot((Document)d, (String)"language");
        for (Map.Entry<Long, Locale> e : languages.entrySet()) {
            r.addElement("lang").addAttribute("id", "" + e.getKey()).addAttribute("code", e.getValue().toLanguageTag());
        }
        XmlExport.toXml((File)LabelDao.getLangFile(), (Document)d);
    }

    public static void add(Locale l) throws Exception {
        long id = 0L;
        for (Map.Entry<Long, Locale> e : languages.entrySet()) {
            id = e.getKey();
        }
        languages.put(id + 1L, l);
        LabelDao.storeLanguages();
        labelCache.put(l, new ArrayList());
    }

    public String getString(long fieldValuesId, long langId) {
        return ApplicationHelper.ensureApplication(langId).getOmString(fieldValuesId, langId);
    }

    public String getString(String key, long langId) {
        return ApplicationHelper.ensureApplication(langId).getOmString(key, langId);
    }

    private static File getLangFile() {
        return new File(OmFileHelper.getLanguagesDir(), "languages.xml");
    }

    public static Class<?> getAppClass() throws ClassNotFoundException {
        if (APP == null) {
            APP = Class.forName("org.apache.openmeetings.web.app.Application");
        }
        return APP;
    }

    public static void initLanguageMap() {
        SAXReader reader = new SAXReader();
        try {
            LabelDao.getAppClass();
            Document document = reader.read(LabelDao.getLangFile());
            Element root = document.getRootElement();
            languages.clear();
            Iterator it = root.elementIterator("lang");
            while (it.hasNext()) {
                Element item = (Element)it.next();
                Long id = Long.valueOf(item.attributeValue("id"));
                String code = item.attributeValue("code");
                if (id == 3L) continue;
                languages.put(id, Locale.forLanguageTag(code));
            }
        }
        catch (Exception e) {
            log.error("Error while building language map");
        }
    }

    public static String getLabelFileName(Locale l) {
        String name = APP_RESOURCES_EN;
        if (!Locale.ENGLISH.equals(l)) {
            name = String.format(APP_RESOURCES, l.toLanguageTag().replace('-', '_'));
        }
        return name;
    }

    private static void storeLabels(Locale l) throws Exception {
        Document d = XmlExport.createDocument();
        Element r = XmlExport.createRoot((Document)d);
        List<StringLabel> labels = labelCache.get(l);
        for (StringLabel sl : labels) {
            r.addElement(ENTRY_ELEMENT).addAttribute(KEY_ATTR, (String)sl.getKey()).addCDATA((String)sl.getValue());
        }
        URL u = APP.getResource(LabelDao.getLabelFileName(l));
        XmlExport.toXml((File)new File(u.toURI()), (Document)d);
    }

    public static void upload(Locale l, InputStream is) throws Exception {
        List<StringLabel> labels = LabelDao.getLabels(is);
        URL u = APP.getResource(LabelDao.getLabelFileName(Locale.ENGLISH));
        File el = new File(u.toURI());
        File f = new File(el.getParentFile(), LabelDao.getLabelFileName(l));
        if (!f.exists()) {
            f.createNewFile();
        }
        labelCache.put(l, labels);
        LabelDao.storeLabels(l);
    }

    private static List<StringLabel> getLabels(Locale l) {
        List<StringLabel> labels = new ArrayList<StringLabel>();
        try (InputStream is = APP.getResourceAsStream(LabelDao.getLabelFileName(l));){
            labels = LabelDao.getLabels(is);
        }
        catch (Exception e) {
            log.error("Error reading resources document", (Throwable)e);
        }
        return labels;
    }

    private static List<StringLabel> getLabels(InputStream is) throws Exception {
        final ArrayList<StringLabel> labels = new ArrayList<StringLabel>();
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser parser = spf.newSAXParser();
        XMLReader xr = parser.getXMLReader();
        xr.setContentHandler(new ContentHandler(){
            StringLabel label = null;

            @Override
            public void startPrefixMapping(String prefix, String uri) throws SAXException {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                if (LabelDao.ENTRY_ELEMENT.equals(localName)) {
                    this.label = new StringLabel(atts.getValue(LabelDao.KEY_ATTR), "");
                }
            }

            @Override
            public void startDocument() throws SAXException {
            }

            @Override
            public void skippedEntity(String name) throws SAXException {
            }

            @Override
            public void setDocumentLocator(Locator locator) {
            }

            @Override
            public void processingInstruction(String target, String data) throws SAXException {
            }

            @Override
            public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            }

            @Override
            public void endPrefixMapping(String prefix) throws SAXException {
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (LabelDao.ENTRY_ELEMENT.equals(localName)) {
                    labels.add(this.label);
                }
            }

            @Override
            public void endDocument() throws SAXException {
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                StringBuilder sb = new StringBuilder((String)this.label.getValue());
                sb.append(ch, start, length);
                this.label.setValue(sb.toString());
            }
        });
        xr.parse(new InputSource(is));
        return labels;
    }

    private static List<StringLabel> getLabels(Locale l, final String search) {
        List<StringLabel> ll;
        if (!labelCache.containsKey(l) && (ll = LabelDao.getLabels(l)) != null) {
            labelCache.putIfAbsent(l, ll);
        }
        ArrayList<StringLabel> result = new ArrayList<StringLabel>(labelCache.containsKey(l) ? labelCache.get(l) : new ArrayList());
        if (!Strings.isEmpty((CharSequence)search)) {
            CollectionUtils.filter(result, (Predicate)new Predicate<StringLabel>(){

                public boolean evaluate(StringLabel o) {
                    return o != null && (((String)o.getKey()).contains(search) || ((String)o.getValue()).contains(search));
                }
            });
        }
        return result;
    }

    @Override
    public StringLabel get(long id) {
        throw new RuntimeException("Should not be used");
    }

    @Override
    public StringLabel get(Long id) {
        throw new RuntimeException("Should not be used");
    }

    @Override
    public List<StringLabel> get(int start, int count) {
        throw new RuntimeException("Should not be used");
    }

    @Override
    public List<StringLabel> get(String search, int start, int count, String order) {
        throw new RuntimeException("Should not be used");
    }

    public List<StringLabel> get(Locale l, String search, int start, int count, final SortParam<String> sort) {
        List<StringLabel> result = LabelDao.getLabels(l, search);
        if (sort != null) {
            Collections.sort(result, new Comparator<StringLabel>(){

                @Override
                public int compare(StringLabel o1, StringLabel o2) {
                    int val = 0;
                    if (LabelDao.KEY_ATTR.equals(sort.getProperty())) {
                        try {
                            int i1 = Integer.parseInt((String)o1.getKey());
                            int i2 = Integer.parseInt((String)o2.getKey());
                            val = i1 - i2;
                        }
                        catch (Exception e) {
                            val = ((String)o1.getKey()).compareTo((String)o2.getKey());
                        }
                    } else {
                        val = ((String)o1.getValue()).compareTo((String)o2.getValue());
                    }
                    return (sort.isAscending() ? 1 : -1) * val;
                }
            });
        }
        return result.subList(start, start + count > result.size() ? result.size() : start + count);
    }

    @Override
    public long count() {
        throw new RuntimeException("Should not be used");
    }

    @Override
    public long count(String search) {
        throw new RuntimeException("Should not be used");
    }

    public long count(Locale l, String search) {
        return LabelDao.getLabels(l, search).size();
    }

    @Override
    public StringLabel update(StringLabel entity, Long userId) {
        throw new RuntimeException("Should not be used");
    }

    public StringLabel update(Locale l, StringLabel entity) throws Exception {
        List<StringLabel> labels = labelCache.get(l);
        if (!labels.contains(entity)) {
            labels.add(entity);
            keys.add((String)entity.getKey());
        }
        LabelDao.storeLabels(l);
        return entity;
    }

    @Override
    public void delete(StringLabel entity, Long userId) {
        throw new RuntimeException("Should not be used");
    }

    public void delete(Locale l, StringLabel entity) throws Exception {
        List<StringLabel> labels = labelCache.get(l);
        if (labels.contains(entity)) {
            labels.remove(entity);
            keys.remove(entity.getKey());
            LabelDao.storeLabels(l);
        }
    }

    public static void delete(Locale l) {
        for (Map.Entry<Long, Locale> e : languages.entrySet()) {
            if (!e.getValue().equals(l)) continue;
            languages.remove(e.getKey());
            break;
        }
        labelCache.remove(l);
        try {
            File f;
            URL u = APP.getResource(LabelDao.getLabelFileName(l));
            if (u != null && (f = new File(u.toURI())).exists()) {
                f.delete();
            }
        }
        catch (Exception e) {
            log.error("Unexpected error while deleting language", (Throwable)e);
        }
    }
}

