/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.record;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.dto.record.RecordingContainerData;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RecordingDao {
    private static final Logger log = Red5LoggerFactory.getLogger(RecordingDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private UserDao userDao;

    public Recording get(Long recordingId) {
        try {
            TypedQuery query = this.em.createNamedQuery("getRecordingById", Recording.class);
            query.setParameter("id", (Object)recordingId);
            Recording recording = null;
            try {
                recording = (Recording)query.getSingleResult();
            }
            catch (NoResultException ex) {
                // empty catch block
            }
            return recording;
        }
        catch (Exception ex2) {
            log.error("[get]: ", (Throwable)ex2);
            return null;
        }
    }

    public Recording getByHash(String hash) {
        try {
            TypedQuery query = this.em.createNamedQuery("getRecordingByHash", Recording.class);
            query.setParameter("hash", (Object)hash);
            try {
                return (Recording)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
            }
        }
        catch (Exception ex2) {
            log.error("[getByHash]: ", (Throwable)ex2);
        }
        return null;
    }

    public List<Recording> getByExternalId(String externalId, String externalType) {
        try {
            log.debug("getFByExternalId :externalId: {}; externalType: {}", (Object)externalId, (Object)externalType);
            TypedQuery query = this.em.createNamedQuery("getRecordingsByExternalUser", Recording.class);
            query.setParameter("externalId", (Object)externalId);
            query.setParameter("externalType", (Object)externalType);
            List recordingList = query.getResultList();
            log.debug("getByExternalId :: " + recordingList.size());
            return recordingList;
        }
        catch (Exception ex2) {
            log.error("[getByExternalId]: ", (Throwable)ex2);
            return null;
        }
    }

    public List<Recording> getByExternalTypeAndCreator(String externalType, Long insertedBy) {
        try {
            log.debug("getByExternalType :externalType: " + externalType);
            TypedQuery query = this.em.createNamedQuery("getRecordingsByExternalTypeAndOwner", Recording.class);
            query.setParameter("externalType", (Object)externalType);
            query.setParameter("insertedBy", (Object)insertedBy);
            List recordingList = query.getResultList();
            log.debug("getByExternalType :: " + recordingList.size());
            return recordingList;
        }
        catch (Exception ex2) {
            log.error("[getByExternalType]: ", (Throwable)ex2);
            return null;
        }
    }

    public List<Recording> get() {
        try {
            TypedQuery query = this.em.createNamedQuery("getRecordingsAll", Recording.class);
            return query.getResultList();
        }
        catch (Exception ex2) {
            log.error("[get]: ", (Throwable)ex2);
            return null;
        }
    }

    public List<Recording> getByExternalType(String externalType) {
        log.debug("getByExternalType :externalType: " + externalType);
        TypedQuery query = this.em.createNamedQuery("getRecordingsByExternalType", Recording.class);
        query.setParameter("externalType", (Object)externalType);
        return query.getResultList();
    }

    public List<Recording> getRootByPublic(Long groupId) {
        TypedQuery q = this.em.createNamedQuery(groupId == null ? "getRecordingsPublic" : "getRecordingsByGroup", Recording.class);
        if (groupId != null) {
            q.setParameter("groupId", (Object)groupId);
        }
        return q.getResultList();
    }

    public List<Recording> getRootByOwner(Long ownerId) {
        return this.em.createNamedQuery("getRecordingsByOwner", Recording.class).setParameter("ownerId", (Object)ownerId).getResultList();
    }

    public List<Recording> getByRoomId(Long roomId) {
        try {
            TypedQuery query = this.em.createNamedQuery("getRecordingsByRoom", Recording.class);
            query.setParameter("roomId", (Object)roomId);
            List recordingList = query.getResultList();
            return recordingList;
        }
        catch (Exception ex2) {
            log.error("[getByRoomId]: ", (Throwable)ex2);
            return null;
        }
    }

    public List<Recording> getByParent(Long parentId) {
        return this.em.createNamedQuery("getRecordingsByParent", Recording.class).setParameter("parentId", (Object)parentId).getResultList();
    }

    public void updateEndTime(Long recordingId, Date recordEnd) {
        try {
            Recording fId = this.get(recordingId);
            fId.setProgressPostProcessing(0);
            fId.setRecordEnd(recordEnd);
            this.update(fId);
        }
        catch (Exception ex2) {
            log.error("[updateEndTime]: ", (Throwable)ex2);
        }
    }

    public boolean delete(Recording f) {
        if (f == null || f.getId() == null) {
            return false;
        }
        f.setDeleted(true);
        this.update(f);
        return true;
    }

    public Recording update(Recording f) {
        try {
            if (f.getId() == null) {
                f.setInserted(new Date());
                this.em.persist((Object)f);
            } else {
                f.setUpdated(new Date());
                if (!this.em.contains((Object)f)) {
                    f = (Recording)this.em.merge((Object)f);
                }
            }
        }
        catch (Exception ex2) {
            log.error("[update]: ", (Throwable)ex2);
        }
        return f;
    }

    public void resetProcessingStatus() {
        this.em.createNamedQuery("resetRecordingProcessingStatus").setParameter("error", (Object)Recording.Status.ERROR).setParameter("recording", (Object)Recording.Status.RECORDING).setParameter("converting", (Object)Recording.Status.CONVERTING).executeUpdate();
    }

    public RecordingContainerData getContainerData(long userId) {
        try {
            RecordingContainerData containerData = new RecordingContainerData();
            List<Recording> homes = this.getRootByOwner(userId);
            long homeFileSize = 0L;
            for (Recording home : homes) {
                homeFileSize += this.getSize(home);
            }
            containerData.setUserHomeSize(homeFileSize);
            long publicFileSize = 0L;
            for (GroupUser ou : this.userDao.get(userId).getGroupUsers()) {
                List<Recording> publicRecordings = this.getRootByPublic(ou.getGroup().getId());
                for (Recording r : publicRecordings) {
                    publicFileSize += this.getSize(r);
                }
            }
            containerData.setPublicFileSize(publicFileSize);
            return containerData;
        }
        catch (Exception ex2) {
            log.error("[getRecordingContainerData]: ", (Throwable)ex2);
            return null;
        }
    }

    private long getSize(Recording r) {
        long size = 0L;
        if (OmFileHelper.isRecordingExists((String)r.getHash())) {
            size += OmFileHelper.getRecording((String)r.getHash()).length();
        }
        if (OmFileHelper.isRecordingExists((String)r.getAlternateDownload())) {
            size += OmFileHelper.getRecording((String)r.getAlternateDownload()).length();
        }
        if (OmFileHelper.isRecordingExists((String)r.getPreviewImage())) {
            size += OmFileHelper.getRecording((String)r.getPreviewImage()).length();
        }
        if (OmFileHelper.isRecordingExists((String)(r.getHash() + ".mp4"))) {
            size += OmFileHelper.getMp4Recording((String)r.getHash()).length();
        }
        if (OmFileHelper.isRecordingExists((String)(r.getHash() + ".ogg"))) {
            size += OmFileHelper.getOggRecording((String)r.getHash()).length();
        }
        for (Recording rec : this.getByParent(r.getId())) {
            size += this.getSize(rec);
        }
        return size;
    }
}

