/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class InvitationDao {
    private static final Logger log = Red5LoggerFactory.getLogger(InvitationDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public Invitation update(Invitation invitation) {
        if (invitation.getId() == null) {
            invitation.setInserted(new Date());
            this.em.persist((Object)invitation);
        } else {
            invitation.setUpdated(new Date());
            invitation = (Invitation)this.em.merge((Object)invitation);
        }
        return invitation;
    }

    public Invitation get(Long invId) {
        try {
            TypedQuery query = this.em.createNamedQuery("getInvitationbyId", Invitation.class);
            query.setParameter("id", (Object)invId);
            try {
                return (Invitation)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
            }
        }
        catch (Exception e) {
            log.error("get : ", (Throwable)e);
        }
        return null;
    }

    public Invitation getInvitationByHashCode(String hashCode, boolean hidePass) {
        try {
            TypedQuery query = this.em.createNamedQuery("getInvitationByHashCode", Invitation.class);
            query.setParameter("hashCode", (Object)hashCode);
            try {
                return (Invitation)query.getSingleResult();
            }
            catch (NoResultException ex) {
            }
        }
        catch (Exception e) {
            log.error("getInvitationByHashCode : ", (Throwable)e);
        }
        return null;
    }
}

