/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.entity.room.RoomPoll;
import org.apache.openmeetings.db.entity.room.RoomPollAnswer;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PollDao {
    private static final Logger log = Red5LoggerFactory.getLogger(PollDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public RoomPoll update(RoomPoll p) {
        if (p.getId() == null) {
            p.setCreated(new Date());
            this.em.persist((Object)p);
        } else {
            p = (RoomPoll)this.em.merge((Object)p);
        }
        return p;
    }

    public boolean close(Long roomId) {
        try {
            log.debug(" :: close :: ");
            Query q = this.em.createNamedQuery("closePoll");
            q.setParameter("roomId", (Object)roomId);
            q.setParameter("archived", (Object)true);
            return q.executeUpdate() > 0;
        }
        catch (Exception err) {
            log.error("[close]", (Throwable)err);
            return false;
        }
    }

    public boolean delete(RoomPoll p) {
        try {
            log.debug(" :: delete :: ");
            Query q = this.em.createNamedQuery("deletePoll");
            q.setParameter("id", (Object)p.getId());
            return q.executeUpdate() > 0;
        }
        catch (Exception err) {
            log.error("[delete]", (Throwable)err);
            return false;
        }
    }

    public RoomPoll get(Long id) {
        List list = this.em.createNamedQuery("getPollById", RoomPoll.class).setParameter("id", (Object)id).getResultList();
        return list.isEmpty() ? null : (RoomPoll)list.get(0);
    }

    public RoomPoll getByRoom(Long roomId) {
        try {
            log.debug(" :: getPoll :: " + roomId);
            TypedQuery q = this.em.createNamedQuery("getPoll", RoomPoll.class);
            q.setParameter("roomId", (Object)roomId);
            return (RoomPoll)q.getSingleResult();
        }
        catch (NoResultException nre) {
        }
        catch (Exception err) {
            log.error("[getPoll]", (Throwable)err);
        }
        return null;
    }

    public List<RoomPoll> get() {
        try {
            TypedQuery q = this.em.createNamedQuery("getPollListBackup", RoomPoll.class);
            return q.getResultList();
        }
        catch (NoResultException nre) {
        }
        catch (Exception err) {
            log.error("[get]", (Throwable)err);
        }
        return null;
    }

    public List<RoomPoll> getArchived(Long roomId) {
        try {
            log.debug(" :: getArchived :: " + roomId);
            TypedQuery q = this.em.createNamedQuery("getArchivedPollList", RoomPoll.class);
            q.setParameter("roomId", (Object)roomId);
            return q.getResultList();
        }
        catch (NoResultException nre) {
        }
        catch (Exception err) {
            log.error("[getArchived]", (Throwable)err);
        }
        return null;
    }

    public boolean hasPoll(Long roomId) {
        try {
            log.debug(" :: hasPoll :: " + roomId);
            TypedQuery q = this.em.createNamedQuery("hasPoll", Long.class);
            q.setParameter("roomId", (Object)roomId);
            q.setParameter("archived", (Object)false);
            return (Long)q.getSingleResult() > 0L;
        }
        catch (NoResultException nre) {
        }
        catch (Exception err) {
            log.error("[hasPoll]", (Throwable)err);
        }
        return false;
    }

    public boolean hasVoted(Long roomId, Long userId) {
        try {
            log.debug(" :: hasVoted :: " + roomId + ", " + userId);
            TypedQuery q = this.em.createNamedQuery("hasVoted", RoomPollAnswer.class);
            q.setParameter("roomId", (Object)roomId);
            q.setParameter("userId", (Object)userId);
            q.getSingleResult();
            return true;
        }
        catch (NoResultException nre) {
        }
        catch (Exception err) {
            log.error("[hasVoted]", (Throwable)err);
        }
        return false;
    }
}

