/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.server;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.util.DaoHelper;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class OAuth2Dao
implements IDataProviderDao<OAuthServer> {
    public static final String[] searchFields = new String[]{"name"};
    @PersistenceContext
    private EntityManager em;

    public List<OAuthServer> getActive() {
        TypedQuery query = this.em.createNamedQuery("getEnabledOAuthServers", OAuthServer.class);
        return query.getResultList();
    }

    @Override
    public OAuthServer get(long id) {
        return this.get((Long)id);
    }

    @Override
    public OAuthServer get(Long id) {
        TypedQuery query = this.em.createNamedQuery("getOAuthServerById", OAuthServer.class);
        query.setParameter("id", (Object)id);
        OAuthServer result = null;
        try {
            result = (OAuthServer)query.getSingleResult();
        }
        catch (NoResultException e) {
            // empty catch block
        }
        return result;
    }

    @Override
    public List<OAuthServer> get(int start, int count) {
        TypedQuery query = this.em.createNamedQuery("getAllOAuthServers", OAuthServer.class);
        query.setFirstResult(start);
        query.setMaxResults(count);
        return query.getResultList();
    }

    @Override
    public List<OAuthServer> get(String search, int start, int count, String order) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"OAuthServer", (String)"s", (String)search, (boolean)true, (boolean)false, null, (String[])searchFields), OAuthServer.class);
        q.setFirstResult(start);
        q.setMaxResults(count);
        return q.getResultList();
    }

    @Override
    public long count() {
        TypedQuery q = this.em.createNamedQuery("countOAuthServers", Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public long count(String search) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"OAuthServer", (String)"s", (String)search, (boolean)true, (boolean)true, null, (String[])searchFields), Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public OAuthServer update(OAuthServer server, Long userId) {
        if (server.getId() == null) {
            this.em.persist((Object)server);
        } else {
            server = (OAuthServer)this.em.merge((Object)server);
        }
        return server;
    }

    @Override
    public void delete(OAuthServer server, Long userId) {
        server.setDeleted(true);
        this.update(server, userId);
    }
}

