/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.server;

import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.entity.server.SOAPLogin;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SOAPLoginDao {
    private static final Logger log = Red5LoggerFactory.getLogger(SOAPLoginDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public String addSOAPLogin(String sessionHash, Long roomId, boolean becomemoderator, boolean showAudioVideoTest, boolean allowSameURLMultipleTimes, Long recordingId, boolean showNickNameDialog, String landingZone, boolean allowRecording) {
        try {
            SOAPLogin soapLogin = new SOAPLogin();
            soapLogin.setCreated(new Date());
            soapLogin.setUsed(false);
            soapLogin.setRoomId(roomId);
            soapLogin.setAllowSameURLMultipleTimes(allowSameURLMultipleTimes);
            soapLogin.setHash(UUID.randomUUID().toString());
            soapLogin.setRecordingId(recordingId);
            soapLogin.setSessionHash(sessionHash);
            soapLogin.setBecomemoderator(becomemoderator);
            soapLogin.setShowAudioVideoTest(showAudioVideoTest);
            soapLogin.setShowNickNameDialog(showNickNameDialog);
            soapLogin.setLandingZone(landingZone);
            soapLogin.setAllowRecording(allowRecording);
            soapLogin = (SOAPLogin)this.em.merge((Object)soapLogin);
            Long soapLoginId = soapLogin.getId();
            if (soapLoginId != null) {
                return soapLogin.getHash();
            }
            throw new Exception("Could not store SOAPLogin");
        }
        catch (Exception ex2) {
            log.error("[addSOAPLogin]: ", (Throwable)ex2);
            return null;
        }
    }

    public SOAPLogin get(String hash) {
        try {
            String hql = "select sl from SOAPLogin as sl WHERE sl.hash LIKE :hash";
            TypedQuery query = this.em.createQuery(hql, SOAPLogin.class);
            query.setParameter("hash", (Object)hash);
            List sList = query.getResultList();
            if (sList.size() > 1) {
                throw new Exception("there are more then one SOAPLogin with identical hash! " + hash);
            }
            if (sList.size() == 1) {
                return (SOAPLogin)sList.get(0);
            }
        }
        catch (Exception ex2) {
            log.error("[get]: ", (Throwable)ex2);
        }
        return null;
    }

    public void update(SOAPLogin soapLogin) {
        try {
            if (soapLogin.getId() == null) {
                this.em.persist((Object)soapLogin);
            } else if (!this.em.contains((Object)soapLogin)) {
                this.em.merge((Object)soapLogin);
            }
        }
        catch (Exception ex2) {
            log.error("[update]: ", (Throwable)ex2);
        }
    }
}

