/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.util.DaoHelper;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class GroupUserDao
implements IDataProviderDao<GroupUser> {
    @PersistenceContext
    private EntityManager em;
    public static final String[] searchFields = new String[]{"user.lastname", "user.firstname", "user.login", "user.address.email"};

    @Override
    public GroupUser get(long id) {
        return this.get((Long)id);
    }

    @Override
    public GroupUser get(Long id) {
        TypedQuery q = this.em.createNamedQuery("getGroupUsersById", GroupUser.class);
        q.setParameter("id", (Object)id);
        return (GroupUser)q.getSingleResult();
    }

    @Override
    public List<GroupUser> get(int start, int count) {
        throw new RuntimeException("Should not be used");
    }

    @Override
    public List<GroupUser> get(String search, int start, int count, String sort) {
        throw new RuntimeException("Should not be used");
    }

    public List<GroupUser> get(long groupId, String search, int start, int count, String sort) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)GroupUser.class.getSimpleName(), (String)"ou", null, (String)search, (boolean)false, (boolean)false, (String)"ou.group.id = :groupId", (String)sort, (String[])searchFields), GroupUser.class);
        q.setParameter("groupId", (Object)groupId);
        q.setFirstResult(start);
        q.setMaxResults(count);
        return q.getResultList();
    }

    public List<GroupUser> get(long groupId, int start, int count) {
        TypedQuery q = this.em.createNamedQuery("getGroupUsersByGroupId", GroupUser.class);
        q.setParameter("id", (Object)groupId);
        q.setFirstResult(start);
        q.setMaxResults(count);
        return q.getResultList();
    }

    public GroupUser getByGroupAndUser(long groupId, long userId) {
        try {
            List list = this.em.createNamedQuery("isUserInGroup", GroupUser.class).setParameter("groupId", (Object)groupId).setParameter("userId", (Object)userId).getResultList();
            if (list != null && !list.isEmpty()) {
                return (GroupUser)list.get(0);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    public boolean isUserInGroup(long groupId, long userId) {
        return this.em.createNamedQuery("isUserInGroup", GroupUser.class).setParameter("groupId", (Object)groupId).setParameter("userId", (Object)userId).getResultList().size() > 0;
    }

    @Override
    public long count() {
        throw new RuntimeException("Should not be used");
    }

    @Override
    public long count(String search) {
        throw new RuntimeException("Should not be used");
    }

    public long count(long groupId, String search) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)GroupUser.class.getSimpleName(), (String)"ou", (String)search, (boolean)false, (boolean)true, null, (String[])searchFields), Long.class);
        return (Long)q.getSingleResult();
    }

    public long count(long groupId) {
        TypedQuery q = this.em.createNamedQuery("countGroupUsers", Long.class);
        q.setParameter("id", (Object)groupId);
        return (Long)q.getSingleResult();
    }

    @Override
    public GroupUser update(GroupUser entity, Long userId) {
        throw new RuntimeException("Should not be used");
    }

    @Override
    public void delete(GroupUser entity, Long userId) {
        throw new RuntimeException("Should not be used");
    }
}

