/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.PrivateMessage;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class PrivateMessageDao
implements IDataProviderDao<PrivateMessage> {
    private static final Logger log = Red5LoggerFactory.getLogger(PrivateMessageDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public Long addPrivateMessage(String subject, String message, Long parentMessageId, User from, User to, User owner, Boolean bookedRoom, Room room, boolean isContactRequest, Long userContactId) {
        try {
            PrivateMessage privateMessage = new PrivateMessage();
            privateMessage.setInserted(new Date());
            privateMessage.setSubject(subject);
            privateMessage.setMessage(message);
            privateMessage.setFrom(from);
            privateMessage.setTo(to);
            privateMessage.setOwner(owner);
            privateMessage.setBookedRoom(Boolean.TRUE.equals(bookedRoom));
            privateMessage.setRoom(room);
            privateMessage.setParentMessage(parentMessageId);
            privateMessage.setFolderId(PrivateMessage.INBOX_FOLDER_ID);
            privateMessage.setIsRead(false);
            privateMessage.setIsContactRequest(isContactRequest);
            privateMessage.setUserContactId(userContactId);
            privateMessage = (PrivateMessage)this.em.merge((Object)privateMessage);
            Long privateMessageId = privateMessage.getFolderId();
            return privateMessageId;
        }
        catch (Exception e) {
            log.error("[addPrivateMessage]", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<PrivateMessage> get(int first, int count) {
        return this.em.createNamedQuery("getPrivateMessages", PrivateMessage.class).setFirstResult(first).setMaxResults(count).getResultList();
    }

    @Override
    public PrivateMessage get(long id) {
        return this.get((Long)id);
    }

    @Override
    public PrivateMessage get(Long id) {
        TypedQuery query = this.em.createNamedQuery("getPrivateMessageById", PrivateMessage.class);
        query.setParameter("id", (Object)id);
        PrivateMessage privateMessage = null;
        try {
            privateMessage = (PrivateMessage)query.getSingleResult();
        }
        catch (NoResultException ex) {
            // empty catch block
        }
        return privateMessage;
    }

    @Override
    public PrivateMessage update(PrivateMessage entity, Long userId) {
        if (entity.getId() == null) {
            entity.setInserted(new Date());
            this.em.persist((Object)entity);
        } else {
            entity = (PrivateMessage)this.em.merge((Object)entity);
        }
        return entity;
    }

    private static String getQuery(boolean isCount, String search, String orderBy, boolean asc) {
        StringBuilder hql = new StringBuilder("SELECT ");
        hql.append(isCount ? "COUNT(" : "").append("m").append(isCount ? ")" : "").append(" FROM PrivateMessage m WHERE m.owner.id = :ownerId ").append(" AND m.folderId = :folderId ");
        if (!StringUtils.isEmpty((CharSequence)search)) {
            hql.append(" AND ( ").append("lower(m.subject) LIKE :search ").append("OR lower(m.message) LIKE :search ").append("OR lower(m.from.firstname) LIKE :search ").append("OR lower(m.from.lastname) LIKE :search ").append("OR lower(m.from.login) LIKE :search ").append("OR lower(m.from.address.email) LIKE :search ").append(" ) ");
        }
        if (!isCount && !StringUtils.isEmpty((CharSequence)orderBy)) {
            hql.append(" ORDER BY ").append(orderBy).append(asc ? " ASC" : " DESC");
        }
        return hql.toString();
    }

    public Long count(Long ownerId, Long folderId, String search) {
        TypedQuery query = this.em.createQuery(PrivateMessageDao.getQuery(true, search, null, true), Long.class);
        query.setParameter("ownerId", (Object)ownerId);
        if (!StringUtils.isEmpty((CharSequence)search)) {
            query.setParameter("search", (Object)StringUtils.lowerCase((String)("%" + search + "%")));
        }
        query.setParameter("folderId", (Object)folderId);
        return (Long)query.getSingleResult();
    }

    public List<PrivateMessage> get(Long ownerId, Long folderId, String search, String orderBy, boolean asc, int start, int max) {
        TypedQuery query = this.em.createQuery(PrivateMessageDao.getQuery(false, search, orderBy, asc), PrivateMessage.class);
        query.setParameter("ownerId", (Object)ownerId);
        query.setParameter("folderId", (Object)folderId);
        if (!StringUtils.isEmpty((CharSequence)search)) {
            query.setParameter("search", (Object)StringUtils.lowerCase((String)("%" + search + "%")));
        }
        query.setFirstResult(start);
        query.setMaxResults(max);
        return query.getResultList();
    }

    public int updateReadStatus(Collection<Long> ids, Boolean isRead) {
        Query query = this.em.createNamedQuery("updatePrivateMessagesReadStatus");
        query.setParameter("isRead", (Object)isRead);
        query.setParameter("ids", ids);
        return query.executeUpdate();
    }

    public int moveMailsToFolder(Collection<Long> ids, Long folderId) {
        Query query = this.em.createNamedQuery("moveMailsToFolder");
        query.setParameter("folderId", (Object)folderId);
        query.setParameter("ids", ids);
        return query.executeUpdate();
    }

    public int delete(Collection<Long> ids) {
        Query query = this.em.createNamedQuery("deletePrivateMessages");
        query.setParameter("ids", ids);
        return query.executeUpdate();
    }

    public List<PrivateMessage> getByRoom(Long roomId) {
        return this.em.createNamedQuery("getPrivateMessagesByRoom", PrivateMessage.class).setParameter("roomId", (Object)roomId).getResultList();
    }

    @Override
    public List<PrivateMessage> get(String search, int start, int count, String order) {
        throw new RuntimeException("Should not be used");
    }

    @Override
    public long count() {
        throw new RuntimeException("Should not be used");
    }

    @Override
    public long count(String search) {
        throw new RuntimeException("Should not be used");
    }

    @Override
    public void delete(PrivateMessage entity, Long userId) {
        throw new RuntimeException("Should not be used");
    }
}

