/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.user.GroupDao;
import org.apache.openmeetings.db.entity.user.Address;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.AuthLevelUtil;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.db.util.UserHelper;
import org.apache.openmeetings.util.DaoHelper;
import org.apache.openmeetings.util.OmException;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.wicket.util.string.Strings;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class UserDao
implements IDataProviderDao<User> {
    private static final Logger log = Red5LoggerFactory.getLogger(UserDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    public static final String[] searchFields = new String[]{"lastname", "firstname", "login", "address.email", "address.town"};
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private ConfigurationDao cfgDao;
    @Autowired
    private GroupDao groupDao;
    @Autowired
    private TimezoneUtil timezoneUtil;

    public static Set<User.Right> getDefaultRights() {
        HashSet<User.Right> rights = new HashSet<User.Right>();
        rights.add(User.Right.Login);
        rights.add(User.Right.Dashboard);
        rights.add(User.Right.Room);
        return rights;
    }

    public User getNewUserInstance(User currentUser) {
        User user = new User();
        user.setSalutation(User.Salutation.mr);
        user.setRights(UserDao.getDefaultRights());
        user.setLanguageId(this.cfgDao.getConfValue("default_lang_id", Long.class, "1"));
        user.setTimeZoneId(this.timezoneUtil.getTimeZone(currentUser).getID());
        user.setForceTimeZoneCheck(false);
        user.setSendSMS(false);
        user.setAge(new Date());
        Address address = new Address();
        address.setCountry(Locale.getDefault().getCountry());
        user.setAddress(address);
        user.setShowContactData(false);
        user.setShowContactDataToContacts(false);
        return user;
    }

    @Override
    public List<User> get(int first, int count) {
        TypedQuery q = this.em.createNamedQuery("getNondeletedUsers", User.class);
        q.setFirstResult(first);
        q.setMaxResults(count);
        return q.getResultList();
    }

    private static String getAdditionalJoin(boolean filterContacts) {
        return filterContacts ? "LEFT JOIN u.groupUsers ou" : null;
    }

    private static String getAdditionalWhere(boolean excludeContacts, Map<String, Object> params) {
        if (excludeContacts) {
            params.put("contact", (Object)User.Type.contact);
            return "u.type <> :contact";
        }
        return null;
    }

    private static String getAdditionalWhere(boolean filterContacts, Long ownerId, Map<String, Object> params) {
        if (filterContacts) {
            params.put("ownerId", ownerId);
            params.put("contact", (Object)User.Type.contact);
            return "((u.type <> :contact AND ou.group.id IN (SELECT ou.group.id FROM GroupUser ou WHERE ou.user.id = :ownerId)) OR (u.type = :contact AND u.ownerId = :ownerId))";
        }
        return null;
    }

    private static void setAdditionalParams(TypedQuery<?> q, Map<String, Object> params) {
        for (Map.Entry<String, Object> me : params.entrySet()) {
            q.setParameter(me.getKey(), me.getValue());
        }
    }

    public List<User> get(String search, int start, int count, String sort, boolean filterContacts, Long currentUserId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"User", (String)"u", (String)UserDao.getAdditionalJoin(filterContacts), (String)search, (boolean)true, (boolean)true, (boolean)false, (String)UserDao.getAdditionalWhere(filterContacts, currentUserId, params), (String)sort, (String[])searchFields), User.class);
        q.setFirstResult(start);
        q.setMaxResults(count);
        UserDao.setAdditionalParams(q, params);
        return q.getResultList();
    }

    @Override
    public long count() {
        TypedQuery q = this.em.createNamedQuery("countNondeletedUsers", Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public long count(String search) {
        return this.count(search, false, -1L);
    }

    public long count(String search, Long currentUserId) {
        return this.count(search, false, currentUserId);
    }

    public long count(String search, boolean filterContacts, Long currentUserId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"User", (String)"u", (String)UserDao.getAdditionalJoin(filterContacts), (String)search, (boolean)true, (boolean)true, (boolean)true, (String)UserDao.getAdditionalWhere(filterContacts, currentUserId, params), null, (String[])searchFields), Long.class);
        UserDao.setAdditionalParams(q, params);
        return (Long)q.getSingleResult();
    }

    public List<User> get(String search, boolean excludeContacts, int first, int count) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"User", (String)"u", null, (String)search, (boolean)true, (boolean)true, (boolean)false, (String)UserDao.getAdditionalWhere(excludeContacts, params), null, (String[])searchFields), User.class);
        UserDao.setAdditionalParams(q, params);
        q.setFirstResult(first);
        q.setMaxResults(count);
        return q.getResultList();
    }

    public List<User> get(String search, boolean filterContacts, Long currentUserId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"User", (String)"u", (String)UserDao.getAdditionalJoin(filterContacts), (String)search, (boolean)true, (boolean)true, (boolean)false, (String)UserDao.getAdditionalWhere(filterContacts, currentUserId, params), null, (String[])searchFields), User.class);
        UserDao.setAdditionalParams(q, params);
        return q.getResultList();
    }

    @Override
    public User update(User u, Long userId) {
        if (u.getId() == null) {
            if (u.getRegdate() == null) {
                u.setRegdate(new Date());
            }
            u.setInserted(new Date());
            this.em.persist((Object)u);
        } else {
            u.setUpdated(new Date());
            u = (User)this.em.merge((Object)u);
        }
        return u;
    }

    public User resetPassword(User u, String password) throws NoSuchAlgorithmException {
        if (u != null) {
            u.setResethash(null);
            u = this.update(u, password, u.getId());
        }
        return u;
    }

    public User update(User user, String password, Long updatedBy) throws NoSuchAlgorithmException {
        User u = this.update(user, updatedBy);
        if (u != null && !Strings.isEmpty((CharSequence)password)) {
            User u1 = this.get(u.getId(), true);
            u1.updatePassword(this.cfgDao, password);
            u = this.update(u1, updatedBy);
        }
        return u;
    }

    @Override
    public User get(Long id) {
        return this.get(id, false);
    }

    @Override
    public User get(long id) {
        return this.get(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User get(Long id, boolean force) {
        User u = null;
        if (id != null && id > 0L) {
            OpenJPAEntityManager oem = OpenJPAPersistence.cast((EntityManager)this.em);
            boolean qrce = oem.getFetchPlan().getQueryResultCacheEnabled();
            try {
                oem.getFetchPlan().setQueryResultCacheEnabled(false);
                TypedQuery q = oem.createNamedQuery("getUserById", User.class).setParameter("id", (Object)id);
                OpenJPAQuery kq = OpenJPAPersistence.cast((Query)q);
                kq.getFetchPlan().addFetchGroup("groupUsers");
                if (force) {
                    kq.getFetchPlan().addFetchGroup("backupexport");
                }
                try {
                    u = (User)kq.getSingleResult();
                }
                catch (NoResultException ne) {
                    // empty catch block
                }
            }
            finally {
                oem.getFetchPlan().setQueryResultCacheEnabled(qrce);
            }
        } else {
            log.info("[get] Info: No user id given");
        }
        return u;
    }

    @Override
    public void delete(User u, Long userId) {
        if (u != null && u.getId() != null) {
            for (GroupUser ou : u.getGroupUsers()) {
                this.em.remove((Object)ou);
            }
            u.setGroupUsers(null);
            u.setDeleted(true);
            u.setUpdated(new Date());
            u.setSipUser(null);
            Address adr = u.getAddress();
            if (adr != null) {
                adr.setDeleted(true);
            }
            this.update(u, userId);
        }
    }

    public List<User> get(Collection<Long> ids) {
        return this.em.createNamedQuery("getUsersByIds", User.class).setParameter("ids", ids).getResultList();
    }

    public List<User> getAllUsers() {
        TypedQuery q = this.em.createNamedQuery("getNondeletedUsers", User.class);
        return q.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> getAllBackupUsers() {
        OpenJPAEntityManager oem = OpenJPAPersistence.cast((EntityManager)this.em);
        boolean qrce = oem.getFetchPlan().getQueryResultCacheEnabled();
        try {
            oem.getFetchPlan().setQueryResultCacheEnabled(false);
            TypedQuery q = oem.createNamedQuery("getAllUsers", User.class);
            OpenJPAQuery kq = OpenJPAPersistence.cast((Query)q);
            kq.getFetchPlan().addFetchGroups(new String[]{"backupexport", "groupUsers"});
            List list = kq.getResultList();
            return list;
        }
        finally {
            oem.getFetchPlan().setQueryResultCacheEnabled(qrce);
        }
    }

    public boolean checkLogin(String login, User.Type type, Long domainId, Long id) {
        try {
            User u = this.getByLogin(login, type, domainId);
            return u == null || u.getId().equals(id);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean checkEmail(String email, User.Type type, Long domainId, Long id) {
        log.debug("checkEmail: email = {}, id = {}", (Object)email, (Object)id);
        try {
            User u = this.getByEmail(email, type, domainId);
            return u == null || u.getId().equals(id);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean validLogin(String login) {
        return !Strings.isEmpty((CharSequence)login) && login.length() >= UserHelper.getMinLoginLength(this.cfgDao);
    }

    public User getByLogin(String login, User.Type type, Long domainId) {
        User u = null;
        try {
            u = (User)this.em.createNamedQuery("getUserByLogin", User.class).setParameter("login", (Object)login).setParameter("type", (Object)type).setParameter("domainId", (Object)(domainId == null ? Long.valueOf(0L) : domainId)).getSingleResult();
        }
        catch (NoResultException ex) {
            // empty catch block
        }
        return u;
    }

    public User getByEmail(String email) {
        return this.getByEmail(email, User.Type.user, null);
    }

    public User getByEmail(String email, User.Type type, Long domainId) {
        User u = null;
        try {
            u = (User)this.em.createNamedQuery("getUserByEmail", User.class).setParameter("email", (Object)email).setParameter("type", (Object)type).setParameter("domainId", (Object)(domainId == null ? Long.valueOf(0L) : domainId)).getSingleResult();
        }
        catch (NoResultException ex) {
            // empty catch block
        }
        return u;
    }

    public Object getUserByHash(String hash) {
        if (hash.length() == 0) {
            return new Long(-5L);
        }
        User us = null;
        try {
            us = (User)this.em.createNamedQuery("getUserByHash", User.class).setParameter("resethash", (Object)hash).setParameter("type", (Object)User.Type.user).getSingleResult();
        }
        catch (NoResultException ex) {
        }
        catch (Exception e) {
            log.error("[getUserByHash]", (Throwable)e);
        }
        if (us != null) {
            return us;
        }
        return new Long(-5L);
    }

    public Long selectMaxFromUsersWithSearch(String search) {
        try {
            TypedQuery query = this.em.createNamedQuery("selectMaxFromUsersWithSearch", Long.class);
            query.setParameter("search", (Object)StringUtils.lowerCase((String)search));
            List ll = query.getResultList();
            log.info("selectMaxFromUsers" + ll.get(0));
            return (Long)ll.get(0);
        }
        catch (Exception ex2) {
            log.error("[selectMaxFromUsers] ", (Throwable)ex2);
            return null;
        }
    }

    public boolean verifyPassword(Long userId, String password) {
        List l = this.em.createNamedQuery("getPassword", String.class).setParameter("userId", (Object)userId).getResultList();
        if (l == null || l.size() != 1) {
            return false;
        }
        return CryptProvider.get().verify(password, (String)l.get(0));
    }

    public User getContact(String email, Long ownerId) {
        return this.getContact(email, "", "", ownerId);
    }

    public User getContact(String email, User owner) {
        return this.getContact(email, "", "", null, null, owner);
    }

    public User getContact(String email, String firstName, String lastName, Long ownerId) {
        return this.getContact(email, firstName, lastName, null, null, this.get(ownerId));
    }

    public User getContact(String email, String firstName, String lastName, Long langId, String tzId, Long ownerId) {
        return this.getContact(email, firstName, lastName, langId, tzId, this.get(ownerId));
    }

    public User getContact(String email, String firstName, String lastName, Long langId, String tzId, User owner) {
        User to = null;
        try {
            to = (User)this.em.createNamedQuery("getContactByEmailAndUser", User.class).setParameter("email", (Object)email).setParameter("type", (Object)User.Type.contact).setParameter("ownerId", (Object)owner.getId()).getSingleResult();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (to == null) {
            to = new User();
            to.setType(User.Type.contact);
            String login = owner.getId() + "_" + email;
            to.setLogin(login.length() < UserHelper.getMinLoginLength(this.cfgDao) ? UUID.randomUUID().toString() : login);
            to.setFirstname(firstName);
            to.setLastname(lastName);
            to.setLanguageId(null == langId ? owner.getLanguageId() : langId.longValue());
            to.setOwnerId(owner.getId());
            to.setAddress(new Address());
            to.getAddress().setEmail(email);
            to.setTimeZoneId(null == tzId ? owner.getTimeZoneId() : tzId);
        }
        return to;
    }

    public User getUserByActivationHash(String hash) {
        TypedQuery query = this.em.createQuery("SELECT u FROM User as u WHERE u.activatehash = :activatehash AND u.deleted = false", User.class);
        query.setParameter("activatehash", (Object)hash);
        User u = null;
        try {
            u = (User)query.getSingleResult();
        }
        catch (NoResultException e) {
            // empty catch block
        }
        return u;
    }

    private <T> TypedQuery<T> getUserProfileQuery(Class<T> clazz, Long userId, String text, String offers, String search, String orderBy, boolean asc) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean filterContacts = true;
        boolean count = clazz.isAssignableFrom(Long.class);
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append(count ? "COUNT(" : "").append("u").append(count ? ") " : " ").append("FROM User u ").append(UserDao.getAdditionalJoin(filterContacts)).append(" WHERE u.deleted = false AND ").append(UserDao.getAdditionalWhere(filterContacts, userId, params));
        if (!Strings.isEmpty((CharSequence)offers)) {
            sb.append(" AND (LOWER(u.userOffers) LIKE :userOffers) ");
            params.put("userOffers", UserDao.getStringParam(offers));
        }
        if (!Strings.isEmpty((CharSequence)search)) {
            sb.append(" AND (LOWER(u.userSearchs) LIKE :userSearchs) ");
            params.put("userSearchs", UserDao.getStringParam(search));
        }
        if (!Strings.isEmpty((CharSequence)text)) {
            sb.append(" AND (LOWER(u.login) LIKE :search ").append("OR LOWER(u.firstname) LIKE :search ").append("OR LOWER(u.lastname) LIKE :search ").append("OR LOWER(u.address.email) LIKE :search ").append("OR LOWER(u.address.town) LIKE :search ) ");
            params.put("search", UserDao.getStringParam(text));
        }
        if (!count && !Strings.isEmpty((CharSequence)orderBy)) {
            sb.append(" ORDER BY ").append(orderBy).append(asc ? " ASC" : " DESC");
        }
        TypedQuery query = this.em.createQuery(sb.toString(), clazz);
        UserDao.setAdditionalParams(query, params);
        return query;
    }

    private static String getStringParam(String param) {
        return param == null ? "%" : "%" + StringUtils.lowerCase((String)param) + "%";
    }

    public List<User> searchUserProfile(Long userId, String text, String offers, String search, String orderBy, int start, int max, boolean asc) {
        return this.getUserProfileQuery(User.class, userId, text, offers, search, orderBy, asc).setFirstResult(start).setMaxResults(max).getResultList();
    }

    public Long searchCountUserProfile(Long userId, String text, String offers, String search) {
        return (Long)this.getUserProfileQuery(Long.class, userId, text, offers, search, null, false).getSingleResult();
    }

    public User getExternalUser(String extId, String extType) {
        User u = null;
        try {
            u = (User)this.em.createNamedQuery("getExternalUser", User.class).setParameter("externalId", (Object)extId).setParameter("externalType", (Object)extType).getSingleResult();
        }
        catch (NoResultException ex) {
            // empty catch block
        }
        return u;
    }

    @Override
    public List<User> get(String search, int start, int count, String order) {
        return this.get(search, start, count, order, false, -1L);
    }

    public Set<User.Right> getRights(Long id) {
        HashSet<User.Right> rights = new HashSet<User.Right>();
        if (id == null) {
            return rights;
        }
        if (id < 0L) {
            rights.add(User.Right.Room);
            return rights;
        }
        User u = this.get(id);
        if (u != null) {
            return u.getRights();
        }
        return rights;
    }

    public User login(String userOrEmail, String userpass) throws OmException {
        List users = this.em.createNamedQuery("getUserByLoginOrEmail", User.class).setParameter("userOrEmail", (Object)userOrEmail).setParameter("type", (Object)User.Type.user).getResultList();
        log.debug("login:: {} users were found", (Object)users.size());
        if (users.size() == 0) {
            log.debug("No users was found: {}", (Object)userOrEmail);
            throw new OmException(-10L);
        }
        User u = (User)users.get(0);
        if (!this.verifyPassword(u.getId(), userpass)) {
            log.debug("Password does not match: {}", (Object)u);
            throw new OmException(-11L);
        }
        if (!AuthLevelUtil.hasLoginLevel(u.getRights())) {
            log.debug("Not activated: {}", (Object)u);
            throw new OmException(-41L);
        }
        log.debug("loginUser " + u.getGroupUsers());
        if (u.getGroupUsers().isEmpty()) {
            log.debug("No Group assigned: {}", (Object)u);
            throw new OmException("No Group assigned to user");
        }
        u.setLastlogin(new Date());
        return this.update(u, u.getId());
    }

    public Address getAddress(String street, String zip, String town, String country, String additionalname, String fax, String phone, String email) {
        Address a = new Address();
        a.setStreet(street);
        a.setZip(zip);
        a.setTown(town);
        a.setCountry(country);
        a.setAdditionalname(additionalname);
        a.setComment("");
        a.setFax(fax);
        a.setPhone(phone);
        a.setEmail(email);
        return a;
    }

    public User addUser(Set<User.Right> rights, String firstname, String login, String lastname, long languageId, String userpass, Address adress, boolean sendSMS, Date age, String hash, TimeZone timezone, boolean forceTimeZoneCheck, String userOffers, String userSearchs, boolean showContactData, boolean showContactDataToContacts, String externalId, String externalType, List<Long> groupIds, String pictureuri) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        User u = new User();
        u.setFirstname(firstname);
        u.setLogin(login);
        u.setLastname(lastname);
        u.setAge(age);
        u.setAddress(adress);
        u.setSendSMS(sendSMS);
        u.setRights(rights);
        u.setLastlogin(new Date());
        u.setLasttrans(new Long(0L));
        u.setSalutation(User.Salutation.mr);
        u.setActivatehash(hash);
        u.setTimeZoneId(timezone.getID());
        u.setForceTimeZoneCheck(forceTimeZoneCheck);
        u.setExternalId(externalId);
        u.setExternalType(externalType);
        if (!Strings.isEmpty((CharSequence)u.getExternalType())) {
            u.setType(User.Type.external);
        }
        u.setUserOffers(userOffers);
        u.setUserSearchs(userSearchs);
        u.setShowContactData(showContactData);
        u.setShowContactDataToContacts(showContactDataToContacts);
        u.setLanguageId(languageId != 0L ? languageId : 1L);
        if (!Strings.isEmpty((CharSequence)userpass)) {
            u.updatePassword(this.cfgDao, userpass);
        }
        u.setDeleted(false);
        u.setPictureuri(pictureuri);
        for (Long grpId : groupIds) {
            u.getGroupUsers().add(new GroupUser(this.groupDao.get(grpId), u));
        }
        return this.update(u, (Long)null);
    }
}

