/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.openjpa.persistence.OpenJPAEntityManager;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.room.SipDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.util.DaoHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RoomDao
implements IDataProviderDao<Room> {
    private static final Logger log = Red5LoggerFactory.getLogger(RoomDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    public static final String[] searchFields = new String[]{"name"};
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private ConfigurationDao cfgDao;
    @Autowired
    private SipDao sipDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private TimezoneUtil timezoneUtil;

    @Override
    public Room get(long id) {
        return this.get((Long)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Room get(Long id) {
        Room r = null;
        if (id != null && id > 0L) {
            OpenJPAEntityManager oem = OpenJPAPersistence.cast((EntityManager)this.em);
            boolean qrce = oem.getFetchPlan().getQueryResultCacheEnabled();
            try {
                oem.getFetchPlan().setQueryResultCacheEnabled(false);
                TypedQuery q = oem.createNamedQuery("getRoomById", Room.class);
                q.setParameter("id", (Object)id);
                OpenJPAQuery kq = OpenJPAPersistence.cast((Query)q);
                kq.getFetchPlan().addFetchGroups(new String[]{"roomModerators", "roomGroups"});
                List l = kq.getResultList();
                r = l.isEmpty() ? r : (Room)l.get(0);
            }
            finally {
                oem.getFetchPlan().setQueryResultCacheEnabled(qrce);
            }
        } else {
            log.info("[get] Info: No room id given");
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Room> get() {
        OpenJPAEntityManager oem = OpenJPAPersistence.cast((EntityManager)this.em);
        boolean qrce = oem.getFetchPlan().getQueryResultCacheEnabled();
        try {
            oem.getFetchPlan().setQueryResultCacheEnabled(false);
            TypedQuery q = oem.createNamedQuery("getBackupRooms", Room.class);
            OpenJPAQuery kq = OpenJPAPersistence.cast((Query)q);
            kq.getFetchPlan().addFetchGroups(new String[]{"roomModerators", "roomGroups"});
            List list = kq.getResultList();
            return list;
        }
        finally {
            oem.getFetchPlan().setQueryResultCacheEnabled(qrce);
        }
    }

    public List<Room> get(List<Long> ids) {
        return this.em.createNamedQuery("getRoomsByIds", Room.class).setParameter("ids", ids).getResultList();
    }

    @Override
    public List<Room> get(int start, int count) {
        TypedQuery q = this.em.createNamedQuery("getNondeletedRooms", Room.class);
        q.setFirstResult(start);
        q.setMaxResults(count);
        return q.getResultList();
    }

    @Override
    public List<Room> get(String search, int start, int count, String sort) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"Room", (String)"r", (String)search, (boolean)true, (boolean)false, (String)sort, (String[])searchFields), Room.class);
        q.setFirstResult(start);
        q.setMaxResults(count);
        return q.getResultList();
    }

    @Override
    public long count() {
        TypedQuery q = this.em.createNamedQuery("countRooms", Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public long count(String search) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"Room", (String)"r", (String)search, (boolean)true, (boolean)true, null, (String[])searchFields), Long.class);
        return (Long)q.getSingleResult();
    }

    public List<Room> getPublicRooms() {
        return this.em.createNamedQuery("getPublicRoomsOrdered", Room.class).getResultList();
    }

    public List<Room> getPublicRooms(Room.Type type) {
        return this.em.createNamedQuery("getPublicRooms", Room.class).setParameter("type", (Object)type).getResultList();
    }

    public List<Long> getSipRooms(List<Long> ids) {
        TypedQuery q = this.em.createNamedQuery("getSipRoomIdsByIds", Long.class);
        q.setParameter("ids", ids);
        return q.getResultList();
    }

    public List<Room> getGroupRooms(long groupId) {
        TypedQuery q = this.em.createNamedQuery("getGroupRooms", Room.class);
        q.setParameter("groupId", (Object)groupId);
        return q.getResultList();
    }

    public List<Room> getAppointedRoomsByUser(long userId) {
        log.debug("getAppointedRoomsByUser : UserID - " + userId);
        TimeZone timeZone = this.timezoneUtil.getTimeZone(this.userDao.get(userId));
        Calendar startCal = Calendar.getInstance(timeZone);
        startCal.set(12, 0);
        startCal.set(10, 0);
        startCal.set(13, 1);
        Calendar endCal = Calendar.getInstance(timeZone);
        endCal.set(12, 23);
        endCal.set(10, 59);
        endCal.set(13, 59);
        return this.em.createNamedQuery("appointedRoomsInRangeByUser", Room.class).setParameter("userId", (Object)userId).setParameter("start", (Object)startCal.getTime()).setParameter("end", (Object)endCal.getTime()).getResultList();
    }

    public long getRoomsCapacityByIds(List<Long> ids) {
        return ids == null || ids.isEmpty() ? 0L : (Long)this.em.createNamedQuery("getRoomsCapacityByIds", Long.class).setParameter("ids", ids).getSingleResult();
    }

    private boolean isSipEnabled() {
        return "yes".equals(this.cfgDao.getConfValue("red5sip.enable", String.class, "no"));
    }

    private String getSipNumber(long roomId) {
        if (this.isSipEnabled()) {
            return this.cfgDao.getConfValue("red5sip.room_prefix", String.class, "400") + roomId;
        }
        return null;
    }

    @Override
    public Room update(Room entity, Long userId) {
        if (entity.getId() == null) {
            entity.setInserted(new Date());
            this.em.persist((Object)entity);
        } else {
            entity.setUpdated(new Date());
        }
        if (entity.isSipEnabled() && this.isSipEnabled()) {
            String sipNumber = this.getSipNumber(entity.getId());
            if (sipNumber != null && !sipNumber.equals(entity.getConfno())) {
                entity.setConfno(sipNumber);
            }
            this.sipDao.update(sipNumber, entity.getPin());
        } else {
            this.sipDao.delete(entity.getConfno());
            entity.setConfno(null);
            entity.setPin(null);
        }
        entity = (Room)this.em.merge((Object)entity);
        return entity;
    }

    @Override
    public void delete(Room entity, Long userId) {
        entity.setDeleted(true);
        entity.setSipEnabled(false);
        this.update(entity, userId);
    }

    public Room getUserRoom(Long ownerId, Room.Type type, String name) {
        log.debug("getRoomByOwnerAndTypeId : " + ownerId + " || " + (Object)((Object)type));
        Room room = null;
        List ll = this.em.createNamedQuery("getRoomByOwnerAndTypeId", Room.class).setParameter("ownerId", (Object)ownerId).setParameter("type", (Object)type).getResultList();
        if (ll.size() > 0) {
            room = (Room)ll.get(0);
        }
        if (room == null) {
            log.debug("Could not find room " + ownerId + " || " + (Object)((Object)type));
            room = new Room();
            room.setName(name);
            room.setType(type);
            room.setComment("My Rooms of ownerId " + ownerId);
            room.setNumberOfPartizipants(Room.Type.conference == type ? 25L : 150L);
            room.setAllowUserQuestions(true);
            room.setAllowFontStyles(true);
            room.setOwnerId(ownerId);
            room.setAllowRecording(true);
            room = this.update(room, ownerId);
            if (room.getId() != null) {
                return room;
            }
            return null;
        }
        return room;
    }

    public Room getExternal(Room.Type type, String externalType, Long externalId) {
        log.debug("getExternal : " + externalId + " - " + externalType + " - " + (Object)((Object)type));
        List ll = this.em.createNamedQuery("getRoomByExternalId", Room.class).setParameter("externalId", (Object)externalId).setParameter("externalType", (Object)externalType).setParameter("type", (Object)type).getResultList();
        if (ll.size() > 0) {
            return (Room)ll.get(0);
        }
        log.error("Could not find room " + externalId);
        return null;
    }
}

