/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.record;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.record.RecordingLog;
import org.apache.openmeetings.db.entity.record.RecordingMetaData;
import org.apache.openmeetings.util.OmFileHelper;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Entity
@NamedQueries(value={@NamedQuery(name="getRecordingById", query="SELECT f FROM Recording f WHERE f.id = :id"), @NamedQuery(name="getRecordingByHash", query="SELECT f FROM Recording f WHERE f.hash = :hash"), @NamedQuery(name="getRecordingsByExternalUser", query="SELECT c FROM Recording c, User u WHERE c.insertedBy = u.id AND u.externalId = :externalId  AND u.externalType = :externalType AND c.deleted = false"), @NamedQuery(name="getRecordingsPublic", query="SELECT f FROM Recording f WHERE f.deleted = false AND f.ownerId IS NULL AND f.groupId IS NULL AND (f.parentId IS NULL OR f.parentId = 0) ORDER BY f.type DESC, f.inserted"), @NamedQuery(name="getRecordingsByGroup", query="SELECT f FROM Recording f WHERE f.deleted = false AND f.ownerId IS NULL AND f.groupId = :groupId AND (f.parentId IS NULL OR f.parentId = 0) ORDER BY f.type DESC, f.inserted"), @NamedQuery(name="getRecordingsByOwner", query="SELECT f FROM Recording f WHERE f.deleted = false AND f.ownerId = :ownerId AND (f.parentId IS NULL OR f.parentId = 0) ORDER BY f.type DESC, f.inserted"), @NamedQuery(name="resetRecordingProcessingStatus", query="UPDATE Recording f SET f.status = :error WHERE f.status IN (:recording, :converting)"), @NamedQuery(name="getRecordingsAll", query="SELECT c FROM Recording c LEFT JOIN FETCH c.metaData ORDER BY c.id"), @NamedQuery(name="getRecordingsByExternalTypeAndOwner", query="SELECT c FROM Recording c, Room r WHERE c.roomId = r.id AND r.externalType LIKE :externalType AND c.insertedBy LIKE :insertedBy AND c.deleted = false"), @NamedQuery(name="getRecordingsByRoom", query="SELECT c FROM Recording c WHERE c.deleted = false AND c.roomId = :roomId ORDER BY c.type ASC, c.inserted"), @NamedQuery(name="getRecordingsByParent", query="SELECT f FROM Recording f WHERE f.deleted = false AND f.parentId = :parentId ORDER BY f.type ASC, f.inserted"), @NamedQuery(name="getRecordingsByExternalType", query="SELECT rec FROM Recording rec, Room r, User u WHERE rec.deleted = false AND rec.roomId = r.id AND rec.insertedBy = u.id AND (r.externalType = :externalType OR u.externalType = :externalType)")})
@Table(name="recording")
@Root(name="flvrecording")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Recording
extends FileItem
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    @Element(data=true, name="flvRecordingId")
    private Long id;
    @Column(name="alternate_download")
    @Element(data=true, required=false)
    private String alternateDownload;
    @Column(name="comment")
    @Element(data=true, required=false)
    private String comment;
    @Column(name="record_start")
    @Element(data=true, required=false)
    private Date recordStart;
    @Column(name="record_end")
    @Element(data=true, required=false)
    private Date recordEnd;
    @Column(name="width")
    @Element(data=true, required=false)
    private Integer width;
    @Column(name="height")
    @Element(data=true, required=false)
    private Integer height;
    @Column(name="duration")
    @Element(data=true, required=false)
    private String duration;
    @Column(name="recorder_stream_id")
    @Element(data=true, required=false)
    private String recorderStreamId;
    @Column(name="group_id")
    @Element(data=true, required=false)
    private Long groupId;
    @Column(name="is_interview")
    @Element(data=true, required=false)
    private boolean interview;
    @Column(name="progress_post_processing")
    @Element(data=true, required=false)
    private Integer progressPostProcessing;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="recording_id")
    @ElementList(name="flvrecordingmetadatas", required=false)
    private List<RecordingMetaData> metaData;
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    @Element(data=true, required=false)
    private Status status = Status.NONE;
    @Transient
    private List<RecordingLog> log;
    private static int pcInheritedFieldCount = FileItem.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$file$FileItem;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$record$Recording$Status;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$record$Recording;

    @Override
    public Long getId() {
        return Recording.pcGetid(this);
    }

    @Override
    public void setId(Long id) {
        Recording.pcSetid(this, id);
    }

    public String getComment() {
        return Recording.pcGetcomment(this);
    }

    public void setComment(String comment) {
        Recording.pcSetcomment(this, comment);
    }

    public String getDuration() {
        return Recording.pcGetduration(this);
    }

    public void setDuration(String duration) {
        Recording.pcSetduration(this, duration);
    }

    public Date getRecordStart() {
        return Recording.pcGetrecordStart(this);
    }

    public void setRecordStart(Date recordStart) {
        Recording.pcSetrecordStart(this, recordStart);
    }

    public Date getRecordEnd() {
        return Recording.pcGetrecordEnd(this);
    }

    public void setRecordEnd(Date recordEnd) {
        Recording.pcSetrecordEnd(this, recordEnd);
    }

    public String getRecorderStreamId() {
        return Recording.pcGetrecorderStreamId(this);
    }

    public void setRecorderStreamId(String recorderStreamId) {
        Recording.pcSetrecorderStreamId(this, recorderStreamId);
    }

    public Long getGroupId() {
        return Recording.pcGetgroupId(this);
    }

    public void setGroupId(Long groupId) {
        Recording.pcSetgroupId(this, groupId);
    }

    public List<RecordingMetaData> getMetaData() {
        return Recording.pcGetmetaData(this);
    }

    public void setMetaData(List<RecordingMetaData> metaData) {
        Recording.pcSetmetaData(this, metaData);
    }

    public Integer getWidth() {
        return Recording.pcGetwidth(this);
    }

    public void setWidth(Integer width) {
        Recording.pcSetwidth(this, width);
    }

    public Integer getHeight() {
        return Recording.pcGetheight(this);
    }

    public void setHeight(Integer height) {
        Recording.pcSetheight(this, height);
    }

    public String getAlternateDownload() {
        return Recording.pcGetalternateDownload(this);
    }

    public void setAlternateDownload(String alternateDownload) {
        Recording.pcSetalternateDownload(this, alternateDownload);
    }

    public List<RecordingLog> getLog() {
        return this.log;
    }

    public void setLog(List<RecordingLog> log) {
        this.log = log;
    }

    public boolean isInterview() {
        return Recording.pcGetinterview(this);
    }

    public void setInterview(boolean interview) {
        Recording.pcSetinterview(this, interview);
    }

    public Integer getProgressPostProcessing() {
        return Recording.pcGetprogressPostProcessing(this);
    }

    public void setProgressPostProcessing(Integer progressPostProcessing) {
        Recording.pcSetprogressPostProcessing(this, progressPostProcessing);
    }

    public Status getStatus() {
        return Recording.pcGetstatus(this);
    }

    public void setStatus(Status status) {
        Recording.pcSetstatus(this, status);
    }

    @Override
    public File internalGetFile(String ext) {
        File f = null;
        if (this.getId() != null && !this.isDeleted()) {
            if (ext == null || "mp4".equals(ext)) {
                f = OmFileHelper.getRecording((String)String.format("%s%s.%s.%s", "flvRecording_", Recording.pcGetid(this), "flv", "mp4"));
            } else if ("flv".equals(ext)) {
                f = OmFileHelper.getRecording((String)String.format("%s%s.%s", "flvRecording_", Recording.pcGetid(this), "flv"));
            } else if ("avi".equals(ext)) {
                f = OmFileHelper.getRecording((String)String.format("%s%s.%s", "flvRecording_", Recording.pcGetid(this), "avi"));
            } else if ("ogg".equals(ext)) {
                f = OmFileHelper.getRecording((String)String.format("%s%s.%s.%s", "flvRecording_", Recording.pcGetid(this), "flv", "ogg"));
            }
        }
        return f;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1674154;
    }

    static {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$file$FileItem != null ? class$Lorg$apache$openmeetings$db$entity$file$FileItem : (class$Lorg$apache$openmeetings$db$entity$file$FileItem = Recording.class$("org.apache.openmeetings.db.entity.file.FileItem"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"alternateDownload", "comment", "duration", "groupId", "height", "id", "interview", "metaData", "progressPostProcessing", "recordEnd", "recordStart", "recorderStreamId", "status", "width"};
        Class[] classArray = new Class[14];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Recording.class$("java.lang.String"));
        classArray[0] = clazz2;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Recording.class$("java.lang.String"));
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Recording.class$("java.lang.String"));
        Class clazz3 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = Recording.class$("java.lang.Long"));
        classArray[3] = clazz3;
        Class clazz4 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Recording.class$("java.lang.Integer"));
        classArray[4] = clazz4;
        classArray[5] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = Recording.class$("java.lang.Long"));
        classArray[6] = Boolean.TYPE;
        Class clazz5 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Recording.class$("java.util.List"));
        classArray[7] = clazz5;
        classArray[8] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Recording.class$("java.lang.Integer"));
        Class clazz6 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Recording.class$("java.util.Date"));
        classArray[9] = clazz6;
        classArray[10] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = Recording.class$("java.util.Date"));
        classArray[11] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Recording.class$("java.lang.String"));
        Class clazz7 = class$Lorg$apache$openmeetings$db$entity$record$Recording$Status != null ? class$Lorg$apache$openmeetings$db$entity$record$Recording$Status : (class$Lorg$apache$openmeetings$db$entity$record$Recording$Status = Recording.class$("org.apache.openmeetings.db.entity.record.Recording$Status"));
        classArray[12] = clazz7;
        classArray[13] = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = Recording.class$("java.lang.Integer"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 5, 26, 26, 26, 26, 26, 26};
        Class clazz8 = class$Lorg$apache$openmeetings$db$entity$record$Recording != null ? class$Lorg$apache$openmeetings$db$entity$record$Recording : (class$Lorg$apache$openmeetings$db$entity$record$Recording = Recording.class$("org.apache.openmeetings.db.entity.record.Recording"));
        PCRegistry.register((Class)clazz8, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Recording", (PersistenceCapable)new Recording());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.alternateDownload = null;
        this.comment = null;
        this.duration = null;
        this.groupId = null;
        this.height = null;
        this.id = null;
        this.interview = false;
        this.metaData = null;
        this.progressPostProcessing = null;
        this.recordEnd = null;
        this.recordStart = null;
        this.recorderStreamId = null;
        this.status = null;
        this.width = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Recording recording = new Recording();
        if (bl) {
            recording.pcClearFields();
        }
        recording.pcStateManager = stateManager;
        recording.pcCopyKeyFieldsFromObjectId(object);
        return recording;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Recording recording = new Recording();
        if (bl) {
            recording.pcClearFields();
        }
        recording.pcStateManager = stateManager;
        return recording;
    }

    protected static int pcGetManagedFieldCount() {
        return 14 + FileItem.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.alternateDownload = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.comment = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.duration = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.groupId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.height = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.interview = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.metaData = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.progressPostProcessing = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.recordEnd = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.recordStart = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.recorderStreamId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.status = (Status)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 13: {
                this.width = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.alternateDownload);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.comment);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.duration);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.groupId);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.height);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 6: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.interview);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.metaData);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.progressPostProcessing);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.recordEnd);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.recordStart);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.recorderStreamId);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.status);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.width);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Recording recording, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(recording, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.alternateDownload = recording.alternateDownload;
                return;
            }
            case 1: {
                this.comment = recording.comment;
                return;
            }
            case 2: {
                this.duration = recording.duration;
                return;
            }
            case 3: {
                this.groupId = recording.groupId;
                return;
            }
            case 4: {
                this.height = recording.height;
                return;
            }
            case 5: {
                this.id = recording.id;
                return;
            }
            case 6: {
                this.interview = recording.interview;
                return;
            }
            case 7: {
                this.metaData = recording.metaData;
                return;
            }
            case 8: {
                this.progressPostProcessing = recording.progressPostProcessing;
                return;
            }
            case 9: {
                this.recordEnd = recording.recordEnd;
                return;
            }
            case 10: {
                this.recordStart = recording.recordStart;
                return;
            }
            case 11: {
                this.recorderStreamId = recording.recorderStreamId;
                return;
            }
            case 12: {
                this.status = recording.status;
                return;
            }
            case 13: {
                this.width = recording.width;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Recording recording = (Recording)object;
        if (recording.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(recording, nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        super.pcCopyKeyFieldsFromObjectId(fieldConsumer, object);
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(5 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(Object object) {
        super.pcCopyKeyFieldsFromObjectId(object);
        LongId longId = (LongId)object;
        this.id = new Long(longId.getId());
    }

    @Override
    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$record$Recording != null ? class$Lorg$apache$openmeetings$db$entity$record$Recording : (class$Lorg$apache$openmeetings$db$entity$record$Recording = Recording.class$("org.apache.openmeetings.db.entity.record.Recording"));
        return new LongId(clazz, (String)object);
    }

    @Override
    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$record$Recording != null ? class$Lorg$apache$openmeetings$db$entity$record$Recording : (class$Lorg$apache$openmeetings$db$entity$record$Recording = Recording.class$("org.apache.openmeetings.db.entity.record.Recording"));
        return new LongId(clazz, this.id);
    }

    private static final String pcGetalternateDownload(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.alternateDownload;
        }
        int n = pcInheritedFieldCount + 0;
        recording.pcStateManager.accessingField(n);
        return recording.alternateDownload;
    }

    private static final void pcSetalternateDownload(Recording recording, String string) {
        if (recording.pcStateManager == null) {
            recording.alternateDownload = string;
            return;
        }
        recording.pcStateManager.settingStringField((PersistenceCapable)recording, pcInheritedFieldCount + 0, recording.alternateDownload, string, 0);
    }

    private static final String pcGetcomment(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.comment;
        }
        int n = pcInheritedFieldCount + 1;
        recording.pcStateManager.accessingField(n);
        return recording.comment;
    }

    private static final void pcSetcomment(Recording recording, String string) {
        if (recording.pcStateManager == null) {
            recording.comment = string;
            return;
        }
        recording.pcStateManager.settingStringField((PersistenceCapable)recording, pcInheritedFieldCount + 1, recording.comment, string, 0);
    }

    private static final String pcGetduration(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.duration;
        }
        int n = pcInheritedFieldCount + 2;
        recording.pcStateManager.accessingField(n);
        return recording.duration;
    }

    private static final void pcSetduration(Recording recording, String string) {
        if (recording.pcStateManager == null) {
            recording.duration = string;
            return;
        }
        recording.pcStateManager.settingStringField((PersistenceCapable)recording, pcInheritedFieldCount + 2, recording.duration, string, 0);
    }

    private static final Long pcGetgroupId(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.groupId;
        }
        int n = pcInheritedFieldCount + 3;
        recording.pcStateManager.accessingField(n);
        return recording.groupId;
    }

    private static final void pcSetgroupId(Recording recording, Long l) {
        if (recording.pcStateManager == null) {
            recording.groupId = l;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 3, (Object)recording.groupId, (Object)l, 0);
    }

    private static final Integer pcGetheight(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.height;
        }
        int n = pcInheritedFieldCount + 4;
        recording.pcStateManager.accessingField(n);
        return recording.height;
    }

    private static final void pcSetheight(Recording recording, Integer n) {
        if (recording.pcStateManager == null) {
            recording.height = n;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 4, (Object)recording.height, (Object)n, 0);
    }

    private static final Long pcGetid(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.id;
        }
        int n = pcInheritedFieldCount + 5;
        recording.pcStateManager.accessingField(n);
        return recording.id;
    }

    private static final void pcSetid(Recording recording, Long l) {
        if (recording.pcStateManager == null) {
            recording.id = l;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 5, (Object)recording.id, (Object)l, 0);
    }

    private static final boolean pcGetinterview(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.interview;
        }
        int n = pcInheritedFieldCount + 6;
        recording.pcStateManager.accessingField(n);
        return recording.interview;
    }

    private static final void pcSetinterview(Recording recording, boolean bl) {
        if (recording.pcStateManager == null) {
            recording.interview = bl;
            return;
        }
        recording.pcStateManager.settingBooleanField((PersistenceCapable)recording, pcInheritedFieldCount + 6, recording.interview, bl, 0);
    }

    private static final List pcGetmetaData(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.metaData;
        }
        int n = pcInheritedFieldCount + 7;
        recording.pcStateManager.accessingField(n);
        return recording.metaData;
    }

    private static final void pcSetmetaData(Recording recording, List list) {
        if (recording.pcStateManager == null) {
            recording.metaData = list;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 7, recording.metaData, (Object)list, 0);
    }

    private static final Integer pcGetprogressPostProcessing(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.progressPostProcessing;
        }
        int n = pcInheritedFieldCount + 8;
        recording.pcStateManager.accessingField(n);
        return recording.progressPostProcessing;
    }

    private static final void pcSetprogressPostProcessing(Recording recording, Integer n) {
        if (recording.pcStateManager == null) {
            recording.progressPostProcessing = n;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 8, (Object)recording.progressPostProcessing, (Object)n, 0);
    }

    private static final Date pcGetrecordEnd(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.recordEnd;
        }
        int n = pcInheritedFieldCount + 9;
        recording.pcStateManager.accessingField(n);
        return recording.recordEnd;
    }

    private static final void pcSetrecordEnd(Recording recording, Date date) {
        if (recording.pcStateManager == null) {
            recording.recordEnd = date;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 9, (Object)recording.recordEnd, (Object)date, 0);
    }

    private static final Date pcGetrecordStart(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.recordStart;
        }
        int n = pcInheritedFieldCount + 10;
        recording.pcStateManager.accessingField(n);
        return recording.recordStart;
    }

    private static final void pcSetrecordStart(Recording recording, Date date) {
        if (recording.pcStateManager == null) {
            recording.recordStart = date;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 10, (Object)recording.recordStart, (Object)date, 0);
    }

    private static final String pcGetrecorderStreamId(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.recorderStreamId;
        }
        int n = pcInheritedFieldCount + 11;
        recording.pcStateManager.accessingField(n);
        return recording.recorderStreamId;
    }

    private static final void pcSetrecorderStreamId(Recording recording, String string) {
        if (recording.pcStateManager == null) {
            recording.recorderStreamId = string;
            return;
        }
        recording.pcStateManager.settingStringField((PersistenceCapable)recording, pcInheritedFieldCount + 11, recording.recorderStreamId, string, 0);
    }

    private static final Status pcGetstatus(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.status;
        }
        int n = pcInheritedFieldCount + 12;
        recording.pcStateManager.accessingField(n);
        return recording.status;
    }

    private static final void pcSetstatus(Recording recording, Status status) {
        if (recording.pcStateManager == null) {
            recording.status = status;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 12, (Object)recording.status, (Object)status, 0);
    }

    private static final Integer pcGetwidth(Recording recording) {
        if (recording.pcStateManager == null) {
            return recording.width;
        }
        int n = pcInheritedFieldCount + 13;
        recording.pcStateManager.accessingField(n);
        return recording.width;
    }

    private static final void pcSetwidth(Recording recording, Integer n) {
        if (recording.pcStateManager == null) {
            recording.width = n;
            return;
        }
        recording.pcStateManager.settingObjectField((PersistenceCapable)recording, pcInheritedFieldCount + 13, (Object)recording.width, (Object)n, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    @XmlType(namespace="org.apache.openmeetings.record")
    public static enum Status {
        NONE,
        RECORDING,
        CONVERTING,
        PROCESSED,
        ERROR;

    }
}

