/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.calendar;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.calendar.MeetingMemberDao;
import org.apache.openmeetings.db.dao.room.IInvitationManager;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.calendar.Appointment;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AppointmentDao {
    private static final Logger log = Red5LoggerFactory.getLogger(AppointmentDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private MeetingMemberDao meetingMemberDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private RoomDao roomDao;
    @Autowired
    private ConfigurationDao cfgDao;
    @Autowired
    private TimezoneUtil timezoneUtil;
    @Autowired
    private IInvitationManager invitationManager;

    public Appointment get(Long id) {
        TypedQuery query = this.em.createNamedQuery("getAppointmentById", Appointment.class);
        query.setParameter("id", (Object)id);
        Appointment a = null;
        try {
            a = (Appointment)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return a;
    }

    public Appointment getAny(Long id) {
        TypedQuery query = this.em.createNamedQuery("getAppointmentByIdAny", Appointment.class).setParameter("id", (Object)id);
        Appointment a = null;
        try {
            a = (Appointment)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return a;
    }

    public List<Appointment> get() {
        return this.em.createNamedQuery("getAppointments", Appointment.class).getResultList();
    }

    public Appointment update(Appointment a, Long userId) {
        return this.update(a, userId, true);
    }

    public Appointment update(Appointment a, Long userId, boolean sendmails) {
        Room r = a.getRoom();
        if (r.getId() == null) {
            r.setName(a.getTitle());
            r.setNumberOfPartizipants(this.cfgDao.getConfValue("calendar.conference.rooms.default.size", Long.class, "50"));
        }
        this.roomDao.update(r, userId);
        if (sendmails) {
            HashSet mmIds = a.getId() == null ? new HashSet() : this.meetingMemberDao.getMeetingMemberIdsByAppointment(a.getId());
            Appointment a0 = a.getId() == null ? null : this.get(a.getId());
            boolean sendMail = a0 == null || !a0.getTitle().equals(a.getTitle()) || a0.getDescription() != null && !a0.getDescription().equals(a.getDescription()) || a0.getLocation() != null && !a0.getLocation().equals(a.getLocation()) || !a0.getStart().equals(a.getStart()) || !a0.getEnd().equals(a.getEnd());
            List<MeetingMember> mmList = a.getMeetingMembers();
            if (mmList != null) {
                for (MeetingMember mm : mmList) {
                    if (mm.getId() == null || !mmIds.contains(mm.getId())) {
                        this.invitationManager.processInvitation(a, mm, Invitation.MessageType.Create);
                        continue;
                    }
                    mmIds.remove(mm.getId());
                    this.invitationManager.processInvitation(a, mm, Invitation.MessageType.Update, sendMail);
                }
            }
            Iterator<MeetingMember> iterator = mmIds.iterator();
            while (iterator.hasNext()) {
                long id = (Long)((Object)iterator.next());
                this.invitationManager.processInvitation(a, this.meetingMemberDao.get(id), Invitation.MessageType.Cancel);
            }
            MeetingMember owner = new MeetingMember();
            owner.setUser(a.getOwner());
            if (a.getId() == null) {
                this.invitationManager.processInvitation(a, owner, Invitation.MessageType.Create);
            } else if (a.isDeleted()) {
                this.invitationManager.processInvitation(a, owner, Invitation.MessageType.Cancel);
            } else if (sendMail) {
                this.invitationManager.processInvitation(a, owner, Invitation.MessageType.Update, sendMail);
            }
        }
        if (a.getId() == null) {
            a.setInserted(new Date());
            this.em.persist((Object)a);
        } else {
            a.setUpdated(new Date());
            a = (Appointment)this.em.merge((Object)a);
        }
        return a;
    }

    public void delete(Appointment a, Long userId) {
        a.setUpdated(new Date());
        a.setDeleted(true);
        a.setMeetingMembers(null);
        if (a.getRoom().isAppointment()) {
            a.getRoom().setDeleted(true);
        }
        this.update(a, userId);
    }

    public List<Appointment> getInRange(Long userId, Date start, Date end) {
        log.debug("Start " + start + " End " + end);
        TypedQuery query = this.em.createNamedQuery("appointmentsInRange", Appointment.class);
        query.setParameter("start", (Object)start);
        query.setParameter("end", (Object)end);
        query.setParameter("userId", (Object)userId);
        ArrayList<Appointment> listAppoints = new ArrayList<Appointment>(query.getResultList());
        TypedQuery q1 = this.em.createNamedQuery("joinedAppointmentsInRange", Appointment.class);
        q1.setParameter("start", (Object)start);
        q1.setParameter("end", (Object)end);
        q1.setParameter("userId", (Object)userId);
        for (Appointment a : q1.getResultList()) {
            a.setConnectedEvent(true);
            listAppoints.add(a);
        }
        return listAppoints;
    }

    public List<Appointment> getInRange(Calendar start, Calendar end) {
        TypedQuery q = this.em.createNamedQuery("appointmentsInRangeRemind", Appointment.class);
        q.setParameter("none", (Object)Appointment.Reminder.none);
        q.setParameter("start", (Object)start.getTime());
        q.setParameter("end", (Object)end.getTime());
        return q.getResultList();
    }

    public Appointment getNext(Long userId, Date start) {
        List list = this.em.createNamedQuery("getNextAppointment", Appointment.class).setParameter("start", (Object)start).setParameter("userId", (Object)userId).getResultList();
        return list == null || list.isEmpty() ? null : (Appointment)list.get(0);
    }

    public List<Appointment> searchAppointmentsByTitle(Long userId, String title) {
        return this.em.createNamedQuery("getNextAppointment", Appointment.class).setParameter("title", (Object)title).setParameter("userId", (Object)userId).getResultList();
    }

    public List<Appointment> getForToday(Long userId) {
        log.debug("getAppoitmentbyRangeAndMember : UserID - " + userId);
        TimeZone timeZone = this.timezoneUtil.getTimeZone(this.userDao.get(userId));
        Calendar startCal = Calendar.getInstance(timeZone);
        startCal.set(12, 0);
        startCal.set(10, 0);
        startCal.set(13, 1);
        Calendar endCal = Calendar.getInstance(timeZone);
        endCal.set(12, 23);
        endCal.set(10, 59);
        endCal.set(13, 59);
        TypedQuery query = this.em.createNamedQuery("appointmentsInRangeByUser", Appointment.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("start", (Object)startCal.getTime());
        query.setParameter("end", (Object)endCal.getTime());
        List listAppoints = query.getResultList();
        return listAppoints;
    }

    public Appointment getByRoom(Long userId, Long roomId) {
        try {
            List list = this.em.createNamedQuery("getAppointmentByOwnerRoomId", Appointment.class).setParameter("userId", (Object)userId).setParameter("roomId", (Object)roomId).getResultList();
            return list.size() > 0 ? (Appointment)list.get(0) : null;
        }
        catch (Exception e) {
            log.error("[getByRoom]", (Throwable)e);
            return null;
        }
    }

    public Appointment getByRoom(Long roomId) {
        Appointment a;
        List list = this.em.createNamedQuery("getAppointmentByRoomId", Appointment.class).setParameter("roomId", (Object)roomId).getResultList();
        Appointment appointment = a = list.size() > 0 ? (Appointment)list.get(0) : null;
        if (a != null && !a.getRoom().isAppointment()) {
            throw new RuntimeException("Room " + a.getRoom().getName() + " isnt part of an appointed meeting");
        }
        return a;
    }
}

